/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.incscc;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.counting.CountingAlg;
import org.eclipse.viatra.query.runtime.base.itc.alg.dred.DRedTcRelation;
import org.eclipse.viatra.query.runtime.base.itc.alg.incscc.CollectionHelper;
import org.eclipse.viatra.query.runtime.base.itc.alg.incscc.CountingListener;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.DFSPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.GraphHelper;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.IGraphPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.Tuple;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.bfs.BFS;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCC;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCCResult;
import org.eclipse.viatra.query.runtime.base.itc.graphimpl.Graph;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalWrapper;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcObserver;
import org.eclipse.viatra.query.runtime.matchers.algorithms.UnionFind;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;

public class IncSCCAlg<V>
implements IGraphObserver<V>,
ITcDataSource<V> {
    private static final long serialVersionUID = 6207002106223444807L;
    public UnionFind<V> sccs;
    public IBiDirectionalGraphDataSource<V> gds;
    private CountingAlg<V> counting;
    private Graph<V> reducedGraph;
    private IBiDirectionalGraphDataSource<V> reducedGraphIndexer;
    private List<ITcObserver<V>> observers;
    private CountingListener<V> countingListener;

    public IncSCCAlg(IGraphDataSource<V> graphDataSource) {
        this.gds = graphDataSource instanceof IBiDirectionalGraphDataSource ? (IBiDirectionalGraphDataSource)graphDataSource : new IBiDirectionalWrapper<V>(graphDataSource);
        this.observers = new ArrayList<ITcObserver<V>>();
        this.sccs = new UnionFind();
        this.reducedGraph = new Graph();
        this.reducedGraphIndexer = new IBiDirectionalWrapper<V>(this.reducedGraph);
        this.countingListener = new CountingListener(this);
        this.initalizeInternalDataStructures();
        this.gds.attachObserver(this);
    }

    private void initalizeInternalDataStructures() {
        SCCResult<V> _sccres = SCC.computeSCC(this.gds);
        Set<Set<V>> _sccs = _sccres.getSccs();
        for (Set<V> _set : _sccs) {
            this.sccs.makeSet(_set);
        }
        for (Object n : this.sccs.getPartitionHeads()) {
            this.reducedGraph.insertNode(n);
        }
        for (Object source : this.gds.getAllNodes()) {
            Map<Object, Integer> targetNodes = this.gds.getTargetNodes(source);
            for (Map.Entry<Object, Integer> entry : targetNodes.entrySet()) {
                int i = 0;
                while (i < entry.getValue()) {
                    Object targetRoot;
                    Object target = entry.getKey();
                    Object sourceRoot = this.sccs.find(source);
                    if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
                        this.reducedGraph.insertEdge(sourceRoot, targetRoot);
                    }
                    ++i;
                }
            }
        }
        this.counting = new CountingAlg<V>(this.reducedGraph);
    }

    @Override
    public void edgeInserted(V source, V target) {
        Object targetRoot;
        Object sourceRoot = this.sccs.find(source);
        if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            if (this.counting.isReachable(targetRoot, sourceRoot)) {
                AbstractCollection targetSCCs;
                AbstractCollection sourceSCCs;
                Set<Object> predecessorRoots = this.counting.getAllReachableSources(sourceRoot);
                Set<Object> successorRoots = this.counting.getAllReachableTargets(targetRoot);
                Set<Object> isectRoots = CollectionHelper.intersection(predecessorRoots, successorRoots);
                isectRoots.add(sourceRoot);
                isectRoots.add(targetRoot);
                if (this.observers.size() > 0) {
                    sourceSCCs = new HashSet();
                    targetSCCs = new HashSet();
                    sourceSCCs.add(sourceRoot);
                    sourceSCCs.addAll(predecessorRoots);
                    targetSCCs.add(targetRoot);
                    targetSCCs.addAll(successorRoots);
                    for (Object sourceSCC : sourceSCCs) {
                        for (Object targetSCC : CollectionHelper.difference(targetSCCs, this.counting.getAllReachableTargets(sourceSCC))) {
                            boolean needsNotification = false;
                            if (sourceSCC.equals(targetSCC) && this.sccs.getPartition(sourceSCC).size() == 1 && GraphHelper.getEdgeCount(this.sccs.getPartition(sourceSCC).iterator().next(), this.gds) == 0) {
                                needsNotification = true;
                            } else if (!sourceSCC.equals(targetSCC)) {
                                needsNotification = true;
                            }
                            if (!needsNotification) continue;
                            this.notifyTcObservers((V)this.sccs.getPartition(sourceSCC), (V)this.sccs.getPartition(targetSCC), Direction.INSERT);
                        }
                    }
                }
                sourceSCCs = new ArrayList();
                targetSCCs = new ArrayList();
                for (Object r : isectRoots) {
                    List<Object> sourceSCCsOfSCC = this.getSourceSCCsOfSCC(r);
                    List<Object> targetSCCsOfSCC = this.getTargetSCCsOfSCC(r);
                    for (Object sourceSCC : sourceSCCsOfSCC) {
                        if (sourceSCC.equals(r)) continue;
                        this.reducedGraph.deleteEdge(sourceSCC, r);
                    }
                    for (Object targetSCC : targetSCCsOfSCC) {
                        if (isectRoots.contains(targetSCC) || r.equals(targetSCC)) continue;
                        this.reducedGraph.deleteEdge(r, targetSCC);
                    }
                    sourceSCCs.addAll(sourceSCCsOfSCC);
                    targetSCCs.addAll(targetSCCsOfSCC);
                }
                for (Object r : isectRoots) {
                    this.reducedGraph.deleteNode(r);
                }
                Iterator<Object> iterator = isectRoots.iterator();
                Object newRoot = iterator.next();
                while (iterator.hasNext()) {
                    newRoot = this.sccs.union(newRoot, iterator.next());
                }
                this.reducedGraph.insertNode(newRoot);
                Set containedNodes = this.sccs.getPartition(newRoot);
                for (Object sourceSCC : sourceSCCs) {
                    if (containedNodes.contains(sourceSCC) || sourceSCC.equals(newRoot)) continue;
                    this.reducedGraph.insertEdge(sourceSCC, newRoot);
                }
                for (Object targetSCC : targetSCCs) {
                    if (containedNodes.contains(targetSCC) || targetSCC.equals(newRoot)) continue;
                    this.reducedGraph.insertEdge(newRoot, targetSCC);
                }
            } else {
                if (this.observers.size() > 0 && GraphHelper.getEdgeCount(source, target, this.gds) == 1) {
                    this.counting.attachObserver(this.countingListener);
                }
                this.reducedGraph.insertEdge(sourceRoot, targetRoot);
                this.counting.detachObserver(this.countingListener);
            }
        } else if (this.observers.size() > 0 && this.sccs.getPartition(sourceRoot).size() == 1 && GraphHelper.getEdgeCount(source, target, this.gds) == 1) {
            this.notifyTcObservers(source, source, Direction.INSERT);
        }
    }

    @Override
    public void edgeDeleted(V source, V target) {
        Object targetRoot;
        Object sourceRoot = this.sccs.find(source);
        if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            if (this.observers.size() > 0 && GraphHelper.getEdgeCount(source, target, this.gds) == 0) {
                this.counting.attachObserver(this.countingListener);
            }
            this.reducedGraph.deleteEdge(sourceRoot, targetRoot);
            this.counting.detachObserver(this.countingListener);
        } else {
            Graph<V> g = GraphHelper.getSubGraph(this.sccs.getPartition(sourceRoot), this.gds);
            if (!BFS.isReachable(source, target, g)) {
                HashMap<Object, Integer> reachableSources = new HashMap<Object, Integer>(this.reducedGraphIndexer.getSourceNodes(sourceRoot));
                HashMap<Object, Integer> reachableTargets = new HashMap<Object, Integer>(this.reducedGraphIndexer.getTargetNodes(sourceRoot));
                SCCResult<V> _newSccs = SCC.computeSCC(g);
                for (Map.Entry entry : reachableSources.entrySet()) {
                    int n = 0;
                    while (n < (Integer)entry.getValue()) {
                        Object s = entry.getKey();
                        this.reducedGraph.deleteEdge(s, sourceRoot);
                        ++n;
                    }
                }
                for (Map.Entry entry : reachableTargets.entrySet()) {
                    int n = 0;
                    while (n < (Integer)entry.getValue()) {
                        Object t = entry.getKey();
                        this.reducedGraph.deleteEdge(sourceRoot, t);
                        ++n;
                    }
                }
                this.sccs.deleteSet(sourceRoot);
                this.reducedGraph.deleteNode(sourceRoot);
                Set<Set<V>> newSCCs = _newSccs.getSccs();
                HashSet<Object> newSCCRoots = new HashSet<Object>();
                for (Set set : newSCCs) {
                    Object newRoot = this.sccs.makeSet((Collection)set);
                    this.reducedGraph.insertNode(newRoot);
                    newSCCRoots.add(newRoot);
                }
                for (Object e : newSCCRoots) {
                    List sourceSCCsOfSCC = this.getSourceSCCsOfSCC(e);
                    List targetSCCsOfSCC = this.getTargetSCCsOfSCC(e);
                    for (Object e2 : sourceSCCsOfSCC) {
                        if (e2.equals(e)) continue;
                        this.reducedGraph.insertEdge(this.sccs.find(e2), e);
                    }
                    for (Object e3 : targetSCCsOfSCC) {
                        if (newSCCRoots.contains(e3) || e3.equals(e)) continue;
                        this.reducedGraph.insertEdge(e, e3);
                    }
                }
                if (this.observers.size() > 0) {
                    Object object = this.sccs.find(source);
                    Object newTargetRoot = this.sccs.find(target);
                    Set<Object> sourceSCCs = this.counting.getAllReachableSources(object);
                    sourceSCCs.add(object);
                    Set<Object> targetSCCs = this.counting.getAllReachableTargets(newTargetRoot);
                    targetSCCs.add(newTargetRoot);
                    for (Object object2 : sourceSCCs) {
                        for (Object targetSCC : CollectionHelper.difference(targetSCCs, this.counting.getAllReachableTargets(object2))) {
                            boolean needsNotification = false;
                            if (object2.equals(targetSCC) && this.sccs.getPartition(object2).size() == 1 && GraphHelper.getEdgeCount(this.sccs.getPartition(object2).iterator().next(), this.gds) == 0) {
                                needsNotification = true;
                            } else if (!object2.equals(targetSCC)) {
                                needsNotification = true;
                            }
                            if (!needsNotification) continue;
                            this.notifyTcObservers((V)this.sccs.getPartition(object2), (V)this.sccs.getPartition(targetSCC), Direction.DELETE);
                        }
                    }
                }
            } else if (this.observers.size() > 0 && this.sccs.getPartition(sourceRoot).size() == 1 && GraphHelper.getEdgeCount(source, target, this.gds) == 0) {
                this.notifyTcObservers(source, source, Direction.DELETE);
            }
        }
    }

    @Override
    public void nodeInserted(V n) {
        this.sccs.makeSet(n);
        this.reducedGraph.insertNode(n);
    }

    @Override
    public void nodeDeleted(V n) {
        int i;
        Map<V, Integer> sources = this.gds.getSourceNodes(n);
        Map<V, Integer> targets = this.gds.getTargetNodes(n);
        for (Map.Entry<V, Integer> entry : sources.entrySet()) {
            i = 0;
            while (i < entry.getValue()) {
                V source = entry.getKey();
                this.edgeDeleted(source, n);
                ++i;
            }
        }
        for (Map.Entry<V, Integer> entry : targets.entrySet()) {
            i = 0;
            while (i < entry.getValue()) {
                V target = entry.getKey();
                this.edgeDeleted(n, target);
                ++i;
            }
        }
        this.sccs.deleteSet(n);
    }

    @Override
    public void attachObserver(ITcObserver<V> to) {
        this.observers.add(to);
    }

    @Override
    public void detachObserver(ITcObserver<V> to) {
        this.observers.remove(to);
    }

    @Override
    public Set<V> getAllReachableTargets(V source) {
        Set<Object> rootSet;
        Object sourceRoot = this.sccs.find(source);
        Set containedNodes = this.sccs.getPartition(sourceRoot);
        HashSet targets = new HashSet();
        if (containedNodes.size() > 1 || GraphHelper.getEdgeCount(source, this.gds) == 1) {
            targets.addAll(containedNodes);
        }
        if ((rootSet = this.counting.getAllReachableTargets(sourceRoot)) != null) {
            for (Object _root : rootSet) {
                targets.addAll(this.sccs.getPartition(_root));
            }
        }
        return targets;
    }

    @Override
    public Set<V> getAllReachableSources(V target) {
        Set<Object> rootSet;
        Object targetRoot = this.sccs.find(target);
        Set containedNodes = this.sccs.getPartition(targetRoot);
        HashSet sources = new HashSet();
        if (containedNodes.size() > 1 || GraphHelper.getEdgeCount(target, this.gds) == 1) {
            sources.addAll(containedNodes);
        }
        if ((rootSet = this.counting.getAllReachableSources(targetRoot)) != null) {
            for (Object _root : rootSet) {
                sources.addAll(this.sccs.getPartition(_root));
            }
        }
        return sources;
    }

    @Override
    public boolean isReachable(V source, V target) {
        Object targetRoot;
        Object sourceRoot = this.sccs.find(source);
        if (sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            return true;
        }
        return this.counting.isReachable(sourceRoot, targetRoot);
    }

    public List<V> getReachabilityPath(V source, V target) {
        if (!this.isReachable(source, target)) {
            return null;
        }
        Set<V> sccsInSubGraph = CollectionHelper.intersection(this.counting.getAllReachableTargets(source), this.counting.getAllReachableSources(target));
        sccsInSubGraph.add(this.sccs.find(source));
        sccsInSubGraph.add(this.sccs.find(target));
        HashSet nodesInSubGraph = new HashSet();
        for (V sccRoot : sccsInSubGraph) {
            nodesInSubGraph.addAll(this.sccs.getPartition(sccRoot));
        }
        return GraphHelper.constructPath(source, target, nodesInSubGraph, this.gds);
    }

    public boolean checkTcRelation(DRedTcRelation<V> tc) {
        for (V s : tc.getTupleStarts()) {
            for (V t : tc.getTupleEnds(s)) {
                if (this.isReachable(s, t)) continue;
                return false;
            }
        }
        for (V root : this.counting.getTcRelation().getTupleStarts()) {
            for (V end : this.counting.getTcRelation().getTupleEnds(root)) {
                for (Object s : this.sccs.getPartition(root)) {
                    for (Object t : this.sccs.getPartition(end)) {
                        if (tc.containsTuple(s, t)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private List<V> getSourceSCCsOfSCC(V root) {
        ArrayList<Object> sourceSCCs = new ArrayList<Object>();
        for (Object containedNode : this.sccs.getPartition(root)) {
            Map<V, Integer> sourceNodes = this.gds.getSourceNodes(containedNode);
            for (V source : sourceNodes.keySet()) {
                sourceSCCs.add(this.sccs.find(source));
            }
        }
        return sourceSCCs;
    }

    public boolean hasIncomingEdges(V root) {
        for (Object containedNode : this.sccs.getPartition(root)) {
            Map<V, Integer> sourceNodes = this.gds.getSourceNodes(containedNode);
            for (V source : sourceNodes.keySet()) {
                Object otherRoot = this.sccs.find(source);
                if (Objects.equals(root, otherRoot)) continue;
                return true;
            }
        }
        return false;
    }

    private List<V> getTargetSCCsOfSCC(V root) {
        ArrayList<Object> targetSCCs = new ArrayList<Object>();
        for (Object containedNode : this.sccs.getPartition(root)) {
            Map targetNodes = this.gds.getTargetNodes(containedNode);
            for (Object target : targetNodes.keySet()) {
                targetSCCs.add(this.sccs.find(target));
            }
        }
        return targetSCCs;
    }

    public boolean hasOutgoingEdges(V root) {
        for (Object containedNode : this.sccs.getPartition(root)) {
            Map targetNodes = this.gds.getTargetNodes(containedNode);
            for (Object target : targetNodes.keySet()) {
                Object otherRoot = this.sccs.find(target);
                if (Objects.equals(root, otherRoot)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        this.gds.detachObserver(this);
        this.counting.dispose();
    }

    protected void notifyTcObservers(Set<V> sources, Set<V> targets, Direction direction) {
        for (V s : sources) {
            for (V t : targets) {
                this.notifyTcObservers(s, t, direction);
            }
        }
    }

    private void notifyTcObservers(V source, V target, Direction direction) {
        for (ITcObserver<V> observer : this.observers) {
            if (direction == Direction.INSERT) {
                observer.tupleInserted(source, target);
            }
            if (direction != Direction.DELETE) continue;
            observer.tupleDeleted(source, target);
        }
    }

    public V getRepresentative(V node) {
        return (V)this.sccs.find(node);
    }

    public Set<Tuple<V>> getTcRelation() {
        HashSet<Tuple<V>> resultSet = new HashSet<Tuple<V>>();
        for (Object sourceRoot : this.sccs.getPartitionHeads()) {
            Set<V> reachableTargets;
            Set sources = this.sccs.getPartition(sourceRoot);
            if (sources.size() > 1 || GraphHelper.getEdgeCount(sources.iterator().next(), this.gds) == 1) {
                for (Object source : sources) {
                    for (Object target : sources) {
                        resultSet.add(new Tuple(source, target));
                    }
                }
            }
            if ((reachableTargets = this.counting.getAllReachableTargets(sourceRoot)) == null) continue;
            for (V targetRoot : reachableTargets) {
                for (Object source : sources) {
                    for (Object target : this.sccs.getPartition(targetRoot)) {
                        resultSet.add(new Tuple(source, target));
                    }
                }
            }
        }
        return resultSet;
    }

    public boolean isIsolated(V node) {
        Map<V, Integer> targets = this.gds.getTargetNodes(node);
        Map<V, Integer> sources = this.gds.getSourceNodes(node);
        return targets.isEmpty() && sources.isEmpty();
    }

    @Override
    public IGraphPathFinder<V> getPathFinder() {
        return new DFSPathFinder<V>(this.gds, this);
    }

    public Graph<V> getReducedGraph() {
        return this.reducedGraph;
    }
}

