/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.diagnostic.filters;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;

public class ConstraintCategoryFilter
implements IConstraintFilter {
    private Set<String> categoryIdPatterns = new HashSet<String>();

    public ConstraintCategoryFilter() {
    }

    public ConstraintCategoryFilter(String categoryIdPattern) {
        Assert.isNotNull((Object)categoryIdPattern);
        this.categoryIdPatterns.add(categoryIdPattern);
    }

    public void addCategory(String categoryIdPattern) {
        Assert.isNotNull((Object)categoryIdPattern);
        this.categoryIdPatterns.add(categoryIdPattern);
    }

    public boolean accept(IConstraintDescriptor constraint, EObject target) {
        if (constraint != null) {
            for (Category category : constraint.getCategories()) {
                while (category != null) {
                    for (String categoryIdPattern : this.categoryIdPatterns) {
                        if (!category.getId().matches(categoryIdPattern)) continue;
                        return true;
                    }
                    category = category.getParent();
                }
            }
        }
        return false;
    }
}

