/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.transformation.evm.api.Agenda;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventRealm;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.api.resolver.ScopedConflictSet;

public class RuleBase {
    protected final EventRealm eventRealm;
    protected final Table<RuleSpecification<?>, EventFilter<?>, RuleInstance<?>> ruleInstanceTable;
    protected final Agenda agenda;
    protected final Logger logger;

    protected RuleBase(EventRealm eventRealm, Agenda agenda) {
        this.eventRealm = (EventRealm)Preconditions.checkNotNull((Object)eventRealm, (Object)"Cannot create RuleBase with null event source");
        this.ruleInstanceTable = HashBasedTable.create();
        this.logger = agenda.getLogger();
        this.agenda = agenda;
    }

    protected <EventAtom> RuleInstance<EventAtom> instantiateRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)"Cannot instantiate null rule!");
        Preconditions.checkNotNull(filter, (Object)"Cannot instantiate rule with null filter!");
        RuleInstance<? super EventAtom> instance = this.findInstance(specification, filter);
        if (instance != null) {
            return instance;
        }
        RuleInstance<EventAtom> rule = specification.instantiateRule(this.eventRealm, filter);
        rule.addActivationNotificationListener(this.agenda.getActivationListener(), true);
        this.ruleInstanceTable.put(specification, filter, rule);
        return rule;
    }

    protected <EventAtom> boolean removeRule(RuleInstance<EventAtom> instance) {
        Preconditions.checkNotNull(instance, (Object)"Cannot remove null rule instance!");
        return this.removeRule(instance.getSpecification(), instance.getFilter());
    }

    protected <EventAtom> boolean removeRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)"Cannot remove null rule specification!");
        Preconditions.checkNotNull(filter, (Object)"Cannot remove instance for null filter");
        RuleInstance<EventAtom> instance = this.findInstance(specification, filter);
        if (instance != null) {
            instance.dispose();
            this.ruleInstanceTable.remove(specification, filter);
            return true;
        }
        return false;
    }

    protected void dispose() {
        for (RuleInstance instance : this.ruleInstanceTable.values()) {
            instance.dispose();
        }
    }

    public EventRealm getEventRealm() {
        return this.eventRealm;
    }

    public Multimap<RuleSpecification<?>, EventFilter<?>> getRuleSpecificationMultimap() {
        HashMultimap ruleMap = HashMultimap.create();
        Map rowMap = this.ruleInstanceTable.rowMap();
        for (Map.Entry entry : rowMap.entrySet()) {
            ruleMap.putAll((Object)((RuleSpecification)entry.getKey()), ((Map)entry.getValue()).keySet());
        }
        return ruleMap;
    }

    public Set<RuleInstance<?>> getRuleInstances() {
        return ImmutableSet.copyOf((Collection)this.ruleInstanceTable.values());
    }

    public <EventAtom> RuleInstance<EventAtom> getInstance(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)"Cannot get instance for null specification");
        Preconditions.checkNotNull(filter, (Object)"Cannot get instance for null filter");
        return this.findInstance(specification, filter);
    }

    protected <EventAtom> RuleInstance<EventAtom> findInstance(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        return (RuleInstance)this.ruleInstanceTable.get(specification, filter);
    }

    public ScopedConflictSet createScopedConflictSet(ConflictResolver conflictResolver, Multimap<RuleSpecification<?>, EventFilter<?>> specifications) {
        ScopedConflictSet set = new ScopedConflictSet(this, conflictResolver, specifications);
        return set;
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

