/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelRepository;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.internal.models.rcp.RepositoryDetailsDialog;
import org.eclipse.recommenders.internal.models.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.ModelCoordinates;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.models.rcp.actions.TriggerModelDownloadForModelCoordinatesAction;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Uris;
import org.eclipse.recommenders.utils.rcp.Selections;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;

public class ModelRepositoriesView
extends ViewPart {
    private DataBindingContext bindingContext;
    private Tree tree;
    private Action addRemoteRepositoryAction;
    private final IModelIndex index;
    private final SharedImages images;
    private final EclipseModelRepository repo;
    private final ModelsRcpPreferences preferences;
    private final List<String> modelClassifiers;
    private final EventBus bus;
    private TreeViewer treeViewer;
    private Text txtSearch;
    private boolean initializeFilter = true;
    private ListMultimap<String, KnownCoordinate> coordinatesGroupedByRepo = LinkedListMultimap.create();
    private ListMultimap<String, KnownCoordinate> filteredCoordinatesGroupedByRepo = LinkedListMultimap.create();
    private final Function<KnownCoordinate, String> toStringRepresentation = new Function<KnownCoordinate, String>(){

        public String apply(KnownCoordinate input) {
            return input.pc.toString();
        }
    };

    @Inject
    public ModelRepositoriesView(IModelIndex index, SharedImages images, EclipseModelRepository repo, ModelsRcpPreferences preferences, @Named(value="MODEL_CLASSIFIER") ImmutableSet<String> modelClassifiers, EventBus bus) {
        this.index = index;
        this.images = images;
        this.repo = repo;
        this.preferences = preferences;
        this.modelClassifiers = new ArrayList<String>((Collection<String>)modelClassifiers);
        Collections.sort(this.modelClassifiers);
        this.bus = bus;
    }

    public void createPartControl(Composite parent) {
        this.bus.register((Object)this);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.txtSearch = new Text(container, 2944);
        this.txtSearch.setMessage(Messages.SEARCH_PLACEHOLDER_FILTER_TEXT);
        this.txtSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && ModelRepositoriesView.this.tree.getItemCount() != 0) {
                    ModelRepositoriesView.this.tree.setFocus();
                    ModelRepositoriesView.this.tree.setSelection(ModelRepositoriesView.this.tree.getTopItem());
                }
            }
        });
        Composite composite = new Composite(container, 0);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        composite.setLayout((Layout)treeLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new TreeViewer(composite, 0x10010800);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.tree = this.treeViewer.getTree();
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        TreeViewerColumn repositoryViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn repositoryColumn = repositoryViewerColumn.getColumn();
        treeLayout.setColumnData((Widget)repositoryColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        repositoryColumn.setText(Messages.COLUMN_LABEL_REPOSITORY);
        repositoryViewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                StyledString text = new StyledString();
                if (element instanceof String) {
                    String url = (String)element;
                    text.append(Uris.toStringWithMaskedPassword((URI)Uris.toUri((String)url), (char)'*'));
                    text.append(" ");
                    text.append(MessageFormat.format(Messages.TABLE_CELL_SUFFIX_KNOWN_COORDINATES, ModelRepositoriesView.this.fetchNumberOfModels(url)), StyledString.COUNTER_STYLER);
                    cell.setImage(this.getCellImage(url));
                }
                if (element instanceof KnownCoordinate) {
                    KnownCoordinate v = (KnownCoordinate)element;
                    text.append(v.pc.toString());
                }
                cell.setText(text.toString());
                cell.setStyleRanges(text.getStyleRanges());
                super.update(cell);
            }

            private Image getCellImage(String url) {
                URI uri = (URI)Uris.parseURI((String)url).orNull();
                if (uri == null) {
                    return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_REPOSITORY);
                }
                if (Uris.isPasswordProtected((URI)uri)) {
                    return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_LOCKED_REPOSITORY);
                }
                if (ModelRepositoriesView.this.preferences.hasPassword(url)) {
                    return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_LOCKED_REPOSITORY);
                }
                return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_REPOSITORY);
            }
        });
        int minWidth = this.calculateMinColumnWidthForClassifier();
        for (String classifier : this.modelClassifiers) {
            this.newColumn(treeLayout, classifier, minWidth);
        }
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)new ILazyTreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                ModelRepositoriesView.this.filteredCoordinatesGroupedByRepo = (ListMultimap)ArrayListMultimap.create((Multimap)ModelRepositoriesView.this.coordinatesGroupedByRepo);
            }

            public void dispose() {
            }

            public void updateElement(Object parent, int index) {
                if (parent instanceof IViewSite) {
                    String element = ((ModelRepositoriesView)ModelRepositoriesView.this).preferences.remotes[index];
                    ModelRepositoriesView.this.treeViewer.replace(parent, index, (Object)element);
                    ModelRepositoriesView.this.treeViewer.setChildCount((Object)element, this.getChildren(element).length);
                } else if (parent instanceof String) {
                    ModelRepositoriesView.this.treeViewer.replace(parent, index, this.getChildren(parent)[index]);
                }
            }

            private Object[] getChildren(Object element) {
                if (element instanceof String) {
                    return ModelRepositoriesView.this.filteredCoordinatesGroupedByRepo.get((Object)((String)element)).toArray();
                }
                return new Object[0];
            }

            public void updateChildCount(Object element, int currentChildCount) {
                int count = 0;
                if (element instanceof IViewSite) {
                    count = ((ModelRepositoriesView)ModelRepositoriesView.this).preferences.remotes.length;
                }
                if (ArrayUtils.contains((Object[])((ModelRepositoriesView)ModelRepositoriesView.this).preferences.remotes, (Object)element)) {
                    count = this.getChildren(element).length;
                }
                if (count != currentChildCount) {
                    ModelRepositoriesView.this.treeViewer.setChildCount(element, count);
                }
            }

            public Object getParent(Object element) {
                if (element instanceof KnownCoordinate) {
                    KnownCoordinate v = (KnownCoordinate)element;
                    return v.url;
                }
                return null;
            }
        });
        this.treeViewer.setInput((Object)this.getViewSite());
        this.refreshData();
        this.addRemoteRepositoryAction = new Action(){

            public void run() {
                ModelRepositoriesView.this.addRemoteRepository();
            }
        };
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.addAction(Messages.TOOLBAR_TOOLTIP_ADD_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_ADD_REPOSITORY, (IContributionManager)toolBarManager, (IAction)this.addRemoteRepositoryAction);
        this.addAction(Messages.TOOLBAR_TOOLTIP_REFRESH, (SharedImages.ImageResource)SharedImages.Images.ELCL_REFRESH, (IContributionManager)toolBarManager, (IAction)new Action(){

            public void run() {
                ModelRepositoriesView.this.refreshData();
            }
        });
        this.addAction(Messages.TOOLBAR_TOOLTIP_EXPAND_ALL, (SharedImages.ImageResource)SharedImages.Images.ELCL_EXPAND_ALL, (IContributionManager)toolBarManager, (IAction)new Action(){

            public void run() {
                int i = 0;
                while (i < ModelRepositoriesView.this.treeViewer.getTree().getItemCount()) {
                    ModelRepositoriesView.this.treeViewer.getTree().getItem(i).setExpanded(true);
                    ++i;
                }
            }
        });
        this.addAction(Messages.TOOLBAR_TOOLTIP_COLLAPSE_ALL, (SharedImages.ImageResource)SharedImages.Images.ELCL_COLLAPSE_ALL, (IContributionManager)toolBarManager, (IAction)new Action(){

            public void run() {
                int i = 0;
                while (i < ModelRepositoriesView.this.treeViewer.getTree().getItemCount()) {
                    ModelRepositoriesView.this.treeViewer.getTree().getItem(i).setExpanded(false);
                    ++i;
                }
            }
        });
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        this.addAction(Messages.MENUITEM_DELETE_MODELS, (SharedImages.ImageResource)SharedImages.Images.ELCL_DELETE, (IContributionManager)menuManager, (IAction)new Action(){

            public void run() {
                ModelRepositoriesView.this.deleteCacheAndRefresh();
            }
        });
        this.addContextMenu();
        this.bindingContext = this.initDataBindings();
    }

    private int calculateMinColumnWidthForClassifier() {
        GC gc = new GC((Drawable)this.tree);
        int maxLength = 0;
        for (String classifier : this.modelClassifiers) {
            int extent = gc.textExtent((String)classifier.toUpperCase()).x;
            if (extent <= maxLength) continue;
            maxLength = extent;
        }
        gc.dispose();
        return maxLength;
    }

    private void refreshData() {
        new UIJob(Messages.JOB_NAME_REFRESHING_MODEL_REPOSITORIES_VIEW){
            {
                this.schedule();
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Multimap fetchedCoordinates = ModelRepositoriesView.this.fetchCoordinatesGroupedByRepo();
                ModelRepositoriesView.this.coordinatesGroupedByRepo.clear();
                for (Map.Entry entry : fetchedCoordinates.asMap().entrySet()) {
                    ModelRepositoriesView.this.coordinatesGroupedByRepo.putAll((Object)((String)entry.getKey()), (Iterable)ModelRepositoriesView.this.createCoordiantes((String)entry.getKey(), (Collection)entry.getValue()));
                }
                ModelRepositoriesView.this.treeViewer.setInput((Object)ModelRepositoriesView.this.getViewSite());
                return Status.OK_STATUS;
            }
        };
    }

    private Multimap<String, ModelCoordinate> fetchCoordinatesGroupedByRepo() {
        LinkedListMultimap coordinatesGroupedByRepo = LinkedListMultimap.create();
        for (String classifier : this.modelClassifiers) {
            this.addCoordinateToIndex((Multimap<String, ModelCoordinate>)coordinatesGroupedByRepo, classifier);
        }
        return coordinatesGroupedByRepo;
    }

    private void addCoordinateToIndex(Multimap<String, ModelCoordinate> coordinatesGroupedByRepo, String classifier) {
        for (ModelCoordinate mc : this.index.getKnownModels(classifier)) {
            Optional hint = mc.getHint("repository.url");
            if (!hint.isPresent()) continue;
            coordinatesGroupedByRepo.put((Object)((String)hint.get()), (Object)mc);
        }
    }

    private List<KnownCoordinate> createCoordiantes(String url, Collection<ModelCoordinate> modelCoordinates) {
        Multimap<ProjectCoordinate, ModelCoordinate> coordinatesGroupedByProjectCoordinate = this.groupByProjectCoordinate(modelCoordinates);
        ArrayList<KnownCoordinate> coordinates = new ArrayList<KnownCoordinate>();
        for (ProjectCoordinate pc : coordinatesGroupedByProjectCoordinate.keySet()) {
            coordinates.add(new KnownCoordinate(url, pc, coordinatesGroupedByProjectCoordinate.get((Object)pc)));
        }
        return Ordering.natural().onResultOf(this.toStringRepresentation).sortedCopy(coordinates);
    }

    private Multimap<ProjectCoordinate, ModelCoordinate> groupByProjectCoordinate(Collection<ModelCoordinate> modelCoordinates) {
        LinkedListMultimap coordinatesGroupedByProjectCoordinate = LinkedListMultimap.create();
        for (ModelCoordinate modelCoordinate : modelCoordinates) {
            coordinatesGroupedByProjectCoordinate.put((Object)ModelCoordinates.toProjectCoordinate((ModelCoordinate)modelCoordinate), (Object)modelCoordinate);
        }
        return coordinatesGroupedByProjectCoordinate;
    }

    protected int fetchNumberOfModels(String url) {
        return this.coordinatesGroupedByRepo.get((Object)url).size();
    }

    private void addAction(String text, SharedImages.ImageResource imageResource, IContributionManager contributionManager, IAction action) {
        action.setImageDescriptor(this.images.getDescriptor(imageResource));
        action.setText(text);
        action.setToolTipText(text);
        contributionManager.add(action);
    }

    private void addContextMenu() {
        final MenuManager menuManager = new MenuManager();
        Menu contextMenu = menuManager.createContextMenu((Control)this.tree);
        menuManager.setRemoveAllWhenShown(true);
        this.tree.setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (this.isValidType(ModelRepositoriesView.this.treeViewer.getSelection(), KnownCoordinate.class)) {
                    Set selectedValues = Selections.toSet((ISelection)ModelRepositoriesView.this.treeViewer.getSelection());
                    HashSet<ModelCoordinate> selectedModelCoordinates = new HashSet<ModelCoordinate>();
                    for (KnownCoordinate value : selectedValues) {
                        Collection<ModelCoordinate> mcs = value.mcs;
                        selectedModelCoordinates.addAll(mcs);
                    }
                    if (!selectedValues.isEmpty()) {
                        TriggerModelDownloadForModelCoordinatesAction action = new TriggerModelDownloadForModelCoordinatesAction(Messages.MENUITEM_DOWNLOAD_MODELS, selectedModelCoordinates, ModelRepositoriesView.this.repo, ModelRepositoriesView.this.bus);
                        menuManager.add((IAction)action);
                    }
                }
                if (this.isValidType(ModelRepositoriesView.this.treeViewer.getSelection(), String.class)) {
                    ModelRepositoriesView.this.addAction(Messages.MENUITEM_ADD_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_ADD_REPOSITORY, (IContributionManager)menuManager, (IAction)ModelRepositoriesView.this.addRemoteRepositoryAction);
                    final Optional url = Selections.getFirstSelected((ISelection)ModelRepositoriesView.this.treeViewer.getSelection());
                    if (url.isPresent()) {
                        ModelRepositoriesView.this.addAction(Messages.MENUITEM_EDIT_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_EDIT_REPOSITORY, (IContributionManager)menuManager, (IAction)new Action(){

                            public void run() {
                                ModelRepositoriesView.this.editRepository((String)url.get());
                                ModelRepositoriesView.this.refreshData();
                            }
                        });
                        ModelRepositoriesView.this.addAction(Messages.MENUITEM_REMOVE_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_REMOVE_REPOSITORY, (IContributionManager)menuManager, (IAction)new Action(){

                            public void run() {
                                ModelRepositoriesView.this.deleteRepository((String)url.get());
                                ModelRepositoriesView.this.refreshData();
                            }
                        });
                    }
                }
            }

            private boolean isValidType(ISelection selection, Class<?> expectedType) {
                return Selections.safeFirstElement((ISelection)ModelRepositoriesView.this.treeViewer.getSelection(), expectedType).isPresent();
            }
        });
    }

    private void newColumn(TreeColumnLayout treeLayout, final String classifier, int minWidth) {
        TreeViewerColumn classifierViewerColumn = new TreeViewerColumn(this.treeViewer, 0x1000000);
        TreeColumn classifierColumn = classifierViewerColumn.getColumn();
        classifierColumn.setMoveable(true);
        classifierColumn.setResizable(false);
        treeLayout.setColumnData((Widget)classifierColumn, (ColumnLayoutData)new ColumnPixelData(minWidth, false, true));
        classifierColumn.setText(classifier.toUpperCase());
        classifierColumn.pack();
        classifierViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof KnownCoordinate) {
                    KnownCoordinate v = (KnownCoordinate)element;
                    if (!v.hasModelCoordinate(classifier)) {
                        return Messages.TABLE_CELL_TOOLTIP_UNAVAILABLE;
                    }
                    if (v.isDownloaded(classifier)) {
                        return Messages.TABLE_CELL_TOOLTIP_AVAILABLE_LOCALLY;
                    }
                    return Messages.TABLE_CELL_TOOLTIP_AVAILABLE_REMOTELY;
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof KnownCoordinate) {
                    KnownCoordinate v = (KnownCoordinate)element;
                    if (!v.hasModelCoordinate(classifier)) {
                        return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_CROSS_RED);
                    }
                    if (v.isDownloaded(classifier)) {
                        return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_CHECK_GREEN);
                    }
                    return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_BULLET_BLUE);
                }
                return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_TRANSPARENT);
            }
        });
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void setFilter(final String filter) {
        if (this.initializeFilter && filter.isEmpty()) {
            this.initializeFilter = false;
            return;
        }
        new UIJob(Messages.JOB_NAME_REFRESHING_MODEL_REPOSITORIES_VIEW){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!filter.isEmpty()) {
                    ModelRepositoriesView.this.filteredCoordinatesGroupedByRepo.clear();
                    for (String key : ModelRepositoriesView.this.coordinatesGroupedByRepo.keySet()) {
                        List unfiltered = ModelRepositoriesView.this.coordinatesGroupedByRepo.get((Object)key);
                        Iterable filtered = Iterables.filter((Iterable)unfiltered, (Predicate)new GlobMatcher(filter));
                        ModelRepositoriesView.this.filteredCoordinatesGroupedByRepo.putAll((Object)key, filtered);
                    }
                } else {
                    ModelRepositoriesView.this.filteredCoordinatesGroupedByRepo = (ListMultimap)ArrayListMultimap.create((Multimap)ModelRepositoriesView.this.coordinatesGroupedByRepo);
                }
                ModelRepositoriesView.this.refreshUI();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void refreshUI() {
        int numberOfVisibleElements = this.treeViewer.getTree().getSize().y / this.treeViewer.getTree().getItemHeight() + 1;
        this.treeViewer.refresh();
        int replacedElementsCount = 0;
        int i = 0;
        while (i < this.preferences.remotes.length) {
            String url = this.preferences.remotes[i];
            List elements = this.filteredCoordinatesGroupedByRepo.get((Object)url);
            this.treeViewer.setChildCount((Object)url, elements.size());
            int j = 0;
            while (j < elements.size() && replacedElementsCount < numberOfVisibleElements) {
                this.treeViewer.replace((Object)url, j, elements.get(j));
                ++replacedElementsCount;
                ++j;
            }
            this.treeViewer.getTree().getItem(i).setExpanded(true);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        this.bindingContext.dispose();
        this.bus.unregister((Object)this);
    }

    @Subscribe
    public void onModelIndexOpened(ModelEvents.ModelIndexOpenedEvent e) {
        this.refreshData();
    }

    @Subscribe
    public void onAdvisorConfigurationChanged(ModelEvents.AdvisorConfigurationChangedEvent e) throws IOException {
        this.refreshData();
    }

    @Subscribe
    public void onModelArchiveDownloaded(final ModelEvents.ModelArchiveDownloadedEvent e) {
        new UIJob(Messages.JOB_NAME_REFRESHING_MODEL_REPOSITORIES_VIEW){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                KnownCoordinate element;
                KnownCoordinate key = this.createKey(e.model);
                if (key != null && (element = (KnownCoordinate)Iterables.tryFind((Iterable)ModelRepositoriesView.this.coordinatesGroupedByRepo.get((Object)key.url), (Predicate)Predicates.equalTo((Object)key)).orNull()) != null) {
                    ModelRepositoriesView.this.treeViewer.update((Object)element, null);
                }
                return Status.OK_STATUS;
            }

            private KnownCoordinate createKey(ModelCoordinate mc) {
                Optional remoteUrl = mc.getHint("repository.url");
                if (remoteUrl.isPresent()) {
                    return new KnownCoordinate((String)remoteUrl.get(), ModelCoordinates.toProjectCoordinate((ModelCoordinate)mc), Collections.emptyList());
                }
                return null;
            }
        }.schedule();
    }

    private void addRemoteRepository() {
        RepositoryDetailsDialog newRepositoryDialog = new RepositoryDetailsDialog(null, null, Lists.newArrayList((Object[])this.preferences.remotes), this.preferences);
        if (newRepositoryDialog.open() == 0) {
            this.addRepository(newRepositoryDialog.getRepositoryUrl());
        }
    }

    private void deleteRepository(String remoteUrl) {
        ArrayList newRemotes = Lists.newArrayList((Object[])this.preferences.remotes);
        newRemotes.remove(remoteUrl);
        this.storeRepositories(newRemotes);
    }

    private void addRepository(String remoteUrl) {
        ArrayList newRemotes = Lists.newArrayList((Object[])this.preferences.remotes);
        newRemotes.add(remoteUrl);
        this.storeRepositories(newRemotes);
    }

    private void editRepository(String remoteUrl) {
        ArrayList newRemotes = Lists.newArrayList((Object[])this.preferences.remotes);
        RepositoryDetailsDialog editRepositoryDialog = new RepositoryDetailsDialog(null, remoteUrl, newRemotes, this.preferences);
        if (editRepositoryDialog.open() == 0) {
            String updatedRepositoryUrl = editRepositoryDialog.getRepositoryUrl();
            int indexOfOriginalRepository = newRemotes.indexOf(remoteUrl);
            newRemotes.remove(indexOfOriginalRepository);
            newRemotes.add(indexOfOriginalRepository, updatedRepositoryUrl);
            this.storeRepositories(newRemotes);
        }
    }

    private void storeRepositories(List<String> newRemotes) {
        try {
            IEclipsePreferences s = InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.models.rcp");
            s.put("repository.url.list", ModelsRcpPreferences.joinRemoteRepositoriesToString(newRemotes));
            s.flush();
        }
        catch (BackingStoreException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_STORE_REMOTE_REPOSITORY_PREFERENCES, (Throwable)e);
        }
    }

    private void deleteCacheAndRefresh() {
        new Job(Messages.JOB_NAME_DELETING_MODEL_CACHE){
            {
                this.schedule();
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ModelRepositoriesView.this.repo.deleteModels();
                    ModelRepositoriesView.this.refreshData();
                    return Status.OK_STATUS;
                }
                catch (IOException iOException) {
                    return new Status(4, "org.eclipse.recommenders.models.rcp", Messages.LOG_ERROR_FAILED_TO_DELETE_MODEL_CACHE);
                }
            }
        };
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue search = WidgetProperties.text((int)24).observeDelayed(400, (Widget)this.txtSearch);
        IObservableValue filter = PojoProperties.value((String)"filter").observe((Object)this);
        bindingContext.bindValue(filter, (IObservableValue)search, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        return bindingContext;
    }

    private static final class GlobMatcher
    implements Predicate<KnownCoordinate> {
        private final String glob;

        private GlobMatcher(String glob) {
            this.glob = "*" + Objects.requireNonNull(glob) + "*";
        }

        public boolean apply(KnownCoordinate kc) {
            return FilenameUtils.wildcardMatch((String)kc.pc.toString(), (String)this.glob, (IOCase)IOCase.INSENSITIVE);
        }
    }

    public class KnownCoordinate {
        public String url;
        public ProjectCoordinate pc;
        public Collection<ModelCoordinate> mcs;

        public KnownCoordinate(String url, ProjectCoordinate pc, Collection<ModelCoordinate> mcs) {
            this.url = url;
            this.pc = pc;
            this.mcs = mcs;
        }

        private Optional<ModelCoordinate> searchModelCoordinate(String classifier) {
            for (ModelCoordinate mc : this.mcs) {
                if (!mc.getClassifier().equals(classifier)) continue;
                return Optional.of((Object)mc);
            }
            return Optional.absent();
        }

        public boolean isDownloaded(String classifier) {
            Optional<ModelCoordinate> omc = this.searchModelCoordinate(classifier);
            if (omc.isPresent()) {
                return ModelRepositoriesView.this.repo.getLocation((ModelCoordinate)omc.get(), false).isPresent();
            }
            return false;
        }

        public boolean hasModelCoordinate(String classifier) {
            return this.searchModelCoordinate(classifier).isPresent();
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[]{"mcs"});
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[]{"mcs"});
        }
    }
}

