/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.jdbc.DelegatingConnection;
import org.eclipse.net4j.internal.db.DBDatabase;
import org.eclipse.net4j.internal.db.DBPreparedStatement;
import org.eclipse.net4j.internal.db.DBResultSet;
import org.eclipse.net4j.internal.db.DBSchemaTransaction;
import org.eclipse.net4j.util.CheckUtil;

public final class DBConnection
extends DelegatingConnection
implements IDBConnection {
    private final TreeMap<String, DBPreparedStatement> cache = new TreeMap();
    private final Set<DBPreparedStatement> checkOuts = new HashSet<DBPreparedStatement>();
    private final DBDatabase database;
    private int lastTouch;
    private boolean closed;

    public DBConnection(DBDatabase database, Connection delegate) {
        super(delegate);
        this.database = database;
        try {
            delegate.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new DBException(ex, "SET AUTO COMMIT = false");
        }
    }

    public DBDatabase getDatabase() {
        return this.database;
    }

    public String getUserID() {
        return this.database.getUserID();
    }

    public void close() {
        DBUtil.close(this.getDelegate());
        this.closed = true;
        this.database.closeConnection(this);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public IDBSchemaTransaction openSchemaTransaction() {
        DBSchemaTransaction schemaTransaction = this.database.openSchemaTransaction();
        schemaTransaction.setConnection(this);
        return schemaTransaction;
    }

    @Deprecated
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public IDBPreparedStatement prepareStatement(String sql, IDBPreparedStatement.ReuseProbability reuseProbability) {
        return this.prepareStatement(sql, 1003, 1007, reuseProbability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDBPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, IDBPreparedStatement.ReuseProbability reuseProbability) {
        DBPreparedStatement preparedStatement;
        this.database.beginSchemaAccess(false);
        DBConnection dBConnection = this;
        synchronized (dBConnection) {
            preparedStatement = this.cache.remove(sql);
            if (preparedStatement == null) {
                try {
                    PreparedStatement delegate = this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency);
                    preparedStatement = new DBPreparedStatement(this, sql, reuseProbability, delegate);
                }
                catch (SQLException ex) {
                    throw new DBException(ex);
                }
            }
            this.checkOuts.add(preparedStatement);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, IDBPreparedStatement.ReuseProbability.LOW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePreparedStatement(DBPreparedStatement preparedStatement) {
        try {
            if (preparedStatement == null) {
                return;
            }
            DBConnection dBConnection = this;
            synchronized (dBConnection) {
                this.checkOuts.remove(preparedStatement);
                preparedStatement.setTouch(++this.lastTouch);
                String sql = preparedStatement.getSQL();
                if (this.cache.put(sql, preparedStatement) != null) {
                    throw new IllegalStateException(String.valueOf(sql) + " already in cache");
                }
                if (this.cache.size() > this.database.getStatementCacheCapacity()) {
                    DBPreparedStatement old = this.cache.remove(this.cache.firstKey());
                    DBUtil.close(old.getDelegate());
                }
            }
        }
        finally {
            this.database.endSchemaAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateStatementCache() {
        DBConnection dBConnection = this;
        synchronized (dBConnection) {
            CheckUtil.checkState((boolean)this.checkOuts.isEmpty(), (String)("Statements are checked out: " + this.checkOuts));
            for (DBPreparedStatement preparedStatement : this.cache.values()) {
                PreparedStatement delegate = preparedStatement.getDelegate();
                DBUtil.close(delegate);
            }
            this.cache.clear();
        }
    }

    public String convertString(DBPreparedStatement preparedStatement, int parameterIndex, String value) {
        return this.getDatabase().convertString(preparedStatement, parameterIndex, value);
    }

    public String convertString(DBResultSet resultSet, int columnIndex, String value) {
        return this.getDatabase().convertString(resultSet, columnIndex, value);
    }

    public String convertString(DBResultSet resultSet, String columnLabel, String value) {
        return this.getDatabase().convertString(resultSet, columnLabel, value);
    }
}

