/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceIndirectionRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class IntroduceIndirectionInputPage
extends UserInputWizardPage {
    private Text fIntermediaryMethodName;
    private Combo fIntermediaryTypeName;
    private static final int INTERMEDIARY_TYPE_COUNT = 10;
    private static List<String> fgIntermediaryTypes = new ArrayList<String>(10);

    public IntroduceIndirectionInputPage(String name) {
        super(name);
    }

    private Text createIntermediaryNameCombo(Composite result) {
        Text textField = new Text(result, 18436);
        textField.setLayoutData((Object)new GridData(768));
        TextFieldNavigationHandler.install(textField);
        return textField;
    }

    private Combo createIntermediaryTypeCombo(Composite composite) {
        Combo textCombo = new Combo(composite, 2052);
        textCombo.setLayoutData((Object)new GridData(768));
        textCombo.setItems(fgIntermediaryTypes.toArray(new String[fgIntermediaryTypes.size()]));
        textCombo.setVisibleItemCount(10);
        JavaTypeCompletionProcessor processor = new JavaTypeCompletionProcessor(false, false, true);
        processor.setPackageFragment(this.getIntroduceIndirectionRefactoring().getInvocationPackage());
        ControlContentAssistHelper.createComboContentAssistant(textCombo, processor);
        TextFieldNavigationHandler.install(textCombo);
        return textCombo;
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label methNameLabel = new Label(result, 0);
        methNameLabel.setText(RefactoringMessages.IntroduceIndirectionInputPage_new_method_name);
        this.fIntermediaryMethodName = this.createIntermediaryNameCombo(result);
        Label intermediaryTypeLabel = new Label(result, 0);
        intermediaryTypeLabel.setText(RefactoringMessages.IntroduceIndirectionInputPage_declaring_class);
        Composite inner = new Composite(result, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerLayout.numColumns = 2;
        inner.setLayout((Layout)innerLayout);
        inner.setLayoutData((Object)new GridData(768));
        this.fIntermediaryTypeName = this.createIntermediaryTypeCombo(inner);
        this.fIntermediaryTypeName.setLayoutData((Object)new GridData(768));
        Button browseTypes = new Button(inner, 8);
        browseTypes.setText(RefactoringMessages.IntroduceIndirectionInputPage_browse);
        GridData gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.widthHint = SWTUtil.getButtonWidthHint(browseTypes);
        browseTypes.setLayoutData((Object)gd);
        final Button enableReferencesCheckBox = new Button(result, 32);
        enableReferencesCheckBox.setText(RefactoringMessages.IntroduceIndirectionInputPage_update_references);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 2;
        enableReferencesCheckBox.setLayoutData((Object)gd);
        this.fIntermediaryMethodName.setText(this.getIntroduceIndirectionRefactoring().getIntermediaryMethodName());
        this.fIntermediaryTypeName.setText(this.getIntroduceIndirectionRefactoring().getIntermediaryTypeName());
        this.fIntermediaryMethodName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IntroduceIndirectionInputPage.this.validateInput();
            }
        });
        enableReferencesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntroduceIndirectionInputPage.this.getIntroduceIndirectionRefactoring().setEnableUpdateReferences(enableReferencesCheckBox.getSelection());
            }
        });
        this.fIntermediaryTypeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IntroduceIndirectionInputPage.this.validateInput();
            }
        });
        browseTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType intermediaryType = IntroduceIndirectionInputPage.this.chooseIntermediaryType();
                if (intermediaryType == null) {
                    return;
                }
                IntroduceIndirectionInputPage.this.fIntermediaryTypeName.setText(intermediaryType.getFullyQualifiedName('.'));
            }
        });
        if (this.getIntroduceIndirectionRefactoring().canEnableUpdateReferences()) {
            enableReferencesCheckBox.setSelection(true);
        } else {
            enableReferencesCheckBox.setSelection(false);
            enableReferencesCheckBox.setEnabled(false);
            this.getIntroduceIndirectionRefactoring().setEnableUpdateReferences(false);
        }
        this.fIntermediaryMethodName.setFocus();
        this.fIntermediaryMethodName.selectAll();
        this.validateInput();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.introduce_indirection_wizard_page_context");
    }

    private IType chooseIntermediaryType() {
        IJavaProject proj = this.getIntroduceIndirectionRefactoring().getProject();
        if (proj == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{proj};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        int elementKinds = JavaModelUtil.is18OrHigher((IJavaProject)proj) ? 10 : 5;
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, elementKinds);
        dialog.setTitle(RefactoringMessages.IntroduceIndirectionInputPage_dialog_choose_declaring_class);
        dialog.setMessage(RefactoringMessages.IntroduceIndirectionInputPage_dialog_choose_declaring_class_long);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private IntroduceIndirectionRefactoring getIntroduceIndirectionRefactoring() {
        return (IntroduceIndirectionRefactoring)this.getRefactoring();
    }

    private void validateInput() {
        RefactoringStatus merged = new RefactoringStatus();
        merged.merge(this.getIntroduceIndirectionRefactoring().setIntermediaryTypeName(this.fIntermediaryTypeName.getText()));
        merged.merge(this.getIntroduceIndirectionRefactoring().setIntermediaryMethodName(this.fIntermediaryMethodName.getText()));
        this.setPageComplete(!merged.hasError());
        int severity = merged.getSeverity();
        String message = merged.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }

    protected boolean performFinish() {
        this.storeIntermediaryTypeName();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.storeIntermediaryTypeName();
        return super.getNextPage();
    }

    private void storeIntermediaryTypeName() {
        String destination = this.fIntermediaryTypeName.getText();
        if (!fgIntermediaryTypes.remove(destination) && fgIntermediaryTypes.size() >= 10) {
            fgIntermediaryTypes.remove(fgIntermediaryTypes.size() - 1);
        }
        fgIntermediaryTypes.add(0, destination);
    }
}

