/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.net.URI;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.epp.mpc.core.service.IMarketplaceStorageService;
import org.eclipse.userstorage.util.ProtocolException;

public abstract class AbstractDataStorageService {
    private IMarketplaceStorageService storageService;

    public IMarketplaceStorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(IMarketplaceStorageService storageService) {
        this.storageService = storageService;
    }

    protected static Exception processProtocolException(Exception exception) {
        Throwable ex = exception;
        while (ex != null) {
            if (ex instanceof ProtocolException) {
                ProtocolException protocolException = (ProtocolException)ex;
                return AbstractDataStorageService.processProtocolException(protocolException);
            }
            if (ex instanceof OperationCanceledException) {
                OperationCanceledException oce = (OperationCanceledException)ex;
                return AbstractDataStorageService.processProtocolException(oce);
            }
            ex = ex.getCause();
        }
        return exception;
    }

    protected static ProtocolException processProtocolException(OperationCanceledException ex) {
        return new NotAuthorizedException(ex);
    }

    protected static ProtocolException processProtocolException(ProtocolException ex) {
        if (ex.getStatusCode() == 401 || ex.getStatusCode() == 403) {
            return new NotAuthorizedException(ex);
        }
        if (ex.getStatusCode() == 406 && ex.getMessage() != null && ex.getMessage().toLowerCase().contains("account") && ex.getMessage().toLowerCase().contains("blocked")) {
            return new NotAuthorizedException(ex);
        }
        return ex;
    }

    public void bindStorageService(IMarketplaceStorageService storageService) {
        this.setStorageService(storageService);
    }

    public void unbindStorageService(IMarketplaceStorageService storageService) {
        if (this.getStorageService() == storageService) {
            this.setStorageService(null);
        }
    }

    public static class NotAuthorizedException
    extends ProtocolException {
        public NotAuthorizedException() {
        }

        public NotAuthorizedException(Throwable cause) {
            this.initCause(cause);
            this.setStackTrace(cause.getStackTrace());
        }

        public NotAuthorizedException(ProtocolException exception) {
            super(exception.getMethod(), exception.getURI(), exception.getProtocolVersion(), exception.getStatusCode(), exception.getReasonPhrase());
            this.initCause(exception);
            this.setStackTrace(exception.getStackTrace());
        }

        public NotAuthorizedException(String method, URI uri, String protocolVersion, int statusCode, String reasonPhrase) {
            super(method, uri, protocolVersion, statusCode, reasonPhrase);
        }

        public String getMessage() {
            String reasonPhrase = this.getReasonPhrase();
            if (reasonPhrase != null && !"".equals(reasonPhrase)) {
                return reasonPhrase;
            }
            return super.getMessage();
        }

        public String toString() {
            String s = ((Object)((Object)this)).getClass().getName();
            String message = super.getMessage();
            return message != null ? String.valueOf(s) + ": " + message : s;
        }
    }
}

