/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.menu;

import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.IDropRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.part.menu.MenuEditPart;
import org.eclipse.wb.internal.core.gef.part.menu.MenuPopupEditPart;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuObjectInfo;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;

public final class SubmenuAwareLayoutEditPolicy
extends LayoutEditPolicy {
    private final IMenuObjectInfo m_object;
    private final ILayoutRequestValidator m_validator = new ILayoutRequestValidator(){

        public boolean validateCreateRequest(EditPart host, CreateRequest request) {
            IMenuInfo subMenu = SubmenuAwareLayoutEditPolicy.this.getSubMenu();
            return subMenu != null && subMenu.getPolicy().validateCreate(request.getNewObject());
        }

        public boolean validatePasteRequest(EditPart host, PasteRequest request) {
            IMenuInfo subMenu = SubmenuAwareLayoutEditPolicy.this.getSubMenu();
            return subMenu != null && subMenu.getPolicy().validatePaste(request.getMemento());
        }

        public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
            IMenuInfo subMenu = SubmenuAwareLayoutEditPolicy.this.getSubMenu();
            if (subMenu == null) {
                return false;
            }
            for (EditPart editPart : request.getEditParts()) {
                if (subMenu.getPolicy().validateMove(editPart.getModel())) continue;
                return false;
            }
            return true;
        }

        public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
            return this.validateMoveRequest(host, request);
        }
    };

    public SubmenuAwareLayoutEditPolicy(IMenuObjectInfo object) {
        this.m_object = object;
    }

    protected Layer getFeedbackLayer() {
        return this.getLayer("Menu Feedback Layer");
    }

    public void showTargetFeedback(Request request) {
        PolicyUtils.showBorderTargetFeedback(this);
    }

    public void eraseTargetFeedback(Request request) {
        PolicyUtils.eraseBorderTargetFeedback(this);
    }

    public EditPart getTargetEditPart(Request request) {
        int height;
        int halfWidth;
        if (!this.isRequestCondition(request)) {
            return null;
        }
        if (this.getHost() instanceof MenuPopupEditPart) {
            return this.getHost();
        }
        if (!(this.getHost().getParent() instanceof MenuEditPart)) {
            return this.getHost();
        }
        if (this.getSubMenu() == null) {
            return null;
        }
        Figure figure = this.getHostFigure();
        Point location = ((IDropRequest)((Object)request)).getLocation().getCopy();
        FigureUtils.translateAbsoluteToFigure2(figure, location);
        IMenuInfo parentMenu = ((MenuEditPart)this.getHost().getParent()).getMenu();
        if (parentMenu.isHorizontal() ? SubmenuAwareLayoutEditPolicy.between(location.x, (halfWidth = figure.getSize().width / 2) - halfWidth / 4, halfWidth + halfWidth / 4) : SubmenuAwareLayoutEditPolicy.between(location.y, (height = figure.getSize().height) / 2 - height / 3, height / 2 + height / 3)) {
            return this.getHost();
        }
        return null;
    }

    private IMenuInfo getSubMenu() {
        return MenuObjectInfoUtils.getSubMenu(this.m_object);
    }

    private static boolean between(int x, int a, int b) {
        return x >= a && x <= b;
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return this.m_validator;
    }
}

