/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.palette;

import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.border.MarginBorder;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.utils.ui.SwtResourceManager;
import org.eclipse.wb.internal.draw2d.CustomTooltipProvider;
import org.eclipse.wb.internal.draw2d.JustifyLabel;
import org.eclipse.wb.internal.draw2d.Label;

public final class JustifyPaletteTooltipProvider
extends CustomTooltipProvider {
    private final String m_header;
    private final String m_details;
    private final int m_wrapChars;

    public JustifyPaletteTooltipProvider(String header, String details, int wrapChars) {
        this.m_header = header;
        this.m_details = details;
        this.m_wrapChars = wrapChars;
    }

    protected Figure createTooltipFigure(Figure hostFigure) {
        Label headerFigure = new Label(this.m_header);
        headerFigure.setFont(SwtResourceManager.getBoldFont(headerFigure.getFont()));
        JustifyLabel detailsFigure = new JustifyLabel();
        detailsFigure.setBorder(new MarginBorder(new Insets(0, 2, 2, 2)));
        detailsFigure.setWrapChars(this.m_wrapChars);
        detailsFigure.setText(this.m_details);
        Dimension headerSize = headerFigure.getPreferredSize();
        Dimension detailsSize = detailsFigure.getPreferredSize();
        if (headerSize.width > detailsSize.width) {
            detailsFigure.setWrapPixels(headerSize.width + 10);
            detailsSize = detailsFigure.getPreferredSize();
            if (headerSize.width > detailsSize.width) {
                detailsSize.width = headerSize.width + 10;
            }
        }
        Figure tooltipFigure = new Figure();
        tooltipFigure.add((Figure)headerFigure, new Rectangle(detailsSize.width / 2 - headerSize.width / 2, 0, headerSize.width, headerSize.height));
        tooltipFigure.add((Figure)detailsFigure, new Rectangle(0, headerSize.height, detailsSize.width, detailsSize.height));
        tooltipFigure.setBounds(new Rectangle(0, 0, detailsSize.width, headerSize.height + detailsSize.height));
        return tooltipFigure;
    }
}

