/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.ParameterVariable;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.ResultVariable;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionHelper;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public class PivotHelper {
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull StandardLibrary standardLibrary;

    public PivotHelper(@NonNull EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.standardLibrary = environmentFactory.getStandardLibrary();
    }

    public @NonNull BooleanLiteralExp createBooleanLiteralExp(boolean booleanSymbol) {
        BooleanLiteralExp asBoolean = PivotFactory.eINSTANCE.createBooleanLiteralExp();
        asBoolean.setBooleanSymbol(booleanSymbol);
        asBoolean.setType(this.standardLibrary.getBooleanType());
        asBoolean.setIsRequired(true);
        return asBoolean;
    }

    public @NonNull CollectionItem createCollectionItem(@NonNull OCLExpression asItem) {
        CollectionItem collectionItem = PivotFactory.eINSTANCE.createCollectionItem();
        collectionItem.setOwnedItem(asItem);
        collectionItem.setType(asItem.getType());
        collectionItem.setIsRequired(asItem.isIsRequired());
        return collectionItem;
    }

    public @NonNull CollectionLiteralExp createCollectionLiteralExp(@NonNull CollectionType asType, @NonNull Iterable<CollectionLiteralPart> asParts) {
        CollectionLiteralExp collectionLiteralExp = PivotFactory.eINSTANCE.createCollectionLiteralExp();
        Iterables.addAll(collectionLiteralExp.getOwnedParts(), asParts);
        collectionLiteralExp.setType(asType);
        collectionLiteralExp.setKind(TypeUtil.getCollectionKind(asType));
        collectionLiteralExp.setIsRequired(true);
        return collectionLiteralExp;
    }

    public @NonNull CollectionRange createCollectionRange(@NonNull OCLExpression asFirst, @NonNull OCLExpression asLast) {
        CollectionRange collectionRange = PivotFactory.eINSTANCE.createCollectionRange();
        collectionRange.setOwnedFirst(asFirst);
        collectionRange.setOwnedLast(asLast);
        collectionRange.setType(this.standardLibrary.getIntegerType());
        collectionRange.setIsRequired(true);
        return collectionRange;
    }

    public @NonNull Comment createComment(@NonNull String comment) {
        Comment asComment = PivotFactory.eINSTANCE.createComment();
        asComment.setBody(comment);
        return asComment;
    }

    public @NonNull IfExp createIfExp(@NonNull OCLExpression asCondition, @NonNull OCLExpression asThen, @NonNull OCLExpression asElse) {
        Type commonType = this.getMetamodelManager().getCommonType(ClassUtil.nonNullState(asThen.getType()), TemplateParameterSubstitutions.EMPTY, ClassUtil.nonNullState(asElse.getType()), TemplateParameterSubstitutions.EMPTY);
        IfExp asIf = PivotFactory.eINSTANCE.createIfExp();
        asIf.setOwnedCondition(asCondition);
        asIf.setOwnedThen(asThen);
        asIf.setOwnedElse(asElse);
        asIf.setType(commonType);
        asIf.setIsRequired(asThen.isIsRequired() && asElse.isIsRequired());
        return asIf;
    }

    public @NonNull Import createImport(@Nullable String name, @NonNull Namespace namespace) {
        Import asImport = PivotFactory.eINSTANCE.createImport();
        asImport.setName(name);
        asImport.setImportedNamespace(namespace);
        return asImport;
    }

    public @NonNull IntegerLiteralExp createIntegerLiteralExp(@NonNull Number integerSymbol) {
        IntegerLiteralExp asInteger = PivotFactory.eINSTANCE.createIntegerLiteralExp();
        asInteger.setIntegerSymbol(integerSymbol);
        asInteger.setType(this.standardLibrary.getIntegerType());
        asInteger.setIsRequired(true);
        return asInteger;
    }

    public @NonNull InvalidLiteralExp createInvalidExpression() {
        InvalidLiteralExp invalidLiteralExp = PivotFactory.eINSTANCE.createInvalidLiteralExp();
        invalidLiteralExp.setType(this.standardLibrary.getOclInvalidType());
        return invalidLiteralExp;
    }

    public @NonNull IterateExp createIterateExp(@NonNull OCLExpression asSource, @NonNull Iteration asIteration, @NonNull List<@NonNull ? extends Variable> asIterators, @NonNull Variable asResult, @NonNull OCLExpression asBody) {
        IterateExp asCallExp = PivotFactory.eINSTANCE.createIterateExp();
        asCallExp.setReferredIteration(asIteration);
        asCallExp.setOwnedSource(asSource);
        asCallExp.getOwnedIterators().addAll(asIterators);
        asCallExp.setOwnedResult(asResult);
        asCallExp.setOwnedBody(asBody);
        Type formalType = asIteration.getType();
        assert (formalType != null);
        asCallExp.setType(formalType);
        asCallExp.setIsRequired(asIteration.isIsRequired());
        Type actualType = asSource.getType();
        assert (actualType != null);
        Type returnType = this.getMetamodelManager().specializeType(formalType, asCallExp, actualType, asSource.getTypeValue());
        asCallExp.setType(returnType);
        return asCallExp;
    }

    public @NonNull IteratorExp createIteratorExp(@NonNull OCLExpression asSource, @NonNull Iteration asIteration, @NonNull List<@NonNull ? extends Variable> asIterators, @NonNull OCLExpression asBody) {
        IteratorExp asCallExp = PivotFactory.eINSTANCE.createIteratorExp();
        asCallExp.setReferredIteration(asIteration);
        asCallExp.setOwnedSource(asSource);
        asCallExp.getOwnedIterators().addAll(asIterators);
        asCallExp.setOwnedBody(asBody);
        Type formalType = asIteration.getType();
        assert (formalType != null);
        asCallExp.setType(formalType);
        asCallExp.setIsRequired(asIteration.isIsRequired());
        Type actualType = asSource.getType();
        assert (actualType != null);
        Type returnType = this.getMetamodelManager().specializeType(formalType, asCallExp, actualType, asSource.getTypeValue());
        asCallExp.setType(returnType);
        return asCallExp;
    }

    public @NonNull IteratorVariable createIteratorVariable(@NonNull String name, @NonNull Type asType, boolean isRequired) {
        IteratorVariable asVariable = PivotFactory.eINSTANCE.createIteratorVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        return asVariable;
    }

    public @NonNull LetExp createLetExp(@NonNull Variable asVariable, @NonNull OCLExpression asInExpression) {
        Type commonType = this.getMetamodelManager().getCommonType(ClassUtil.nonNullState(asVariable.getType()), TemplateParameterSubstitutions.EMPTY, ClassUtil.nonNullState(asInExpression.getType()), TemplateParameterSubstitutions.EMPTY);
        LetExp asLetExp = PivotFactory.eINSTANCE.createLetExp();
        asLetExp.setOwnedVariable(asVariable);
        asLetExp.setOwnedIn(asInExpression);
        asLetExp.setType(commonType);
        asLetExp.setIsRequired(asInExpression.isIsRequired());
        asLetExp.setOwnedVariable(asVariable);
        return asLetExp;
    }

    public @NonNull LetVariable createLetVariable(@NonNull String name, @NonNull OCLExpression asInitExpression) {
        LetVariable asVariable = PivotFactory.eINSTANCE.createLetVariable();
        asVariable.setName(name);
        asVariable.setType(asInitExpression.getType());
        asVariable.setIsRequired(asInitExpression.isIsRequired());
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    public @NonNull LetVariable createLetVariable(@NonNull String name, @NonNull Type asType, boolean isRequired) {
        LetVariable asVariable = PivotFactory.eINSTANCE.createLetVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        return asVariable;
    }

    public @NonNull LetVariable createLetVariable(@NonNull String name, @NonNull Type asType, boolean isRequired, @NonNull OCLExpression asInitExpression) {
        LetVariable asVariable = PivotFactory.eINSTANCE.createLetVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    public @NonNull OCLExpression createMapLiteralExp(@NonNull MapType asType, @NonNull Iterable<MapLiteralPart> asParts) {
        MapLiteralExp mapLiteralExp = PivotFactory.eINSTANCE.createMapLiteralExp();
        Iterables.addAll(mapLiteralExp.getOwnedParts(), asParts);
        mapLiteralExp.setType(asType);
        mapLiteralExp.setIsRequired(true);
        return mapLiteralExp;
    }

    public @NonNull MapLiteralPart createMapLiteralPart(@NonNull OCLExpression asKey, @NonNull OCLExpression asValue) {
        MapLiteralPart mapLiteralPart = PivotFactory.eINSTANCE.createMapLiteralPart();
        mapLiteralPart.setOwnedKey(asKey);
        mapLiteralPart.setOwnedValue(asValue);
        return mapLiteralPart;
    }

    public @NonNull NavigationCallExp createNavigationCallExp(@NonNull OCLExpression asSourceExpression, @NonNull Property asProperty) {
        return PivotUtil.createNavigationCallExp(asSourceExpression, asProperty);
    }

    public @NonNull NullLiteralExp createNullLiteralExp() {
        NullLiteralExp asNull = PivotFactory.eINSTANCE.createNullLiteralExp();
        asNull.setType(this.standardLibrary.getOclVoidType());
        asNull.setIsRequired(false);
        return asNull;
    }

    public @NonNull OperationCallExp createOperationCallExp(@NonNull OCLExpression asSourceExpression, @NonNull String opName, OCLExpression ... asArguments) {
        Type asType = ClassUtil.nonNullState(asSourceExpression.getType());
        CompleteClass completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(asType);
        int argumentCount = asArguments != null ? asArguments.length : 0;
        int bestMatches = -1;
        Operation bestOperation = null;
        for (Operation asOperation : completeClass.getOperations(FeatureFilter.SELECT_NON_STATIC, opName)) {
            List<@NonNull Parameter> asParameters = ClassUtil.nullFree(asOperation.getOwnedParameters());
            if (asParameters.size() != argumentCount || asArguments == null) continue;
            int exactMatches = 0;
            boolean gotOne = true;
            int i = 0;
            while (i < argumentCount) {
                Type asArgumentType;
                Type asParameterType = ClassUtil.nonNullState(((TypedElement)asParameters.get(i)).getType());
                if (asParameterType instanceof SelfType) {
                    asArgumentType = asArguments[i].getType();
                    if (asArgumentType.conformsTo(this.standardLibrary, asType) && asType.conformsTo(this.standardLibrary, asArgumentType)) {
                        ++exactMatches;
                    }
                } else {
                    asArgumentType = asArguments[i].getType();
                    if (!asArgumentType.conformsTo(this.standardLibrary, asParameterType)) {
                        gotOne = false;
                        break;
                    }
                    if (asParameterType.conformsTo(this.standardLibrary, asArgumentType)) {
                        ++exactMatches;
                    }
                }
                ++i;
            }
            if (!gotOne) continue;
            if (exactMatches > bestMatches) {
                bestMatches = exactMatches;
                bestOperation = asOperation;
                continue;
            }
            if (exactMatches <= bestMatches) continue;
            bestOperation = null;
        }
        if (bestMatches < 0) {
            throw new IllegalStateException("No match found for " + opName);
        }
        if (bestOperation == null) {
            throw new IllegalStateException("Ambiguous match found for " + opName);
        }
        return this.createOperationCallExp(asSourceExpression, bestOperation, asArguments != null ? Lists.newArrayList((Object[])asArguments) : null);
    }

    public @NonNull OperationCallExp createOperationCallExp(@Nullable OCLExpression asSourceExpression, @NonNull Operation asOperation, @Nullable List<@NonNull OCLExpression> asArguments) {
        OperationCallExp asOperationCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
        asOperationCallExp.setOwnedSource(asSourceExpression);
        asOperationCallExp.setReferredOperation(asOperation);
        if (asArguments != null) {
            asOperationCallExp.getOwnedArguments().addAll(asArguments);
        }
        asOperationCallExp.setIsRequired(asOperation.isIsRequired());
        Type formalType = asOperation.getType();
        Type sourceType = null;
        Type sourceTypeValue = null;
        if (asSourceExpression != null) {
            sourceType = asSourceExpression.getType();
            sourceTypeValue = asSourceExpression.getTypeValue();
        }
        Type returnType = null;
        if (formalType != null && sourceType != null) {
            java.lang.Class<?> className;
            TemplateParameterSubstitutionHelper helper;
            PivotMetamodelManager metamodelManager = this.getMetamodelManager();
            returnType = asOperation.isIsTypeof() ? metamodelManager.specializeType(formalType, asOperationCallExp, sourceType, null) : metamodelManager.specializeType(formalType, asOperationCallExp, sourceType, sourceTypeValue);
            boolean returnIsRequired = asOperation.isIsRequired();
            LibraryFeature implementationClass = asOperation.getImplementation();
            if (implementationClass != null && (helper = TemplateParameterSubstitutionHelper.getHelper(className = implementationClass.getClass())) != null) {
                returnType = helper.resolveReturnType(metamodelManager, asOperationCallExp, returnType);
                returnIsRequired = helper.resolveReturnNullity(metamodelManager, asOperationCallExp, returnIsRequired);
            }
            if (asOperation.isIsTypeof()) {
                this.setType(asOperationCallExp, this.standardLibrary.getClassType(), returnIsRequired, returnType);
            } else {
                this.setType(asOperationCallExp, returnType, returnIsRequired, null);
            }
        }
        return asOperationCallExp;
    }

    public @NonNull Package createPackage(@NonNull String name, @Nullable String nsPrefix, @Nullable String nsURI) {
        Package asPackage = PivotFactory.eINSTANCE.createPackage();
        asPackage.setName(name);
        if (nsPrefix != null) {
            asPackage.setNsPrefix(nsPrefix);
        }
        if (nsURI != null) {
            asPackage.setURI(nsURI);
        }
        return asPackage;
    }

    public @NonNull Parameter createParameter(@NonNull TypedElement typedElement) {
        String name = ClassUtil.nonNullState(typedElement.getName());
        Type type = ClassUtil.nonNullState(typedElement.getType());
        Parameter asParameter = PivotUtil.createParameter(name, type, typedElement.isIsRequired());
        return asParameter;
    }

    public @NonNull ParameterVariable createParameterVariable(@NonNull String name, @NonNull Type asType, boolean isRequired) {
        ParameterVariable asVariable = PivotFactory.eINSTANCE.createParameterVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        return asVariable;
    }

    public @NonNull RealLiteralExp createRealLiteralExp(@NonNull Number realSymbol) {
        RealLiteralExp asReal = PivotFactory.eINSTANCE.createRealLiteralExp();
        asReal.setRealSymbol(realSymbol);
        asReal.setType(this.standardLibrary.getRealType());
        asReal.setIsRequired(true);
        return asReal;
    }

    public @NonNull ResultVariable createResultVariable(@NonNull String name, @NonNull Type asType, boolean isRequired, @NonNull OCLExpression asInitExpression) {
        ResultVariable asVariable = PivotFactory.eINSTANCE.createResultVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    public @NonNull OCLExpression createShadowExp(@NonNull Class asClass, @NonNull Iterable<ShadowPart> asParts) {
        ShadowExp shadowExp = PivotFactory.eINSTANCE.createShadowExp();
        Iterables.addAll(shadowExp.getOwnedParts(), asParts);
        shadowExp.setType(asClass);
        shadowExp.setIsRequired(true);
        return shadowExp;
    }

    public @NonNull ShadowPart createShadowPart(@NonNull Property asProperty, @NonNull OCLExpression asValue) {
        ShadowPart shadowPart = PivotFactory.eINSTANCE.createShadowPart();
        shadowPart.setReferredProperty(asProperty);
        shadowPart.setType(asProperty.getType());
        shadowPart.setIsRequired(asProperty.isIsRequired());
        shadowPart.setOwnedInit(asValue);
        return shadowPart;
    }

    public @NonNull StringLiteralExp createStringLiteralExp(@NonNull String stringSymbol) {
        StringLiteralExp asString = PivotFactory.eINSTANCE.createStringLiteralExp();
        asString.setStringSymbol(stringSymbol);
        asString.setType(this.standardLibrary.getStringType());
        asString.setIsRequired(true);
        return asString;
    }

    public @NonNull TupleLiteralExp createTupleLiteralExp(@NonNull TupleType asType, @NonNull Iterable<TupleLiteralPart> asParts) {
        TupleLiteralExp tupleLiteralExp = PivotFactory.eINSTANCE.createTupleLiteralExp();
        Iterables.addAll(tupleLiteralExp.getOwnedParts(), asParts);
        tupleLiteralExp.setType(asType);
        tupleLiteralExp.setIsRequired(true);
        return tupleLiteralExp;
    }

    public @NonNull TupleLiteralPart createTupleLiteralPart(@NonNull String name, @NonNull Type asType, boolean isRequired, @NonNull OCLExpression asValue) {
        TupleLiteralPart tupleLiteralPart = PivotFactory.eINSTANCE.createTupleLiteralPart();
        tupleLiteralPart.setName(name);
        tupleLiteralPart.setType(asType);
        tupleLiteralPart.setIsRequired(isRequired);
        tupleLiteralPart.setOwnedInit(asValue);
        return tupleLiteralPart;
    }

    public @NonNull TypeExp createTypeExp(@NonNull Type type) {
        TypeExp asTypeExp = PivotFactory.eINSTANCE.createTypeExp();
        asTypeExp.setIsRequired(true);
        asTypeExp.setReferredType(type);
        asTypeExp.setType(this.standardLibrary.getClassType());
        asTypeExp.setTypeValue(type);
        return asTypeExp;
    }

    public @NonNull UnlimitedNaturalLiteralExp createUnlimitedNaturalLiteralExp(@NonNull Number unlimitedNaturalSymbol) {
        UnlimitedNaturalLiteralExp asUnlimitedNatural = PivotFactory.eINSTANCE.createUnlimitedNaturalLiteralExp();
        asUnlimitedNatural.setUnlimitedNaturalSymbol(unlimitedNaturalSymbol);
        asUnlimitedNatural.setType(this.standardLibrary.getUnlimitedNaturalType());
        asUnlimitedNatural.setIsRequired(true);
        return asUnlimitedNatural;
    }

    @Deprecated
    public @NonNull Variable createVariable(@NonNull String name, @NonNull OCLExpression asInitExpression) {
        Variable asVariable = PivotUtil.createVariable(name, asInitExpression);
        return asVariable;
    }

    @Deprecated
    public @NonNull Variable createVariable(@NonNull String name, @NonNull Type asType, boolean isRequired, @Nullable OCLExpression asInitExpression) {
        Variable asVariable = PivotUtil.createVariable(name, asType, isRequired, asInitExpression);
        return asVariable;
    }

    @Deprecated
    public @NonNull Variable createVariable(@NonNull TypedElement typedElement) {
        String name = ClassUtil.nonNullState(typedElement.getName());
        Type type = ClassUtil.nonNullState(typedElement.getType());
        Variable asVariable = PivotUtil.createVariable(name, type, typedElement.isIsRequired(), null);
        return asVariable;
    }

    public @NonNull VariableExp createVariableExp(@NonNull VariableDeclaration asVariable) {
        VariableExp asVariableExp = PivotUtil.createVariableExp(asVariable);
        return asVariableExp;
    }

    public @NonNull Class getDataTypeClass() {
        return ClassUtil.nonNullState(this.environmentFactory.getMetamodelManager().getASClass("DataType"));
    }

    public @NonNull Property getDataTypeValueProperty() {
        return ClassUtil.nonNullState(NameUtil.getNameable(this.getDataTypeClass().getOwnedProperties(), "value"));
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    protected @NonNull PivotMetamodelManager getMetamodelManager() {
        return (PivotMetamodelManager)this.environmentFactory.getMetamodelManager();
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    public void rewriteSafeNavigations(@NonNull Element asTree) {
        List<@NonNull CallExp> unsafeCallExps = null;
        if (asTree instanceof CallExp) {
            unsafeCallExps = this.rewriteUnsafeCallExp_Gather(unsafeCallExps, (CallExp)asTree);
        }
        TreeIterator tit = asTree.eAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof CallExp)) continue;
            unsafeCallExps = this.rewriteUnsafeCallExp_Gather(unsafeCallExps, (CallExp)eObject);
        }
        if (unsafeCallExps != null) {
            PivotMetamodelManager metamodelManager = (PivotMetamodelManager)this.environmentFactory.getMetamodelManager();
            Class oclAnyType = this.environmentFactory.getStandardLibrary().getOclAnyType();
            Operation oclEqualsOperation = NameUtil.getNameable(oclAnyType.getOwnedOperations(), "=");
            assert (oclEqualsOperation != null);
            Class collectionType = this.environmentFactory.getStandardLibrary().getCollectionType();
            Operation excludingOperation = NameUtil.getNameable(collectionType.getOwnedOperations(), "excluding");
            assert (excludingOperation != null);
            for (CallExp unsafeCallExp : unsafeCallExps) {
                OCLExpression source = unsafeCallExp.getOwnedSource();
                assert (source != null);
                if (source.getType() instanceof CollectionType) {
                    this.rewriteUnsafeCollectionCallExp(metamodelManager, excludingOperation, unsafeCallExp);
                    continue;
                }
                this.rewriteUnsafeObjectCallExp(metamodelManager, oclEqualsOperation, unsafeCallExp);
            }
        }
    }

    private @Nullable List<@NonNull CallExp> rewriteUnsafeCallExp_Gather(@Nullable List<@NonNull CallExp> unsafeCallExps, @NonNull CallExp callExp) {
        OCLExpression source = callExp.getOwnedSource();
        if (source != null && callExp.isIsSafe()) {
            if (unsafeCallExps == null) {
                unsafeCallExps = new ArrayList<CallExp>();
            }
            unsafeCallExps.add(callExp);
        }
        return unsafeCallExps;
    }

    private void rewriteUnsafeCollectionCallExp(@NonNull PivotMetamodelManager metamodelManager, @NonNull Operation excludingOperation, @NonNull CallExp unsafeCollectionCallExp) {
        unsafeCollectionCallExp.setIsSafe(false);
        EObject eContainer = unsafeCollectionCallExp.eContainer();
        EReference eContainmentFeature = unsafeCollectionCallExp.eContainmentFeature();
        PivotUtilInternal.resetContainer(unsafeCollectionCallExp);
        NullLiteralExp nullExpression = metamodelManager.createNullLiteralExp();
        OperationCallExp safeCollectionCallExp = this.createOperationCallExp((OCLExpression)unsafeCollectionCallExp, excludingOperation, Collections.singletonList(nullExpression));
        eContainer.eSet((EStructuralFeature)eContainmentFeature, (Object)safeCollectionCallExp);
    }

    private void rewriteUnsafeObjectCallExp(@NonNull PivotMetamodelManager metamodelManager, @NonNull Operation oclEqualsOperation, @NonNull CallExp unsafeObjectCallExp) {
        unsafeObjectCallExp.setIsSafe(false);
        EObject eContainer = unsafeObjectCallExp.eContainer();
        EReference eContainmentFeature = unsafeObjectCallExp.eContainmentFeature();
        PivotUtilInternal.resetContainer(unsafeObjectCallExp);
        OCLExpression oldSourceExpression = unsafeObjectCallExp.getOwnedSource();
        assert (oldSourceExpression != null);
        LetVariable unsafeSourceVariable = this.createLetVariable("unsafe", oldSourceExpression);
        VariableExp unsafeSourceExpression1 = this.createVariableExp(unsafeSourceVariable);
        unsafeObjectCallExp.setOwnedSource(unsafeSourceExpression1);
        VariableExp unsafeSourceExpression2 = this.createVariableExp(unsafeSourceVariable);
        NullLiteralExp nullExpression = metamodelManager.createNullLiteralExp();
        OperationCallExp isUnsafeExpression = this.createOperationCallExp((OCLExpression)unsafeSourceExpression2, oclEqualsOperation, Collections.singletonList(nullExpression));
        NullLiteralExp thenExpression = metamodelManager.createNullLiteralExp();
        IfExp safeObjectCallExp = metamodelManager.createIfExp((OCLExpression)isUnsafeExpression, (OCLExpression)thenExpression, (OCLExpression)unsafeObjectCallExp);
        LetExp safeExp = this.createLetExp(unsafeSourceVariable, safeObjectCallExp);
        eContainer.eSet((EStructuralFeature)eContainmentFeature, (Object)safeExp);
    }

    public void setType(@NonNull OCLExpression asExpression, Type type, boolean isRequired, @Nullable Type typeValue) {
        Type primaryTypeValue;
        this.setType(asExpression, type, isRequired);
        Type type2 = primaryTypeValue = typeValue != null ? this.getMetamodelManager().getPrimaryType(typeValue) : null;
        if (primaryTypeValue != asExpression.getTypeValue()) {
            asExpression.setTypeValue(primaryTypeValue);
        }
    }

    public void setType(@NonNull TypedElement asTypedElement, Type type, boolean isRequired) {
        boolean wasRequired;
        Type primaryType;
        Type type2 = primaryType = type != null ? this.getMetamodelManager().getPrimaryType(type) : null;
        if (primaryType != asTypedElement.getType()) {
            asTypedElement.setType(primaryType);
        }
        if ((wasRequired = asTypedElement.isIsRequired()) != isRequired) {
            asTypedElement.setIsRequired(isRequired);
        }
        if (primaryType != null) {
            PivotUtil.debugWellContainedness(primaryType);
        }
    }
}

