/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.attributes;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.scoping.AbstractAttribution;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;

public class ExpressionInOCLAttribution
extends AbstractAttribution {
    public static final ExpressionInOCLAttribution INSTANCE = new ExpressionInOCLAttribution();

    @Override
    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        ExpressionInOCL targetExpression = (ExpressionInOCL)target;
        Variable contextVariable = targetExpression.getOwnedContext();
        for (Variable parameterVariable : targetExpression.getOwnedParameters()) {
            assert (parameterVariable != null);
            environmentView.addNamedElement(parameterVariable);
        }
        Variable resultVariable = targetExpression.getOwnedResult();
        if (resultVariable != null) {
            environmentView.addNamedElement(resultVariable);
        }
        if (contextVariable != null) {
            Package contextPackage;
            Type userType;
            Type type = contextVariable.getType();
            EnvironmentFactoryInternal environmentFactory = environmentView.getEnvironmentFactory();
            if (type != null) {
                environmentView.addNamedElement(contextVariable);
            } else {
                type = environmentFactory.getStandardLibrary().getOclVoidType();
            }
            if (!environmentView.hasFinalResult() && (userType = type) instanceof Class && (contextPackage = ((Class)userType).getOwningPackage()) != null) {
                if (targetExpression.eContainer() == null) {
                    environmentView.addRootPackages();
                    environmentView.addAllPackages(contextPackage);
                }
                if (!environmentView.hasFinalResult()) {
                    environmentView.addElementsOfScope(contextPackage, scopeView);
                }
                if (targetExpression.eContainer() == null) {
                    environmentView.addRootPackages();
                    environmentView.addAllPackages(contextPackage);
                    if (!environmentView.hasFinalResult()) {
                        environmentView.addElementsOfScope(contextPackage, scopeView);
                        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
                        if (environmentView.accepts(PivotPackage.Literals.TYPE)) {
                            Type typeValue = contextVariable.getTypeValue();
                            if (typeValue != null) {
                                environmentView.addNamedElement(typeValue);
                            }
                            for (Type gType : metamodelManager.getGlobalTypes()) {
                                if (gType == null) continue;
                                environmentView.addNamedElement(gType);
                            }
                        }
                        if (environmentView.accepts(PivotPackage.Literals.NAMESPACE)) {
                            for (Map.Entry<String, Namespace> entry : metamodelManager.getGlobalNamespaces()) {
                                String key = entry.getKey();
                                Namespace value = entry.getValue();
                                if (key == null || value == null) continue;
                                environmentView.addElement(key, value);
                            }
                        }
                    }
                }
            }
            if (!environmentView.hasFinalResult()) {
                environmentView.addElementsOfScope(type, scopeView);
            }
        }
        return scopeView.getParent();
    }
}

