/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleStructures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutGraph;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;

public class SimpleGraph
implements LayoutGraph {
    Map objectsToNodes = new HashMap();
    List relationships = new ArrayList();

    public void addEntity(LayoutEntity node) {
        if (node instanceof SimpleNode) {
            this.objectsToNodes.put(((SimpleNode)node).getRealObject(), node);
        }
    }

    public LayoutEntity addObjectNode(Object object) {
        SimpleNode simpleNode = (SimpleNode)this.objectsToNodes.get(object);
        if (simpleNode == null) {
            simpleNode = new SimpleNode(object);
            this.objectsToNodes.put(object, simpleNode);
        }
        return simpleNode;
    }

    public void addObjectRelationship(Object sourceNode, Object destinationNode) {
        this.addObjectRelationship(sourceNode, destinationNode, true, 1);
    }

    public void addObjectRelationship(Object sourceObject, Object destinationObject, boolean bidirectional, int weight) {
        this.addObjectNode(sourceObject);
        this.addObjectNode(destinationObject);
        SimpleNode sourceNode = (SimpleNode)this.objectsToNodes.get(sourceObject);
        SimpleNode destinationNode = (SimpleNode)this.objectsToNodes.get(destinationObject);
        SimpleRelationship simpleRelationship = new SimpleRelationship(sourceNode, destinationNode, bidirectional, weight);
        this.relationships.add(simpleRelationship);
    }

    public void addRelationship(LayoutEntity srcNode, LayoutEntity destNode) {
        this.addRelationship(srcNode, destNode, true, 1);
    }

    public void addRelationship(LayoutEntity srcNode, LayoutEntity destNode, boolean bidirectional, int weight) {
        this.addEntity(srcNode);
        this.addEntity(destNode);
        SimpleRelationship rel = new SimpleRelationship(srcNode, destNode, bidirectional, weight);
        this.relationships.add(rel);
    }

    public void addRelationship(LayoutRelationship relationship) {
        this.relationships.add(relationship);
    }

    public List getEntities() {
        return new ArrayList(this.objectsToNodes.values());
    }

    public List getRelationships() {
        return this.relationships;
    }

    public boolean isBidirectional() {
        boolean isBidirectional = true;
        Iterator iter = this.relationships.iterator();
        while (iter.hasNext()) {
            SimpleRelationship rel = (SimpleRelationship)iter.next();
            if (rel.isBidirectionalInLayout()) continue;
            isBidirectional = false;
            break;
        }
        return isBidirectional;
    }
}

