/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.tuple;

import java.util.Arrays;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class LeftInheritanceTuple
extends Tuple {
    private final int inheritedIndex;
    private final Tuple ancestor;
    private final Object[] localElements;

    public LeftInheritanceTuple(Tuple ancestor, Object[] localElements) {
        this.localElements = localElements;
        this.ancestor = ancestor;
        this.inheritedIndex = ancestor.getSize();
        this.calcHash();
    }

    @Override
    public int getSize() {
        return this.inheritedIndex + this.localElements.length;
    }

    @Override
    public Object get(int index) {
        return index < this.inheritedIndex ? this.ancestor.get(index) : this.localElements[index - this.inheritedIndex];
    }

    @Override
    void calcHash() {
        int PRIME = 31;
        this.cachedHash = this.ancestor.hashCode();
        int i = 0;
        while (i < this.localElements.length) {
            this.cachedHash *= 31;
            Object element = this.localElements[i];
            if (element != null) {
                this.cachedHash += element.hashCode();
            }
            ++i;
        }
    }

    @Override
    protected boolean internalEquals(Tuple other) {
        if (other instanceof LeftInheritanceTuple) {
            LeftInheritanceTuple lit = (LeftInheritanceTuple)other;
            if (lit.inheritedIndex == this.inheritedIndex && this.ancestor.equals(lit.ancestor)) {
                return Arrays.equals(this.localElements, lit.localElements);
            }
        }
        return super.internalEquals(other);
    }
}

