/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceFileSystemElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceValidateAndImportOperation;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class TraceImportOperation
extends WorkspaceModifyOperation {
    private final String fSourcePath;
    private final TmfTraceFolder fDestFolder;
    private boolean fSkipArchiveExtraction = false;
    private ITmfTimestamp fStartTimeRange = null;
    private ITmfTimestamp fEndTimeRange = null;

    public TraceImportOperation(String sourcePath, TmfTraceFolder destFolder) {
        this.fSourcePath = sourcePath;
        this.fDestFolder = destFolder;
    }

    public void setSkipArchiveExtraction(boolean skipArchiveExtraction) {
        this.fSkipArchiveExtraction = skipArchiveExtraction;
    }

    public void setFilteringTimeRange(ITmfTimestamp start, ITmfTimestamp end) {
        if (start.compareTo(end) < 0) {
            this.fStartTimeRange = start;
            this.fEndTimeRange = end;
        }
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        int importOptionFlags = 22;
        if (this.fSkipArchiveExtraction) {
            importOptionFlags |= 0x40;
        }
        if (this.fStartTimeRange != null && this.fEndTimeRange != null) {
            importOptionFlags |= 0x80;
        }
        Path baseSourceContainerPath = new Path(this.fSourcePath);
        IPath destinationContainerPath = this.fDestFolder.getPath();
        FileSystemObjectImportStructureProvider provider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
        IFileSystemObject object = provider.getIFileSystemObject(new File(this.fSourcePath));
        TraceFileSystemElement root = TraceFileSystemElement.createRootTraceFileElement(object, provider);
        ArrayList<TraceFileSystemElement> fileSystemElements = new ArrayList<TraceFileSystemElement>();
        root.getAllChildren(fileSystemElements);
        TraceValidateAndImportOperation importOperation = new TraceValidateAndImportOperation(null, fileSystemElements, null, (IPath)baseSourceContainerPath, destinationContainerPath, false, importOptionFlags, this.fDestFolder, this.fStartTimeRange, this.fEndTimeRange);
        try {
            importOperation.run(monitor);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError("Error running trace import operation", e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        monitor.done();
    }
}

