/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.symbols;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.BasicSymbolProviderPreferencePage;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.MappingFile;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;

public class BasicSymbolProvider
implements ISymbolProvider {
    private final @NonNull ITmfTrace fTrace;
    private final @NonNull List<@NonNull MappingFile> fMappingFiles = new ArrayList<MappingFile>();

    public BasicSymbolProvider(@NonNull ITmfTrace trace) {
        this.fTrace = trace;
    }

    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    public synchronized @NonNull List<@NonNull MappingFile> getMappingFiles() {
        return ImmutableList.copyOf(this.fMappingFiles);
    }

    public synchronized void setMappingFiles(@NonNull List<@NonNull MappingFile> mappingFiles) {
        this.fMappingFiles.clear();
        this.fMappingFiles.addAll(mappingFiles);
    }

    public void loadConfiguration(IProgressMonitor monitor) {
    }

    public @Nullable String getSymbolText(long address) {
        Map.Entry<Long, String> currentFloorEntry = null;
        for (MappingFile mf : this.fMappingFiles) {
            NavigableMap<Long, String> symbolMapping = mf.getSymbolMapping();
            Map.Entry<Long, String> floorEntry = symbolMapping.floorEntry(address);
            if (floorEntry == null) continue;
            String value = floorEntry.getValue();
            long floorValue = floorEntry.getKey();
            if (value.endsWith(mf.getEndSuffix()) && floorValue != address) continue;
            if (floorValue == address) {
                return value;
            }
            if (currentFloorEntry == null) {
                currentFloorEntry = floorEntry;
                continue;
            }
            if (address - floorValue >= address - currentFloorEntry.getKey()) continue;
            currentFloorEntry = floorEntry;
        }
        return null;
    }

    @Override
    public ISymbolProviderPreferencePage createPreferencePage() {
        return new BasicSymbolProviderPreferencePage(this);
    }
}

