/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.tracecompass.tmf.ui.project.wizards.RenameFolderDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameFolderHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        TmfTraceFolder selectedFolder = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof TmfTraceFolder) {
            selectedFolder = (TmfTraceFolder)element;
        }
        if (selectedFolder == null) {
            return null;
        }
        final TmfTraceFolder oldFolder = selectedFolder;
        RenameFolderDialog dialog = new RenameFolderDialog(window.getShell(), oldFolder);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return null;
        }
        final String newName = (String)dialog.getFirstResult();
        IContainer parentFolder = oldFolder.getResource().getParent();
        final TmfTraceFolder tracesFolder = oldFolder.getProject().getTracesFolder();
        final IPath newFolderPath = parentFolder.getFullPath().append(newName);
        final TmfExperimentFolder experimentFolder = oldFolder.getProject().getExperimentsFolder();
        if (tracesFolder == null || experimentFolder == null) {
            return null;
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("", 1000);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    for (final TmfTraceElement traceElement : oldFolder.getTraces()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                traceElement.closeEditors();
                            }
                        });
                        IPath relativePath = traceElement.getPath().makeRelativeTo(oldFolder.getPath());
                        String newElementPath = newFolderPath.makeRelativeTo(tracesFolder.getPath()).append(relativePath).toString();
                        traceElement.renameSupplementaryFolder(newElementPath);
                    }
                    oldFolder.getResource().move(newFolderPath, 33, monitor);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
            return null;
        }
        operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IPath oldFolderElementPath = oldFolder.getPath().makeRelativeTo(tracesFolder.getPath());
                IPath newFolderElementPath = oldFolderElementPath.removeLastSegments(1).append(newName);
                for (TmfExperimentElement experiment : experimentFolder.getExperiments()) {
                    block1: for (TmfTraceElement oldTrace : experiment.getTraces()) {
                        if (!oldTrace.getElementPath().startsWith(oldFolderElementPath.toString())) continue;
                        experiment.removeTrace(oldTrace);
                        String relativePath = oldTrace.getElementPath().substring(oldFolderElementPath.toString().length() + 1);
                        String newTraceElementPath = newFolderElementPath.append(relativePath).toString();
                        for (TmfTraceElement newTrace : tracesFolder.getTraces()) {
                            if (!newTrace.getElementPath().equals(newTraceElementPath)) continue;
                            experiment.addTrace(newTrace);
                            continue block1;
                        }
                    }
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
            return null;
        }
        return null;
    }
}

