/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.ShowAnnotationAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowResourceInHistoryAction;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSModelSynchronizeParticipant;
import org.eclipse.team.internal.ccvs.ui.mappings.MergeSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSActionDelegateWrapper;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public class ModelMergeParticipant
extends CVSModelSynchronizeParticipant {
    public static final String VIEWER_ID = "org.eclipse.team.cvs.ui.mergeSynchronization";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_1 = "otherActions1";
    public static final String ID = "org.eclipse.team.cvs.ui.modelMergeParticipant";
    private static final String CTX_SUBSCRIBER = "mergeSubscriber";
    private static final String CTX_ROOT = "root";
    private static final String CTX_ROOT_PATH = "root_resource";
    private static final String CTX_START_TAG = "start_tag";
    private static final String CTX_START_TAG_TYPE = "start_tag_type";
    private static final String CTX_END_TAG = "end_tag";
    private static final String CTX_END_TAG_TYPE = "end_tag_type";
    private CVSMergeSubscriber subscriber;

    public ModelMergeParticipant() {
    }

    public ModelMergeParticipant(MergeSubscriberContext context) {
        super((SynchronizationContext)context);
        this.subscriber = this.getSubscriber();
        this.initialize();
    }

    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new MergeActionGroup();
    }

    @Override
    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)VIEWER_ID);
        super.initializeConfiguration(configuration);
        configuration.setSupportedModes(9);
        configuration.setMode(1);
    }

    private void initialize() {
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
            this.setInitializationData(descriptor);
            CVSMergeSubscriber s = this.getSubscriber();
            this.setSecondaryId(s.getId().getLocalName());
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
        }
    }

    private CVSMergeSubscriber getSubscriber() {
        return (CVSMergeSubscriber)((MergeSubscriberContext)this.getContext()).getSubscriber();
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        if (memento != null) {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
            String qualifier = descriptor.getId();
            String localname = secondaryId;
            if (qualifier == null || localname == null) {
                throw new PartInitException(CVSUIMessages.MergeSynchronizeParticipant_8);
            }
            try {
                this.subscriber = this.read(new QualifiedName(qualifier, localname), memento.getChild(CTX_SUBSCRIBER));
            }
            catch (CVSException e) {
                throw new PartInitException(CVSUIMessages.MergeSynchronizeParticipant_9, (Throwable)e);
            }
        }
        try {
            super.init(secondaryId, memento);
        }
        catch (PartInitException e) {
            this.subscriber.cancel();
            throw e;
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.write(this.subscriber, memento.createChild(CTX_SUBSCRIBER));
    }

    private CVSMergeSubscriber read(QualifiedName id, IMemento memento) throws CVSException {
        CVSTag start = new CVSTag(memento.getString(CTX_START_TAG), memento.getInteger(CTX_START_TAG_TYPE).intValue());
        CVSTag end = new CVSTag(memento.getString(CTX_END_TAG), memento.getInteger(CTX_END_TAG_TYPE).intValue());
        IMemento[] rootNodes = memento.getChildren(CTX_ROOT);
        if (rootNodes == null || rootNodes.length == 0) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.MergeSynchronizeParticipant_10, (Object[])new String[]{id.toString()}));
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < rootNodes.length) {
            IMemento rootNode = rootNodes[i];
            Path path = new Path(rootNode.getString(CTX_ROOT_PATH));
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path, true);
            if (resource != null) {
                resources.add(resource);
            } else {
                CVSProviderPlugin.log((int)1, (String)NLS.bind((String)CVSUIMessages.MergeSynchronizeParticipant_11, (Object[])new String[]{path.toString()}), null);
            }
            ++i;
        }
        if (resources.isEmpty()) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.MergeSynchronizeParticipant_12, (Object[])new String[]{id.toString()}));
        }
        IResource[] roots = resources.toArray(new IResource[resources.size()]);
        return new CVSMergeSubscriber(id, roots, start, end);
    }

    private void write(CVSMergeSubscriber s, IMemento memento) {
        CVSTag start = s.getStartTag();
        CVSTag end = s.getEndTag();
        memento.putString(CTX_START_TAG, start.getName());
        memento.putInteger(CTX_START_TAG_TYPE, start.getType());
        memento.putString(CTX_END_TAG, end.getName());
        memento.putInteger(CTX_END_TAG_TYPE, end.getType());
        IResource[] roots = s.roots();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            IMemento rootNode = memento.createChild(CTX_ROOT);
            rootNode.putString(CTX_ROOT_PATH, resource.getFullPath().toString());
            ++i;
        }
    }

    protected String getShortTaskName() {
        return CVSUIMessages.Participant_merging;
    }

    public void dispose() {
        if (TeamUI.getSynchronizeManager().get(this.getId(), this.getSecondaryId()) != null) {
            ((MergeSubscriberContext)this.getContext()).setCancelSubscriber(false);
        }
        super.dispose();
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        return new SubscriberScopeManager(this.subscriber.getName(), mappings, (Subscriber)this.subscriber, true);
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) throws CoreException {
        return MergeSubscriberContext.createContext(manager, (Subscriber)this.subscriber);
    }

    public String getName() {
        return NLS.bind((String)CVSUIMessages.CompareParticipant_0, (Object[])new String[]{this.getSubscriber().getName(), Utils.getScopeDescription((ISynchronizationScope)this.getContext().getScope())});
    }

    public static ModelMergeParticipant getMatchingParticipant(ResourceMapping[] mappings, CVSTag startTag, CVSTag endTag) {
        ISynchronizeParticipantReference[] refs = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        int i = 0;
        while (i < refs.length) {
            block8: {
                ISynchronizeParticipantReference reference = refs[i];
                if (reference.getId().equals(ID)) {
                    ModelMergeParticipant p;
                    try {
                        p = (ModelMergeParticipant)reference.getParticipant();
                    }
                    catch (TeamException teamException) {
                        break block8;
                    }
                    ISynchronizationScope scope = p.getContext().getScope().asInputScope();
                    ResourceMapping[] roots = scope.getMappings();
                    if (roots.length == mappings.length) {
                        boolean match = true;
                        int j = 0;
                        while (j < mappings.length) {
                            ResourceMapping mapping = mappings[j];
                            if (scope.getTraversals(mapping) == null) {
                                match = false;
                                break;
                            }
                            ++j;
                        }
                        if (match && p.getSubscriber().getStartTag().equals((Object)startTag) && p.getSubscriber().getEndTag().equals((Object)endTag)) {
                            return p;
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public class MergeActionGroup
    extends ModelSynchronizeParticipantActionGroup {
        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            if (!configuration.getSite().isModal()) {
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", ModelMergeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)new CVSActionDelegateWrapper(new ShowAnnotationAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", ModelMergeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)new CVSActionDelegateWrapper(new ShowResourceInHistoryAction(), configuration));
            }
        }
    }
}

