/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFolder;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

abstract class EclipseResource
implements ICVSResource,
Comparable {
    protected static final String SEPARATOR = "/";
    protected static final String CURRENT_LOCAL_FOLDER = ".";
    IResource resource;

    protected EclipseResource(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.resource = resource;
    }

    @Override
    public String getRelativePath(ICVSFolder root) throws CVSException {
        String result;
        block3: {
            try {
                EclipseResource rootFolder = (EclipseResource)((Object)root);
                result = Util.getRelativePath(rootFolder.getPath(), this.getPath());
                if (result.length() != 0) break block3;
                return CURRENT_LOCAL_FOLDER;
            }
            catch (ClassCastException e) {
                CVSStatus status = new CVSStatus(4, 4, CVSMessages.EclipseResource_invalidResourceClass, (Throwable)e, root);
                throw new CVSException((IStatus)status);
            }
        }
        return result;
    }

    @Override
    public boolean exists() {
        return this.resource.exists();
    }

    @Override
    public ICVSFolder getParent() {
        IContainer parent = this.resource.getParent();
        if (parent == null) {
            return null;
        }
        return new EclipseFolder(parent);
    }

    @Override
    public String getName() {
        return this.resource.getName();
    }

    @Override
    public boolean isIgnored() throws CVSException {
        if (this.isManaged() || this.resource.getType() == 8 || this.resource.getType() == 4) {
            return false;
        }
        if (this.resource.isDerived() || this.resource.isLinked()) {
            return true;
        }
        String name = this.getName();
        if (name.equals("CVS")) {
            return true;
        }
        if (Team.isIgnoredHint((IResource)this.resource)) {
            return true;
        }
        if (EclipseSynchronizer.getInstance().isIgnored(this.resource)) {
            return true;
        }
        ICVSFolder parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.isIgnored()) {
            return true;
        }
        FolderSyncInfo info = parent.getFolderSyncInfo();
        if (info == null) {
            return false;
        }
        return info.isVirtualDirectory();
    }

    @Override
    public void setIgnoredAs(final String pattern) throws CVSException {
        this.run(new ICVSRunnable(){

            @Override
            public void run(IProgressMonitor monitor) throws CVSException {
                EclipseSynchronizer.getInstance().addIgnored(EclipseResource.this.resource.getParent(), pattern);
            }
        }, null);
    }

    @Override
    public boolean isManaged() throws CVSException {
        return this.isManaged(this.getSyncBytes());
    }

    public boolean isManaged(byte[] syncBytes) {
        return syncBytes != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EclipseResource)) {
            return false;
        }
        return this.getPath().equals(((EclipseResource)obj).getPath());
    }

    public String getPath() {
        return this.resource.getFullPath().toString();
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    public byte[] getSyncBytes() throws CVSException {
        return EclipseSynchronizer.getInstance().getSyncBytes(this.getIResource());
    }

    public void setSyncBytes(byte[] syncBytes) throws CVSException {
        if (this.getParent().isCVSFolder()) {
            EclipseSynchronizer.getInstance().setSyncBytes(this.getIResource(), syncBytes);
        }
    }

    @Override
    public ResourceSyncInfo getSyncInfo() throws CVSException {
        return EclipseSynchronizer.getInstance().getResourceSync(this.resource);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public void unmanage(IProgressMonitor monitor) throws CVSException {
        EclipseSynchronizer.getInstance().deleteResourceSync(this.resource);
    }

    public int compareTo(Object arg0) {
        EclipseResource other = (EclipseResource)arg0;
        return this.resource.getFullPath().toString().compareTo(other.resource.getFullPath().toString());
    }

    @Override
    public IResource getIResource() {
        return this.resource;
    }

    public abstract void handleModification(boolean var1) throws CVSException;

    public void run(final ICVSRunnable job, IProgressMonitor monitor) throws CVSException {
        final CVSException[] error = new CVSException[1];
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        EclipseSynchronizer.getInstance().run((ISchedulingRule)EclipseResource.this.getIResource(), job, monitor);
                    }
                    catch (CVSException e) {
                        error[0] = e;
                    }
                }
            }, null, 0, monitor);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
        if (error[0] != null) {
            throw error[0];
        }
    }
}

