/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtcore.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.analysis.AbstractDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.util.QVTcoreVisitor;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;

public class RootDomainUsageAnalysis
extends AbstractDomainUsageAnalysis
implements QVTcoreVisitor<DomainUsage>,
DomainUsageAnalysis.Root {
    private static final @NonNull Integer NONE_USAGE_BIT_MASK = 0;
    private static final @NonNull Integer PRIMITIVE_USAGE_BIT_MASK = 1;
    protected final @NonNull StandardLibrary standardLibrary;
    protected final @NonNull Map<@Nullable String, @NonNull Integer> name2bit = new HashMap<String, Integer>();
    protected final @NonNull List<@NonNull TypedModel> bit2typedModel = new ArrayList<TypedModel>();
    private final @NonNull Map<@NonNull Integer, @NonNull DomainUsageConstant> constantUsages = new HashMap<Integer, DomainUsageConstant>();
    private final @NonNull Map<@NonNull Integer, @NonNull DomainUsageConstant> validUsages = new HashMap<Integer, DomainUsageConstant>();
    private DomainUsageConstant middleUsage = null;
    private DomainUsageConstant inputUsage = null;
    private DomainUsageConstant outputUsage = null;
    protected final @NonNull Map<@NonNull Class, @NonNull DomainUsageConstant> class2usage = new HashMap<Class, DomainUsageConstant>();
    protected final @NonNull Map<@NonNull Property, DomainUsage> property2containingClassUsage = new HashMap<Property, DomainUsage>();
    protected final @NonNull Map<@NonNull Operation, @NonNull DomainUsageAnalysis.Internal> operation2analysis = new HashMap<Operation, DomainUsageAnalysis.Internal>();
    private final @NonNull TypedModel primitiveTypeModel = QVTbaseFactory.eINSTANCE.createTypedModel();
    private OperationId oclAnyEqualsOperationId;
    private OperationId oclAnyNotEqualsOperationId;
    private OperationId oclElementOclContainerId;
    private OperationId oclElementOclContentsId;
    private Property oclElementOclContainerProperty;
    private Property oclElementOclContentsProperty;
    private final @NonNull Set<@NonNull Property> dirtyProperties = new HashSet<Property>();
    private final @NonNull Set<@NonNull EReference> dirtyEReferences = new HashSet<EReference>();

    protected RootDomainUsageAnalysis(@NonNull EnvironmentFactory environmentFactory) {
        super(environmentFactory);
        this.standardLibrary = ((EnvironmentFactory)this.context).getStandardLibrary();
        this.primitiveTypeModel.setName("$primitive$");
        this.add(this.primitiveTypeModel);
        this.validUsages.put(NONE_USAGE_BIT_MASK, this.getConstantUsage(NONE_USAGE_BIT_MASK));
        this.validUsages.put(PRIMITIVE_USAGE_BIT_MASK, this.getConstantUsage(PRIMITIVE_USAGE_BIT_MASK));
        this.setUsage((Element)this.primitiveTypeModel, this.getPrimitiveUsage());
    }

    protected int add(@NonNull TypedModel typedModel) {
        int nextBit = this.bit2typedModel.size();
        this.bit2typedModel.add(typedModel);
        this.name2bit.put(typedModel.getName(), nextBit);
        return nextBit;
    }

    public @NonNull DomainUsageAnalysis analyzeOperation(@NonNull Operation object) {
        DomainUsageAnalysis.Internal analysis = this.operation2analysis.get(object);
        if (analysis == null) {
            analysis = this.createNestedAnalysis();
            this.operation2analysis.put(object, analysis);
            DomainUsage usage = analysis.visit((Element)object);
            this.setUsage((Element)object, usage);
        }
        return analysis;
    }

    protected void analyzePropertyAssignments(@NonNull Transformation transformation) {
        TreeIterator tit = transformation.eAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof PropertyAssignment)) continue;
            PropertyAssignment propertyAssignment = (PropertyAssignment)eObject;
            OCLExpression slotExpression = propertyAssignment.getSlotExpression();
            assert (slotExpression != null);
            DomainUsage domainUsage = this.getUsage((Element)PivotUtil.getType((TypedElement)slotExpression));
            if (domainUsage.isOutput() || domainUsage.isMiddle()) continue;
            Property targetProperty = (Property)ClassUtil.nonNullState((Object)propertyAssignment.getTargetProperty());
            this.dirtyProperties.add(targetProperty);
            EObject eProperty = targetProperty.getESObject();
            if (!(eProperty instanceof EReference)) continue;
            this.dirtyEReferences.add((EReference)eProperty);
        }
        for (Property dirtyProperty : this.dirtyProperties) {
            if (!dirtyProperty.isIsTransient()) {
                System.err.println("Dirty " + dirtyProperty + " is not transient");
            }
            if (dirtyProperty.isIsReadOnly()) {
                System.err.println("Dirty " + dirtyProperty + " is readonly");
            }
            if (!dirtyProperty.isIsRequired()) continue;
            System.err.println("Dirty " + dirtyProperty + " is required");
        }
    }

    public @NonNull Map<Element, DomainUsage> analyzeTransformation(@NonNull Transformation transformation) {
        int unenforceableMask = 0;
        int enforceableMask = 0;
        CompleteModel completeModel = ((EnvironmentFactory)this.context).getCompleteModel();
        for (TypedModel typedModel : ClassUtil.nullFree((EList)transformation.getModelParameter())) {
            if (typedModel == this.primitiveTypeModel) continue;
            int nextBit = this.add(typedModel);
            int bitMask = 1 << nextBit;
            @NonNull DomainUsageConstant typedModelUsage = this.getConstantUsage(bitMask);
            this.validUsages.put(bitMask, typedModelUsage);
            boolean isEnforceable = false;
            boolean isUnenforceable = false;
            for (Rule rule : transformation.getRule()) {
                for (Domain domain : rule.getDomain()) {
                    if (domain.getTypedModel() != typedModel) continue;
                    if (domain.isIsEnforceable()) {
                        isEnforceable = true;
                        continue;
                    }
                    isUnenforceable = true;
                }
            }
            if (isEnforceable) {
                enforceableMask |= bitMask;
            }
            if (isUnenforceable) {
                unenforceableMask |= bitMask;
            }
            this.setUsage((Element)typedModel, typedModelUsage);
            Variable ownedContext = typedModel.getOwnedContext();
            if (ownedContext != null) {
                this.setUsage((Element)ownedContext, typedModelUsage);
            }
            HashSet<@NonNull CompleteClass> completeClasses = new HashSet<CompleteClass>();
            for (Package asPackage : QVTbaseUtil.getAllUsedPackages((TypedModel)typedModel)) {
                CompletePackage completePackage = completeModel.getCompletePackage(asPackage);
                for (CompleteClass completeClass : ClassUtil.nullFree((List)completePackage.getOwnedCompleteClasses())) {
                    for (CompleteClass superCompleteClass : completeClass.getSuperCompleteClasses()) {
                        completeClasses.add(superCompleteClass);
                    }
                }
            }
            for (CompleteClass completeClass : completeClasses) {
                for (Class asClass : ClassUtil.nullFree((List)completeClass.getPartialClasses())) {
                    DomainUsageConstant oldUsage = this.class2usage.get(asClass);
                    DomainUsageConstant classUsage = typedModelUsage;
                    if (asClass instanceof DataType && !(asClass instanceof CollectionType)) {
                        classUsage = this.getPrimitiveUsage();
                    }
                    DomainUsageConstant newUsage = oldUsage != null ? classUsage.union(oldUsage) : classUsage;
                    this.class2usage.put(asClass, newUsage);
                }
            }
        }
        for (Class asClass : this.class2usage.keySet()) {
            DomainUsage newUsage = this.class2usage.get(asClass);
            assert (newUsage != null);
            for (Property property : ClassUtil.nullFree((List)asClass.getOwnedProperties())) {
                this.property2containingClassUsage.put(property, newUsage);
                DomainUsage referredTypeUsage = this.getAnnotatedUsage(property);
                if (referredTypeUsage != null) continue;
                referredTypeUsage = this.visit((Element)property.getType());
            }
        }
        this.class2usage.put(((StandardLibraryInternal)this.standardLibrary).getOclTypeType(), this.getAnyUsage());
        this.inputUsage = this.getConstantUsage(this.getAnyMask() & unenforceableMask);
        this.outputUsage = this.getConstantUsage(this.getAnyMask() & enforceableMask);
        this.middleUsage = this.getConstantUsage(this.getAnyMask() & ~unenforceableMask & ~enforceableMask & ~PRIMITIVE_USAGE_BIT_MASK.intValue());
        Variable ownedContext = transformation.getOwnedContext();
        if (ownedContext != null) {
            this.setUsage((Element)ownedContext, this.getAnyUsage());
        }
        this.analyzePropertyAssignments(transformation);
        this.visit((Element)transformation);
        return this.element2usage;
    }

    @Override
    public @Nullable DomainUsage basicGetUsage(@Nullable Element element) {
        DomainUsage usage = super.basicGetUsage(element);
        if (usage != null) {
            return usage;
        }
        Operation operation = PivotUtil.getContainingOperation((EObject)element);
        if (operation == null) {
            return null;
        }
        DomainUsageAnalysis analyzeOperation = this.analyzeOperation(operation);
        usage = analyzeOperation.basicGetUsage(element);
        return usage;
    }

    protected @NonNull Nested createNestedAnalysis() {
        return new Nested();
    }

    public @NonNull DomainUsage createVariableUsage(int intersectionMask) {
        return new DomainUsageVariable(intersectionMask);
    }

    @Override
    protected @NonNull DomainUsage getAllInstancesUsage(@NonNull OperationCallExp asCallExp, @NonNull DomainUsage sourceUsage) {
        if (asCallExp.getOwnedSource().getTypeValue() instanceof DataType) {
            return this.getPrimitiveUsage();
        }
        Area area = QVTcoreUtil.getContainingArea((EObject)asCallExp);
        if (area instanceof CoreDomain) {
            DomainUsage areaUsage = this.getUsage(area);
            return this.intersection(sourceUsage, areaUsage);
        }
        if (area instanceof Mapping) {
            DomainUsage inputUsage = this.getNoneUsage();
            for (Domain domain : ((Mapping)area).getDomain()) {
                if (domain.isIsEnforceable()) continue;
                inputUsage = this.union(inputUsage, this.getUsage((Element)domain));
            }
            if (inputUsage != this.getNoneUsage()) {
                return this.intersection(sourceUsage, inputUsage);
            }
            return this.intersection(sourceUsage, this.getInputUsage());
        }
        return sourceUsage;
    }

    public @NonNull DomainUsageAnalysis getAnalysis(@NonNull Operation operation) {
        DomainUsageAnalysis analysis = this.operation2analysis.get(operation);
        if (analysis == null) {
            analysis = this.analyzeOperation(operation);
        }
        return analysis;
    }

    protected @Nullable DomainUsage getAnnotatedUsage(@NonNull Property property) {
        DomainUsageConstant referredTypeUsage = null;
        for (Element annotation : property.getOwnedAnnotations()) {
            Annotation annotation2;
            if (!(annotation instanceof Annotation) || !"http://www.eclipse.org/qvt#Domains".equals((annotation2 = (Annotation)annotation).getName())) continue;
            for (Detail detail : annotation2.getOwnedDetails()) {
                if (!"referredDomain".equals(detail.getName())) continue;
                int mask = 0;
                for (String value : detail.getValues()) {
                    Integer bit = this.name2bit.get(value.trim());
                    if (bit == null) continue;
                    mask |= 1 << bit;
                }
                referredTypeUsage = this.getValidUsage(mask);
            }
        }
        return referredTypeUsage;
    }

    protected int getAnyMask() {
        return (1 << this.bit2typedModel.size()) - 1;
    }

    public @NonNull DomainUsageConstant getAnyUsage() {
        return this.getConstantUsage(this.getAnyMask());
    }

    @Deprecated
    public @NonNull DomainUsage getCheckableUsage() {
        return this.getInputUsage();
    }

    @Override
    public @NonNull DomainUsageConstant getConstantUsage(int bitMask) {
        DomainUsageConstant usage = this.constantUsages.get(bitMask);
        if (usage == null) {
            usage = new DomainUsageConstant(bitMask);
            this.constantUsages.put(bitMask, usage);
        }
        return usage;
    }

    @Deprecated
    public @NonNull DomainUsage getEnforceableUsage() {
        return this.getOutputUsage();
    }

    public @NonNull DomainUsage getInputUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.inputUsage);
    }

    public @NonNull DomainUsage getMiddleUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.middleUsage);
    }

    public @NonNull DomainUsage getNoneUsage() {
        DomainUsageConstant noneUsage = this.constantUsages.get(NONE_USAGE_BIT_MASK);
        assert (noneUsage != null);
        return noneUsage;
    }

    public @NonNull DomainUsage getOutputUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.outputUsage);
    }

    public @NonNull OperationId getOclContainerId() {
        OperationId oclElementOclContainerId2 = this.oclElementOclContainerId;
        if (oclElementOclContainerId2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            Operation operation = (Operation)NameUtil.getNameable((Iterable)oclElementType.getOwnedOperations(), (String)"oclContainer");
            assert (operation != null);
            this.oclElementOclContainerId = oclElementOclContainerId2 = operation.getOperationId();
        }
        return oclElementOclContainerId2;
    }

    public @NonNull Property getOclContainerProperty() {
        Property oclElementOclContainerProperty2 = this.oclElementOclContainerProperty;
        if (oclElementOclContainerProperty2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            oclElementOclContainerProperty2 = (Property)NameUtil.getNameable((Iterable)oclElementType.getOwnedProperties(), (String)"oclContainer");
            assert (oclElementOclContainerProperty2 != null);
            this.oclElementOclContainerProperty = oclElementOclContainerProperty2;
        }
        return oclElementOclContainerProperty2;
    }

    public @NonNull OperationId getOclContentsId() {
        OperationId oclElementOclContentsId2 = this.oclElementOclContentsId;
        if (oclElementOclContentsId2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            Operation operation = (Operation)NameUtil.getNameable((Iterable)oclElementType.getOwnedOperations(), (String)"oclContents");
            assert (operation != null);
            this.oclElementOclContentsId = oclElementOclContentsId2 = operation.getOperationId();
        }
        return oclElementOclContentsId2;
    }

    public @NonNull Property getOclContentsProperty() {
        Property oclElementOclContentsProperty2 = this.oclElementOclContentsProperty;
        if (oclElementOclContentsProperty2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            oclElementOclContentsProperty2 = (Property)NameUtil.getNameable((Iterable)oclElementType.getOwnedProperties(), (String)"oclContents");
            assert (oclElementOclContentsProperty2 != null);
            this.oclElementOclContentsProperty = oclElementOclContentsProperty2;
        }
        return oclElementOclContentsProperty2;
    }

    public @NonNull OperationId getOclAnyEqualsOperationId() {
        OperationId oclAnyEqualsOperationId2 = this.oclAnyEqualsOperationId;
        if (oclAnyEqualsOperationId2 == null) {
            Class oclAnyType = this.standardLibrary.getOclAnyType();
            Operation operation = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"=");
            assert (operation != null);
            this.oclAnyEqualsOperationId = oclAnyEqualsOperationId2 = operation.getOperationId();
        }
        return oclAnyEqualsOperationId2;
    }

    public @NonNull OperationId getOclAnyNotEqualsOperationId() {
        OperationId oclAnyNotEqualsOperationId2 = this.oclAnyNotEqualsOperationId;
        if (oclAnyNotEqualsOperationId2 == null) {
            Class oclAnyType = this.standardLibrary.getOclAnyType();
            Operation operation = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"<>");
            assert (operation != null);
            this.oclAnyNotEqualsOperationId = oclAnyNotEqualsOperationId2 = operation.getOperationId();
        }
        return oclAnyNotEqualsOperationId2;
    }

    public @NonNull TypedModel getPrimitiveTypeModel() {
        return this.primitiveTypeModel;
    }

    public @NonNull DomainUsageConstant getPrimitiveUsage() {
        DomainUsageConstant primitiveUsage = this.constantUsages.get(PRIMITIVE_USAGE_BIT_MASK);
        assert (primitiveUsage != null);
        return primitiveUsage;
    }

    @Override
    protected @NonNull RootDomainUsageAnalysis getRootAnalysis() {
        return this;
    }

    public @NonNull TypedModel getTypedModel(int i) {
        return this.bit2typedModel.get(i);
    }

    @Override
    public @NonNull DomainUsage getUsage(@NonNull Element element) {
        Operation operation = PivotUtil.getContainingOperation((EObject)element);
        if (operation != null) {
            DomainUsageAnalysis analyzeOperation = this.analyzeOperation(operation);
            return (DomainUsage)ClassUtil.nonNullState((Object)analyzeOperation.getUsage(element));
        }
        return super.getUsage(element);
    }

    public @Nullable DomainUsageConstant getValidUsage(int bitMask) {
        return this.validUsages.get(bitMask);
    }

    public @NonNull DomainUsage getValidOrVariableUsage(@NonNull DomainUsage usage) {
        int bitMask = ((DomainUsage.Internal)usage).getMask();
        DomainUsageConstant validUsage = this.getValidUsage(bitMask);
        if (validUsage != null) {
            return validUsage;
        }
        if (!usage.isConstant()) {
            return usage;
        }
        return this.createVariableUsage(bitMask);
    }

    public boolean isDirty(@NonNull EReference eReference) {
        return this.dirtyEReferences.contains(eReference);
    }

    public boolean isDirty(@NonNull Property property) {
        return property.isIsTransient() || this.dirtyProperties.contains(property);
    }

    protected abstract class AbstractDomainUsage
    implements DomainUsage.Internal {
        protected final int bitMask;

        protected AbstractDomainUsage(int bitMask) {
            this.bitMask = bitMask;
        }

        @Override
        public int compareTo(DomainUsage.Internal o) {
            return this.getMask() - o.getMask();
        }

        @Override
        public int getMask() {
            return this.bitMask;
        }

        @Override
        public @Nullable TypedModel getTypedModel() throws IllegalStateException {
            return this.getTypedModel(null);
        }

        @Override
        public @Nullable TypedModel getTypedModel(@Nullable Element context) throws IllegalStateException {
            int residue = this.bitMask;
            int i = 0;
            while (residue != 0) {
                int bit = 1 << i;
                if ((residue & bit) != 0) {
                    if ((residue &= ~bit) == 0) {
                        return RootDomainUsageAnalysis.this.getTypedModel(i);
                    }
                    if (!(context instanceof NullLiteralExp)) {
                        System.err.println("Ambiguous TypedModel: " + this + " for " + LabelUtil.getLabel((Object)context));
                    }
                    return RootDomainUsageAnalysis.this.getTypedModel(i);
                }
                ++i;
            }
            return null;
        }

        @Override
        public @NonNull Iterable<@NonNull TypedModel> getTypedModels() {
            ArrayList<@NonNull TypedModel> typedModels = new ArrayList<TypedModel>();
            int residue = this.bitMask;
            int i = 0;
            while (residue != 0) {
                int bit = 1 << i;
                if ((residue & bit) != 0) {
                    residue &= ~bit;
                    typedModels.add(RootDomainUsageAnalysis.this.getTypedModel(i));
                }
                ++i;
            }
            return typedModels;
        }

        @Override
        public boolean isCheckable() {
            return this.isInput();
        }

        @Override
        public boolean isEnforceable() {
            return this.isOutput();
        }

        @Override
        public boolean isInput() {
            return (this.bitMask & ((RootDomainUsageAnalysis)RootDomainUsageAnalysis.this).inputUsage.bitMask) != 0;
        }

        @Override
        public boolean isMiddle() {
            return (this.bitMask & ((RootDomainUsageAnalysis)RootDomainUsageAnalysis.this).middleUsage.bitMask) != 0;
        }

        @Override
        public boolean isNone() {
            return this.bitMask == 0;
        }

        @Override
        public boolean isOutput() {
            return (this.bitMask & ((RootDomainUsageAnalysis)RootDomainUsageAnalysis.this).outputUsage.bitMask) != 0;
        }

        @Override
        public boolean isPrimitive() {
            return (this.bitMask & PRIMITIVE_USAGE_BIT_MASK) != 0;
        }

        protected String toString(@NonNull String prefix) {
            StringBuilder s = new StringBuilder();
            s.append(prefix);
            boolean first = true;
            int i = 0;
            while (i < RootDomainUsageAnalysis.this.bit2typedModel.size()) {
                int iMask = 1 << i;
                if ((this.bitMask & iMask) != 0) {
                    String name;
                    if (!first) {
                        s.append("|");
                    }
                    s.append((name = RootDomainUsageAnalysis.this.bit2typedModel.get(i).getName()) != null ? name : "$middle$");
                    first = false;
                }
                ++i;
            }
            if (first) {
                s.append("$none$");
            }
            return s.toString();
        }
    }

    protected class DomainUsageConstant
    extends AbstractDomainUsage {
        protected DomainUsageConstant(int bitMask) {
            super(bitMask);
        }

        @Override
        public void addUsedBy(@NonNull Element element) {
        }

        @Override
        public @NonNull DomainUsage cloneVariable() {
            return this;
        }

        @Override
        public @Nullable Iterable<Element> getElements() {
            return null;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        public String toString() {
            return this.toString("\u00abconstant\u00bb");
        }

        public @NonNull DomainUsageConstant union(@NonNull DomainUsageConstant usage) {
            return RootDomainUsageAnalysis.this.getConstantUsage(this.bitMask | usage.bitMask);
        }
    }

    protected class DomainUsageVariable
    extends AbstractDomainUsage {
        protected final @NonNull List<Element> usedBy;

        protected DomainUsageVariable(int bitMask) {
            super(bitMask);
            this.usedBy = new ArrayList<Element>();
            assert (bitMask != 0);
        }

        @Override
        public void addUsedBy(@NonNull Element element) {
            this.usedBy.add(element);
        }

        @Override
        public @NonNull DomainUsage cloneVariable() {
            return new DomainUsageVariable(this.bitMask);
        }

        @Override
        public @Nullable Iterable<Element> getElements() {
            return this.usedBy;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        public String toString() {
            return this.toString("\u00abvariable\u00bb");
        }
    }

    protected class Nested
    extends AbstractDomainUsageAnalysis {
        protected Nested() {
            super(RootDomainUsageAnalysis.this.getEnvironmentFactory());
        }

        @Override
        protected @NonNull RootDomainUsageAnalysis getRootAnalysis() {
            return RootDomainUsageAnalysis.this;
        }
    }
}

