/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.AbstractMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.Correlator;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.RegionMerger;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.impl.NamedMappingRegionImpl;

public class EarlyMerger
extends AbstractMerger {
    protected final @NonNull LinkedHashSet<@NonNull MappingRegion> residualInputRegions;
    protected final @NonNull List<@NonNull MappingRegion> outputRegions = new ArrayList<MappingRegion>();

    public static @NonNull List<@NonNull MappingRegion> merge(@NonNull Iterable<@NonNull MappingRegion> inputRegions) {
        EarlyMerger earlyMerger = new EarlyMerger(inputRegions);
        return earlyMerger.merge();
    }

    protected EarlyMerger(@NonNull Iterable<@NonNull MappingRegion> inputRegions) {
        this.residualInputRegions = Sets.newLinkedHashSet(inputRegions);
    }

    protected @NonNull Iterable<@NonNull Node> getHostNodes(@NonNull MappingRegion region) {
        HashSet<@NonNull Node> hostNodes = new HashSet<Node>();
        for (Node node : RegionUtil.getHeadNodes((Region)region)) {
            this.getHostNodesAccumulator(hostNodes, node);
        }
        return hostNodes;
    }

    protected void getHostNodesAccumulator(@NonNull Set<@NonNull Node> hostNodes, @NonNull Node node) {
        if (!node.isClass()) {
            return;
        }
        if (node.isExplicitNull()) {
            return;
        }
        if (node.isOperation()) {
            return;
        }
        if (!node.isRequired()) {
            return;
        }
        if (node.isTrue()) {
            return;
        }
        if (!node.isPattern()) {
            return;
        }
        if (!hostNodes.add(node)) {
            return;
        }
        for (NavigableEdge edge : node.getNavigationEdges()) {
            if (!edge.isUnconditional()) continue;
            Property property = edge.getProperty();
            if (edge.isNew()) {
                if (!this.isToZeroOrOne((TypedElement)property) || !this.isToZeroOrOne((TypedElement)property.getOpposite())) continue;
                this.getHostNodesAccumulator(hostNodes, edge.getEdgeTarget());
                continue;
            }
            if (!this.isToOne((TypedElement)property) || !this.isToOne((TypedElement)property.getOpposite())) continue;
            this.getHostNodesAccumulator(hostNodes, edge.getEdgeTarget());
        }
    }

    protected boolean isPrimaryCandidate(@NonNull Region mappingRegion) {
        List headNodes = mappingRegion.getHeadNodes();
        return headNodes.size() == 1;
    }

    protected boolean isSecondaryCandidate(@NonNull Region primaryRegion, @NonNull Region secondaryRegion, @NonNull Set<@NonNull ClassDatumAnalysis> toOneReachableClasses) {
        List<@NonNull Node> secondaryHeadNodes = RegionUtil.Internal.getHeadNodesList(secondaryRegion);
        if (secondaryHeadNodes.size() != 1) {
            return false;
        }
        Node classNode = secondaryHeadNodes.get(0);
        ClassDatumAnalysis classDatumAnalysis = RegionUtil.getClassDatumAnalysis(classNode);
        return toOneReachableClasses.contains(classDatumAnalysis);
    }

    private boolean isToOne(@Nullable TypedElement typedElement) {
        if (typedElement == null) {
            return false;
        }
        if (!typedElement.isIsRequired()) {
            return false;
        }
        Type type = typedElement.getType();
        return !(type instanceof CollectionType);
    }

    private boolean isToZeroOrOne(@Nullable TypedElement typedElement) {
        if (typedElement == null) {
            return false;
        }
        Type type = typedElement.getType();
        return !(type instanceof CollectionType);
    }

    protected @NonNull List<@NonNull MappingRegion> merge() {
        while (!this.residualInputRegions.isEmpty()) {
            Iterable<MappingRegion> secondaryRegions;
            @NonNull MappingRegion candidateRegion = (MappingRegion)this.residualInputRegions.iterator().next();
            MappingRegion mergedRegion = null;
            if (this.isPrimaryCandidate((Region)candidateRegion) && (secondaryRegions = this.selectSecondaryRegions(candidateRegion)) != null) {
                mergedRegion = this.merge(candidateRegion, secondaryRegions);
            }
            if (mergedRegion == null) {
                this.outputRegions.add(candidateRegion);
            } else {
                this.outputRegions.add(mergedRegion);
                if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
                    RegionUtil.getScheduleManager((Region)mergedRegion).writeDebugGraphs((Region)mergedRegion, null);
                }
            }
            this.residualInputRegions.remove(candidateRegion);
        }
        return this.outputRegions;
    }

    protected @Nullable MappingRegion merge(@NonNull MappingRegion candidateRegion, @NonNull Iterable<@NonNull MappingRegion> secondaryRegions) {
        MappingRegion primaryRegion = candidateRegion;
        MappingRegion mergedRegion = null;
        for (MappingRegion secondaryRegion : secondaryRegions) {
            Correlator secondary2primary;
            if (!this.residualInputRegions.contains(secondaryRegion)) continue;
            if (EARLY.isActive()) {
                EARLY.println("Correlating: " + secondaryRegion + ", " + primaryRegion);
            }
            if ((secondary2primary = Correlator.correlate(secondaryRegion, primaryRegion, EarlyStrategy.INSTANCE, null)) == null) continue;
            boolean doMerge = false;
            if (!this.isSharedHead((Region)primaryRegion, (Region)secondaryRegion)) {
                doMerge = false;
            } else if (Correlator.correlate(primaryRegion, secondaryRegion, EarlyStrategy.INSTANCE, secondary2primary.getNode2Node()) != null) {
                doMerge = true;
            }
            if (!doMerge) continue;
            this.residualInputRegions.remove(mergedRegion);
            this.residualInputRegions.remove(secondaryRegion);
            EarlyRegionMerger regionMerger = new EarlyRegionMerger(primaryRegion);
            regionMerger.addSecondaryRegion(secondaryRegion, secondary2primary.getNode2Node());
            regionMerger.prune();
            mergedRegion = regionMerger.create();
            primaryRegion.getScheduleModel().getOwnedOtherMappingRegions().add((Object)mergedRegion);
            regionMerger.check(mergedRegion);
            primaryRegion = mergedRegion;
        }
        return mergedRegion;
    }

    protected @Nullable Iterable<@NonNull MappingRegion> selectSecondaryRegions(@NonNull MappingRegion primaryRegion) {
        HashMap<@NonNull ClassDatumAnalysis, @NonNull Integer> hostClass2count = new HashMap<ClassDatumAnalysis, Integer>();
        for (Node hostNode : this.getHostNodes(primaryRegion)) {
            ClassDatumAnalysis hostClassDatumAnalysis;
            Integer count = (Integer)hostClass2count.get(hostClassDatumAnalysis = RegionUtil.getClassDatumAnalysis(hostNode));
            hostClass2count.put(hostClassDatumAnalysis, count != null ? count + 1 : 1);
        }
        HashSet<@NonNull MappingRegion> secondaryRegions = new HashSet<MappingRegion>();
        for (Map.Entry entry : hostClass2count.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            ClassDatumAnalysis primaryClassDatumAnalysis = (ClassDatumAnalysis)entry.getKey();
            block2: for (MappingRegion secondaryRegion : primaryClassDatumAnalysis.getConsumingRegions()) {
                if (secondaryRegion == primaryRegion) continue;
                for (Node secondaryHeadNode : RegionUtil.getHeadNodes((Region)secondaryRegion)) {
                    if (RegionUtil.getClassDatumAnalysis(secondaryHeadNode) != primaryClassDatumAnalysis) continue;
                    secondaryRegions.add(secondaryRegion);
                    continue block2;
                }
            }
        }
        ArrayList<@NonNull MappingRegion> sortedSecondaryRegions = new ArrayList<MappingRegion>(secondaryRegions);
        Collections.sort(sortedSecondaryRegions, NameUtil.NAMEABLE_COMPARATOR);
        return sortedSecondaryRegions;
    }

    public static class EarlyMergedMappingRegion
    extends NamedMappingRegionImpl {
        public EarlyMergedMappingRegion(@NonNull ScheduleManager scheduleManager, @NonNull String name) {
            this.setFixmeScheduleModel(scheduleManager.getScheduleModel());
            this.setName(name);
            this.setSymbolNameSuffix("_e");
        }
    }

    protected static class EarlyRegionMerger
    extends RegionMerger {
        protected EarlyRegionMerger(@NonNull MappingRegion primaryRegion) {
            super(primaryRegion);
        }

        @Override
        protected @NonNull MappingRegion createNewRegion(@NonNull String newName) {
            return new EarlyMergedMappingRegion(RegionUtil.getScheduleManager((Region)this.primaryRegion), newName);
        }
    }

    private static class EarlyStrategy
    extends Correlator.AbstractCorrelationStrategy {
        public static @NonNull EarlyStrategy INSTANCE = new EarlyStrategy();

        private EarlyStrategy() {
        }
    }
}

