/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.VariableAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.VariablesAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

abstract class AbstractQVTr2QVTcRelations
extends QVTcoreHelper {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;
    protected final @NonNull Relation rRelation;
    protected final @NonNull RelationalTransformation rTransformation;
    protected final @NonNull String rRelationName;
    protected final @NonNull Set<@NonNull Variable> rAllVariables;
    protected final @NonNull Map<@NonNull Variable, @Nullable TypedModel> rWhenVariable2rTypedModel;
    protected final @NonNull Map<@NonNull Variable, @Nullable TypedModel> rWhereVariable2rTypedModel;
    protected final @NonNull Set<@NonNull Predicate> rWhenPredicates;
    protected final @NonNull Set<@NonNull Predicate> rWherePredicates;
    protected final @NonNull Set<@NonNull Variable> rSharedVariables;
    protected final @NonNull Set<@NonNull Relation> rAllOverrides = new HashSet<Relation>();
    protected final @NonNull Transformation cTransformation;

    protected AbstractQVTr2QVTcRelations(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull Relation rRelation) {
        super(qvtr2qvtc.getEnvironmentFactory());
        this.qvtr2qvtc = qvtr2qvtc;
        this.rRelation = rRelation;
        this.rTransformation = QVTrelationUtil.getTransformation((Relation)rRelation);
        this.rRelationName = PivotUtil.getName((NamedElement)rRelation);
        this.rWhenVariable2rTypedModel = new HashMap<Variable, TypedModel>();
        this.rWhenPredicates = new HashSet<Predicate>();
        Pattern rWhenPattern = rRelation.getWhen();
        if (rWhenPattern != null) {
            VariablesAnalysis.gatherReferredVariablesWithTypedModels(this.rWhenVariable2rTypedModel, (Element)rWhenPattern);
            for (Predicate rWhenPredicate : QVTrelationUtil.getOwnedPredicates((Pattern)rWhenPattern)) {
                if (rWhenPredicate.getConditionExpression() instanceof RelationCallExp) continue;
                this.rWhenPredicates.add(rWhenPredicate);
            }
        }
        this.rWhereVariable2rTypedModel = new HashMap<Variable, TypedModel>();
        this.rWherePredicates = new HashSet<Predicate>();
        Pattern rWherePattern = rRelation.getWhere();
        if (rWherePattern != null) {
            VariablesAnalysis.gatherReferredVariablesWithTypedModels(this.rWhereVariable2rTypedModel, (Element)rWherePattern);
            for (Predicate rWherePredicate : QVTrelationUtil.getOwnedPredicates((Pattern)rWherePattern)) {
                if (rWherePredicate.getConditionExpression() instanceof RelationCallExp) continue;
                this.rWherePredicates.add(rWherePredicate);
            }
        }
        this.rAllVariables = new HashSet<Variable>();
        VariablesAnalysis.gatherReferredVariables(this.rAllVariables, QVTrelationUtil.getOwnedDomains((Relation)rRelation));
        if (rWhenPattern != null) {
            VariablesAnalysis.gatherReferredVariables(this.rAllVariables, (Element)rWhenPattern);
        }
        if (rWherePattern != null) {
            VariablesAnalysis.gatherReferredVariables(this.rAllVariables, (Element)rWherePattern);
        }
        this.rSharedVariables = VariablesAnalysis.getMiddleDomainVariables(rRelation);
        this.gatherOverrides(rRelation);
        this.cTransformation = qvtr2qvtc.getCoreTransformation(this.rTransformation);
    }

    private void gatherOverrides(@NonNull Relation rOverriding) {
        if (this.rAllOverrides.add(rOverriding)) {
            Relation rOverridden = QVTrelationUtil.basicGetOverridden((Relation)rOverriding);
            if (rOverridden != null) {
                this.gatherOverrides(rOverridden);
            }
        } else {
            System.err.println("Override cycle for " + (Object)((Object)this) + " at " + rOverriding);
        }
    }

    public abstract void analyze() throws CompilerChainException;

    public @NonNull Relation getRelation() {
        return this.rRelation;
    }

    public @NonNull AbstractEnforceableRelationDomain2CoreMapping getTopRelationDomain2CoreMapping(@NonNull TypedModel rEnforcedTypedModel) {
        throw new IllegalStateException();
    }

    protected @Nullable Iterable<@NonNull RelationCallExp> getWhenInvocations() {
        return null;
    }

    public @NonNull AbstractEnforceableRelationDomain2CoreMapping getWhenRelationDomain2CoreMapping(@NonNull TypedModel rEnforcedTypedModel) {
        throw new IllegalStateException();
    }

    protected @Nullable Iterable<@NonNull RelationCallExp> getWhereInvocations() {
        return null;
    }

    public @NonNull AbstractEnforceableRelationDomain2CoreMapping getWhereRelationDomain2CoreMapping(@NonNull TypedModel rEnforcedTypedModel) {
        throw new IllegalStateException();
    }

    public abstract void synthesize() throws CompilerChainException;

    public @NonNull String toString() {
        return String.valueOf(PivotUtil.getName((NamedElement)this.rTransformation)) + "::" + this.rRelationName;
    }

    protected abstract class AbstractEnforceableRelationDomain2CoreMapping {
        protected final @NonNull RelationDomain rEnforcedDomain;
        protected final @NonNull TypedModel rEnforcedTypedModel;
        protected final @NonNull String rEnforcedDomainName;
        protected final @NonNull Map<@NonNull Variable, @NonNull TemplateExp> rEnforcedBoundVariables;
        protected final @Nullable Map<@NonNull Variable, @NonNull List<@NonNull CollectionTemplateExp>> rEnforcedMemberVariables;
        protected final @Nullable Map<@NonNull Variable, @NonNull CollectionTemplateExp> rEnforcedRestVariables;
        protected final @NonNull Set<@NonNull Variable> rEnforcedReferredVariables;
        protected final @NonNull List<@NonNull TemplateExp> rEnforcedRootTemplateExpressions;
        protected final @NonNull List<@NonNull Variable> rEnforcedRootVariables;
        protected final @NonNull List<@NonNull AbstractOtherRelationDomain2CoreDomain> otherDomain2coreDomains;
        protected final @NonNull Set<@NonNull Variable> rAllOtherBoundVariables;
        protected final @NonNull Set<@NonNull Variable> rAllOtherReferredVariables;
        protected final @NonNull Mapping cMapping;
        protected final @NonNull GuardPattern cMiddleGuardPattern;
        protected final @NonNull BottomPattern cMiddleBottomPattern;
        protected final @NonNull TypedModel cEnforcedTypedModel;
        protected final @NonNull CoreDomain cEnforcedDomain;
        protected final @NonNull GuardPattern cEnforcedGuardPattern;
        protected final @NonNull BottomPattern cEnforcedBottomPattern;
        protected final @NonNull VariablesAnalysis variablesAnalysis;
        protected final @NonNull RealizedVariable cMiddleRealizedVariable;
        private final @NonNull Map<@NonNull Element, @NonNull List<@NonNull Element>> source2targets = new HashMap<Element, List<Element>>();
        private final @NonNull Map<@NonNull Element, @NonNull Element> target2source = new HashMap<Element, Element>();

        public AbstractEnforceableRelationDomain2CoreMapping(@NonNull RelationDomain rEnforcedDomain, String cMappingName) throws CompilerChainException {
            Variable rVariable;
            this.rEnforcedDomain = rEnforcedDomain;
            this.rEnforcedBoundVariables = VariablesAnalysis.gatherBoundVariables((Element)rEnforcedDomain);
            this.rEnforcedMemberVariables = VariablesAnalysis.gatherMemberVariables((Element)rEnforcedDomain);
            this.rEnforcedRestVariables = VariablesAnalysis.gatherRestVariables((Element)rEnforcedDomain);
            this.rEnforcedReferredVariables = new HashSet<Variable>();
            VariablesAnalysis.gatherReferredVariables(this.rEnforcedReferredVariables, (Element)rEnforcedDomain);
            this.rEnforcedRootTemplateExpressions = this.getRootTemplateExpressions(rEnforcedDomain);
            this.rEnforcedRootVariables = QVTrelationUtil.getRootVariables((RelationDomain)rEnforcedDomain);
            this.rEnforcedTypedModel = QVTrelationUtil.getTypedModel((Domain)rEnforcedDomain);
            this.rEnforcedDomainName = (String)ClassUtil.nonNullState((Object)rEnforcedDomain.getName());
            @NonNull Class traceClass = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getTraceClass(AbstractQVTr2QVTcRelations.this.rRelation);
            this.cEnforcedTypedModel = this.getCoreTypedModel(this.rEnforcedTypedModel);
            this.cMapping = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.createMapping(AbstractQVTr2QVTcRelations.this.rRelation, cMappingName);
            this.cMiddleGuardPattern = (GuardPattern)ClassUtil.nonNullState((Object)this.cMapping.getGuardPattern());
            this.cMiddleBottomPattern = (BottomPattern)ClassUtil.nonNullState((Object)this.cMapping.getBottomPattern());
            this.cEnforcedDomain = this.createCoreDomain(this.cEnforcedTypedModel, true);
            this.cEnforcedGuardPattern = (GuardPattern)ClassUtil.nonNullState((Object)this.cEnforcedDomain.getGuardPattern());
            this.cEnforcedBottomPattern = (BottomPattern)ClassUtil.nonNullState((Object)this.cEnforcedDomain.getBottomPattern());
            this.variablesAnalysis = this.createVariablesAnalysis(rEnforcedDomain, (Type)traceClass);
            this.cMiddleRealizedVariable = this.variablesAnalysis.getMiddleRealizedVariable();
            this.otherDomain2coreDomains = new ArrayList<AbstractOtherRelationDomain2CoreDomain>();
            this.rAllOtherBoundVariables = new HashSet<Variable>();
            for (Domain rDomain : ClassUtil.nullFree((EList)rEnforcedDomain.getRule().getDomain())) {
                if (rDomain == rEnforcedDomain || !(rDomain instanceof RelationDomain)) continue;
                RelationDomain rRelationDomain = (RelationDomain)rDomain;
                this.otherDomain2coreDomains.add(this.createOtherDomain2CoreDomain(rRelationDomain));
            }
            HashSet<@NonNull Variable> rUnsharedEnforcedDomainVariables = new HashSet<Variable>(this.rEnforcedReferredVariables);
            rUnsharedEnforcedDomainVariables.removeAll(AbstractQVTr2QVTcRelations.this.rSharedVariables);
            this.rAllOtherReferredVariables = new HashSet<Variable>(AbstractQVTr2QVTcRelations.this.rAllVariables);
            this.rAllOtherReferredVariables.removeAll(rUnsharedEnforcedDomainVariables);
            for (Map.Entry<Variable, TypedModel> entry : AbstractQVTr2QVTcRelations.this.rWhenVariable2rTypedModel.entrySet()) {
                TypedModel rWhenTypedModel = entry.getValue();
                if (rWhenTypedModel == null) continue;
                this.variablesAnalysis.getVariableAnalysis(entry.getKey()).setWhen(this.getCoreDomain(rWhenTypedModel));
            }
            for (Map.Entry<Variable, TypedModel> entry : AbstractQVTr2QVTcRelations.this.rWhereVariable2rTypedModel.entrySet()) {
                TypedModel rWhereTypedModel = entry.getValue();
                if (rWhereTypedModel == null) continue;
                this.variablesAnalysis.getVariableAnalysis(entry.getKey()).setWhere(this.getCoreDomain(rWhereTypedModel));
            }
            for (Variable rVariable2 : this.rEnforcedBoundVariables.keySet()) {
                Key rKey = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getKeyForType(QVTrelationUtil.getType((TypedElement)rVariable2));
                this.variablesAnalysis.getVariableAnalysis(rVariable2).setIsEnforcedBound(this.rEnforcedBoundVariables.get(rVariable2), this.rEnforcedTypedModel, rKey);
            }
            for (Variable rVariable2 : this.rEnforcedReferredVariables) {
                this.variablesAnalysis.getVariableAnalysis(rVariable2).setIsEnforcedReferred();
            }
            for (Variable rVariable2 : this.rEnforcedRootVariables) {
                this.variablesAnalysis.getVariableAnalysis(rVariable2).setIsRoot();
            }
            block6: for (Map.Entry<Variable, TypedModel> entry : AbstractQVTr2QVTcRelations.this.rWhenVariable2rTypedModel.entrySet()) {
                OCLExpression rWhenInit;
                Variable rWhenVariable = entry.getKey();
                TypedModel rWhenTypedModel = entry.getValue();
                VariableAnalysis variableAnalysis = this.variablesAnalysis.getVariableAnalysis(rWhenVariable);
                if (rWhenTypedModel != null || (rWhenInit = rWhenVariable.getOwnedInit()) == null) continue;
                HashSet<@NonNull Variable> rReferredVariables = new HashSet<Variable>();
                VariablesAnalysis.gatherReferredVariables(rReferredVariables, (Element)rWhenInit);
                for (Variable rReferredVariable : rReferredVariables) {
                    VariableAnalysis referredVariableAnalysis = this.variablesAnalysis.basicGetVariableAnalysis(rReferredVariable);
                    if (referredVariableAnalysis == null) continue;
                    CorePattern corePattern = referredVariableAnalysis.getCorePattern();
                    if (corePattern == null) continue block6;
                    variableAnalysis.setPredicate((Area)ClassUtil.nonNullState((Object)corePattern.getArea()));
                    continue block6;
                }
            }
            QVTr2QVTc.VARIABLES.println(" In " + this.cMapping + "\n\t\t" + this.variablesAnalysis.toString().replace("\n", "\n\t\t"));
            for (VariableAnalysis analysis : this.variablesAnalysis.getAnalyses()) {
                rVariable = analysis.getRelationVariable();
                if (rVariable == null) continue;
                Variable cVariable = analysis.getCoreVariable();
                this.putTrace((Element)cVariable, (Element)rVariable);
            }
            for (VariableAnalysis analysis : this.variablesAnalysis.getAnalyses()) {
                OCLExpression rOwnedInit;
                rVariable = analysis.getRelationVariable();
                if (rVariable == null || (rOwnedInit = rVariable.getOwnedInit()) == null) continue;
                Variable cVariable = analysis.getCoreVariable();
                cVariable.setOwnedInit(this.mapExpression(rOwnedInit));
            }
        }

        private void addPropertyAssignmentToMiddleBottomPattern(@NonNull Variable rTargetVariable, @NonNull Property targetProperty, @NonNull OCLExpression rExpression) throws CompilerChainException {
            Variable cTargetVariable = null;
            OCLExpression cExpression = null;
            if (rExpression instanceof ObjectTemplateExp) {
                Variable rBoundVariable = (Variable)ClassUtil.nonNullState((Object)((ObjectTemplateExp)rExpression).getBindsTo());
                if (!AbstractQVTr2QVTcRelations.this.rSharedVariables.contains(rBoundVariable)) {
                    Variable cBoundVariable = this.variablesAnalysis.getCoreVariable(rBoundVariable);
                    cExpression = AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cBoundVariable);
                    cTargetVariable = this.variablesAnalysis.addTraceNavigationAssignment(rBoundVariable, false);
                }
            } else if (rExpression instanceof VariableExp) {
                cTargetVariable = this.variablesAnalysis.getCoreVariable(rTargetVariable);
                Variable rReferredVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)((VariableExp)rExpression).getReferredVariable()));
                Variable cReferredVariable = this.variablesAnalysis.getCoreVariable(rReferredVariable);
                if (!AbstractQVTr2QVTcRelations.this.rSharedVariables.contains(rReferredVariable) && !this.cEnforcedBottomPattern.getRealizedVariable().contains((Object)cTargetVariable)) {
                    this.cEnforcedBottomPattern.getRealizedVariable().add((Object)((RealizedVariable)cTargetVariable));
                }
                cExpression = AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cReferredVariable);
            } else {
                cTargetVariable = this.variablesAnalysis.getCoreVariable(rTargetVariable);
                cExpression = this.mapExpression(rExpression);
            }
            if (cTargetVariable != null && cExpression != null) {
                this.variablesAnalysis.addNavigationAssignment(rTargetVariable, targetProperty, cExpression, false);
            }
        }

        private @NonNull CoreDomain createCoreDomain(@NonNull TypedModel cTypedModel, boolean isEnforced) {
            CoreDomain coreDomain = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.createCoreDomain(cTypedModel);
            coreDomain.setIsCheckable(false);
            coreDomain.setIsEnforceable(isEnforced);
            coreDomain.setRule((Rule)this.cMapping);
            return coreDomain;
        }

        protected abstract @NonNull AbstractOtherRelationDomain2CoreDomain createOtherDomain2CoreDomain(@NonNull RelationDomain var1);

        protected abstract @NonNull VariablesAnalysis createVariablesAnalysis(@NonNull RelationDomain var1, @NonNull Type var2) throws CompilerChainException;

        protected @NonNull CoreDomain getCoreDomain(@NonNull TypedModel rTypedModel) {
            TypedModel cTypedModel = this.getCoreTypedModel(rTypedModel);
            for (Domain cDomain : ClassUtil.nullFree((EList)this.cMapping.getDomain())) {
                if (QVTcoreUtil.getTypedModel((Domain)cDomain) != cTypedModel) continue;
                return (CoreDomain)cDomain;
            }
            throw new IllegalStateException();
        }

        public @NonNull Mapping getCoreMapping() {
            return this.cMapping;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected @NonNull TypedModel getCoreTypedModel(@NonNull TypedModel rTypedModel) {
            String name = PivotUtil.getName((NamedElement)rTypedModel);
            @NonNull Iterable usedPackages = QVTrelationUtil.getUsedPackages((TypedModel)rTypedModel);
            for (TypedModel cTypedModel : QVTcoreUtil.getModelParameters((Transformation)AbstractQVTr2QVTcRelations.this.cTransformation)) {
                if (!name.equals(cTypedModel.getName())) continue;
                assert (cTypedModel.getUsedPackage().equals((Object)usedPackages));
                return cTypedModel;
            }
            return (TypedModel)ClassUtil.nonNullState(null);
        }

        protected abstract @NonNull Set<@NonNull Variable> getEnforcedBottomDomainVariables();

        protected @NonNull Set<@NonNull RelationDomain> getOtherRelationDomains() {
            HashSet<@NonNull RelationDomain> relationDomains = new HashSet<RelationDomain>();
            for (Domain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)AbstractQVTr2QVTcRelations.this.rRelation)) {
                relationDomains.add((RelationDomain)relationDomain);
            }
            relationDomains.remove(this.rEnforcedDomain);
            return relationDomains;
        }

        protected @NonNull List<@NonNull TemplateExp> getRootTemplateExpressions(@NonNull RelationDomain rRelationDomain) {
            ArrayList<@NonNull TemplateExp> rTemplateExpressions = new ArrayList<TemplateExp>();
            for (DomainPattern rDomainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)rRelationDomain)) {
                rTemplateExpressions.add(QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)rDomainPattern));
            }
            return rTemplateExpressions;
        }

        private boolean isVarBoundToSomeOtherTemplate(ObjectTemplateExp rootTe, TemplateExp skipTe, Variable v) {
            if (rootTe == skipTe) {
                return false;
            }
            if (rootTe.getBindsTo().equals(v)) {
                return true;
            }
            boolean exists = false;
            for (PropertyTemplateItem p : rootTe.getPart()) {
                if (!(p.getValue() instanceof ObjectTemplateExp)) continue;
                exists |= this.isVarBoundToSomeOtherTemplate((ObjectTemplateExp)p.getValue(), skipTe, v);
            }
            return exists;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected void mapEnforcedCollectionTemplateExpression(@NonNull CollectionTemplateExp rEnforcedCollectionTemplateExp, @Nullable Key key) throws CompilerChainException {
            @NonNull CollectionTemplateExp cte = rEnforcedCollectionTemplateExp;
            Variable vcte = QVTrelationUtil.getBindsTo((TemplateExp)cte);
            Variable mvcte = this.variablesAnalysis.getCoreVariable(vcte);
            HashMap<@NonNull OCLExpression, @NonNull Variable> rMember2mVariable = new HashMap<OCLExpression, Variable>();
            @NonNull List rMembers = QVTrelationUtil.Internal.getOwnedMembersList((CollectionTemplateExp)cte);
            for (OCLExpression rMember : rMembers) {
                Variable mVariable;
                if (rMember instanceof TemplateExp) {
                    TemplateExp rTemplateExp = (TemplateExp)rMember;
                    this.mapEnforcedTemplateExpression(rTemplateExp);
                    Variable rVariable = QVTrelationUtil.getBindsTo((TemplateExp)rTemplateExp);
                    mVariable = this.variablesAnalysis.getCoreVariable(rVariable);
                } else if (rMember instanceof VariableExp) {
                    Variable rVariable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)rMember));
                    mVariable = this.variablesAnalysis.getCoreVariable(rVariable);
                } else {
                    OCLExpression mMember = this.mapExpression(rMember);
                    mVariable = this.variablesAnalysis.addCoreVariable("member", mMember);
                }
                rMember2mVariable.put(rMember, mVariable);
            }
            CollectionType collectionType = QVTrelationUtil.getReferredCollectionType((CollectionTemplateExp)cte);
            Variable rRest = cte.getRest();
            if (rRest == null) {
                ArrayList<@NonNull CollectionItem> mParts = new ArrayList<CollectionItem>();
                for (OCLExpression rMember : rMembers) {
                    Variable mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                    CollectionItem mItem = AbstractQVTr2QVTcRelations.this.createCollectionItem((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mVariable));
                    mParts.add(mItem);
                }
                CollectionLiteralExp cle = AbstractQVTr2QVTcRelations.this.createCollectionLiteralExp(collectionType, mParts);
                this.variablesAnalysis.addConditionPredicate((CorePattern)this.cMiddleBottomPattern, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mvcte), (OCLExpression)cle);
            } else if (rRest.isIsImplicit()) {
                PropertyTemplateItem rPropertyTemplateItem = (PropertyTemplateItem)cte.eContainer();
                assert (rPropertyTemplateItem != null);
                ObjectTemplateExp rObjectTemplateExp = QVTrelationUtil.getOwningObjectTemplateExp((PropertyTemplateItem)rPropertyTemplateItem);
                Variable vote = QVTrelationUtil.getBindsTo((TemplateExp)rObjectTemplateExp);
                Variable cvote = this.variablesAnalysis.getCoreVariable(vote);
                for (OCLExpression rMember : rMembers) {
                    Variable mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                    NavigationAssignment aRest = AbstractQVTr2QVTcRelations.this.createNavigationAssignment((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cvote), QVTrelationUtil.getReferredProperty((PropertyTemplateItem)rPropertyTemplateItem), (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mVariable), true);
                    this.cMiddleBottomPattern.getAssignment().add((Object)aRest);
                }
            } else {
                ArrayList<@NonNull CollectionItem> ownedParts = new ArrayList<CollectionItem>();
                for (OCLExpression rMember : rMembers) {
                    Variable mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                    ownedParts.add(AbstractQVTr2QVTcRelations.this.createCollectionItem((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mVariable)));
                }
                CollectionLiteralExp cExpression = AbstractQVTr2QVTcRelations.this.createCollectionLiteralExp(collectionType, ownedParts);
                Variable mRest = this.variablesAnalysis.getCoreVariable(rRest);
                cExpression = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)cExpression, "includingAll", new OCLExpression[]{AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mRest)});
                VariableAssignment aRest = AbstractQVTr2QVTcRelations.this.createVariableAssignment(mvcte, (OCLExpression)cExpression);
                this.cMiddleBottomPattern.getAssignment().add((Object)aRest);
            }
        }

        protected void mapEnforcedDomainPatterns() throws CompilerChainException {
            for (TemplateExp rEnforcedRootTemplateExpression : this.rEnforcedRootTemplateExpressions) {
                this.mapEnforcedTemplateExpression(rEnforcedRootTemplateExpression);
            }
        }

        protected void mapEnforcedObjectTemplateExpression(@NonNull ObjectTemplateExp rEnforcedObjectTemplateExpression, @Nullable Key key) throws CompilerChainException {
            Variable rTemplateVariable = QVTrelationUtil.getBindsTo((TemplateExp)rEnforcedObjectTemplateExpression);
            for (PropertyTemplateItem pt : QVTrelationUtil.getOwnedParts((ObjectTemplateExp)rEnforcedObjectTemplateExpression)) {
                Property partProperty = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)pt);
                OCLExpression rPartValue = QVTrelationUtil.getOwnedValue((PropertyTemplateItem)pt);
                if (key != null && key.getPart().contains((Object)partProperty)) {
                    this.addPropertyAssignmentToMiddleBottomPattern(rTemplateVariable, partProperty, rPartValue);
                    continue;
                }
                if (rPartValue instanceof CollectionTemplateExp) {
                    CollectionTemplateExp cte = (CollectionTemplateExp)rPartValue;
                    Variable cTemplateVariable = this.variablesAnalysis.getCoreVariable(rTemplateVariable);
                    Variable vcte = QVTrelationUtil.getBindsTo((TemplateExp)cte);
                    Variable mvcte = this.variablesAnalysis.getCoreVariable(vcte);
                    NavigationCallExp pce = AbstractQVTr2QVTcRelations.this.createNavigationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cTemplateVariable), partProperty);
                    VariableAssignment a = AbstractQVTr2QVTcRelations.this.createVariableAssignment(mvcte, (OCLExpression)pce);
                    this.cMiddleBottomPattern.getAssignment().add((Object)a);
                    this.mapEnforcedTemplateExpression((TemplateExp)cte);
                    continue;
                }
                if (rPartValue instanceof ObjectTemplateExp) {
                    ObjectTemplateExp ote = (ObjectTemplateExp)rPartValue;
                    Variable pv = (Variable)ClassUtil.nonNullState((Object)ote.getBindsTo());
                    Variable cTargetVariable = this.variablesAnalysis.getCoreVariable(pv);
                    this.variablesAnalysis.addNavigationAssignment(rTemplateVariable, partProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cTargetVariable), null);
                    this.mapEnforcedTemplateExpression((TemplateExp)ote);
                    continue;
                }
                if (rPartValue instanceof VariableExp) {
                    Variable rPartVariable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)rPartValue));
                    for (TemplateExp rTemplateExpression : this.rEnforcedRootTemplateExpressions) {
                        if (!(rTemplateExpression instanceof ObjectTemplateExp) || !this.isVarBoundToSomeOtherTemplate((ObjectTemplateExp)rTemplateExpression, (TemplateExp)rEnforcedObjectTemplateExpression, rPartVariable)) continue;
                        Variable cReferredVariable = this.variablesAnalysis.getCoreVariable(rPartVariable);
                        Property cTargetProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getTraceProperty(QVTrelationUtil.getType((TypedElement)cReferredVariable), (VariableDeclaration)cReferredVariable);
                        NavigationCallExp cPropertyCallExp = AbstractQVTr2QVTcRelations.this.createNavigationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)this.cMiddleRealizedVariable), cTargetProperty);
                        this.variablesAnalysis.addConditionPredicate((CorePattern)this.cMiddleGuardPattern, (OCLExpression)cPropertyCallExp, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cReferredVariable));
                        this.cEnforcedGuardPattern.getBindsTo().add((Object)cReferredVariable);
                    }
                    this.variablesAnalysis.addNavigationAssignment(rTemplateVariable, partProperty, this.mapExpression(rPartValue), null);
                    if (this.rAllOtherReferredVariables.contains(rPartVariable)) continue;
                    this.variablesAnalysis.addTraceNavigationAssignment(rPartVariable, false);
                    continue;
                }
                this.variablesAnalysis.addNavigationAssignment(rTemplateVariable, partProperty, this.mapExpression(rPartValue), null);
            }
        }

        private void mapEnforcedTemplateExpression(@NonNull TemplateExp rEnforcedTemplateExpression) throws CompilerChainException {
            Variable rTemplateVariable = QVTrelationUtil.getBindsTo((TemplateExp)rEnforcedTemplateExpression);
            Type rTemplateVariableType = QVTrelationUtil.getType((TypedElement)rTemplateVariable);
            Key key = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getKeyForType(rTemplateVariableType);
            VariableAnalysis variableAnalysis = this.variablesAnalysis.getVariableAnalysis(rTemplateVariable);
            if (variableAnalysis.hasWhenDomain()) {
                key = null;
            }
            if (rEnforcedTemplateExpression instanceof ObjectTemplateExp) {
                this.mapEnforcedObjectTemplateExpression((ObjectTemplateExp)rEnforcedTemplateExpression, key);
            } else if (rEnforcedTemplateExpression instanceof CollectionTemplateExp) {
                this.mapEnforcedCollectionTemplateExpression((CollectionTemplateExp)rEnforcedTemplateExpression, key);
            } else {
                throw new CompilerChainException("Missing mapEnforcedTemplateExpression support " + rEnforcedTemplateExpression.eClass().getName(), new Object[0]);
            }
            this.variablesAnalysis.addTraceNavigationAssignment(rTemplateVariable, false);
            OCLExpression rGuardPredicate = rEnforcedTemplateExpression.getWhere();
            if (rGuardPredicate != null) {
                this.cMiddleGuardPattern.getPredicate().add((Object)AbstractQVTr2QVTcRelations.this.createPredicate(this.mapExpression(rGuardPredicate)));
            }
        }

        protected @NonNull OCLExpression mapExpression(@NonNull OCLExpression rExpression) {
            ExpressionCopier copier = new ExpressionCopier();
            OCLExpression eOut = (OCLExpression)copier.copy((EObject)rExpression);
            copier.copyReferences();
            for (EObject eSource : copier.keySet()) {
                EObject eTarget = (EObject)copier.get(eSource);
                if (eTarget == null) continue;
                assert (eSource != null);
                this.putTrace((Element)eTarget, (Element)eSource);
            }
            assert (eOut != null);
            return eOut;
        }

        protected void mapIncomingInvocation() throws CompilerChainException {
        }

        protected void mapOtherDomainPatterns() throws CompilerChainException {
            for (AbstractOtherRelationDomain2CoreDomain otherDomain2coreDomain : this.otherDomain2coreDomains) {
                otherDomain2coreDomain.synthesize();
            }
        }

        protected void mapOtherDomainVariables(@NonNull Set<@NonNull Variable> rDomainVariables) throws CompilerChainException {
            for (Variable rDomainVariable : rDomainVariables) {
                this.variablesAnalysis.addTraceNavigationAssignment(rDomainVariable, true);
            }
        }

        protected abstract @NonNull AbstractEnforceableRelationDomain2CoreMapping mapOverrides(@NonNull AbstractQVTr2QVTcRelations var1);

        protected void mapRelationImplementation() {
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected void mapWhenPattern() throws CompilerChainException {
            Pattern rWhenPattern = AbstractQVTr2QVTcRelations.this.rRelation.getWhen();
            if (rWhenPattern != null) {
                HashSet<@NonNull Variable> rMiddleGuardDomainVariables = new HashSet<Variable>(AbstractQVTr2QVTcRelations.this.rWhenVariable2rTypedModel.keySet());
                rMiddleGuardDomainVariables.removeAll(AbstractQVTr2QVTcRelations.this.rAllVariables);
                for (Predicate rWhenPredicate : QVTrelationUtil.getOwnedPredicates((Pattern)rWhenPattern)) {
                    OCLExpression rConditionExpression = QVTrelationUtil.getConditionExpression((Predicate)rWhenPredicate);
                    if (rConditionExpression instanceof RelationCallExp) {
                        String invokedName;
                        RelationCallExp rInvocation = (RelationCallExp)rConditionExpression;
                        Relation rInvokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)rInvocation);
                        @NonNull List rArguments = QVTrelationUtil.Internal.getOwnedArgumentsList((RelationCallExp)rInvocation);
                        List<@NonNull Variable> rParameters = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getRootVariables(rInvokedRelation);
                        int iSize = rArguments.size();
                        assert (iSize == rParameters.size());
                        if (rInvokedRelation.isIsTopLevel()) {
                            Class invokedTraceClass = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getTraceClass(rInvokedRelation);
                            invokedName = "when_" + invokedTraceClass.getName();
                            Variable cCalledVariable = this.variablesAnalysis.addCoreGuardVariable(invokedName, (Type)invokedTraceClass);
                            int i = 0;
                            while (i < iSize) {
                                VariableExp rArgument = (VariableExp)rArguments.get(i);
                                Variable rParameter = rParameters.get(i);
                                Variable rArgumentVariable = QVTbaseUtil.getReferredVariable((VariableExp)rArgument);
                                Variable cArgumentVariable = this.variablesAnalysis.getCoreVariable(rArgumentVariable);
                                Property cCalledProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getTraceProperty(QVTrelationUtil.getType((TypedElement)cCalledVariable), (VariableDeclaration)rParameter);
                                NavigationCallExp cCalledValue = AbstractQVTr2QVTcRelations.this.createNavigationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cCalledVariable), cCalledProperty);
                                this.variablesAnalysis.addConditionPredicate((CorePattern)this.cMiddleGuardPattern, (OCLExpression)cCalledValue, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cArgumentVariable));
                                ++i;
                            }
                            continue;
                        }
                        Class invokedSignatureClass = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getSignatureClass(rInvokedRelation);
                        invokedName = "when_" + invokedSignatureClass.getName();
                        RealizedVariable cInvocationVariable = this.variablesAnalysis.addCoreRealizedVariable(invokedName, (Type)invokedSignatureClass);
                        Property cInvocationProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getTraceProperty(rInvocation);
                        this.variablesAnalysis.addTraceNavigationAssignment(cInvocationProperty, (Variable)cInvocationVariable);
                        VariableAnalysis signatureVariableAnalysis = this.variablesAnalysis.getCoreVariableAnalysis((Variable)cInvocationVariable);
                        int i = 0;
                        while (i < iSize) {
                            VariableExp rArgument = (VariableExp)rArguments.get(i);
                            Variable rParameter = rParameters.get(i);
                            Variable cArgumentVariable = this.variablesAnalysis.getCoreVariable(QVTbaseUtil.getReferredVariable((VariableExp)rArgument));
                            Property cCalledProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getSignatureProperty(QVTrelationUtil.getClass((TypedElement)cInvocationVariable), (VariableDeclaration)rParameter);
                            signatureVariableAnalysis.addNavigationAssignment(cCalledProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cArgumentVariable), false);
                            ++i;
                        }
                        continue;
                    }
                    OCLExpression cConditionExpression = this.mapExpression(rConditionExpression);
                    this.variablesAnalysis.addPredicate((CorePattern)this.cMiddleGuardPattern, cConditionExpression);
                }
            }
        }

        protected void mapWhereBottomPredicates(@NonNull Iterable<@NonNull Predicate> rWherePredicates) throws CompilerChainException {
            for (Predicate rWherePredicate : rWherePredicates) {
                OCLExpression rExpression = QVTrelationUtil.getConditionExpression((Predicate)rWherePredicate);
                this.variablesAnalysis.addPredicate((CorePattern)this.cMiddleBottomPattern, this.mapExpression(rExpression));
            }
        }

        protected void mapWhereGuardPredicates(@NonNull Set<@NonNull Predicate> rWhereGuardPredicates, @NonNull Set<@NonNull Variable> rEnforcedBottomDomainVariables) throws CompilerChainException {
            HashSet<@NonNull Variable> nonRootEnforcedBottomDomainVariables = new HashSet<Variable>(rEnforcedBottomDomainVariables);
            nonRootEnforcedBottomDomainVariables.removeAll(this.rEnforcedRootVariables);
            Set<@NonNull Predicate> wherePredicatesWithVarBindings = this.selectPredicatesThatReferToVariables(rWhereGuardPredicates, nonRootEnforcedBottomDomainVariables);
            HashSet<@NonNull Predicate> remainingWherePredicatesWithoutVarBindings = new HashSet<Predicate>(rWhereGuardPredicates);
            remainingWherePredicatesWithoutVarBindings.removeAll(wherePredicatesWithVarBindings);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected void mapWherePattern() throws CompilerChainException {
            Pattern rWherePattern = AbstractQVTr2QVTcRelations.this.rRelation.getWhere();
            if (rWherePattern != null) {
                for (Predicate rWherePredicate : QVTrelationUtil.getOwnedPredicates((Pattern)rWherePattern)) {
                    OCLExpression rConditionExpression = QVTrelationUtil.getConditionExpression((Predicate)rWherePredicate);
                    if (!(rConditionExpression instanceof RelationCallExp)) continue;
                    RelationCallExp rInvocation = (RelationCallExp)rConditionExpression;
                    Relation rInvokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)rInvocation);
                    Class invokedSignatureClass = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getSignatureClass(rInvokedRelation);
                    @NonNull List rArguments = QVTrelationUtil.Internal.getOwnedArgumentsList((RelationCallExp)rInvocation);
                    String invokedName = "where_" + invokedSignatureClass.getName();
                    RealizedVariable cInvocationVariable = this.variablesAnalysis.addCoreRealizedVariable(invokedName, (Type)invokedSignatureClass);
                    Property cInvocationProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getTraceProperty(rInvocation);
                    this.variablesAnalysis.addTraceNavigationAssignment(cInvocationProperty, (Variable)cInvocationVariable);
                    VariableAnalysis signatureVariableAnalysis = this.variablesAnalysis.getCoreVariableAnalysis((Variable)cInvocationVariable);
                    List<@NonNull Variable> rParameters = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getRootVariables(rInvokedRelation);
                    int iSize = rArguments.size();
                    assert (iSize == rParameters.size());
                    int i = 0;
                    while (i < iSize) {
                        VariableExp rArgument = (VariableExp)rArguments.get(i);
                        Variable rParameter = rParameters.get(i);
                        Variable cArgumentVariable = this.variablesAnalysis.getCoreVariable(QVTbaseUtil.getReferredVariable((VariableExp)rArgument));
                        Property cCalledProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getSignatureProperty(QVTrelationUtil.getClass((TypedElement)cInvocationVariable), (VariableDeclaration)rParameter);
                        signatureVariableAnalysis.addNavigationAssignment(cCalledProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cArgumentVariable), false);
                        ++i;
                    }
                }
            }
        }

        private void putTrace(@NonNull Element coreElement, @NonNull Element relationElement) {
            Element oldRelationElement = this.target2source.put(coreElement, relationElement);
            assert (oldRelationElement == relationElement || oldRelationElement == null);
            List<@NonNull Element> targets = this.source2targets.get(relationElement);
            if (targets == null) {
                targets = new ArrayList<Element>();
                this.source2targets.put(relationElement, targets);
            }
            targets.add(coreElement);
        }

        protected @NonNull Set<@NonNull Predicate> selectPredicatesThatReferToVariables(@NonNull Set<@NonNull Predicate> rPredicates, @NonNull Set<@NonNull Variable> rVariables) {
            HashSet<@NonNull Predicate> rPredicatesThatReferToVariables = new HashSet<Predicate>();
            for (Predicate rPredicate : rPredicates) {
                HashSet<@NonNull Variable> rPredicateVariables = new HashSet<Variable>();
                VariablesAnalysis.gatherReferredVariables(rPredicateVariables, (Element)rPredicate);
                rPredicateVariables.retainAll(rVariables);
                if (!rPredicateVariables.isEmpty()) continue;
                rPredicatesThatReferToVariables.add(rPredicate);
            }
            return rPredicatesThatReferToVariables;
        }

        protected void synthesize() throws CompilerChainException {
            Set<@NonNull Variable> rEnforcedBottomDomainVariables = this.getEnforcedBottomDomainVariables();
            Set<@NonNull Predicate> rWhereBottomPredicates = this.selectPredicatesThatReferToVariables(AbstractQVTr2QVTcRelations.this.rWherePredicates, rEnforcedBottomDomainVariables);
            HashSet<@NonNull Predicate> rWhereGuardPredicates = new HashSet<Predicate>(AbstractQVTr2QVTcRelations.this.rWherePredicates);
            rWhereGuardPredicates.removeAll(rWhereBottomPredicates);
            this.mapWhereBottomPredicates(rWhereBottomPredicates);
            this.mapOtherDomainPatterns();
            this.mapIncomingInvocation();
            this.mapOtherDomainVariables(this.rAllOtherReferredVariables);
            this.mapWhenPattern();
            this.mapWhereGuardPredicates(rWhereGuardPredicates, rEnforcedBottomDomainVariables);
            this.mapEnforcedDomainPatterns();
            this.mapWherePattern();
            if (this.rEnforcedMemberVariables != null) {
                for (Variable rMemberVariable : this.rEnforcedMemberVariables.keySet()) {
                    this.variablesAnalysis.addTraceNavigationAssignment(rMemberVariable, true);
                }
            }
            this.mapRelationImplementation();
        }

        public @NonNull String toString() {
            return String.valueOf(AbstractQVTr2QVTcRelations.this.rRelationName) + "::" + this.rEnforcedDomainName + " => " + this.cMapping.getName() + "::" + this.cEnforcedDomain.getName();
        }

        protected abstract class AbstractOtherRelationDomain2CoreDomain {
            protected final @NonNull RelationDomain rOtherDomain;
            protected final @NonNull String rOtherDomainName;
            protected final @NonNull TypedModel rOtherTypedModel;
            protected final @NonNull Map<@NonNull Variable, @NonNull TemplateExp> rOtherBoundVariables;
            protected final @Nullable Map<@NonNull Variable, @NonNull List<@NonNull CollectionTemplateExp>> rOtherMemberVariables;
            protected final @Nullable Map<@NonNull Variable, @NonNull CollectionTemplateExp> rOtherRestVariables;
            protected final @NonNull Set<@NonNull Variable> rOtherReferredVariables;
            protected final @NonNull List<@NonNull Variable> rOtherRootVariables;
            protected final @NonNull TypedModel cOtherTypedModel;
            protected final @NonNull CoreDomain cOtherDomain;
            protected final @NonNull GuardPattern cOtherGuardPattern;
            protected final @NonNull BottomPattern cOtherBottomPattern;

            public AbstractOtherRelationDomain2CoreDomain(RelationDomain rOtherDomain) {
                this.rOtherDomain = rOtherDomain;
                this.rOtherDomainName = (String)ClassUtil.nonNullState((Object)rOtherDomain.getName());
                this.rOtherTypedModel = QVTrelationUtil.getTypedModel((Domain)rOtherDomain);
                this.rOtherBoundVariables = VariablesAnalysis.gatherBoundVariables((Element)rOtherDomain);
                this.rOtherMemberVariables = VariablesAnalysis.gatherMemberVariables((Element)rOtherDomain);
                this.rOtherRestVariables = VariablesAnalysis.gatherRestVariables((Element)rOtherDomain);
                this.rOtherReferredVariables = new HashSet<Variable>();
                VariablesAnalysis.gatherReferredVariables(this.rOtherReferredVariables, (Element)rOtherDomain);
                this.rOtherRootVariables = QVTrelationUtil.getRootVariables((RelationDomain)rOtherDomain);
                this.cOtherTypedModel = AbstractEnforceableRelationDomain2CoreMapping.this.getCoreTypedModel(this.rOtherTypedModel);
                this.cOtherDomain = AbstractEnforceableRelationDomain2CoreMapping.this.createCoreDomain(this.cOtherTypedModel, false);
                this.cOtherDomain.setIsCheckable(rOtherDomain.isIsCheckable());
                this.cOtherDomain.setIsEnforceable(false);
                this.cOtherGuardPattern = (GuardPattern)ClassUtil.nonNullState((Object)this.cOtherDomain.getGuardPattern());
                this.cOtherBottomPattern = (BottomPattern)ClassUtil.nonNullState((Object)this.cOtherDomain.getBottomPattern());
                for (Variable rVariable : this.rOtherBoundVariables.keySet()) {
                    AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getVariableAnalysis(rVariable).setOtherBound(this.cOtherDomain);
                }
                for (Variable rVariable : this.rOtherReferredVariables) {
                    AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getVariableAnalysis(rVariable).setOtherReferred(this.cOtherDomain);
                }
                for (Variable rVariable : this.rOtherRootVariables) {
                    AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getVariableAnalysis(rVariable).setIsRoot();
                }
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            private void mapOtherCollectionTemplateExpression(@NonNull CollectionTemplateExp cte) throws CompilerChainException {
                Variable vcte = QVTrelationUtil.getBindsTo((TemplateExp)cte);
                Variable mvcte = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(vcte);
                HashMap<@NonNull OCLExpression, @NonNull Variable> rMember2mVariable = new HashMap<OCLExpression, Variable>();
                @NonNull List rMembers = QVTrelationUtil.Internal.getOwnedMembersList((CollectionTemplateExp)cte);
                for (OCLExpression rMember : rMembers) {
                    Variable mVariable;
                    if (rMember instanceof TemplateExp) {
                        TemplateExp rTemplateExp = (TemplateExp)rMember;
                        this.mapOtherTemplateExpression(rTemplateExp);
                        Variable rVariable = QVTrelationUtil.getBindsTo((TemplateExp)rTemplateExp);
                        mVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rVariable);
                    } else if (rMember instanceof VariableExp) {
                        Variable rVariable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)rMember));
                        mVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rVariable);
                    } else {
                        OCLExpression mMember = AbstractEnforceableRelationDomain2CoreMapping.this.mapExpression(rMember);
                        mVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addCoreVariable("member", mMember);
                    }
                    rMember2mVariable.put(rMember, mVariable);
                }
                CollectionType collectionType = QVTrelationUtil.getReferredCollectionType((CollectionTemplateExp)cte);
                int size = rMembers.size();
                Variable rRest = cte.getRest();
                if (rRest == null) {
                    ArrayList<@NonNull CollectionItem> mParts = new ArrayList<CollectionItem>();
                    for (OCLExpression rMember : rMembers) {
                        Variable mVariable2 = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                        CollectionItem mItem = AbstractQVTr2QVTcRelations.this.createCollectionItem((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mVariable2));
                        mParts.add(mItem);
                    }
                    CollectionLiteralExp cle = AbstractQVTr2QVTcRelations.this.createCollectionLiteralExp(collectionType, mParts);
                    AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addConditionPredicate((CorePattern)AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mvcte), (OCLExpression)cle);
                } else {
                    Variable mVariable;
                    if (!rRest.isIsImplicit()) {
                        Variable mRest = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rRest);
                        VariableExp exclusions = AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mvcte);
                        for (OCLExpression rMember : rMembers) {
                            mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                            exclusions = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)exclusions, "excluding", new OCLExpression[]{AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mVariable)});
                        }
                        VariableAssignment aRest = AbstractQVTr2QVTcRelations.this.createVariableAssignment(mRest, (OCLExpression)exclusions);
                        AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern.getAssignment().add((Object)aRest);
                    }
                    int i = 0;
                    while (i < size) {
                        OCLExpression rMember;
                        @NonNull VariableExp eTerm = AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mvcte);
                        int j = 0;
                        while (j < i) {
                            OCLExpression rMember2 = (OCLExpression)rMembers.get(j);
                            mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember2)));
                            eTerm = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)eTerm, "excluding", new OCLExpression[]{AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mVariable)});
                            ++j;
                        }
                        rMember = (OCLExpression)rMembers.get(i);
                        Variable mVariable2 = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                        eTerm = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)eTerm, "includes", new OCLExpression[]{AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mVariable2)});
                        AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addPredicate((CorePattern)AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern, (OCLExpression)eTerm);
                        ++i;
                    }
                }
            }

            private void mapOtherObjectTemplateExpression(@NonNull ObjectTemplateExp rTemplateExpression) throws CompilerChainException {
                Variable rTemplateVariable = QVTrelationUtil.getBindsTo((TemplateExp)rTemplateExpression);
                for (PropertyTemplateItem propertyTemplateItem : QVTrelationUtil.getOwnedParts((ObjectTemplateExp)rTemplateExpression)) {
                    Property partProperty = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)propertyTemplateItem);
                    Variable cTemplateVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rTemplateVariable);
                    OCLExpression propertyTemplateValue = QVTrelationUtil.getOwnedValue((PropertyTemplateItem)propertyTemplateItem);
                    if (propertyTemplateValue instanceof VariableExp) {
                        Variable rVariable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)propertyTemplateValue));
                        Variable cVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rVariable);
                        AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addNavigationPredicate((CorePattern)this.cOtherBottomPattern, rTemplateVariable, partProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cVariable));
                        continue;
                    }
                    if (propertyTemplateValue instanceof CollectionTemplateExp) {
                        CollectionTemplateExp cte = (CollectionTemplateExp)propertyTemplateValue;
                        Variable vcte = QVTrelationUtil.getBindsTo((TemplateExp)cte);
                        Variable mvcte = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(vcte);
                        NavigationCallExp pce = AbstractQVTr2QVTcRelations.this.createNavigationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cTemplateVariable), partProperty);
                        VariableAssignment a = AbstractQVTr2QVTcRelations.this.createVariableAssignment(mvcte, (OCLExpression)pce);
                        AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern.getAssignment().add((Object)a);
                        this.mapOtherTemplateExpression((TemplateExp)cte);
                        continue;
                    }
                    if (propertyTemplateValue instanceof ObjectTemplateExp) {
                        Variable mvpte;
                        Variable vpte;
                        ObjectTemplateExp pte;
                        if (partProperty.isIsMany()) {
                            pte = (ObjectTemplateExp)propertyTemplateValue;
                            vpte = QVTrelationUtil.getBindsTo((TemplateExp)pte);
                            mvpte = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(vpte);
                            NavigationCallExp cNavigationExp = AbstractQVTr2QVTcRelations.this.createNavigationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)cTemplateVariable), partProperty);
                            OperationCallExp eTerm = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)cNavigationExp, "includes", new OCLExpression[]{AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mvpte)});
                            AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addPredicate((CorePattern)this.cOtherBottomPattern, (OCLExpression)eTerm);
                            this.mapOtherTemplateExpression((TemplateExp)pte);
                            continue;
                        }
                        pte = (ObjectTemplateExp)propertyTemplateValue;
                        vpte = QVTrelationUtil.getBindsTo((TemplateExp)pte);
                        mvpte = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(vpte);
                        AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addNavigationPredicate((CorePattern)this.cOtherBottomPattern, rTemplateVariable, partProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((VariableDeclaration)mvpte));
                        this.mapOtherTemplateExpression((TemplateExp)pte);
                        continue;
                    }
                    AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addNavigationPredicate((CorePattern)this.cOtherBottomPattern, rTemplateVariable, partProperty, AbstractEnforceableRelationDomain2CoreMapping.this.mapExpression(propertyTemplateValue));
                }
            }

            protected void mapOtherTemplateExpression(@NonNull TemplateExp rTemplateExpression) throws CompilerChainException {
                if (rTemplateExpression instanceof ObjectTemplateExp) {
                    this.mapOtherObjectTemplateExpression((ObjectTemplateExp)rTemplateExpression);
                } else if (rTemplateExpression instanceof CollectionTemplateExp) {
                    this.mapOtherCollectionTemplateExpression((CollectionTemplateExp)rTemplateExpression);
                }
                OCLExpression rGuardPredicate = rTemplateExpression.getWhere();
                if (rGuardPredicate != null) {
                    AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern.getPredicate().add((Object)AbstractQVTr2QVTcRelations.this.createPredicate(AbstractEnforceableRelationDomain2CoreMapping.this.mapExpression(rGuardPredicate)));
                }
            }

            public void synthesize() throws CompilerChainException {
                List<@NonNull TemplateExp> rOtherTemplateExpressions = AbstractEnforceableRelationDomain2CoreMapping.this.getRootTemplateExpressions(this.rOtherDomain);
                for (TemplateExp rOtherTemplateExpression : rOtherTemplateExpressions) {
                    this.mapOtherTemplateExpression(rOtherTemplateExpression);
                }
            }
        }

        protected class ExpressionCopier
        extends EcoreUtil.Copier {
            protected ExpressionCopier() {
            }

            public EObject get(Object oIn) {
                if (oIn instanceof Element) {
                    List<@NonNull Element> oOuts = (List<Element>)AbstractEnforceableRelationDomain2CoreMapping.this.source2targets.get(oIn);
                    if (oOuts != null) {
                        assert (oOuts.size() == 1);
                        return (EObject)oOuts.get(0);
                    }
                    oOuts = ((AbstractEnforceableRelationDomain2CoreMapping)AbstractEnforceableRelationDomain2CoreMapping.this).AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getGlobalTargets((Element)oIn);
                    if (oOuts != null) {
                        assert (oOuts.size() == 1);
                        return (EObject)oOuts.get(0);
                    }
                }
                return (EObject)super.get(oIn);
            }

            public EObject copy(EObject oIn) {
                try {
                    if (oIn instanceof IteratorVariable) {
                        return AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable((Variable)((IteratorVariable)oIn));
                    }
                    if (oIn instanceof LetVariable) {
                        return AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable((Variable)((LetVariable)oIn));
                    }
                }
                catch (CompilerChainException e) {
                    e.printStackTrace();
                }
                return super.copy(oIn);
            }
        }
    }
}

