/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceMemberContext;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceTypesStrategy;

public class NamespaceInstanceOfStrategy
extends NamespaceTypesStrategy {
    public NamespaceInstanceOfStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public NamespaceInstanceOfStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        IType[] types;
        ICompletionContext context = this.getContext();
        NamespaceMemberContext concreteContext = (NamespaceMemberContext)context;
        ISourceRange replaceRange = this.getReplacementRange(context);
        String suffix = "";
        String nsSuffix = this.getNSSuffix(concreteContext);
        IType[] iTypeArray = types = this.getTypes(concreteContext);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                int flags = type.getFlags();
                reporter.reportType(type, PHPFlags.isNamespace(flags) ? nsSuffix : suffix, replaceRange, null);
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
    }

    @Override
    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "(".equals(nextWord) ? "" : "()";
    }
}

