/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.AttributeNameCompletionProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.AttributeValueCompletionProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.TagCompletionProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.Parser;

public class TargetDefinitionContentAssist
implements IContentAssistProcessor {
    private static final String PREVIOUS_TAGS_MATCH = "(\\s*<.*>\\s*)*";
    private static final String ATTRIBUTE_NAME_PREFIX_MATCH = "(\\s*<.*>\\s*)*".concat("\\s*<\\s*\\w*(\\s*\\w*\\s*=\\s*\".*?\")*\\s+(?<prefix>\\w*)");
    private static final String TAG_PREFIX_MATCH = "(\\s*<.*>\\s*)*".concat("\\s*<\\s*(?<prefix>\\w*)");
    private static final String ATTRIBUTE_VALUE_MATCH_REGEXP = "(\\s*<.*>\\s*)*".concat("\\s*<\\s*\\w*(\\s+\\w*\\s*=\\s*\".*?\")*\\s+\\w*\\s*=\\s*\"[^\"]*");
    private static final String ATTRIBUTE_VALUE_ACKEY_MATCH = "(\\s*<.*>\\s*)*".concat("\\s*<\\s*\\w*(\\s+\\w*\\s*=\\s*\".*?\")*\\s+(?<ackey>\\w*)\\s*=\\s*\"[^\"]*");
    private static final String ATTRIBUTE_VALUE_PREFIX_MATCH = "(\\s*<.*>\\s*)*".concat("\\s*<\\s*\\w*(\\s+\\w*\\s*=\\s*\".*?\")*\\s+\\w*\\s*=\\s*\"(?<prefix>[^\"]*)");
    private static final String ATTRIBUTE_NAME_MATCH_REGEXP = "(\\s*<.*>\\s*)*".concat("\\s*<\\s*\\w*(\\s*\\w*\\s*=\\s*\".*?\")*\\s+\\w*");
    private static final String ATTRIBUTE_NAME_ACKEY_MATCH = "(\\s*<.*>\\s*)*".concat("\\s*<\\s*(?<ackey>\\w*)(\\s*\\w*\\s*=\\s*\".*?\")*\\s+\\w*");
    private static final String TAG_MATCH_REGEXP = "(\\s*<.*>\\s*)*".concat("\\s*<\\s*\\w*");
    private static final int COMPLETION_TYPE_TAG = 0;
    private static final int COMPLETION_TYPE_ATTRIBUTE_NAME = 1;
    private static final int COMPLETION_TYPE_ATTRIBUTE_VALUE = 2;
    private static final int COMPLETION_TYPE_HEADER = 4;
    private static final int COMPLETION_TYPE_UNKNOWN = 5;
    private static final Pattern TAG_PREFIX_PATTERN = Pattern.compile(TAG_PREFIX_MATCH);
    private static final Pattern ATT_NAME_PREFIX_PATTERN = Pattern.compile(ATTRIBUTE_NAME_PREFIX_MATCH);
    private static final Pattern ATTR_NAME_ACKEY_MATCH = Pattern.compile(ATTRIBUTE_NAME_ACKEY_MATCH);
    private static final Pattern ATTR_VALUE_PREFIX_PATTERN = Pattern.compile(ATTRIBUTE_VALUE_PREFIX_MATCH);
    private static final Pattern ATTR_VALUE_ACKEY_PATTERN = Pattern.compile(ATTRIBUTE_VALUE_ACKEY_MATCH);
    private String prefix = "";
    private String acKey;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        String text = document.get();
        try {
            Parser.getDefault().parse(document);
        }
        catch (XMLStreamException xMLStreamException) {}
        int completionType = this.detectCompletionType(document, text, offset);
        if (completionType == 5) {
            return new ICompletionProposal[0];
        }
        if (completionType == 0) {
            TagCompletionProcessor processor = new TagCompletionProcessor(this.prefix, this.acKey, offset);
            return processor.getCompletionProposals();
        }
        if (completionType == 1) {
            AttributeNameCompletionProcessor processor = new AttributeNameCompletionProcessor(this.prefix, this.acKey, offset);
            return processor.getCompletionProposals();
        }
        if (completionType == 2) {
            AttributeValueCompletionProcessor processor = new AttributeValueCompletionProcessor(this.prefix, this.acKey, offset);
            return processor.getCompletionProposals();
        }
        return new ICompletionProposal[0];
    }

    private int detectCompletionType(IDocument doc, String text, int offset) {
        if (offset == 0) {
            return 4;
        }
        IRegion lineInfo = null;
        try {
            lineInfo = doc.getLineInformationOfOffset(offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return 5;
        }
        String lineText = text.substring(lineInfo.getOffset(), lineInfo.getOffset() + lineInfo.getLength());
        int deltaOffset = offset - lineInfo.getOffset();
        String partialLineText = lineText.substring(0, deltaOffset);
        if (partialLineText.matches(TAG_MATCH_REGEXP)) {
            Matcher matcher = TAG_PREFIX_PATTERN.matcher(partialLineText);
            matcher.matches();
            this.prefix = matcher.group("prefix");
            return 0;
        }
        if (partialLineText.matches(ATTRIBUTE_NAME_MATCH_REGEXP)) {
            Matcher matcher = ATT_NAME_PREFIX_PATTERN.matcher(partialLineText);
            matcher.matches();
            this.prefix = matcher.group("prefix");
            matcher = ATTR_NAME_ACKEY_MATCH.matcher(partialLineText);
            matcher.matches();
            this.acKey = matcher.group("ackey");
            return 1;
        }
        if (partialLineText.matches(ATTRIBUTE_VALUE_MATCH_REGEXP)) {
            Matcher matcher = ATTR_VALUE_PREFIX_PATTERN.matcher(partialLineText);
            matcher.matches();
            this.prefix = matcher.group("prefix");
            matcher = ATTR_VALUE_ACKEY_PATTERN.matcher(partialLineText);
            matcher.matches();
            this.acKey = matcher.group("ackey");
            return 2;
        }
        return 5;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

