/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomActionExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.messages.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.preferences.CustomDiagramGeneralPreferencePage;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.uml2.uml.Message;

public class CreateExecutionSpecificationWithMessage
extends AbstractTransactionalCommand {
    protected CreateConnectionViewAndElementRequest request;
    protected EditPart graphicalContainer;
    protected String preference;
    protected IHintedType type;
    protected boolean createReply;

    public CreateExecutionSpecificationWithMessage(TransactionalEditingDomain domain, CreateConnectionViewAndElementRequest request, EditPart graphicalContainer) {
        super(domain, Messages.Commands_CreateExecutionSpecification_Label, null);
        this.request = request;
        this.graphicalContainer = graphicalContainer;
        this.createReply = false;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Message message = this.getMessage();
        if (message == null) {
            throw new ExecutionException("null message");
        }
        this.retrievePreferences();
        if (this.type == null || "CHOICE_NONE".equals(this.preference)) {
            throw new ExecutionException("undefined preference");
        }
        this.createExecutionSpecification();
        return CommandResult.newOKCommandResult();
    }

    private void createExecutionSpecification() {
        LifelineEditPart lifelineEditPart = (LifelineEditPart)this.graphicalContainer;
        CreateViewRequest requestcreation = CreateViewRequestFactory.getCreateShapeRequest((IElementType)this.type, (PreferencesHint)lifelineEditPart.getDiagramPreferencesHint());
        Point point = this.request.getLocation().getCopy();
        requestcreation.setLocation(point);
        Command command = lifelineEditPart.getCommand((Request)requestcreation);
        command.execute();
        if (this.createReply) {
            Point replysourcepoint = point.getCopy();
            replysourcepoint.setY(replysourcepoint.y + CustomActionExecutionSpecificationEditPart.DEFAULT_HEIGHT);
            this.createReplyMessage(lifelineEditPart, replysourcepoint);
        }
    }

    private void createReplyMessage(LifelineEditPart lifelineEditPart, Point replysourcepoint) {
        CreateConnectionViewRequest requestreplycreation = CreateViewRequestFactory.getCreateConnectionRequest((IElementType)UMLDIElementTypes.MESSAGE_REPLY_EDGE, (PreferencesHint)lifelineEditPart.getDiagramPreferencesHint());
        requestreplycreation.setLocation(replysourcepoint);
        requestreplycreation.setSourceEditPart(null);
        requestreplycreation.setTargetEditPart((EditPart)lifelineEditPart);
        requestreplycreation.setType((Object)"connection start");
        Command replycommand = lifelineEditPart.getCommand((Request)requestreplycreation);
        requestreplycreation.setSourceEditPart((EditPart)lifelineEditPart);
        LifelineEditPart target = (LifelineEditPart)this.request.getSourceEditPart();
        requestreplycreation.setTargetEditPart((EditPart)target);
        requestreplycreation.setType((Object)"connection end");
        LifelineFigure f = target.getPrimaryShape();
        Rectangle b = f.getBounds().getCopy();
        f.translateToAbsolute((Translatable)b);
        Point c = b.getCenter().getCopy();
        Point replytargetpoint = replysourcepoint.getCopy();
        replytargetpoint.setX(c.x);
        requestreplycreation.setLocation(replytargetpoint);
        replycommand = target.getCommand((Request)requestreplycreation);
        replycommand.execute();
    }

    private Message getMessage() {
        Message message = null;
        CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor connectionViewAndElementDescriptor = this.request.getConnectionViewAndElementDescriptor();
        if (connectionViewAndElementDescriptor != null) {
            CreateElementRequestAdapter createElementRequestAdapter = connectionViewAndElementDescriptor.getCreateElementRequestAdapter();
            message = (Message)createElementRequestAdapter.getAdapter(Message.class);
        }
        return message;
    }

    private void retrievePreferences() {
        this.type = null;
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        if (this.request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_ASYNCH_EDGE.getSemanticHint())) {
            this.preference = store.getString(CustomDiagramGeneralPreferencePage.PREF_EXECUTION_SPECIFICATION_ASYNC_MSG);
        }
        if (this.request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_SYNCH_EDGE.getSemanticHint())) {
            this.preference = store.getString(CustomDiagramGeneralPreferencePage.PREF_EXECUTION_SPECIFICATION_SYNC_MSG);
        }
        if ("CHOICE_BEHAVIOR".equals(this.preference) || "CHOICE_BEHAVIOR_AND_REPLY".equals(this.preference)) {
            this.type = UMLDIElementTypes.BEHAVIOR_EXECUTION_SPECIFICATION_SHAPE;
        }
        if ("CHOICE_ACTION".equals(this.preference) || "CHOICE_ACTION_AND_REPLY".equals(this.preference)) {
            this.type = UMLDIElementTypes.ACTION_EXECUTION_SPECIFICATION_SHAPE;
        }
        if ("CHOICE_BEHAVIOR_AND_REPLY".equals(this.preference) || "CHOICE_ACTION_AND_REPLY".equals(this.preference)) {
            this.createReply = true;
        }
    }
}

