/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.uml2.uml.Element;

public class CreateCoordinateCommand
extends RecordingCommand {
    private BasicCompartment compartment;
    private String name;
    private int position;
    private EObject semantic;

    public CreateCoordinateCommand(TransactionalEditingDomain domain, BasicCompartment compartment, String name, Element semantic, int position) {
        super(domain, "create Grilling Structure");
        this.compartment = compartment;
        this.name = name;
        this.position = position;
        this.semantic = semantic;
    }

    public void doExecute() {
        DecorationNode coordinate = NotationFactory.eINSTANCE.createDecorationNode();
        Location linelocation = NotationFactory.eINSTANCE.createLocation();
        coordinate.setType(this.name);
        if (this.name.startsWith(GridManagementEditPolicy.COLUMN)) {
            linelocation.setX(this.position);
        }
        if (this.name.startsWith(GridManagementEditPolicy.ROW)) {
            linelocation.setY(this.position);
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, ">>>Create row at " + this.position);
        }
        coordinate.setLayoutConstraint((LayoutConstraint)linelocation);
        if (this.semantic != null) {
            coordinate.setElement(this.semantic);
        }
        ViewUtil.insertChildView((View)this.compartment, (View)coordinate, (int)-1, (boolean)false);
    }
}

