/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.SyncStyles;
import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.policy.SyncPolicyDelegate;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public abstract class NotationSyncPolicyDelegate<M extends EObject, T extends EditPart>
extends SyncPolicyDelegate<M, T> {
    private final String feature;

    public NotationSyncPolicyDelegate(String feature) {
        this.feature = feature;
    }

    public boolean shouldSynchronize(SyncItem<M, T> from, SyncItem<M, T> to) {
        View view;
        EditPart backend = (EditPart)to.getBackend();
        View view2 = view = backend == null ? null : (View)TypeUtils.as((Object)backend.getModel(), View.class);
        return view != null && SyncStyles.isSynchronized(view, this.feature);
    }

    protected Command stopSynchronzing(T editPart) {
        View view;
        Command result = null;
        View view2 = view = editPart == null ? null : (View)TypeUtils.as((Object)editPart.getModel(), View.class);
        if (view != null && !(result = SyncStyles.createSetExcludedCommand(view, this.feature, true)).canExecute()) {
            result = null;
        }
        return result;
    }

    protected void overrideOccurred(EMFDispatch receiver, SyncItem<M, T> syncItem) {
        Command reaction = this.stopSynchronzing((EditPart)syncItem.getBackend());
        if (reaction != null) {
            receiver.react(reaction);
        }
        this.unobserve(syncItem);
    }
}

