/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.utilities;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.internal.resource.ICSI2ASMapping;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.CSI;
import org.eclipse.ocl.xtext.basecs.ConstraintCS;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;

public class CSI2ASMapping
implements ICSI2ASMapping {
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull Map<BaseCSResource, ASResource> cs2asResourceMap = new HashMap<BaseCSResource, ASResource>();
    protected final @NonNull Map<BaseCSResource, CS2AS> cs2as2as = new HashMap<BaseCSResource, CS2AS>();
    private Map<CSI, Element> csi2as = new HashMap<CSI, Element>();
    private Map<Element, ModelElementCS> as2cs = null;
    private @Nullable HashedCSIs hashedCSIs = null;

    public static @Nullable CSI2ASMapping basicGetCSI2ASMapping(@NonNull EnvironmentFactoryInternal environmentFactory) {
        return (CSI2ASMapping)environmentFactory.getCSI2ASMapping();
    }

    public static @NonNull CSI2ASMapping getCSI2ASMapping(@NonNull EnvironmentFactoryInternal environmentFactory) {
        ICSI2ASMapping csi2asMapping = environmentFactory.getCSI2ASMapping();
        if (csi2asMapping == null) {
            csi2asMapping = new CSI2ASMapping(environmentFactory);
            environmentFactory.setCSI2ASMapping(csi2asMapping);
        }
        return (CSI2ASMapping)csi2asMapping;
    }

    private CSI2ASMapping(@NonNull EnvironmentFactoryInternal environmentFactory) {
        this.environmentFactory = environmentFactory;
    }

    public void add(Map<? extends BaseCSResource, ? extends ASResource> cs2asResourceMap) {
        this.as2cs = null;
        this.cs2asResourceMap.putAll(cs2asResourceMap);
    }

    public void add(@NonNull BaseCSResource csResource, @NonNull CS2AS cs2as) {
        this.as2cs = null;
        this.cs2asResourceMap.put(csResource, cs2as.getASResource());
        this.cs2as2as.put(csResource, cs2as);
    }

    public Set<CSI> computeCSIs(@NonNull BaseCSResource csResource) {
        HashSet<CSI> map = new HashSet<CSI>();
        TreeIterator it = csResource.getAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof ModelElementCS)) continue;
            ModelElementCS csElement = (ModelElementCS)eObject;
            AbstractCSI csURI = this.getCSI(csElement);
            map.add(csURI);
        }
        return map;
    }

    protected @NonNull Map<Element, ModelElementCS> computeAS2CSMap() {
        HashMap<Element, ModelElementCS> map = new HashMap<Element, ModelElementCS>();
        for (Resource resource : this.cs2asResourceMap.keySet()) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                ModelElementCS csElement;
                Element pivotElement;
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof ModelElementCS) || (pivotElement = (csElement = (ModelElementCS)eObject).getPivot()) == null) continue;
                map.put(pivotElement, csElement);
            }
        }
        return map;
    }

    public void dispose() {
        for (BaseCSResource csResource : new ArrayList<BaseCSResource>(this.cs2as2as.keySet())) {
            csResource.dispose();
        }
        this.csi2as.clear();
        this.as2cs = null;
    }

    public @Nullable Element get(@NonNull ModelElementCS csElement) {
        AbstractCSI csi = this.getCSI(csElement);
        return this.csi2as.get(csi);
    }

    public @Nullable ASResource getASResource(@Nullable BaseCSResource csResource) {
        return this.cs2asResourceMap.get(csResource);
    }

    public @Nullable CS2AS getCS2AS(@NonNull BaseCSResource csResource) {
        return this.cs2as2as.get(csResource);
    }

    private @NonNull AbstractCSI getCSI(@NonNull ElementCS csElement) {
        CSI csi = csElement.getCsi();
        if (csi == null) {
            EObject eContainer;
            HashedCSIs hashedCSIs2 = this.hashedCSIs;
            if (hashedCSIs2 == null) {
                int size = 1024;
                Resource eResource = csElement.eResource();
                if (eResource != null) {
                    int count = 0;
                    TreeIterator tit = eResource.getAllContents();
                    while (tit.hasNext()) {
                        ++count;
                        tit.next();
                    }
                    size = 4 * count;
                }
                this.hashedCSIs = hashedCSIs2 = new HashedCSIs(size);
            }
            csi = (eContainer = csElement.eContainer()) == null ? hashedCSIs2.getRootCSI(csElement) : hashedCSIs2.getChildCSI(csElement);
            csElement.setCsi(csi);
        }
        return (AbstractCSI)csi;
    }

    public @NonNull Set<BaseCSResource> getCSResources() {
        return this.cs2asResourceMap.keySet();
    }

    public @Nullable ModelElementCS getCSElement(@NonNull Element pivotElement) {
        EObject eObject;
        ModelElementCS modelElementCS;
        if (this.as2cs == null) {
            this.as2cs = this.computeAS2CSMap();
        }
        if ((modelElementCS = this.as2cs.get(pivotElement)) == null && pivotElement instanceof ExpressionInOCL && (eObject = ((ExpressionInOCL)pivotElement).eContainer()) instanceof Element && (modelElementCS = this.as2cs.get(eObject)) instanceof ConstraintCS) {
            modelElementCS = ((ConstraintCS)modelElementCS).getOwnedSpecification();
        }
        return modelElementCS;
    }

    public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public Map<CSI, Element> getMapping() {
        return this.csi2as;
    }

    public void put(@NonNull ModelElementCS csElement, @Nullable Element pivotElement) {
        AbstractCSI csi = this.getCSI(csElement);
        this.csi2as.put(csi, pivotElement);
    }

    public void removeCSResource(@NonNull BaseCSResource csResource) {
        this.as2cs = null;
        this.cs2asResourceMap.remove(csResource);
        this.cs2as2as.remove(csResource);
    }

    public void update() {
        this.as2cs = null;
        this.csi2as.clear();
        for (Resource resource : this.cs2asResourceMap.keySet()) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof ModelElementCS)) continue;
                ModelElementCS csElement = (ModelElementCS)eObject;
                Element pivotElement = csElement.getPivot();
                this.put(csElement, pivotElement);
            }
        }
    }

    private static abstract class AbstractCSI
    implements CSI {
        protected final int hashCode;

        protected AbstractCSI(int hashCode) {
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public @Nullable AbstractCSI isCSIfor(@Nullable CSI thatParent, @Nullable EReference thatChild, @Nullable String thatName, int thatIndex) {
            return null;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            this.toString(s);
            return s.toString();
        }

        protected abstract void toString(@NonNull StringBuilder var1);
    }

    private class HashedCSIs {
        private int hashMask;
        private Object[] hash2csis;

        public HashedCSIs(int hashSize) {
            int mask = 1;
            while (mask < hashSize && mask < 65535) {
                mask = mask + mask + 1;
            }
            this.hashMask = mask;
            this.hash2csis = new Object[this.hashMask + 1];
        }

        private void add(@NonNull AbstractCSI csi) {
            WeakReference<AbstractCSI> csiRef = new WeakReference<AbstractCSI>(csi);
            int hashCode = csi.hashCode();
            int hashIndex = hashCode & this.hashMask;
            Object entry = this.hash2csis[hashIndex];
            if (entry == null) {
                this.hash2csis[hashIndex] = csiRef;
            } else if (entry instanceof WeakReference) {
                ArrayList<WeakReference<AbstractCSI>> csiList;
                this.hash2csis[hashIndex] = csiList = new ArrayList<WeakReference<AbstractCSI>>();
                WeakReference castEntry = (WeakReference)entry;
                csiList.add(castEntry);
                csiList.add(csiRef);
            } else {
                List csiList = (List)entry;
                csiList.add(csiRef);
            }
        }

        private @Nullable AbstractCSI find(int hashCode, @Nullable AbstractCSI thisParent, @Nullable EReference thisChild, @Nullable String thisName, int thisIndex) {
            AbstractCSI childCSI;
            WeakReference thatRef;
            AbstractCSI thatCSI;
            int hashIndex = hashCode & this.hashMask;
            Object entry = this.hash2csis[hashIndex];
            if (entry instanceof List) {
                List csiList = (List)entry;
                for (WeakReference thatRef2 : csiList) {
                    AbstractCSI childCSI2;
                    AbstractCSI thatCSI2 = (AbstractCSI)thatRef2.get();
                    if (thatCSI2 == null || (childCSI2 = thatCSI2.isCSIfor(thisParent, thisChild, thisName, thisIndex)) == null) continue;
                    return childCSI2;
                }
            } else if (entry instanceof WeakReference && (thatCSI = (AbstractCSI)(thatRef = (WeakReference)entry).get()) != null && (childCSI = thatCSI.isCSIfor(thisParent, thisChild, thisName, thisIndex)) != null) {
                return childCSI;
            }
            return null;
        }

        protected @NonNull RootCSI getRootCSI(@NonNull ElementCS csElement) {
            assert (csElement.getCsi() == null);
            assert (csElement.eContainer() == null);
            Resource eResource = (Resource)ClassUtil.nonNullState((Object)csElement.eResource());
            String uri = eResource.getURI().toString();
            int index = eResource.getContents().indexOf((Object)csElement);
            int hashCode = 3 * uri.hashCode() + 53 * index;
            AbstractCSI csi = this.find(hashCode, null, null, uri, index);
            if (csi == null) {
                csi = new RootCSI(hashCode, uri, index);
            }
            this.add(csi);
            return (RootCSI)csi;
        }

        protected @NonNull CSI getChildCSI(@NonNull ElementCS csElement) {
            AbstractCSI csi;
            EReference eContainmentFeature;
            assert (csElement.getCsi() == null);
            EObject eContainer = csElement.eContainer();
            assert (eContainer instanceof ElementCS);
            AbstractCSI thisParent = CSI2ASMapping.this.getCSI((ElementCS)eContainer);
            int parentHashCode = thisParent.hashCode();
            EReference thisChild = eContainmentFeature = (EReference)ClassUtil.nonNullState((Object)csElement.eContainmentFeature());
            int childHashCode = eContainmentFeature.hashCode();
            String thisName = null;
            if (csElement instanceof Nameable) {
                thisName = ((Nameable)csElement).getName();
            }
            if (eContainmentFeature.isMany()) {
                int thisIndex;
                List siblings = (List)eContainer.eGet((EStructuralFeature)eContainmentFeature);
                if (thisName == null) {
                    thisIndex = siblings.indexOf(csElement);
                } else {
                    int count = 0;
                    for (Object sibling : siblings) {
                        String thatName;
                        if (sibling == csElement) break;
                        if (!(sibling instanceof Nameable) || !ClassUtil.safeEquals((Object)thisName, (Object)(thatName = ((Nameable)sibling).getName()))) continue;
                        ++count;
                    }
                    thisIndex = count;
                }
                int nameHashCode = thisName != null ? thisName.hashCode() : 0;
                int hashCode = 3 * parentHashCode + 7 * childHashCode + nameHashCode + thisIndex;
                csi = this.find(hashCode, thisParent, thisChild, thisName, thisIndex);
                if (csi == null) {
                    csi = new MultipleChildCSI(hashCode, thisParent, thisChild, thisName, thisIndex);
                }
            } else {
                int hashCode = 3 * parentHashCode + 7 * childHashCode;
                csi = this.find(hashCode, thisParent, thisChild, null, 0);
                if (csi == null) {
                    csi = new SingleChildCSI(hashCode, thisParent, thisChild);
                }
            }
            this.add(csi);
            return csi;
        }
    }

    private static class MultipleChildCSI
    extends SingleChildCSI {
        protected final @Nullable String name;
        protected final int index;

        private MultipleChildCSI(int hashCode, @NonNull AbstractCSI parent, @NonNull EReference child, @Nullable String name, int index) {
            super(hashCode, parent, child);
            this.name = name;
            this.index = index;
        }

        @Override
        public @Nullable MultipleChildCSI isCSIfor(@Nullable CSI thatParent, @Nullable EReference thatChild, @Nullable String thatName, int thatIndex) {
            if (super.isCSIfor(thatParent, thatChild, thatName, thatIndex) == null) {
                return null;
            }
            if (this.index != thatIndex) {
                return null;
            }
            return ClassUtil.safeEquals((Object)this.name, (Object)thatName) ? this : null;
        }

        @Override
        protected void toString(@NonNull StringBuilder s) {
            super.toString(s);
            if (this.name != null) {
                s.append("@");
                s.append(this.name);
            }
            s.append("@");
            s.append(this.index);
        }
    }

    private static class RootCSI
    extends AbstractCSI {
        private final @NonNull String name;
        private final int index;

        private RootCSI(int hashCode, @NonNull String name, int index) {
            super(hashCode);
            this.name = name;
            this.index = index;
        }

        @Override
        public @Nullable RootCSI isCSIfor(@Nullable CSI thatParent, @Nullable EReference thatChild, @Nullable String thatName, int thatIndex) {
            if (thatParent != null) {
                return null;
            }
            if (thatChild != null) {
                return null;
            }
            if (this.index != thatIndex) {
                return null;
            }
            return ClassUtil.safeEquals((Object)this.name, (Object)thatName) ? this : null;
        }

        @Override
        protected void toString(@NonNull StringBuilder s) {
            s.append(this.name);
            s.append("@");
            s.append(this.index);
        }
    }

    private static class SingleChildCSI
    extends AbstractCSI {
        protected final @NonNull AbstractCSI parent;
        protected final @NonNull EReference child;

        protected SingleChildCSI(int hashCode, @NonNull AbstractCSI parent, @NonNull EReference child) {
            super(hashCode);
            this.parent = parent;
            this.child = child;
        }

        @Override
        public @Nullable SingleChildCSI isCSIfor(@Nullable CSI thatParent, @Nullable EReference thatChild, @Nullable String thatName, int thatIndex) {
            if (this.parent != thatParent) {
                return null;
            }
            if (this.child != thatChild) {
                return null;
            }
            return this;
        }

        @Override
        protected void toString(@NonNull StringBuilder s) {
            this.parent.toString(s);
            s.append("/");
            s.append(this.child.getName());
        }
    }
}

