/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.labels.Label;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class TracingAdapter
extends AdapterImpl {
    public static final TracingOption NOTIFICATION = new TracingOption("notification");
    private static Map<Integer, String> eventTypes = null;

    public static void debugNotification(Object target, Notification notification) {
        if (NOTIFICATION.isActive() && notification.getEventType() != 8) {
            NOTIFICATION.println(String.valueOf(Label.labelFor(target)) + " <= " + Label.labelFor(notification.getNotifier()) + "\n    " + TracingAdapter.getEventType(notification.getEventType()) + " " + TracingAdapter.getFeatureType(notification) + " " + Label.labelFor(notification.getOldValue()) + " => " + Label.labelFor(notification.getNewValue()));
        }
    }

    public static @NonNull String getEventType(int eventType) {
        String eventString;
        if (eventTypes == null) {
            NotificationImpl notification = new NotificationImpl(0, 0, 0);
            eventTypes = new HashMap<Integer, String>();
            Field[] fieldArray = Notification.class.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                try {
                    int value = field.getInt(notification);
                    eventTypes.put(value, field.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        if ((eventString = eventTypes.get(eventType)) == null) {
            return "eventType[" + eventType + "]";
        }
        return eventString;
    }

    private static String getFeatureType(@NonNull Notification notification) {
        Object feature = notification.getFeature();
        if (feature == null) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof ResourceSet) {
                int featureID = notification.getFeatureID(ResourceSet.class);
                switch (featureID) {
                    case 0: {
                        return "ResourceSet.resources";
                    }
                }
                return "ResourceSet.featureID[" + featureID + "]";
            }
            if (notifier instanceof Resource) {
                int featureID = notification.getFeatureID(Resource.class);
                switch (featureID) {
                    case 2: {
                        return "Resource.contents";
                    }
                    case 6: {
                        return "Resource.errors";
                    }
                    case 4: {
                        return "Resource.isLoaded";
                    }
                    case 3: {
                        return "Resource.isModified";
                    }
                    case 5: {
                        return "Resource.isTrackingModification";
                    }
                    case 0: {
                        return "Resource.resourceSet";
                    }
                    case 1: {
                        return "Resource.uri";
                    }
                    case 7: {
                        return "Resource.warnings";
                    }
                }
                return "Resource.featureID[" + featureID + "]";
            }
            feature = notification.getFeature();
            int featureID = notification.getFeatureID(null);
            return "<null-" + notifier.getClass().getName() + "-Feature>";
        }
        if (!(feature instanceof EStructuralFeature)) {
            return "<" + feature.getClass().getName() + "-Feature>";
        }
        return String.valueOf(((EStructuralFeature)feature).getEContainingClass().getName()) + "." + ((EStructuralFeature)feature).getName();
    }

    protected void handleNotification(Notification notification) {
    }

    public final void notifyChanged(Notification notification) {
        TracingAdapter.debugNotification(this.target, notification);
        this.handleNotification(notification);
    }
}

