/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.debug.adaptor.dynamic;

import com.sun.jdi.VirtualMachine;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdi.internal.ReferenceTypeImpl;
import org.eclipse.jdi.internal.ValueCache;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.jdwp.JdwpReferenceTypeID;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpointListener;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.objectteams.otdt.core.ext.WeavingScheme;
import org.eclipse.objectteams.otdt.debug.internal.breakpoints.OTBreakpoints;
import org.eclipse.objectteams.otdt.internal.debug.adaptor.OTDebugAdaptorPlugin;
import org.objectteams.DoublyWeakHashMap;
import org.objectteams.IBoundBase2;
import org.objectteams.ITeam;
import org.objectteams.RoleCastException;
import org.objectteams.Team;
import org.objectteams.WrongRoleException;

/*
 * Class file marked as module, but has methods! Treated as a class file
 * Class file marked as module, but no module attribute!
 */
public class RedefineClassesBPListener
extends Team
implements IJavaBreakpointListener {
    private /* synthetic */ boolean _OT$cacheInitTrigger;
    public transient /* synthetic */ DoublyWeakHashMap<VirtualMachineImpl, VM> _OT$cache_OT$VM;

    public RedefineClassesBPListener() {
        this._OT$cacheInitTrigger = this._OT$initCaches();
    }

    public static IJavaBreakpointListener get(WeavingScheme scheme) {
        if (scheme == WeavingScheme.OTDRE) {
            return new RedefineClassesBPListener();
        }
        return null;
    }

    public int breakpointHit(IJavaThread thread, IJavaBreakpoint breakpoint) {
        if (!breakpoint.getMarker().exists()) {
            return 4;
        }
        try {
            if (OTBreakpoints.Descriptor.RedefineClasses.matches((IBreakpoint)breakpoint)) {
                this.handleClassRedefinition(thread);
                return 2;
            }
        }
        catch (Exception ex) {
            OTDebugAdaptorPlugin.logException("RedefineClassesBPListener can't read infos from debugTarget anymore. Disconnected?", ex);
            return 2;
        }
        return 4;
    }

    private void handleClassRedefinition(IJavaThread thread) throws DebugException {
        IValue value;
        IStackFrame frame = thread.getTopStackFrame();
        IVariable[] variables = frame.getVariables();
        if (variables.length > 1 && (value = variables[1].getValue()) instanceof IJavaObject) {
            String className = value.getValueString();
            VirtualMachine vm = ((JDIDebugTarget)thread.getDebugTarget()).getVM();
            this.removeTypeFromCache((VirtualMachineImpl)vm, className);
            this.updateBreakpoints(thread.getDebugTarget(), className);
        }
    }

    private void removeTypeFromCache(VirtualMachineImpl _OT$vm, String typeName) {
        VM vm = this._OT$liftTo$VM(_OT$vm);
        vm.removeTypeFromCache(typeName);
    }

    private void updateBreakpoints(IDebugTarget debugTarget, String className) {
        IBreakpoint[] breakpoints;
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IJavaLineBreakpoint) {
                IJavaLineBreakpoint lineBreakpoint = (IJavaLineBreakpoint)breakpoint;
                try {
                    if (lineBreakpoint.getTypeName().equals(className)) {
                        debugTarget.breakpointRemoved((IBreakpoint)lineBreakpoint, null);
                        debugTarget.breakpointAdded((IBreakpoint)lineBreakpoint);
                    }
                }
                catch (CoreException e) {
                    OTDebugAdaptorPlugin.logException("Failed to update breakpoint", (Exception)((Object)e));
                }
            }
            ++n2;
        }
    }

    public int installingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint, IJavaType type) {
        return 4;
    }

    public void addingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointInstalled(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointHasRuntimeException(IJavaLineBreakpoint breakpoint, DebugException exception) {
    }

    public void breakpointHasCompilationErrors(IJavaLineBreakpoint breakpoint, Message[] errors) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VM _OT$liftTo$VM(VirtualMachineImpl base) {
        DoublyWeakHashMap<VirtualMachineImpl, VM> doublyWeakHashMap = this._OT$cache_OT$VM;
        synchronized (doublyWeakHashMap) {
            VM myRole;
            block8: {
                myRole = null;
                if (base != null) break block8;
                return null;
            }
            if (!this._OT$cache_OT$VM.containsKey((Object)base)) {
                myRole = new __OT__VM(base);
            } else {
                VM role = (VM)this._OT$cache_OT$VM.get((Object)base);
                try {
                    myRole = role;
                }
                catch (ClassCastException classCastException) {
                    throw new WrongRoleException(__OT__VM.class, (Object)base, (Object)role);
                }
            }
            return myRole;
        }
    }

    private boolean _OT$initCaches() {
        if (this._OT$cache_OT$VM == null) {
            this._OT$cache_OT$VM = new DoublyWeakHashMap();
        }
        return true;
    }

    protected void restore() {
        super.restore();
        this._OT$initCaches();
    }

    protected void restoreRole(Class<?> clazz, Object role) {
        if (VM.class.isAssignableFrom(clazz)) {
            VM castedRole = (VM)role;
            VirtualMachineImpl base = castedRole._OT$getBase();
            this._OT$cache_OT$VM.put((Object)base, (Object)castedRole);
            base._OT$addOrRemoveRole((Object)castedRole, true);
            return;
        }
        super.restoreRole(clazz, role);
    }

    public boolean hasRole(Object _OT$base_arg) {
        return this._OT$cache_OT$VM.containsKey(_OT$base_arg);
    }

    public Object getRole(Object _OT$base_arg) {
        Object first_result = null;
        String first_name = null;
        if (this._OT$cache_OT$VM.containsKey(_OT$base_arg)) {
            first_result = (VM)this._OT$cache_OT$VM.get(_OT$base_arg);
            first_name = "_OT$cache_OT$VM";
        }
        return first_result;
    }

    public Object[] getAllRoles() {
        ArrayList first_result = new ArrayList();
        first_result.addAll(this._OT$cache_OT$VM.values());
        return first_result.toArray();
    }

    public void unregisterRole(Object _OT$role_arg) {
        String first_name = null;
        DoublyWeakHashMap<VirtualMachineImpl, VM> first_cache = null;
        VirtualMachineImpl found_base = null;
        if (_OT$role_arg instanceof VM && ((VM)_OT$role_arg)._OT$getTeam() == this && this._OT$cache_OT$VM.containsKey((Object)(found_base = ((VM)_OT$role_arg)._OT$getBase()))) {
            first_cache = this._OT$cache_OT$VM;
            first_name = "_OT$cache_OT$VM";
        }
        if (first_cache != null && found_base != null) {
            first_cache.remove((Object)found_base);
            ((IBoundBase2)found_base)._OT$addOrRemoveRole(_OT$role_arg, false);
        }
    }

    public boolean hasRole(Object _OT$base_arg, Class class_arg) {
        if (class_arg == VM.class) {
            if (class_arg.getName().endsWith("__OT__VM")) {
                return this._OT$cache_OT$VM.containsKey(_OT$base_arg);
            }
            return class_arg.isInstance(this._OT$cache_OT$VM.get(_OT$base_arg));
        }
        throw new IllegalArgumentException("No such bound role type in this team: " + class_arg.getName());
    }

    public <T> T getRole(Object _OT$base_arg, Class<T> class_arg) {
        if (class_arg == VM.class) {
            return (T)this._OT$cache_OT$VM.get(_OT$base_arg);
        }
        throw new IllegalArgumentException("No such bound role type in this team: " + class_arg.getName());
    }

    public void unregisterRole(Object _OT$role_arg, Class class_arg) {
        if (class_arg == VM.class) {
            VirtualMachineImpl base_obj = ((VM)_OT$role_arg)._OT$getBase();
            this._OT$cache_OT$VM.remove((Object)base_obj);
            base_obj._OT$addOrRemoveRole(_OT$role_arg, false);
            return;
        }
        throw new IllegalArgumentException("No such bound role type in this team: " + class_arg.getName());
    }

    public <T> T[] getAllRoles(Class<T> class_arg) {
        Collection values = null;
        if (class_arg == VM.class) {
            values = this._OT$cache_OT$VM.values();
        }
        if (values == null) {
            throw new IllegalArgumentException("No such bound role type in this team: " + class_arg.getName());
        }
        ArrayList result = new ArrayList(values.size());
        for (Object o : values) {
            if (!class_arg.isInstance(o)) continue;
            result.add(o);
        }
        return result.toArray((Object[])Array.newInstance(class_arg, result.size()));
    }

    protected VM _OT$castTo$VM(Object _OT$arg) {
        if (_OT$arg == null) {
            return null;
        }
        VM role = (VM)_OT$arg;
        if (role._OT$getTeam() != this) {
            throw new RoleCastException();
        }
        return role;
    }

    protected VM _OT$create$VM(VirtualMachineImpl base) {
        return new __OT__VM(base);
    }

    protected Team.Confined _OT$castTo$Confined(Object _OT$arg) {
        if (_OT$arg == null) {
            return null;
        }
        Confined role = (Confined)_OT$arg;
        if (role._OT$getTeam() != this) {
            throw new RoleCastException();
        }
        return role;
    }

    public Team.IConfined _OT$castTo$IConfined(Object _OT$arg) {
        if (_OT$arg == null) {
            return null;
        }
        IConfined role = (IConfined)_OT$arg;
        if (role._OT$getTeam() != this) {
            throw new RoleCastException();
        }
        return role;
    }

    public Class<IConfined> _OT$getClass$IConfined() {
        return IConfined.class;
    }

    public Team.ILowerable _OT$castTo$ILowerable(Object _OT$arg) {
        if (_OT$arg == null) {
            return null;
        }
        ILowerable role = (ILowerable)_OT$arg;
        if (role._OT$getTeam() != this) {
            throw new RoleCastException();
        }
        return role;
    }

    public Class<ILowerable> _OT$getClass$ILowerable() {
        return ILowerable.class;
    }

    protected Team.Confined _OT$create$Confined() {
        return new __OT__Confined(this);
    }

    public /* synthetic */ ValueCache _OT$VM$private$getCachedReftypes(VM vM) {
        return __OT__VM._OT$VM$private$getCachedReftypes(vM);
    }

    protected static interface Confined
    extends Team.Confined {
        public ITeam _OT$getTeam();
    }

    public static interface IConfined
    extends Team.IConfined {
    }

    public static interface ILowerable
    extends Team.ILowerable {
        public Object _OT$getBase();
    }

    protected static interface TSuper__OT__Team {
    }

    protected static interface VM {
        public void removeTypeFromCache(String var1);

        public VirtualMachineImpl _OT$getBase();

        public ITeam _OT$getTeam();
    }

    protected class __OT__Confined
    extends Team.__OT__Confined
    implements Confined {
        public final /* synthetic */ RedefineClassesBPListener this$0;

        protected __OT__Confined(RedefineClassesBPListener redefineClassesBPListener) {
            super((Team)redefineClassesBPListener);
        }

        @Override
        public ITeam _OT$getTeam() {
            return this.this$0;
        }
    }

    protected class __OT__VM
    implements VM {
        public final /* synthetic */ VirtualMachineImpl _OT$base;

        @Override
        public void removeTypeFromCache(String typeName) {
            ArrayList<JdwpReferenceTypeID> found = new ArrayList<JdwpReferenceTypeID>();
            ValueCache cache = this.getCachedReftypes();
            for (Object value : cache.values()) {
                ReferenceTypeImpl refType;
                if (!(value instanceof ReferenceTypeImpl) || !(refType = (ReferenceTypeImpl)value).name().equals(typeName)) continue;
                found.add(refType.getRefTypeID());
            }
            for (JdwpReferenceTypeID id : found) {
                cache.remove((Object)id);
            }
        }

        private void _OT$InitFields() {
        }

        @Override
        public VirtualMachineImpl _OT$getBase() {
            return this._OT$base;
        }

        public __OT__VM(VirtualMachineImpl base) {
            this._OT$base = base;
            RedefineClassesBPListener.this._OT$cache_OT$VM.put((Object)this._OT$base, (Object)this);
            this._OT$base._OT$addOrRemoveRole((Object)this, true);
            this._OT$InitFields();
        }

        @Override
        public ITeam _OT$getTeam() {
            return RedefineClassesBPListener.this;
        }

        private ValueCache getCachedReftypes() {
            return (ValueCache)this._OT$base._OT$access(0, 0, new Object[0], (ITeam)RedefineClassesBPListener.this);
        }

        public static /* synthetic */ ValueCache _OT$VM$private$getCachedReftypes(VM vM) {
            return ((__OT__VM)vM).getCachedReftypes();
        }
    }
}

