/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.http.internal.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.http.common.IHTTPConnector;
import org.eclipse.net4j.http.internal.common.HTTPChannel;
import org.eclipse.net4j.http.internal.common.bundle.OM;
import org.eclipse.net4j.http.internal.common.messages.Messages;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.spi.net4j.Connector;
import org.eclipse.spi.net4j.InternalChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPConnector
extends Connector
implements IHTTPConnector {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HTTPConnector.class);
    private static final byte OPERATION_NONE = 0;
    private static final byte OPERATION_OPEN = 1;
    private static final byte OPERATION_OPEN_ACK = 2;
    private static final byte OPERATION_CLOSE = 3;
    private static final byte OPERATION_BUFFER = 4;
    private String connectorID;
    private transient Queue<ChannelOperation> outputOperations = new ConcurrentLinkedQueue<ChannelOperation>();
    private transient long lastTraffic;
    public static final int OPCODE_CONNECT = 1;
    public static final int OPCODE_DISCONNECT = 2;
    public static final int OPCODE_OPERATIONS = 3;

    public HTTPConnector() {
        this.markLastTraffic();
    }

    @Override
    public String getConnectorID() {
        return this.connectorID;
    }

    public void setConnectorID(String connectorID) {
        this.connectorID = connectorID;
    }

    public Queue<ChannelOperation> getOutputQueue() {
        return this.outputOperations;
    }

    public long getLastTraffic() {
        return this.lastTraffic;
    }

    private void markLastTraffic() {
        this.lastTraffic = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplexChannel(InternalChannel channel) {
        long outputOperationCount;
        IBuffer buffer;
        HTTPChannel httpChannel;
        HTTPChannel hTTPChannel = httpChannel = (HTTPChannel)channel;
        synchronized (hTTPChannel) {
            Queue channelQueue = httpChannel.getSendQueue();
            buffer = (IBuffer)channelQueue.poll();
            outputOperationCount = httpChannel.getOutputOperationCount();
            httpChannel.increaseOutputOperationCount();
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Multiplexing {0} (count={1})", new Object[]{buffer.formatContent(true), outputOperationCount});
        }
        this.outputOperations.add(new BufferChannelOperation(httpChannel.getID(), outputOperationCount, buffer));
        if (buffer.isCCAM()) {
            httpChannel.close();
        }
    }

    public boolean writeOutputOperations(ExtendedDataOutputStream out) throws IOException {
        do {
            ChannelOperation operation;
            if ((operation = this.outputOperations.poll()) == null && this.pollAgain()) {
                operation = this.outputOperations.poll();
            }
            if (operation == null) break;
            operation.write(out);
            this.markLastTraffic();
        } while (this.writeMoreOperations());
        out.writeByte(0);
        return !this.outputOperations.isEmpty();
    }

    public void readInputOperations(ExtendedDataInputStream in) throws IOException {
        while (true) {
            ChannelOperation operation;
            byte code = in.readByte();
            switch (code) {
                case 1: {
                    operation = new OpenChannelOperation(in);
                    break;
                }
                case 2: {
                    operation = new OpenAckChannelOperation(in);
                    break;
                }
                case 3: {
                    operation = new CloseChannelOperation(in);
                    break;
                }
                case 4: {
                    operation = new BufferChannelOperation(in);
                    break;
                }
                case 0: {
                    return;
                }
                default: {
                    throw new IOException("Invalid operation code: " + code);
                }
            }
            this.markLastTraffic();
            operation.execute();
        }
    }

    protected INegotiationContext createNegotiationContext() {
        throw new UnsupportedOperationException();
    }

    protected InternalChannel createChannel() {
        return new HTTPChannel();
    }

    protected void registerChannelWithPeer(short channelID, long timeout, IProtocol<?> protocol) throws ChannelException {
        String protocolID = Net4jUtil.getProtocolID(protocol);
        int protocolVersion = Net4jUtil.getProtocolVersion(protocol);
        OpenChannelOperation operation = new OpenChannelOperation(channelID, protocolID, protocolVersion);
        this.outputOperations.add(operation);
        HTTPChannel channel = (HTTPChannel)this.getChannel(channelID);
        channel.waitForOpenAck(timeout);
    }

    protected void deregisterChannelFromPeer(InternalChannel channel) throws ChannelException {
        HTTPChannel httpChannel = (HTTPChannel)channel;
        if (!httpChannel.isInverseRemoved()) {
            CloseChannelOperation operation = new CloseChannelOperation(httpChannel);
            this.outputOperations.add(operation);
        }
    }

    protected boolean pollAgain() {
        return false;
    }

    protected boolean writeMoreOperations() {
        return true;
    }

    private final class BufferChannelOperation
    extends ChannelOperation {
        private IBuffer buffer;

        public BufferChannelOperation(short channelID, long operationCount, IBuffer buffer) {
            super(channelID, operationCount);
            this.buffer = buffer;
        }

        public BufferChannelOperation(ExtendedDataInputStream in) throws IOException {
            super(in);
            int length = in.readShort();
            if (TRACER.isEnabled()) {
                TRACER.format("Receiving Buffer operation: operationID={0}, length={1}", new Object[]{this.getOperationCount(), length});
            }
            this.buffer = HTTPConnector.this.getConfig().getBufferProvider().provideBuffer();
            ByteBuffer byteBuffer = this.buffer.startPutting(this.getChannelID());
            int i = 0;
            while (i < length) {
                byte b = in.readByte();
                byteBuffer.put(b);
                ++i;
            }
            this.buffer.flip();
        }

        public void write(ExtendedDataOutputStream out) throws IOException {
            super.write(out);
            this.buffer.flip();
            ByteBuffer byteBuffer = this.buffer.getByteBuffer();
            byteBuffer.position(4);
            int length = byteBuffer.limit() - byteBuffer.position();
            out.writeShort(length);
            if (TRACER.isEnabled()) {
                TRACER.format("Transmitting Buffer operation: operationID={0}, length={1}", new Object[]{this.getOperationCount(), length});
            }
            int i = 0;
            while (i < length) {
                byte b = byteBuffer.get();
                out.writeByte((int)b);
                ++i;
            }
            this.buffer.release();
        }

        public byte getOperation() {
            return 4;
        }

        public void doExecute(HTTPChannel channel) {
            channel.handleBufferFromMultiplexer(this.buffer);
            this.buffer = null;
        }

        public void dispose() {
            if (this.buffer != null) {
                this.buffer.release();
                this.buffer = null;
            }
            super.dispose();
        }
    }

    public abstract class ChannelOperation {
        private short channelID;
        private long operationCount;

        public ChannelOperation(short channelID, long operationCount) {
            this.channelID = channelID;
            this.operationCount = operationCount;
        }

        public ChannelOperation(ExtendedDataInputStream in) throws IOException {
            this.channelID = in.readShort();
            this.operationCount = in.readLong();
        }

        public void write(ExtendedDataOutputStream out) throws IOException {
            out.writeByte((int)this.getOperation());
            out.writeShort((int)this.channelID);
            out.writeLong(this.operationCount);
        }

        public abstract byte getOperation();

        public short getChannelID() {
            return this.channelID;
        }

        public long getOperationCount() {
            return this.operationCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            long operationCount = this.getOperationCount();
            short channelID = this.getChannelID();
            HTTPChannel channel = (HTTPChannel)HTTPConnector.this.getChannel(channelID);
            if (channel == null) {
                OM.LOG.error("Channel " + channelID + " not found");
                return;
            }
            HTTPChannel hTTPChannel = channel;
            synchronized (hTTPChannel) {
                ChannelOperation operation;
                while (operationCount < channel.getInputOperationCount()) {
                    operation = channel.getQuarantinedInputOperation(channel.getInputOperationCount());
                    if (operation == null) break;
                    operation.doExecute(channel);
                    channel.increaseInputOperationCount();
                }
                if (operationCount == channel.getInputOperationCount()) {
                    this.doExecute(channel);
                    channel.increaseInputOperationCount();
                    while ((operation = channel.getQuarantinedInputOperation(++operationCount)) != null) {
                        operation.doExecute(channel);
                        channel.increaseInputOperationCount();
                    }
                } else {
                    channel.quarantineInputOperation(operationCount, this);
                }
            }
        }

        public abstract void doExecute(HTTPChannel var1);

        public void dispose() {
        }
    }

    private final class CloseChannelOperation
    extends ChannelOperation {
        public CloseChannelOperation(HTTPChannel channel) {
            super(channel.getID(), channel.getOutputOperationCount());
            channel.increaseOutputOperationCount();
        }

        public CloseChannelOperation(ExtendedDataInputStream in) throws IOException {
            super(in);
        }

        public byte getOperation() {
            return 3;
        }

        public void doExecute(HTTPChannel channel) {
            channel.setInverseRemoved();
            HTTPConnector.this.inverseCloseChannel(channel.getID());
        }
    }

    private final class OpenAckChannelOperation
    extends ChannelOperation {
        private boolean success;

        public OpenAckChannelOperation(short channelID, boolean success) {
            super(channelID, 0L);
            this.success = success;
        }

        public OpenAckChannelOperation(ExtendedDataInputStream in) throws IOException {
            super(in);
            this.success = in.readBoolean();
        }

        public void write(ExtendedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeBoolean(this.success);
        }

        public byte getOperation() {
            return 2;
        }

        public void doExecute(HTTPChannel channel) {
            channel.openAck();
        }
    }

    private final class OpenChannelOperation
    extends ChannelOperation {
        private String protocolID;
        private int protocolVersion;

        public OpenChannelOperation(short channelID, String protocolID, int protocolVersion) {
            super(channelID, 0L);
            this.protocolID = protocolID;
            this.protocolVersion = protocolVersion;
        }

        public OpenChannelOperation(ExtendedDataInputStream in) throws IOException {
            super(in);
            this.protocolID = in.readString();
            this.protocolVersion = in.readInt();
        }

        public void write(ExtendedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeString(this.protocolID);
            out.writeInt(this.protocolVersion);
        }

        public byte getOperation() {
            return 1;
        }

        public void execute() {
            HTTPChannel channel = (HTTPChannel)HTTPConnector.this.inverseOpenChannel(this.getChannelID(), this.protocolID, this.protocolVersion);
            if (channel == null) {
                throw new ConnectorException(Messages.getString("HTTPConnector.0"));
            }
            channel.increaseInputOperationCount();
            this.doExecute(channel);
        }

        public void doExecute(HTTPChannel channel) {
            OpenAckChannelOperation operation = new OpenAckChannelOperation(this.getChannelID(), true);
            HTTPConnector.this.outputOperations.add(operation);
        }
    }
}

