/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.controls;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.UniSelectTransformationControl;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.Messages;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AbstractDeferredAdapter
implements IDeferredWorkbenchAdapter {
    private volatile IProgressMonitor fetchMonitor;
    private final TreeViewer viewer;

    public AbstractDeferredAdapter(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public abstract Object[] getChildren(Object var1);

    public abstract boolean isAccepted(Object var1, IProgressMonitor var2);

    public abstract UniSelectTransformationControl.ISelectionListener.TreeAction getTreeAction(Object var1, IProgressMonitor var2);

    public void cancel() {
        WorkbenchJob updateJob = new WorkbenchJob(Messages.DeferredAdapter_cancelJob){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                IProgressMonitor monitor = AbstractDeferredAdapter.this.fetchMonitor;
                if (monitor != null) {
                    monitor.setCanceled(true);
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        this.fetchMonitor = monitor;
        Object[] children = this.getChildren(object);
        monitor.beginTask(Messages.DeferredAdapter_loadingContents, children.length);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (monitor.isCanceled()) break;
            if (this.isAccepted(child, monitor)) {
                collector.add(child, monitor);
                this.checkTreeAction(child, monitor);
            }
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
        collector.done();
        this.fetchMonitor = null;
    }

    private void checkTreeAction(final Object object, IProgressMonitor monitor) {
        final UniSelectTransformationControl.ISelectionListener.TreeAction treeAction = this.getTreeAction(object, monitor);
        if (treeAction == UniSelectTransformationControl.ISelectionListener.TreeAction.NONE) {
            return;
        }
        WorkbenchJob updateJob = new WorkbenchJob(Messages.DeferredAdapter_expandNode){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                if (!AbstractDeferredAdapter.this.viewer.getControl().isDisposed()) {
                    if (treeAction == UniSelectTransformationControl.ISelectionListener.TreeAction.EXPAND) {
                        AbstractDeferredAdapter.this.viewer.expandToLevel(object, 1);
                    }
                    if (treeAction == UniSelectTransformationControl.ISelectionListener.TreeAction.SELECT) {
                        AbstractDeferredAdapter.this.viewer.setSelection((ISelection)new StructuredSelection(object), true);
                        AbstractDeferredAdapter.this.viewer.getTree().showSelection();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    public ISchedulingRule getRule(Object arg0) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }
}

