/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.configuration;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpUnitMask;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchPlugin;

public class OprofileCounter {
    private static final String COUNTER_STRING = OprofileLaunchMessages.getString("oprofileCounter.counterString");
    private int number;
    private boolean _enabled;
    private OprofileDaemonEvent[] daemonEvent;
    private OpEvent[] eventList = null;

    public OprofileCounter(int nr) {
        this(nr, Oprofile.getEvents((int)nr));
    }

    public OprofileCounter(int nr, OpEvent[] events) {
        this.number = nr;
        this._enabled = false;
        this.eventList = events;
        this.daemonEvent = new OprofileDaemonEvent[]{new OprofileDaemonEvent()};
    }

    public static OprofileCounter[] getCounters(ILaunchConfiguration config) {
        OprofileCounter[] ctrs = new OprofileCounter[Oprofile.getNumberOfCounters()];
        int i = 0;
        while (i < ctrs.length) {
            ctrs[i] = new OprofileCounter(i);
            if (config != null) {
                ctrs[i].loadConfiguration(config);
            }
            ++i;
        }
        return ctrs;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setEvents(OpEvent[] events) {
        OprofileDaemonEvent[] newDaemonEvent = new OprofileDaemonEvent[events.length];
        int i = 0;
        while (i < events.length) {
            if (i > this.daemonEvent.length - 1) {
                OprofileDaemonEvent de = new OprofileDaemonEvent();
                de.setEvent(events[i]);
                de.setResetCount(this.daemonEvent[0].getResetCount());
                newDaemonEvent[i] = de;
            } else {
                this.daemonEvent[i].setEvent(events[i]);
                newDaemonEvent[i] = this.daemonEvent[i];
            }
            ++i;
        }
        this.daemonEvent = newDaemonEvent;
    }

    public void setProfileKernel(boolean profileKernel) {
        int i = 0;
        while (i < this.daemonEvent.length) {
            this.daemonEvent[i].setProfileKernel(profileKernel);
            ++i;
        }
    }

    public void setProfileUser(boolean profileUser) {
        int i = 0;
        while (i < this.daemonEvent.length) {
            this.daemonEvent[i].setProfileUser(profileUser);
            ++i;
        }
    }

    public void setCount(int count) {
        int i = 0;
        while (i < this.daemonEvent.length) {
            this.daemonEvent[i].setResetCount(count);
            ++i;
        }
    }

    public void saveConfiguration(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(OprofileLaunchPlugin.attrConterEnabled(this.number), this._enabled);
        config.setAttribute(OprofileLaunchPlugin.attrNumberOfEvents(this.number), this.daemonEvent.length);
        int i = 0;
        while (i < this.daemonEvent.length) {
            if (this.daemonEvent[i].getEvent() != null) {
                config.setAttribute(OprofileLaunchPlugin.attrConterEvent(this.number, i), this.daemonEvent[i].getEvent().getText());
                config.setAttribute(OprofileLaunchPlugin.attrCounterUnitMask(this.number), this.daemonEvent[i].getEvent().getUnitMask().getMaskValue());
            }
            config.setAttribute(OprofileLaunchPlugin.attrCounterProfileKernel(this.number), this.daemonEvent[i].getProfileKernel());
            config.setAttribute(OprofileLaunchPlugin.attrCounterProfileUser(this.number), this.daemonEvent[i].getProfileUser());
            config.setAttribute(OprofileLaunchPlugin.attrCounterCount(this.number), this.daemonEvent[i].getResetCount());
            ++i;
        }
    }

    public void loadConfiguration(ILaunchConfiguration config) {
        try {
            this._enabled = config.getAttribute(OprofileLaunchPlugin.attrConterEnabled(this.number), false);
            int numEvents = config.getAttribute(OprofileLaunchPlugin.attrNumberOfEvents(this.number), 1);
            this.daemonEvent = new OprofileDaemonEvent[numEvents];
            int i = 0;
            while (i < numEvents) {
                String str = config.getAttribute(OprofileLaunchPlugin.attrConterEvent(this.number, i), "");
                int maskValue = config.getAttribute(OprofileLaunchPlugin.attrCounterUnitMask(this.number), -1);
                this.daemonEvent[i] = new OprofileDaemonEvent();
                this.daemonEvent[i].setEvent(this.eventFromString(str));
                if (this.daemonEvent[i].getEvent() != null) {
                    this.daemonEvent[i].getEvent().getUnitMask().setMaskValue(maskValue);
                    this.daemonEvent[i].setProfileKernel(config.getAttribute(OprofileLaunchPlugin.attrCounterProfileKernel(this.number), false));
                    this.daemonEvent[i].setProfileUser(config.getAttribute(OprofileLaunchPlugin.attrCounterProfileUser(this.number), false));
                    this.daemonEvent[i].setResetCount(config.getAttribute(OprofileLaunchPlugin.attrCounterCount(this.number), 0));
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public OpUnitMask getUnitMask() {
        OpEvent event = this.daemonEvent[0].getEvent();
        if (event != null) {
            return event.getUnitMask();
        }
        return null;
    }

    public String getText() {
        return MessageFormat.format(COUNTER_STRING, this.number);
    }

    public int getNumber() {
        return this.number;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public OpEvent[] getEvents() {
        ArrayList<OpEvent> res = new ArrayList<OpEvent>();
        OprofileDaemonEvent[] oprofileDaemonEventArray = this.daemonEvent;
        int n = this.daemonEvent.length;
        int n2 = 0;
        while (n2 < n) {
            OprofileDaemonEvent de = oprofileDaemonEventArray[n2];
            res.add(de.getEvent());
            ++n2;
        }
        return res.toArray(new OpEvent[0]);
    }

    public boolean getProfileKernel() {
        return this.daemonEvent[0].getProfileKernel();
    }

    public boolean getProfileUser() {
        return this.daemonEvent[0].getProfileUser();
    }

    public int getCount() {
        return this.daemonEvent[0].getResetCount();
    }

    public OpEvent[] getValidEvents() {
        return this.eventList;
    }

    public OprofileDaemonEvent[] getDaemonEvents() {
        return this.daemonEvent;
    }

    private OpEvent eventFromString(String str) {
        if (this.eventList != null) {
            int i = 0;
            while (i < this.eventList.length) {
                if (this.eventList[i].getText().equals(str)) {
                    return this.eventList[i];
                }
                ++i;
            }
        }
        return null;
    }
}

