/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester;

import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.swt.tester.ButtonTester;
import org.eclipse.jubula.rc.swt.tester.MenuTester;
import org.eclipse.jubula.rc.swt.tester.adapter.ToolItemAdapter;
import org.eclipse.jubula.rc.swt.tester.util.EventListener;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;

public class ToolItemTester
extends ButtonTester {
    private Menu m_menu = null;
    private MenuTester m_menuTester = new MenuTester();
    private MenuAdapter m_menuCloseListener = new MenuAdapter(){

        public void menuHidden(MenuEvent e) {
            if (e.widget instanceof Menu) {
                Menu menu = (Menu)e.widget;
                menu.removeMenuListener((MenuListener)this);
                ToolItemTester.this.m_menu = null;
            }
        }
    };

    ToolItemAdapter getToolItemAdapter() {
        return (ToolItemAdapter)this.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDropdownMenu() {
        block11: {
            final ToolItem item = (ToolItem)this.getComponent().getRealComponent();
            EventLock lock = new EventLock();
            MenuShownCondition cond = new MenuShownCondition();
            final EventListener menuOpenListener = new EventListener(lock, cond);
            int style = (Integer)this.getEventThreadQueuer().invokeAndWait("getStyle", (IRunnable)new IRunnable<Integer>(){

                public Integer run() throws StepExecutionException {
                    return item.getStyle();
                }
            });
            if ((style & 4) == 0) {
                throw new StepExecutionException("Component does not have a dropdown menu.", EventFactory.createActionError((String)"TestErrorEvent.DropdownNotFound"));
            }
            this.getEventThreadQueuer().invokeAndWait("addMenuOpenListener", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    item.getDisplay().addFilter(22, menuOpenListener);
                    return null;
                }
            });
            try {
                try {
                    this.getRobot().click((Object)item, null, ClickOptions.create().left(), 95, false, 50, false);
                    EventLock eventLock = lock;
                    synchronized (eventLock) {
                        long timeout = 10000L;
                        long done = System.currentTimeMillis() + timeout;
                        while (!lock.isReleased() && timeout > 0L) {
                            lock.wait(timeout);
                            long now = System.currentTimeMillis();
                            timeout = done - now;
                        }
                    }
                    if (this.m_menu == null) {
                        throw new StepExecutionException("Dropdown menu did not appear.", EventFactory.createActionError((String)"TestErrorEvent.DropdownNotFound"));
                    }
                    this.m_menuTester.setComponent(this.m_menu);
                    this.m_menuTester.setContextMenu(true);
                }
                catch (InterruptedException interruptedException) {
                    this.getEventThreadQueuer().invokeAndWait("removeMenuOpenListener", (IRunnable)new IRunnable<Void>(item, (Listener)menuOpenListener){
                        private final /* synthetic */ ToolItem val$item;
                        private final /* synthetic */ Listener val$menuOpenListener;
                        {
                            this.val$item = toolItem;
                            this.val$menuOpenListener = listener;
                        }

                        public Void run() throws StepExecutionException {
                            this.val$item.getDisplay().removeFilter(22, this.val$menuOpenListener);
                            return null;
                        }
                    });
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.getEventThreadQueuer().invokeAndWait("removeMenuOpenListener", (IRunnable)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            this.getEventThreadQueuer().invokeAndWait("removeMenuOpenListener", (IRunnable)new /* invalid duplicate definition of identical inner class */);
        }
    }

    public void rcSelectContextMenuItem(String namePath, String operator) {
        this.openDropdownMenu();
        this.m_menuTester.selectMenuItem(namePath, operator);
    }

    public void rcSelectContextMenuItemByIndexpath(String indexPath) {
        this.openDropdownMenu();
        this.m_menuTester.selectMenuItemByIndexpath(indexPath);
    }

    public void rcVerifyContextMenuEnabled(final String namePath, final String operator, final boolean enabled, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyContextMenuEnabled", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                ToolItemTester.this.openDropdownMenu();
                ToolItemTester.this.m_menuTester.verifyEnabled(namePath, operator, enabled, 0);
            }
        });
    }

    public void rcVerifyContextMenuEnabledByIndexpath(final String indexPath, final boolean enabled, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyContextMenuEnabledByIndexpath", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                ToolItemTester.this.openDropdownMenu();
                ToolItemTester.this.m_menuTester.verifyEnabledByIndexpath(indexPath, enabled, 0);
            }
        });
    }

    public void rcVerifyContextMenuExists(final String namePath, final String operator, final boolean exists, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyContextMenuExists", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                ToolItemTester.this.openDropdownMenu();
                ToolItemTester.this.m_menuTester.verifyExists(namePath, operator, exists, 0);
            }
        });
    }

    public void rcVerifyContextMenuExistsByIndexpath(final String indexPath, final boolean exists, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyContextMenuExistsByIndexpath", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                ToolItemTester.this.openDropdownMenu();
                ToolItemTester.this.m_menuTester.verifyExistsByIndexpath(indexPath, exists, 0);
            }
        });
    }

    public void rcVerifyContextMenuSelected(final String namePath, final String operator, final boolean selected, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyContextMenuSelected", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                ToolItemTester.this.openDropdownMenu();
                ToolItemTester.this.m_menuTester.verifySelected(namePath, operator, selected, 0);
            }
        });
    }

    public void rcVerifyContextMenuSelectedByIndexpath(final String indexPath, final boolean selected, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyContextMenuSelectedByIndexpath", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                ToolItemTester.this.openDropdownMenu();
                ToolItemTester.this.m_menuTester.verifySelectedByIndexpath(indexPath, selected, 0);
            }
        });
    }

    private class MenuShownCondition
    implements EventListener.Condition {
        private MenuShownCondition() {
        }

        public boolean isTrue(Event event) {
            if (event.widget instanceof Menu) {
                ToolItemTester.this.m_menu = (Menu)event.widget;
                ToolItemTester.this.m_menu.addMenuListener((MenuListener)ToolItemTester.this.m_menuCloseListener);
                return true;
            }
            return false;
        }
    }
}

