/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableView;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractTreeTableTester;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.tester.util.NodeTraverseHelper;
import org.eclipse.jubula.rc.javafx.tester.util.TreeTableOperationContext;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class TreeTableViewTester
extends AbstractTreeTableTester {
    private static AutServerLogger log = new AutServerLogger(TreeTableViewTester.class);
    private EventHandler<ScrollToEvent> m_scrollConsumer = new EventHandler<ScrollToEvent>(){

        public void handle(ScrollToEvent event) {
            event.consume();
        }
    };

    public void rcDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treeTextPath, String operator) {
        Node tree = (Node)this.getRealComponent();
        tree.addEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
        super.rcDragByTextPath(mouseButton, modifier, pathType, preAscend, treeTextPath, operator);
    }

    public void rcDropByTextPath(String pathType, int preAscend, String treeTextPath, String operator, int delayBeforeDrop) {
        super.rcDropByTextPath(pathType, preAscend, treeTextPath, operator, delayBeforeDrop);
        Node tree = (Node)this.getRealComponent();
        tree.removeEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
    }

    public void rcDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String treeIndexPath) {
        Node tree = (Node)this.getRealComponent();
        tree.addEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
        super.rcDragByIndexPath(mouseButton, modifier, pathType, preAscend, treeIndexPath);
    }

    public void rcDropByIndexPath(String pathType, int preAscend, String treeIndexPath, int delayBeforeDrop) {
        super.rcDropByIndexPath(pathType, preAscend, treeIndexPath, delayBeforeDrop);
        Node tree = (Node)this.getRealComponent();
        tree.removeEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        Point awtPoint = this.getRobot().getCurrentMousePosition();
        final Point2D point = new Point2D((double)awtPoint.x, (double)awtPoint.y);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeAtMousePosition", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((TreeTableView)TreeTableViewTester.this.getRealComponent()).layout();
                List<TreeTableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)TreeTableViewTester.this.getRealComponent(), TreeTableCell.class);
                TreeTableCell resultCell = null;
                for (TreeTableCell cell : tCells) {
                    if (!TreeTableViewTester.this.childCheck(point, resultCell, cell)) continue;
                    resultCell = cell;
                }
                if (resultCell != null) {
                    return resultCell;
                }
                throw new StepExecutionException("No tree node found at mouse position: X: " + point.getX() + "Y: " + point.getY(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
        return result;
    }

    private boolean childCheck(Point2D point, TreeTableCell parent, TreeTableCell child) {
        return NodeBounds.checkIfContains(point, (Node)child) && (parent == null || child.getTreeTableRow().getTreeItem().getParent().equals(parent.getTreeTableRow().getTreeItem()));
    }

    private TreeTableOperationContext getContext() {
        return new TreeTableOperationContext(this.getEventThreadQueuer(), this.getRobot(), (TreeTableView)this.getRealComponent());
    }

    public void rcVerifyEditable(boolean editable, String row, String rowOperator, String col, String colOperator, int timeout) {
        TreeTableOperationContext context = this.getContext();
        if (context.getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.selectCell(row, rowOperator, col, colOperator, ClickOptions.create(), ValueSets.BinaryChoice.no.rcValue());
        this.rcVerifySelectedEditable(editable, timeout);
    }

    public void rcVerifySelectedEditable(final boolean editable, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifySelectedEditable", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                Cell cell = TreeTableViewTester.this.getContext().getSelectedCell();
                Verifier.equals((boolean)editable, (boolean)TreeTableViewTester.this.getContext().isCellEditable(cell.getRow(), cell.getCol()));
            }
        });
    }

    public void rcVerifyEditableAtMousePosition(final boolean editable, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerisfEditableAtMousePosition", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                TreeTableCell cell = (TreeTableCell)TreeTableViewTester.this.getNodeAtMousePosition();
                Verifier.equals((boolean)editable, (boolean)TreeTableViewTester.this.getContext().isCellEditable(cell));
            }
        });
    }

    public void rcVerifyValueInRow(final String row, final String rowOperator, final String value, final String operator, final String searchType, final boolean exists, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyValueInRow", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                TreeTableOperationContext adapter = TreeTableViewTester.this.getContext();
                int implRow = adapter.getRowFromString(row, rowOperator);
                boolean valueIsExisting = false;
                if (implRow == -1) {
                    int i = TreeTableViewTester.this.getStartingColIndex(searchType);
                    while (i < adapter.getColumnCount()) {
                        if (MatchUtil.getInstance().match(adapter.getColumnHeaderText(i), value, operator)) {
                            valueIsExisting = true;
                            break;
                        }
                        ++i;
                    }
                } else {
                    int i = TreeTableViewTester.this.getStartingColIndex(searchType);
                    while (i < adapter.getColumnCount()) {
                        if (MatchUtil.getInstance().match(TreeTableViewTester.this.getCellText(implRow, i), value, operator)) {
                            valueIsExisting = true;
                            break;
                        }
                        ++i;
                    }
                }
                Verifier.equals((boolean)exists, (boolean)valueIsExisting);
            }
        });
    }

    private int getStartingColIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase(ValueSets.SearchType.relative.rcValue())) {
            startingIndex = this.getContext().getSelectedCell().getCol() + 1;
        }
        return startingIndex;
    }

    public void rcVerifyValueInColumn(final String col, final String colOperator, final String value, final String operator, final String searchType, final boolean exists, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyValueInColumn", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                TreeTableOperationContext adapter = TreeTableViewTester.this.getContext();
                int implCol = adapter.getColumnFromString(col, colOperator, true);
                boolean valueExists = TreeTableViewTester.this.isValueExisting(adapter, implCol, value, operator, searchType);
                Verifier.equals((boolean)exists, (boolean)valueExists);
            }
        });
    }

    private boolean isValueExisting(TreeTableOperationContext adapter, int implCol, String value, String operator, String searchType) {
        int rowCount = adapter.getRowCount();
        int i = this.getStartingRowIndex(searchType);
        while (i < rowCount) {
            if (MatchUtil.getInstance().match(this.getCellText(i, implCol), value, operator)) {
                return true;
            }
            ++i;
        }
        if (adapter.isHeaderVisible()) {
            String header = adapter.getColumnHeaderText(implCol);
            if (MatchUtil.getInstance().match(header, value, operator)) {
                return true;
            }
        }
        return false;
    }

    private int getStartingRowIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase(ValueSets.SearchType.relative.rcValue())) {
            startingIndex = this.getContext().getSelectedCell().getRow() + 1;
        }
        return startingIndex;
    }

    public void rcVerifyText(final String text, final String operator, final String row, final String rowOperator, final String col, final String colOperator, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyText", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                String current;
                TreeTableOperationContext adapter;
                int implRow = (adapter = TreeTableViewTester.this.getContext()).getRowFromString(row, rowOperator);
                int implCol = adapter.getColumnFromString(col, colOperator, implRow != -1);
                if (implRow == -1 && implCol > -1) {
                    current = adapter.getColumnHeaderText(implCol);
                } else {
                    TreeTableViewTester.this.checkRowColBounds(implRow, implCol);
                    adapter.scrollCellToVisible(implRow, implCol);
                    current = TreeTableViewTester.this.getCellText(implRow, implCol);
                }
                Verifier.match((String)current, (String)text, (String)operator);
            }
        });
    }

    public void rcVerifyCellTextAtMousePosition(String txt, String operator) {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("rcVerifyCellTextAtMousePosition", new Callable<String>(){

            @Override
            public String call() throws Exception {
                TreeTableCell cell = (TreeTableCell)TreeTableViewTester.this.getNodeAtMousePosition();
                return TreeTableViewTester.this.getContext().getRenderedText(cell);
            }
        });
        Verifier.match((String)result, (String)txt, (String)operator);
    }

    public void rcVerifyCellTextAtMousePosition(final String txt, final String operator, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyCellTextAtMousePosition", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                TreeTableCell cell = (TreeTableCell)TreeTableViewTester.this.getNodeAtMousePosition();
                String result = TreeTableViewTester.this.getContext().getRenderedText(cell);
                Verifier.match((String)result, (String)txt, (String)operator);
            }
        });
    }

    protected void checkRowColBounds(int row, int column) throws StepExecutionException {
        TreeTableOperationContext adapter = this.getContext();
        this.checkBounds(row, adapter.getRowCount());
        this.checkBounds(column, adapter.getColumnCount());
    }

    private void checkBounds(int value, int count) {
        if (value < 0 || value >= count) {
            throw new StepExecutionException("Invalid row/column: " + value, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndexOrHeader"));
        }
    }

    private String getCellText(int row, int column) {
        return this.getContext().getCellText(row, column);
    }

    public String rcReadValue(String variable, String row, String rowOperator, String col, String colOperator) {
        TreeTableOperationContext adapter;
        int implRow = (adapter = this.getContext()).getRowFromString(row, rowOperator);
        int implCol = adapter.getColumnFromString(col, colOperator, implRow != -1);
        if (implRow == -1 && implCol > -1) {
            return adapter.getColumnHeaderText(implCol);
        }
        this.checkRowColBounds(implRow, implCol);
        adapter.scrollCellToVisible(implRow, implCol);
        return this.getCellText(implRow, implCol);
    }

    public String rcReadValue(String row, String rowOperator, String col, String colOperator) {
        return this.rcReadValue(null, row, rowOperator, col, colOperator);
    }

    public String rcReadValueAtMousePosition(String variable) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("rcVerifyCellTextAtMousePosition", new Callable<String>(){

            @Override
            public String call() throws Exception {
                TreeTableCell cell = (TreeTableCell)TreeTableViewTester.this.getNodeAtMousePosition();
                return TreeTableViewTester.this.getContext().getRenderedText(cell);
            }
        });
    }

    public String rcReadValueAtMousePosition() {
        return this.rcReadValueAtMousePosition(null);
    }

    private void selectCell(String row, String rowOperator, String col, String colOperator, ClickOptions co, String extendSelection) {
        this.rcSelectCell(row, rowOperator, col, colOperator, co.getClickCount(), 50, ValueSets.Unit.percent.rcValue(), 50, ValueSets.Unit.percent.rcValue(), extendSelection, co.getMouseButton());
    }

    public void rcSelectCell(String row, String rowOperator, String col, String colOperator, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection, int button) throws StepExecutionException {
        Rectangle cellBounds;
        TreeTableOperationContext adapter;
        int implRow = (adapter = this.getContext()).getRowFromString(row, rowOperator);
        int implCol = adapter.getColumnFromString(col, colOperator, implRow != -1);
        boolean isExtendSelection = extendSelection.equals(ValueSets.BinaryChoice.yes.rcValue());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selecting row, col: " + row + ", " + col));
        }
        Object source = this.getRealComponent();
        if (implRow == -1 && implCol > -1) {
            cellBounds = adapter.getHeaderBounds(implCol);
            source = adapter.getTableHeader();
        } else {
            cellBounds = adapter.scrollCellToVisible(implRow, implCol);
        }
        ClickOptions clickOptions = ClickOptions.create();
        clickOptions.setClickCount(clickCount).setScrollToVisible(false);
        clickOptions.setMouseButton(button);
        try {
            if (isExtendSelection) {
                this.getRobot().keyPress(this.getRealComponent(), this.getExtendSelectionModifier());
            }
            this.getRobot().click(source, (Object)cellBounds, clickOptions, xPos, xUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()), yPos, yUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()));
        }
        finally {
            if (isExtendSelection) {
                this.getRobot().keyRelease(this.getRealComponent(), this.getExtendSelectionModifier());
            }
        }
    }

    protected int getExtendSelectionModifier() {
        return 17;
    }

    public void rcSelectCellByColValue(String row, String rowOperator, String value, String regex, int clickCount, String extendSelection, String searchType, int button) {
        this.selectCellByColValue(row, rowOperator, value, regex, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    protected void selectCellByColValue(String row, String rowOperator, String value, String regex, String extendSelection, String searchType, ClickOptions co) {
        int i;
        TreeTableOperationContext adapter = this.getContext();
        int implRow = adapter.getRowFromString(row, rowOperator);
        int colCount = adapter.getColumnCount();
        Integer implCol = null;
        if (implRow == -1) {
            i = this.getStartingColIndex(searchType);
            while (i < colCount) {
                if (MatchUtil.getInstance().match(adapter.getColumnHeaderText(i), value, regex)) {
                    implCol = new Integer(i);
                    break;
                }
                ++i;
            }
        } else {
            i = this.getStartingColIndex(searchType);
            while (i < colCount) {
                if (MatchUtil.getInstance().match(this.getCellText(implRow, i), value, regex)) {
                    implCol = new Integer(i);
                    break;
                }
                ++i;
            }
        }
        if (implCol == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String usrIdxRowStr = new Integer(IndexConverter.toUserIndex((int)implRow)).toString();
        String usrIdxColStr = new Integer(IndexConverter.toUserIndex((int)implCol)).toString();
        this.selectCell(usrIdxRowStr, rowOperator, usrIdxColStr, MatchUtil.EQUALS, co, extendSelection);
    }

    public void rcSelectRowByValue(String col, String colOperator, String value, String regexOp, int clickCount, String extendSelection, String searchType, int button) {
        this.selectRowByValue(col, colOperator, value, regexOp, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    protected void selectRowByValue(String col, String colOperator, String value, String regexOp, String extendSelection, String searchType, ClickOptions co) {
        TreeTableOperationContext adapter = this.getContext();
        int implCol = adapter.getColumnFromString(col, colOperator, true);
        Integer implRow = null;
        int rowCount = adapter.getRowCount();
        int i = this.getStartingRowIndex(searchType);
        while (i < rowCount) {
            if (MatchUtil.getInstance().match(this.getCellText(i, implCol), value, regexOp)) {
                implRow = new Integer(i);
                break;
            }
            ++i;
        }
        if (implRow == null) {
            String header = adapter.getColumnHeaderText(implCol);
            if (MatchUtil.getInstance().match(header, value, regexOp)) {
                implRow = new Integer(-1);
            }
        }
        if (implRow == null) {
            throw new StepExecutionException("no such row found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String userIdxRow = new Integer(IndexConverter.toUserIndex((int)implRow)).toString();
        String userIdxCol = new Integer(IndexConverter.toUserIndex((int)implCol)).toString();
        this.selectCell(userIdxRow, MatchUtil.EQUALS, userIdxCol, colOperator, co, extendSelection);
    }

    public void rcMove(String direction, int cellCount, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection) throws StepExecutionException {
        if (this.mouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell currCell = null;
        try {
            TreeTableCell cell = (TreeTableCell)this.getNodeAtMousePosition();
            currCell = new Cell(this.getRowFromCell(cell), this.getColumnFromCell(cell));
        }
        catch (StepExecutionException stepExecutionException) {
            currCell = this.getContext().getSelectedCell();
        }
        int newCol = currCell.getCol();
        int newRow = currCell.getRow();
        if (ValueSets.Direction.up.rcValue().equalsIgnoreCase(direction)) {
            newRow -= cellCount;
        } else if (ValueSets.Direction.down.rcValue().equalsIgnoreCase(direction)) {
            newRow += cellCount;
        } else if (ValueSets.Direction.left.rcValue().equalsIgnoreCase(direction)) {
            newCol -= cellCount;
        } else if (ValueSets.Direction.right.rcValue().equalsIgnoreCase(direction)) {
            newCol += cellCount;
        }
        newRow = IndexConverter.toUserIndex((int)newRow);
        newCol = IndexConverter.toUserIndex((int)newCol);
        String row = Integer.toString(newRow);
        String col = Integer.toString(newCol);
        this.rcSelectCell(row, MatchUtil.DEFAULT_OPERATOR, col, MatchUtil.DEFAULT_OPERATOR, clickCount, xPos, xUnits, yPos, yUnits, extendSelection, ValueSets.InteractionMode.primary.rcIntValue());
    }

    public void rcCheckExistenceOfColumn(final String column, final String columnOperator, final boolean exists, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcCheckExistenceOfColumn", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                Rectangle bounds;
                int index;
                block3: {
                    index = -2;
                    try {
                        index = TreeTableViewTester.this.getContext().getColumnFromString(column, columnOperator, true);
                    }
                    catch (StepExecutionException see) {
                        if (!exists) break block3;
                        throw see;
                    }
                }
                if (index >= 0 && (bounds = TreeTableViewTester.this.getContext().getHeaderBounds(index)).getWidth() <= 0.0) {
                    index = -2;
                }
                Verifier.equals((boolean)exists, (index >= 0 ? 1 : 0) != 0);
            }
        });
    }

    private int getRowFromCell(final TreeTableCell<?, ?> cell) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("get row", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return cell.getTreeTableRow().getIndex();
            }
        });
    }

    private int getColumnFromCell(final TreeTableCell<?, ?> cell) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("get row", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((TreeTableView)TreeTableViewTester.this.getRealComponent()).getVisibleLeafColumns().indexOf((Object)cell.getTableColumn());
            }
        });
    }

    private boolean mouseOnHeader() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("mouse on header", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Point awtPoint = TreeTableViewTester.this.getRobot().getCurrentMousePosition();
                Point2D point = new Point2D((double)awtPoint.x, (double)awtPoint.y);
                return NodeBounds.checkIfContains(point, (Node)TreeTableViewTester.this.getContext().getTableHeader());
            }
        });
    }
}

