/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.ICondStructPO;
import org.eclipse.jubula.client.core.model.IConditionalStatementPO;
import org.eclipse.jubula.client.core.model.IControllerPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IDoWhilePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IEventStackModificationListener;
import org.eclipse.jubula.client.core.model.IExecStackModificationListener;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IIteratePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.IWhileDoPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.utils.DefaultEventHandler;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.IncompleteDataException;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Traverser {
    public static final int NO_DATASET = -1;
    public static final int NO_INDEX = -1;
    private static final Logger LOG = LoggerFactory.getLogger(Traverser.class);
    private INodePO m_root;
    private Stack<ExecObject> m_execStack = new Stack();
    private List<IExecStackModificationListener> m_execListenerList = new ArrayList<IExecStackModificationListener>();
    private List<IEventStackModificationListener> m_eventListenerList = new ArrayList<IEventStackModificationListener>();
    private Stack<EventObject> m_eventStack = new Stack();
    private Map<ExecStackMarker, Integer> m_markerToNumRetriesMap = new HashMap<ExecStackMarker, Integer>();
    private ExternalTestDataBP m_externalTestDataBP;
    private boolean m_building = false;
    private int m_iterMax = 100;

    public Traverser(INodePO root) {
        this.m_root = root;
        this.m_externalTestDataBP = new ExternalTestDataBP();
        this.m_execStack.push(new ExecObject(root, 0));
        this.executeLogging();
    }

    public ICapPO next() throws JBException {
        if (!this.m_execStack.isEmpty()) {
            ExecObject stackObj = this.m_execStack.peek();
            INodePO node = stackObj.getExecNode();
            ITDManager tdManager = null;
            if (node instanceof IParamNodePO) {
                tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager((IParamNodePO)node);
            }
            if (stackObj.getIndex() < node.getNodeListSize() - 1) {
                stackObj.incrementIndex();
                List nodeList = IteratorUtils.toList(node.getNodeListIterator());
                INodePO childNode = (INodePO)nodeList.get(stackObj.getIndex());
                if (!childNode.isActive()) {
                    return this.next();
                }
                if (childNode instanceof ICapPO) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.valueOf(Messages.ActualExecutedCap) + ":" + " " + childNode.getName());
                    }
                    this.fireNextCap((ICapPO)childNode);
                    return (ICapPO)childNode;
                }
                if (childNode instanceof IExecTestCasePO) {
                    if (((IExecTestCasePO)childNode).getSpecTestCase() == null) {
                        throw new IncompleteDataException(Messages.ExecTestCasePOMissingReference, MessageIDs.E_DATASOURCE_CONTAIN_EMPTY_DATA);
                    }
                    this.processExecTestCase(stackObj, (IExecTestCasePO)childNode);
                    return this.next();
                }
                if (childNode instanceof ICommentPO || childNode instanceof IControllerPO || childNode instanceof IAbstractContainerPO) {
                    this.m_execStack.push(new ExecObject(childNode, -1));
                    this.fireExecStackIncremented(childNode);
                    if (childNode instanceof IIteratePO) {
                        this.decrementIterate(((IIteratePO)childNode).getDoBranch());
                    }
                    return this.next();
                }
                Assert.notReached((String)Messages.ErrorInTestExecutionTree);
                return null;
            }
            if (!(stackObj.getExecNode() instanceof ITestSuitePO) && tdManager != null) {
                int maxDsNumber = tdManager.getDataSetCount();
                if (stackObj.getNumberDs() == -1) {
                    stackObj.incrementDataSetNumber();
                }
                if (stackObj.getNumberDs() + 1 < maxDsNumber) {
                    stackObj.incrementDataSetNumber();
                    stackObj.setIndex(-1);
                    this.fireNextDataSetIteration();
                    return this.next();
                }
                ReentryProperty prop = this.decrementStack(node);
                return prop == null ? this.next() : this.next(prop);
            }
            ReentryProperty prop = this.decrementStack(node);
            return prop == null ? this.next() : this.next(prop);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processExecTestCase(ExecObject stackObj, IExecTestCasePO exec) throws JBException {
        ITDManager tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager(exec);
        IDataSetPO dataSet = null;
        int dataSetSize = tdManager.getDataSetCount();
        if (dataSetSize > 0) {
            dataSet = tdManager.getDataSet(0);
        }
        String modelValue = null;
        if (dataSet != null && dataSet.getColumnCount() > 0) {
            modelValue = dataSet.getValueAt(0);
        }
        if (dataSetSize > 1) {
            this.m_execStack.push(new ExecObject(exec, this.getFirstDataSetNumber(exec)));
        } else if (dataSetSize == 1) {
            String uniqueId = tdManager.getUniqueIds().get(0);
            IParamDescriptionPO desc = exec.getParameterForUniqueId(uniqueId);
            ModelParamValueConverter conv = new ModelParamValueConverter(modelValue, exec, desc);
            if (modelValue != null && conv.containsReferences()) {
                this.m_execStack.push(new ExecObject(exec, stackObj.getNumberDs()));
            } else {
                if (modelValue == null) throw new IncompleteDataException(NLS.bind((String)Messages.ErrorWhenBuildingTestExecutionTree, (Object)exec.getSpecAncestor().getName()), MessageIDs.E_DATASOURCE_CONTAIN_EMPTY_DATA);
                this.m_execStack.push(new ExecObject(exec, 0));
            }
        } else {
            this.m_execStack.push(new ExecObject(exec, -1));
        }
        this.fireExecStackIncremented(exec);
    }

    private ReentryProperty decrementStack(INodePO node) throws IncompleteDataException {
        ReentryProperty prop = null;
        if (this.isEventHandler(node)) {
            IEventExecTestCasePO eventExec = (IEventExecTestCasePO)node;
            prop = eventExec.getReentryProp();
        }
        if (node instanceof IAbstractContainerPO) {
            this.m_execStack.pop();
            this.fireExecStackDecremented();
            if (this.m_execStack.isEmpty()) {
                return prop;
            }
            if (node.getParentNode() instanceof IConditionalStatementPO) {
                this.decrementCondStatementCont(node);
            } else if (node.getParentNode() instanceof IDoWhilePO || node.getParentNode() instanceof IWhileDoPO) {
                this.decrementDoWhileDoCont(node);
            } else if (node.getParentNode() instanceof IIteratePO) {
                this.decrementIterate(node);
            }
            return prop;
        }
        if (!this.m_execStack.isEmpty()) {
            this.m_execStack.pop();
            this.fireExecStackDecremented();
        }
        return prop;
    }

    private void decrementCondStatementCont(INodePO node) throws IncompleteDataException {
        IConditionalStatementPO par = (IConditionalStatementPO)node.getParentNode();
        if (node.equals(par.getCondition())) {
            IAbstractContainerPO next = par.isNegate() ? par.getElseBranch() : par.getThenBranch();
            this.m_execStack.push(new ExecObject(next, -1));
            this.fireExecStackIncremented(next);
            return;
        }
        this.m_execStack.pop();
        this.fireExecStackDecremented();
    }

    private void decrementDoWhileDoCont(INodePO node) throws IncompleteDataException {
        ICondStructPO par = (ICondStructPO)node.getParentNode();
        if (node.equals(par.getCondition())) {
            if (par.isNegate() || this.m_building) {
                this.m_execStack.pop();
                this.fireExecStackDecremented();
            } else {
                IAbstractContainerPO next = par.getDoBranch();
                this.m_execStack.push(new ExecObject(next, -1));
                this.fireExecStackIncremented(next);
            }
        } else if (this.m_execStack.peek().getIncLoopCount() >= this.m_iterMax) {
            this.fireInifiniteLoop();
            this.m_execStack.pop();
            this.fireExecStackDecremented();
            LOG.error(Messages.ErrorInfiniteLoop);
        } else {
            IAbstractContainerPO next = par.getCondition();
            this.m_execStack.push(new ExecObject(next, -1));
            this.fireExecStackIncremented(next);
        }
    }

    public void decrementIterate(INodePO node) throws IncompleteDataException {
        IIteratePO iter = (IIteratePO)node.getParentNode();
        ExecObject top = this.m_execStack.peek();
        int limit = 0;
        if (!this.m_building) {
            try {
                limit = Math.min(Integer.parseInt(top.getParameterValue(iter.getParameterList().get(0).getUniqueId())), this.m_iterMax);
            }
            catch (NumberFormatException numberFormatException) {
                limit = 0;
            }
        }
        if (limit < top.getIncLoopCount()) {
            if (limit == this.m_iterMax) {
                this.fireInifiniteLoop();
            }
            this.m_execStack.pop();
            this.fireExecStackDecremented();
            LOG.error(Messages.ErrorInfiniteLoop);
        } else {
            IAbstractContainerPO next = iter.getDoBranch();
            this.m_execStack.push(new ExecObject(next, -1));
            this.fireExecStackIncremented(next);
        }
    }

    private void executeLogging() {
        if (LOG.isDebugEnabled() && !this.m_execStack.isEmpty()) {
            LOG.debug(String.valueOf(Messages.ActualPeekObjectOnStack) + ":" + " " + this.m_execStack.peek().getExecNode().getName());
        }
    }

    private int getFirstDataSetNumber(INodePO node) throws JBException {
        IParamNodePO paramNode;
        ITDManager tdManager;
        int ds;
        int firstDs = -1;
        if (node instanceof IParamNodePO && ((IParamNodePO)node).getDataManager() != null && (ds = (tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager(paramNode = (IParamNodePO)node)).getDataSetCount()) > 0) {
            firstDs = 0;
        }
        return firstDs;
    }

    public List<ExecObject> getExecStackAsList() {
        return Collections.unmodifiableList(new ArrayList<ExecObject>(this.m_execStack));
    }

    public List<INodePO> getExecStackAsNodeList() {
        ArrayList<INodePO> nodes = new ArrayList<INodePO>(this.m_execStack.size());
        for (ExecObject execObject : this.m_execStack) {
            nodes.add(execObject.getExecNode());
        }
        return nodes;
    }

    public INodePO getRoot() {
        return this.m_root;
    }

    public void addExecStackModificationListener(IExecStackModificationListener listener) {
        if (!this.m_execListenerList.contains(listener)) {
            this.m_execListenerList.add(listener);
        }
    }

    public void removeExecStackModificationListener(IExecStackModificationListener listener) {
        this.m_execListenerList.remove(listener);
    }

    public void addEventStackModificationListener(IEventStackModificationListener listener) {
        if (!this.m_eventListenerList.contains(listener)) {
            this.m_eventListenerList.add(listener);
        }
    }

    public void removeEventStackModificationListener(IEventStackModificationListener listener) {
        this.m_eventListenerList.remove(listener);
    }

    private void fireExecStackIncremented(INodePO node) throws IncompleteDataException {
        this.addParameters(this.m_execStack.peek());
        this.executeLogging();
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.stackIncremented(node);
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireExecStackDecremented() {
        this.executeLogging();
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.stackDecremented();
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireInifiniteLoop() {
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.infiniteLoop();
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireEventStackIncremented() {
        this.executeLogging();
        for (IEventStackModificationListener l : this.m_eventListenerList) {
            try {
                l.eventStackIncremented();
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireEventStackDecremented() {
        for (IEventStackModificationListener l : this.m_eventListenerList) {
            try {
                l.eventStackDecremented();
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireNextDataSetIteration() throws IncompleteDataException {
        this.addParameters(this.m_execStack.peek());
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.nextDataSetIteration();
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireNextCap(ICapPO cap) {
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.nextCap(cap);
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    public int getDataSetNumber() {
        int ds = 0;
        if (!this.m_execStack.isEmpty()) {
            ExecObject obj = this.m_execStack.peek();
            ds = obj.getNumberDs();
        }
        return ds;
    }

    private ICapPO next(ReentryProperty reentryProp) throws JBException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ReentryProperty: " + String.valueOf(reentryProp));
        }
        if (!this.m_execStack.isEmpty()) {
            if (reentryProp.equals(ReentryProperty.CONTINUE)) {
                this.popEventStack();
            } else if (reentryProp.equals(ReentryProperty.REPEAT)) {
                ExecObject obj = this.m_execStack.peek();
                obj.decrementIndex();
                this.popEventStack();
            } else if (reentryProp.equals(ReentryProperty.BREAK)) {
                int i = this.m_eventStack.size();
                while (i > 0 && !this.m_execStack.isEmpty()) {
                    this.m_execStack.pop();
                    this.fireExecStackDecremented();
                    --i;
                }
                int pos = this.m_eventStack.peek().getStackPos();
                this.popEventStack();
                this.popEventStackNested(pos);
            } else if (reentryProp.equals(ReentryProperty.RETURN)) {
                int stackPos = this.m_eventStack.peek().getStackPos();
                this.popEventStack();
                stackPos = this.popEventStackNested(stackPos);
                while (this.m_execStack.size() > stackPos) {
                    this.m_execStack.pop();
                    this.fireExecStackDecremented();
                }
            } else if (reentryProp.equals(ReentryProperty.EXIT)) {
                int i = this.m_execStack.size() - 1;
                while (i >= 0) {
                    this.m_execStack.pop();
                    this.fireExecStackDecremented();
                    --i;
                }
                i = this.m_eventStack.size() - 1;
                while (i >= 0) {
                    this.popEventStack();
                    --i;
                }
            } else if (reentryProp.equals(ReentryProperty.STOP)) {
                TestExecution.getInstance().pauseExecution(TestExecution.PauseMode.PAUSE);
                this.popEventStack();
            } else {
                if (reentryProp.equals(ReentryProperty.RETRY)) {
                    this.popEventStack();
                    return this.retryStep();
                }
                int i = this.m_execStack.size() - 1;
                while (i >= 0) {
                    this.m_execStack.pop();
                    this.fireExecStackDecremented();
                    --i;
                }
                i = this.m_eventStack.size() - 1;
                while (i >= 0) {
                    this.popEventStack();
                    --i;
                }
            }
            return this.next();
        }
        return null;
    }

    private int popEventStackNested(int stackPos) {
        while (!this.m_eventStack.isEmpty() && this.m_eventStack.peek().getStackPos() >= stackPos) {
            this.popEventStack();
        }
        return stackPos;
    }

    private void popEventStack() {
        this.m_eventStack.pop();
        this.fireEventStackDecremented();
    }

    private ICapPO retryStep() {
        ExecObject execObj = this.m_execStack.peek();
        List nodeList = IteratorUtils.toList(execObj.getExecNode().getNodeListIterator());
        INodePO childNode = (INodePO)nodeList.get(execObj.getIndex());
        if (childNode instanceof ICapPO) {
            ICapPO cap = (ICapPO)childNode;
            ExecStackMarker marker = new ExecStackMarker(this.m_execStack, cap);
            if (this.m_markerToNumRetriesMap.containsKey(marker)) {
                this.m_markerToNumRetriesMap.put(marker, this.m_markerToNumRetriesMap.get(marker) + 1);
            } else {
                this.m_markerToNumRetriesMap.put(marker, 1);
            }
            this.fireRetryStep(cap);
            return cap;
        }
        return null;
    }

    private void fireRetryStep(ICapPO toRetry) {
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.retryCap(toRetry);
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private boolean isEventHandler(INodePO node) {
        return node instanceof IEventExecTestCasePO;
    }

    public ReentryProperty getEventHandlerReentry(String eventType) {
        return this.getEventObject(eventType, false).getEventExecTc().getReentryProp();
    }

    public ICapPO next(String eventType) throws JBException {
        ExecObject execObj = this.m_execStack.peek();
        EventObject eventObj = this.getEventObject(eventType, true);
        IEventExecTestCasePO eventExecTC = eventObj.getEventExecTc();
        if (eventExecTC.getReentryProp().equals(ReentryProperty.CONDITION)) {
            int stackPos = this.popEventStackNested(eventObj.getStackPos());
            while (this.m_execStack.size() > stackPos + 1) {
                this.m_execStack.pop();
                this.fireExecStackDecremented();
            }
            ExecObject top = this.m_execStack.peek();
            if (top.getExecNode() instanceof IConditionalStatementPO) {
                IConditionalStatementPO cond = (IConditionalStatementPO)top.getExecNode();
                IAbstractContainerPO node = cond.isNegate() ? cond.getThenBranch() : cond.getElseBranch();
                this.m_execStack.push(new ExecObject(node, -1));
                this.fireExecStackIncremented(node);
            } else if (top.getExecNode() instanceof ICondStructPO) {
                ICondStructPO cond = (ICondStructPO)top.getExecNode();
                if (cond.isNegate()) {
                    IAbstractContainerPO node = cond.getDoBranch();
                    this.m_execStack.push(new ExecObject(node, -1));
                    this.fireExecStackIncremented(node);
                } else {
                    this.m_execStack.pop();
                    this.fireExecStackDecremented();
                }
            }
            return this.next();
        }
        int dataSetIndex = 0;
        ITDManager mgr = eventExecTC.getDataManager();
        if (mgr.getDataSetCount() > 0) {
            IDataSetPO row = mgr.getDataSet(0);
            int col = 0;
            while (col < row.getColumnCount()) {
                String uniqueId;
                IParamDescriptionPO desc;
                String td = row.getValueAt(col);
                ModelParamValueConverter conv = new ModelParamValueConverter(td, eventExecTC, desc = eventExecTC.getParameterForUniqueId(uniqueId = mgr.getUniqueIds().get(col)));
                if (conv.containsReferences()) {
                    dataSetIndex = execObj.getNumberDs();
                    break;
                }
                ++col;
            }
        }
        this.m_execStack.push(new ExecObject(eventExecTC, dataSetIndex));
        this.m_eventStack.push(eventObj);
        this.fireEventStackIncremented();
        this.fireExecStackIncremented(eventExecTC);
        return this.next();
    }

    private EventObject getEventObject(String eventType, boolean resetRetryCount) {
        int startIndex;
        List nodeList = IteratorUtils.toList(this.m_execStack.peek().getExecNode().getNodeListIterator());
        ICapPO cap = (ICapPO)nodeList.get(this.m_execStack.peek().getIndex());
        ExecStackMarker marker = new ExecStackMarker(this.m_execStack, cap);
        EventObject eventObj = null;
        int i = startIndex = this.m_execStack.size() - 1;
        while (i > 0 && i < this.m_execStack.size()) {
            ExecObject obj = (ExecObject)this.m_execStack.get(i);
            if (eventType.equals("TestErrorEvent.VerifyFailed") && obj.getExecNode() instanceof IAbstractContainerPO && (eventObj = this.handleContainer((IAbstractContainerPO)obj.getExecNode(), i)) != null) {
                return eventObj;
            }
            if (obj.getExecNode() instanceof IExecTestCasePO) {
                IExecTestCasePO execTc = (IExecTestCasePO)obj.getExecNode();
                IEventExecTestCasePO eventExecTc = execTc.getEventExecTC(eventType);
                if (!this.isHandlingError(i) && eventExecTc != null) {
                    if (!eventExecTc.getReentryProp().equals(ReentryProperty.RETRY) || !this.m_markerToNumRetriesMap.containsKey(marker) || this.m_markerToNumRetriesMap.get(marker) < eventExecTc.getMaxRetries()) {
                        eventObj = new EventObject(eventExecTc, i);
                        break;
                    }
                    eventExecTc = null;
                }
            }
            --i;
        }
        if (eventObj == null) {
            if (this.m_markerToNumRetriesMap.containsKey(marker) && resetRetryCount) {
                this.m_markerToNumRetriesMap.put(marker, 0);
            }
            IEventExecTestCasePO eventExecTc = DefaultEventHandler.getDefaultEventHandler(eventType, this.m_root);
            Validate.notNull((Object)eventExecTc, (String)(String.valueOf(Messages.MissingDefaultEventHandlerForEventType) + eventType + "."));
            eventObj = new EventObject(eventExecTc, 0);
        }
        return eventObj;
    }

    private EventObject handleContainer(IAbstractContainerPO cont, int i) {
        INodePO par = cont.getParentNode();
        if (par instanceof ICondStructPO && cont.equals(((ICondStructPO)par).getCondition())) {
            return new EventObject(NodeMaker.COND_EVENT_EXECTC, i - 1);
        }
        return null;
    }

    private boolean isHandlingError(int execStackIndex) {
        for (EventObject event : this.m_eventStack) {
            if (event.getStackPos() != execStackIndex) continue;
            return true;
        }
        return false;
    }

    public int getSuccessResult() {
        ExecStackMarker marker;
        INodePO currentNode = this.getCurrentNode();
        if (currentNode instanceof ICapPO && this.m_markerToNumRetriesMap.containsKey(marker = new ExecStackMarker(this.m_execStack, (ICapPO)currentNode))) {
            this.m_markerToNumRetriesMap.put(marker, 0);
            return 8;
        }
        return 1;
    }

    private INodePO getCurrentNode() {
        List nodeList = IteratorUtils.toList(this.m_execStack.peek().getExecNode().getNodeListIterator());
        return (INodePO)nodeList.get(this.m_execStack.peek().getIndex());
    }

    private void addParameters(ExecObject execObject) throws IncompleteDataException {
        INodePO execNode = execObject.getExecNode();
        if (execNode instanceof IParamNodePO) {
            IParamNodePO paramNode = (IParamNodePO)execNode;
            List<IParamDescriptionPO> parameterList = paramNode.getParameterList();
            String value = null;
            for (IParamDescriptionPO desc : parameterList) {
                String date;
                IParameterInterfacePO referencedDataCube;
                String descriptionId = desc.getUniqueId();
                ITDManager tdManager = null;
                try {
                    tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager(paramNode);
                }
                catch (JBException e) {
                    LOG.error(String.valueOf(Messages.TestDataNotAvailable) + ".", (Throwable)e);
                }
                TestExecution.getInstance();
                ArrayList<ExecObject> stackList = new ArrayList<ExecObject>(this.getExecStackAsList());
                int dataSetIndex = this.getDataSetNumber();
                if (tdManager.getDataSetCount() <= 1) {
                    dataSetIndex = 0;
                }
                if (paramNode instanceof ICapPO) {
                    dataSetIndex = 0;
                }
                if (tdManager.findColumnForParam(desc.getUniqueId()) == -1 && (referencedDataCube = paramNode.getReferencedDataCube()) != null) {
                    desc = referencedDataCube.getParameterForName(desc.getName());
                }
                if (StringUtils.isBlank((String)(date = this.getDataForExec(execNode, desc, tdManager, dataSetIndex)))) {
                    throw new IncompleteDataException(NLS.bind((String)Messages.MissingTestData, (Object)execNode.getName()), MessageIDs.E_MISSING_DATA);
                }
                ModelParamValueConverter conv = new ModelParamValueConverter(date, paramNode, desc);
                try {
                    value = conv.getExecutionString(stackList);
                }
                catch (InvalidDataException e) {
                    LOG.info(e.getMessage());
                    value = MessageIDs.getMessageObject((Integer)e.getErrorId()).getMessage((Object[])new String[]{e.getLocalizedMessage()});
                }
                execObject.addParameter(descriptionId, StringUtils.defaultString((String)value));
            }
        }
    }

    private String getDataForExec(INodePO node, IParamDescriptionPO desc, ITDManager tdManager, int dataSetIndex) {
        ISpecTestCasePO specNode;
        String data = "";
        boolean cellNotFound = false;
        try {
            data = tdManager.getCell(dataSetIndex, desc);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            cellNotFound = true;
        }
        if (cellNotFound && StringUtils.isBlank((String)data) && node instanceof IExecTestCasePO && (specNode = ((IExecTestCasePO)node).getSpecTestCase()) instanceof ISpecTestCasePO) {
            data = AbstractParamInterfaceBP.getValueForSpecNodeWithParamDesc(desc, specNode);
        }
        return data;
    }

    public void setBuilding(boolean build) {
        this.m_building = build;
    }

    public void setIterMax(int iterMax) {
        this.m_iterMax = iterMax;
    }

    private static class EventObject {
        private IEventExecTestCasePO m_eventExec;
        private int m_stackPos;

        private EventObject(IEventExecTestCasePO eventExec, int stackPos) {
            this.m_eventExec = eventExec;
            this.m_stackPos = stackPos;
        }

        public IEventExecTestCasePO getEventExecTc() {
            return this.m_eventExec;
        }

        public int getStackPos() {
            return this.m_stackPos;
        }
    }

    private static final class ExecStackMarker {
        private Vector<ExecObject> m_execStack;
        private ICapPO m_step;

        ExecStackMarker(Stack<ExecObject> execStack, ICapPO step) {
            this.m_execStack = new Vector<ExecObject>(execStack);
            this.m_step = step;
        }

        List<ExecObject> getExecStack() {
            return UnmodifiableList.decorate(this.m_execStack);
        }

        ICapPO getStep() {
            return this.m_step;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExecStackMarker) {
                ExecStackMarker marker = (ExecStackMarker)obj;
                return new EqualsBuilder().append(this.m_execStack, marker.getExecStack()).append((Object)this.m_step, (Object)marker.getStep()).isEquals();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.m_execStack).append((Object)this.m_step).toHashCode();
        }
    }
}

