/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.initialization;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.initialization.AnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResultAttributeInitializer
extends AnnotationAttributeInitializer {
    public List<MemberValuePair> getMemberValuePairs(IJavaElement javaElement, AST ast, IType annotationType) {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        if (javaElement.getElementType() == 9) {
            IMethod method = (IMethod)javaElement;
            MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"name", (String)this.getName(method));
            memberValuePairs.add(nameValuePair);
        }
        return memberValuePairs;
    }

    public List<ICompletionProposal> getCompletionProposalsForMemberValuePair(IJavaElement javaElement, MemberValuePair memberValuePair) {
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>();
        if (javaElement.getElementType() == 9) {
            IMethod method = (IMethod)javaElement;
            String memberValuePairName = memberValuePair.getName().getIdentifier();
            if (memberValuePairName.equals("name")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getName(method), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("partName")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getPartName(method), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("targetNamespace")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getTargetNamespace(method), memberValuePair.getValue()));
            }
        }
        return completionProposals;
    }

    private String getName(IMethod method) {
        if (this.hasDocumentBareSOAPBinding((IAnnotatable)method)) {
            return String.valueOf(this.getOperationName(method)) + "Response";
        }
        return "return";
    }

    private String getOperationName(IMethod method) {
        try {
            String operationName;
            IAnnotation annotation = AnnotationUtils.getAnnotation(WebMethod.class, (IAnnotatable)method);
            if (annotation != null && (operationName = AnnotationUtils.getStringValue((IAnnotation)annotation, (String)"operationName")) != null) {
                return operationName;
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return method.getElementName();
    }

    private boolean hasDocumentBareSOAPBinding(IAnnotatable annotatable) {
        try {
            IAnnotation annotation = AnnotationUtils.getAnnotation(SOAPBinding.class, (IAnnotatable)annotatable);
            if (annotation != null) {
                return JAXWSUtils.isDocumentBare((IAnnotation)annotation);
            }
            if (annotatable instanceof IMethod) {
                IMethod method = (IMethod)annotatable;
                return this.hasDocumentBareSOAPBinding((IAnnotatable)((IType)method.getParent()));
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return false;
    }

    private String getPartName(IMethod method) {
        try {
            String name;
            IAnnotation annotation = AnnotationUtils.getAnnotation(WebResult.class, (IAnnotatable)method);
            if (annotation != null && (name = AnnotationUtils.getStringValue((IAnnotation)annotation, (String)"name")) != null) {
                return name;
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return this.getName(method);
    }

    private String getTargetNamespace(IMethod method) {
        if (this.hasDocumentWrappedSOAPBinding((IAnnotatable)method) && !this.isHeader(method)) {
            return "";
        }
        return this.getDefaultTargetNamespace(method);
    }

    private boolean hasDocumentWrappedSOAPBinding(IAnnotatable annotatable) {
        try {
            IAnnotation annotation = AnnotationUtils.getAnnotation(SOAPBinding.class, (IAnnotatable)annotatable);
            if (annotation != null) {
                return JAXWSUtils.isDocumentWrapped((IAnnotation)annotation);
            }
            if (annotatable instanceof IMethod) {
                IMethod method = (IMethod)annotatable;
                return this.hasDocumentWrappedSOAPBinding((IAnnotatable)((IType)method.getParent()));
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return true;
    }

    private boolean isHeader(IMethod method) {
        try {
            Boolean header;
            IAnnotation annotation = AnnotationUtils.getAnnotation(WebResult.class, (IAnnotatable)method);
            if (annotation != null && (header = AnnotationUtils.getBooleanValue((IAnnotation)annotation, (String)"header")) != null) {
                return header;
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return false;
    }

    private String getDefaultTargetNamespace(IMethod method) {
        IType type = method.getDeclaringType();
        try {
            String targetNamespace;
            IAnnotation annotation = AnnotationUtils.getAnnotation(WebService.class, (IAnnotatable)type);
            if (annotation != null && (targetNamespace = AnnotationUtils.getStringValue((IAnnotation)annotation, (String)"targetNamespace")) != null) {
                return targetNamespace;
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return JDTUtils.getTargetNamespaceFromPackageName((String)this.getPackageName(type));
    }

    private String getPackageName(IType type) {
        IPackageFragment packageFragment = type.getPackageFragment();
        return packageFragment.getElementName();
    }
}

