/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class JavaAnnotationIterator
implements Iterator<Annotation> {
    private Iterator<Annotation> fIterator;
    private Annotation fNext;
    private boolean fReturnAllAnnotations;

    public JavaAnnotationIterator(Iterator<Annotation> parent, boolean returnAllAnnotations) {
        this.fReturnAllAnnotations = returnAllAnnotations;
        this.fIterator = parent;
        this.skip();
    }

    private void skip() {
        while (this.fIterator.hasNext()) {
            Annotation next = this.fIterator.next();
            if (next.isMarkedDeleted() || !this.fReturnAllAnnotations && !(next instanceof IJavaAnnotation) && !JavaAnnotationIterator.isProblemMarkerAnnotation(next)) continue;
            this.fNext = next;
            return;
        }
        this.fNext = null;
    }

    private static boolean isProblemMarkerAnnotation(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public boolean hasNext() {
        return this.fNext != null;
    }

    @Override
    public Annotation next() {
        try {
            Annotation annotation = this.fNext;
            return annotation;
        }
        finally {
            this.skip();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

