/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheCredentialsProvider
implements CredentialsProvider {
    private final HashMap<AuthScope, Credentials> credentials = new HashMap();

    public synchronized void removeCredentials(AuthScope authscope) {
        Map.Entry<AuthScope, Credentials> nextMatch;
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        Credentials match = this.getCredentials(authscope);
        if (match == null) {
            return;
        }
        Iterator<Map.Entry<AuthScope, Credentials>> entries = this.credentials.entrySet().iterator();
        while ((nextMatch = CacheCredentialsProvider.findNextCredentials(entries, authscope, -1)) != null) {
            Credentials nextCredentials = nextMatch.getValue();
            if (!match.equals(nextCredentials)) continue;
            entries.remove();
        }
    }

    public synchronized void setCredentials(AuthScope authscope, Credentials credentials) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        if (credentials == null) {
            this.removeCredentials(authscope);
        } else {
            this.credentials.put(authscope, credentials);
        }
    }

    private Credentials findBestCredentials(AuthScope authscope) {
        Credentials bestMatch = this.credentials.get(this.credentials);
        if (bestMatch == null) {
            Map.Entry<AuthScope, Credentials> nextMatch;
            int bestMatchFactor = -1;
            Iterator<Map.Entry<AuthScope, Credentials>> entries = this.credentials.entrySet().iterator();
            while ((nextMatch = CacheCredentialsProvider.findNextCredentials(entries, authscope, bestMatchFactor)) != null) {
                bestMatch = nextMatch.getValue();
                bestMatchFactor = authscope.match(nextMatch.getKey());
            }
        }
        return bestMatch;
    }

    private static Map.Entry<AuthScope, Credentials> findNextCredentials(Iterator<Map.Entry<AuthScope, Credentials>> iterator, AuthScope authscope, int minFactor) {
        while (iterator.hasNext()) {
            Map.Entry<AuthScope, Credentials> current = iterator.next();
            int factor = authscope.match(current.getKey());
            if (factor <= minFactor) continue;
            return current;
        }
        return null;
    }

    public synchronized Credentials getCredentials(AuthScope authscope) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        return this.findBestCredentials(authscope);
    }

    public synchronized void clear() {
        this.credentials.clear();
    }

    public String toString() {
        return this.credentials.toString();
    }
}

