/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.xtext.GenModelSupport;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.XcoreRuntimeModule;
import org.eclipse.emf.ecore.xcore.XcoreStandaloneSetupGenerated;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.ecore.EcoreSupportStandaloneSetup;
import org.eclipse.xtext.mwe.ContainersStateFactory;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.mwe.RuntimeResourceSetInitializer;
import org.eclipse.xtext.mwe.UriFilter;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.eclipse.xtext.xbase.XbasePackage;

public class XcoreStandaloneSetup
extends XcoreStandaloneSetupGenerated {
    public static void doSetup() {
        new XcoreStandaloneSetup().createInjectorAndDoEMFRegistration();
    }

    @Override
    public Injector createInjectorAndDoEMFRegistration() {
        EcoreSupportStandaloneSetup.setup();
        new GenModelSupport().registerServices(false);
        return super.createInjectorAndDoEMFRegistration();
    }

    @Override
    public void register(Injector injector) {
        EPackage.Registry packageRegistry = (EPackage.Registry)injector.getInstance(EPackage.Registry.class);
        packageRegistry.put((Object)"http://www.eclipse.org/emf/2011/Xcore", (Object)XcorePackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/xtext/xbase/Xbase", (Object)XbasePackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/xtext/common/JavaVMTypes", (Object)TypesPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EcoreResourceFactoryImpl resourceFactory = new EcoreResourceFactoryImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", resourceFactory);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", resourceFactory);
        super.register(injector);
    }

    @Override
    public Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{new XcoreStandaloneRuntimeModule()});
    }

    public static class XcoreStandaloneRuntimeModule
    extends XcoreRuntimeModule {
        public Class<? extends XtextResourceSet> bindXtextResourceSet() {
            return null;
        }

        @Override
        public void configure(Binder binder) {
            binder.bind(XtextResourceSet.class).toProvider(XcoreStandaloneResourceSetProvider.class);
            super.configure(binder);
        }

        public Class<? extends PathTraverser> bindPathTraverser() {
            return XcorePathTraverser.class;
        }

        public static class XcorePathTraverser
        extends PathTraverser {
            public Set<URI> findAllResourceUris(String path, Predicate<URI> isValidPredicate) {
                Set result = super.findAllResourceUris(path, isValidPredicate);
                if (result.isEmpty() && new File(String.valueOf(path) + "/../build.properties").isFile()) {
                    try {
                        return this.traverseDir(new File(String.valueOf(path) + "/..").getCanonicalFile(), isValidPredicate);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return result;
            }
        }

        public static class XcoreResourceSetInitializer
        extends RuntimeResourceSetInitializer {
            private static List<String> paths;
            private static Multimap<String, URI> pathToUriMap;
            @Inject
            Injector injector;
            @Inject
            private ContainersStateFactory factory;

            public List<String> getClassPathEntries() {
                if (paths == null) {
                    paths = super.getClassPathEntries();
                }
                return paths;
            }

            protected Multimap<String, URI> getPathToUriMap() {
                if (pathToUriMap == null) {
                    pathToUriMap = this.getPathToUriMap(this.getClassPathEntries(), new UriFilter(){
                        Set<String> fileExtensions = Sets.newHashSet((Object[])new String[]{"xcore", "genmodel", "ecore"});

                        public boolean matches(URI uri) {
                            return this.fileExtensions.contains(uri.fileExtension());
                        }
                    });
                }
                return pathToUriMap;
            }

            public IAllContainersState getContainersState() {
                return this.factory.getContainersState(paths, pathToUriMap);
            }

            public XtextResourceSet getInitializedResourceSet() {
                XtextResourceSet resourceSet = new XtextResourceSet();
                this.injector.injectMembers((Object)resourceSet);
                resourceSet.eAdapters().add((Object)new AllContainerAdapter(resourceSet));
                return resourceSet;
            }

            public class AllContainerAdapter
            extends AdapterImpl
            implements IAllContainersState {
                protected ResourceSet resourceSet;
                protected IAllContainersState allContainersState;

                public AllContainerAdapter(XtextResourceSet resourceSet) {
                    this.resourceSet = resourceSet;
                }

                public boolean isAdapterForType(Object type) {
                    return IAllContainersState.class == type;
                }

                public boolean isEmpty(String containerHandle) {
                    return this.getAllContainersState().isEmpty(containerHandle);
                }

                public List<String> getVisibleContainerHandles(String handle) {
                    return this.getAllContainersState().getVisibleContainerHandles(handle);
                }

                public Collection<URI> getContainedURIs(String containerHandle) {
                    return this.getAllContainersState().getContainedURIs(containerHandle);
                }

                public String getContainerHandle(URI uri) {
                    return this.getAllContainersState().getContainerHandle(uri);
                }

                IAllContainersState getAllContainersState() {
                    if (this.allContainersState == null) {
                        ArrayList classPathEntries = Lists.newArrayList(XcoreResourceSetInitializer.this.getClassPathEntries());
                        classPathEntries.add("resourceSet");
                        HashMultimap result = HashMultimap.create();
                        for (Resource resource : this.resourceSet.getResources()) {
                            result.put((Object)"resourceSet", (Object)this.resourceSet.getURIConverter().normalize(resource.getURI()));
                        }
                        Multimap<String, URI> pathToUriMap = XcoreResourceSetInitializer.this.getPathToUriMap();
                        for (URI uri : pathToUriMap.values()) {
                            this.resourceSet.getResource(uri, true);
                        }
                        result.putAll(pathToUriMap);
                        this.allContainersState = XcoreResourceSetInitializer.this.factory.getContainersState((List)classPathEntries, (Multimap)result);
                    }
                    return this.allContainersState;
                }
            }
        }

        public static class XcoreStandaloneResourceSetProvider
        implements Provider<XtextResourceSet> {
            @Inject
            XcoreResourceSetInitializer resourceSetInitializer;

            public XtextResourceSet get() {
                return this.resourceSetInitializer.getInitializedResourceSet();
            }
        }
    }
}

