/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.tabs;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.egerrit.internal.ui.tabs.EGerritHyperlinkManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.HyperlinkManager;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Composite;

class TextViewerWithLinks
extends SourceViewer {
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);

    TextViewerWithLinks(Composite composite, int styles) {
        super(composite, null, styles);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setHyperlinkDetectors(IHyperlinkDetector[] hyperlinkDetectors, int eventStateMask) {
        if (this.fHyperlinkDetectors != null) {
            IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
            int n = this.fHyperlinkDetectors.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlinkDetector fHyperlinkDetector = iHyperlinkDetectorArray[n2];
                if (fHyperlinkDetector instanceof IHyperlinkDetectorExtension) {
                    ((IHyperlinkDetectorExtension)fHyperlinkDetector).dispose();
                }
                ++n2;
            }
        }
        boolean enable = hyperlinkDetectors != null && hyperlinkDetectors.length > 0;
        this.fHyperlinkStateMask = eventStateMask;
        this.fHyperlinkDetectors = hyperlinkDetectors;
        if (enable) {
            if (this.fHyperlinkManager != null) {
                this.fHyperlinkManager.setHyperlinkDetectors(this.fHyperlinkDetectors);
                this.fHyperlinkManager.setHyperlinkStateMask(this.fHyperlinkStateMask);
            }
            this.ensureHyperlinkManagerInstalled();
        } else {
            if (this.fHyperlinkManager != null) {
                this.fHyperlinkManager.uninstall();
            }
            this.fHyperlinkManager = null;
        }
    }

    private void ensureHyperlinkManagerInstalled() {
        if (this.fHyperlinkDetectors != null && this.fHyperlinkDetectors.length > 0 && this.fHyperlinkPresenter != null && this.fHyperlinkManager == null) {
            HyperlinkManager.DETECTION_STRATEGY strategy = this.fHyperlinkPresenter.canShowMultipleHyperlinks() ? HyperlinkManager.ALL : HyperlinkManager.FIRST;
            this.fHyperlinkManager = new EGerritHyperlinkManager(strategy);
            this.fHyperlinkManager.install((ITextViewer)this, this.fHyperlinkPresenter, this.fHyperlinkDetectors, this.fHyperlinkStateMask);
        }
    }
}

