/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.eclemma.core.ICorePreferences;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.core.ISessionExporter;
import org.eclipse.eclemma.core.ISessionImporter;
import org.eclipse.eclemma.core.ISessionManager;
import org.eclipse.eclemma.core.analysis.IJavaCoverageListener;
import org.eclipse.eclemma.core.analysis.IJavaModelCoverage;
import org.eclipse.eclemma.core.launching.ICoverageLaunch;
import org.eclipse.eclemma.internal.core.EclEmmaCorePlugin;
import org.eclipse.eclemma.internal.core.SessionExporter;
import org.eclipse.eclemma.internal.core.SessionImporter;
import org.jacoco.core.analysis.ICoverageNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoverageTools {
    public static final String LAUNCH_MODE = "coverage";

    public static ISessionManager getSessionManager() {
        return EclEmmaCorePlugin.getInstance().getSessionManager();
    }

    public static ICoverageNode getCoverageInfo(Object object) {
        if (object instanceof IAdaptable) {
            return (ICoverageNode)((IAdaptable)object).getAdapter(ICoverageNode.class);
        }
        return null;
    }

    public static IJavaModelCoverage getJavaModelCoverage() {
        return EclEmmaCorePlugin.getInstance().getJavaCoverageLoader().getJavaModelCoverage();
    }

    public static void addJavaCoverageListener(IJavaCoverageListener l) {
        EclEmmaCorePlugin.getInstance().getJavaCoverageLoader().addJavaCoverageListener(l);
    }

    public static void removeJavaCoverageListener(IJavaCoverageListener l) {
        EclEmmaCorePlugin.getInstance().getJavaCoverageLoader().removeJavaCoverageListener(l);
    }

    public static ISessionExporter getExporter(ICoverageSession session) {
        return new SessionExporter(session);
    }

    public static ISessionImporter getImporter() {
        return new SessionImporter(CoverageTools.getSessionManager(), EclEmmaCorePlugin.getInstance().getExecutionDataFiles());
    }

    public static void setPreferences(ICorePreferences preferences) {
        EclEmmaCorePlugin.getInstance().setPreferences(preferences);
    }

    public static List<ICoverageLaunch> getRunningCoverageLaunches() {
        ArrayList<ICoverageLaunch> result = new ArrayList<ICoverageLaunch>();
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof ICoverageLaunch && !launch.isTerminated()) {
                result.add((ICoverageLaunch)launch);
            }
            ++n2;
        }
        return result;
    }

    private CoverageTools() {
    }
}

