/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Collections;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionCost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;

public class Conversions {
    private static final char[] INITIALIZER_LIST_NAME = "initializer_list".toCharArray();
    private static final char[] STD_NAME = "std".toCharArray();

    public static Cost checkImplicitConversionSequence(IType target, IType exprType, IASTExpression.ValueCategory valueCat, UDCMode udc, Context ctx, IASTNode point) throws DOMException {
        boolean isImpliedObject;
        boolean bl = isImpliedObject = ctx == Context.IMPLICIT_OBJECT_FOR_METHOD_WITHOUT_REF_QUALIFIER || ctx == Context.IMPLICIT_OBJECT_FOR_METHOD_WITH_REF_QUALIFIER;
        if (isImpliedObject) {
            udc = UDCMode.FORBIDDEN;
        }
        target = SemanticUtil.getNestedType(target, 1);
        exprType = SemanticUtil.getNestedType(exprType, 5);
        IType cv1T1 = SemanticUtil.getNestedType(target, 5);
        IType T1 = SemanticUtil.getNestedType(cv1T1, 21);
        if (target instanceof ICPPReferenceType) {
            Cost cost;
            Cost.ReferenceBinding refBindingType = Cost.ReferenceBinding.OTHER_REF;
            boolean isLValueRef = !((ICPPReferenceType)target).isRValueReference();
            IType cv2T2 = exprType;
            IType T2 = SemanticUtil.getNestedType(cv2T2, 21);
            Cost.ReferenceBinding referenceBinding = refBindingType = isLValueRef ? Cost.ReferenceBinding.LVALUE_REF : Cost.ReferenceBinding.RVALUE_REF_BINDS_RVALUE;
            if (exprType instanceof InitializerListType) {
                if (isLValueRef && SemanticUtil.getCVQualifier(cv1T1) != CVQualifier.CONST) {
                    return Cost.NO_CONVERSION;
                }
                Cost cost2 = Conversions.listInitializationSequence(((InitializerListType)exprType).getEvaluation(), T1, udc, false, point);
                if (cost2.converts()) {
                    cost2.setReferenceBinding(refBindingType);
                }
                return cost2;
            }
            if (isLValueRef) {
                if (valueCat == IASTExpression.ValueCategory.LVALUE || ctx == Context.IMPLICIT_OBJECT_FOR_METHOD_WITHOUT_REF_QUALIFIER) {
                    if (valueCat != IASTExpression.ValueCategory.LVALUE) {
                        refBindingType = Cost.ReferenceBinding.RVALUE_REF_BINDS_RVALUE;
                    }
                    if ((cost = Conversions.isReferenceCompatible(cv1T1, cv2T2, isImpliedObject, point)) != null) {
                        cost.setReferenceBinding(refBindingType);
                        return cost;
                    }
                }
                if (T2 instanceof ICPPClassType && udc != UDCMode.FORBIDDEN && Conversions.isReferenceRelated(T1, T2, point) < 0 && (cost = Conversions.initializationByConversionForDirectReference(cv1T1, cv2T2, (ICPPClassType)T2, true, false, ctx, point)) != null) {
                    cost.setReferenceBinding(refBindingType);
                    return cost;
                }
            }
            if (isLValueRef && SemanticUtil.getCVQualifier(cv1T1) != CVQualifier.CONST) {
                return Cost.NO_CONVERSION;
            }
            if ((valueCat == IASTExpression.ValueCategory.XVALUE || valueCat == IASTExpression.ValueCategory.PRVALUE && (T2 instanceof ICPPClassType || T2 instanceof IArrayType) || valueCat == IASTExpression.ValueCategory.LVALUE && T2 instanceof ICPPFunctionType) && (cost = Conversions.isReferenceCompatible(cv1T1, cv2T2, isImpliedObject, point)) != null) {
                cost.setReferenceBinding(refBindingType);
                return cost;
            }
            if (T2 instanceof ICPPClassType && udc != UDCMode.FORBIDDEN && Conversions.isReferenceRelated(T1, T2, point) < 0 && (cost = Conversions.initializationByConversionForDirectReference(cv1T1, cv2T2, (ICPPClassType)T2, false, true, ctx, point)) != null) {
                if (cost != Cost.NO_CONVERSION) {
                    cost.setReferenceBinding(refBindingType);
                }
                return cost;
            }
            if (!isImpliedObject && ctx != Context.REQUIRE_DIRECT_BINDING) {
                boolean referenceRelated;
                cost = Conversions.nonReferenceConversion(valueCat, cv2T2, T1, udc, point);
                if (cost.converts()) {
                    cost.setReferenceBinding(refBindingType);
                }
                boolean bl2 = referenceRelated = Conversions.isReferenceRelated(T1, T2, point) >= 0;
                if (referenceRelated && Conversions.compareQualifications(cv1T1, cv2T2) < 0) {
                    return Cost.NO_CONVERSION;
                }
                if (referenceRelated && !isLValueRef && valueCat == IASTExpression.ValueCategory.LVALUE) {
                    return Cost.NO_CONVERSION;
                }
                return cost;
            }
            return Cost.NO_CONVERSION;
        }
        return Conversions.nonReferenceConversion(valueCat, exprType, T1, udc, point);
    }

    private static Cost initializationByConversionForDirectReference(IType cv1T1, IType cv2T2, ICPPClassType T2, boolean needLValue, boolean illFormedIfLValue, Context ctx, IASTNode point) throws DOMException {
        ICPPMethod[] fcns = SemanticUtil.getConversionOperators(T2, point);
        Cost operatorCost = null;
        FunctionCost bestUdcCost = null;
        boolean ambiguousConversionOperator = false;
        if (fcns.length > 0 && !(fcns[0] instanceof IProblemBinding)) {
            ICPPMethod[] iCPPMethodArray = fcns;
            int n = fcns.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod op = iCPPMethodArray[n2];
                if (!op.isExplicit() || ctx == Context.FIRST_PARAM_OF_DIRECT_COPY_CTOR) {
                    IType implicitParameterType;
                    Cost udcCost;
                    boolean isLValueRef;
                    ICPPFunctionType ft = op.getType();
                    IType t = SemanticUtil.getNestedType(ft.getReturnType(), 1);
                    boolean bl = isLValueRef = t instanceof ICPPReferenceType && !((ICPPReferenceType)t).isRValueReference();
                    if ((!needLValue || isLValueRef) && (udcCost = Conversions.isReferenceCompatible(SemanticUtil.getNestedType(implicitParameterType = CPPSemantics.getImplicitParameterType(op), 5), cv2T2, true, point)) != null) {
                        Cost cost;
                        udcCost.setReferenceBinding(Cost.ReferenceBinding.LVALUE_REF);
                        FunctionCost udcFuncCost = new FunctionCost((ICPPFunction)op, udcCost, point);
                        int cmp = udcFuncCost.compareTo(null, bestUdcCost);
                        if (cmp <= 0 && (cost = Conversions.isReferenceCompatible(cv1T1, SemanticUtil.getNestedType(t, 5), false, point)) != null) {
                            bestUdcCost = udcFuncCost;
                            ambiguousConversionOperator = cmp == 0;
                            operatorCost = cost;
                            operatorCost.setUserDefinedConversion(op);
                            if (illFormedIfLValue && isLValueRef) {
                                operatorCost = Cost.NO_CONVERSION;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        if (operatorCost != null && !ambiguousConversionOperator) {
            return operatorCost;
        }
        return null;
    }

    private static Cost nonReferenceConversion(IASTExpression.ValueCategory valueCat, IType source, IType target, UDCMode udc, IASTNode point) throws DOMException {
        if (source instanceof InitializerListType) {
            return Conversions.listInitializationSequence(((InitializerListType)source).getEvaluation(), target, udc, false, point);
        }
        IType uqTarget = SemanticUtil.getNestedType(target, 13);
        IType uqSource = SemanticUtil.getNestedType(source, 13);
        if (uqTarget instanceof ICPPClassType) {
            int depth;
            if (uqSource instanceof ICPPClassType && (depth = SemanticUtil.calculateInheritanceDepth(uqSource, uqTarget, point)) >= 0) {
                if (depth == 0) {
                    return new Cost(source, target, Cost.Rank.IDENTITY);
                }
                Cost cost = new Cost(source, target, Cost.Rank.CONVERSION);
                cost.setInheritanceDistance(depth);
                return cost;
            }
            if (udc == UDCMode.FORBIDDEN) {
                return Cost.NO_CONVERSION;
            }
            return Conversions.copyInitializationOfClass(valueCat, source, (ICPPClassType)uqTarget, udc == UDCMode.DEFER, point);
        }
        if (uqSource instanceof ICPPClassType) {
            if (udc == UDCMode.FORBIDDEN) {
                return Cost.NO_CONVERSION;
            }
            return Conversions.initializationByConversion(valueCat, source, (ICPPClassType)uqSource, target, udc == UDCMode.DEFER, point, false);
        }
        return Conversions.checkStandardConversionSequence(uqSource, target, point);
    }

    static ICPPField[] getFieldsForAggregateInitialization(ICPPClassType targetClass, IASTNode point) {
        ICPPField[] fields;
        ICPPField[] result = fields = ClassTypeHelper.getDeclaredFields(targetClass, point);
        int j = 0;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isStatic()) {
                if (fields == result) {
                    result = new ICPPField[fields.length - 1];
                    System.arraycopy(fields, 0, result, 0, i);
                }
            } else if (fields != result) {
                result[j] = fields[i];
                ++j;
            }
            ++i;
        }
        return ArrayUtil.trim(result);
    }

    static boolean checkAggregateInitialization(EvalInitList list, ICPPClassType targetClass, IASTNode point) throws DOMException {
        ICPPField[] fields = Conversions.getFieldsForAggregateInitialization(targetClass, point);
        ICPPEvaluation[] initializers = list.getClauses();
        if (initializers.length > fields.length) {
            return false;
        }
        int i = 0;
        while (i < initializers.length) {
            ICPPEvaluation initializer = initializers[i];
            ICPPField field = fields[i];
            Cost cost = Conversions.checkImplicitConversionSequence(field.getType(), initializer.getType(point), initializer.getValueCategory(point), UDCMode.ALLOWED, Context.ORDINARY, point);
            if (!cost.converts()) {
                return false;
            }
            if (!(initializer instanceof EvalInitList) && cost.isNarrowingConversion(point)) {
                return false;
            }
            ++i;
        }
        while (i < fields.length) {
            ICPPField field = fields[i];
            IValue initialValue = field.getInitialValue();
            if (initialValue == null) {
                IType fieldType = SemanticUtil.getNestedType(field.getType(), 1);
                if (fieldType instanceof ICPPReferenceType) {
                    return false;
                }
                EvalInitList emptyInit = new EvalInitList(ICPPEvaluation.EMPTY_ARRAY, point);
                Cost cost = Conversions.listInitializationSequence(emptyInit, fieldType, UDCMode.ALLOWED, false, point);
                if (!cost.converts()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    static Cost listInitializationSequence(EvalInitList arg, IType target, UDCMode udc, boolean isDirect, IASTNode point) throws DOMException {
        Cost result = Conversions.listInitializationSequenceHelper(arg, target, udc, isDirect, point);
        result.setListInitializationTarget(target);
        return result;
    }

    static Cost listInitializationSequenceHelper(EvalInitList arg, IType target, UDCMode udc, boolean isDirect, IASTNode point) throws DOMException {
        Number arraySize;
        IType listType = Conversions.getInitListType(target);
        if (listType == null && target instanceof IArrayType && (arraySize = ((IArrayType)target).getSize().numberValue()) != null) {
            IType elementType = ((IArrayType)target).getType();
            if ((long)arg.getClauses().length <= arraySize.longValue()) {
                listType = elementType;
            }
        }
        if (listType != null) {
            ICPPEvaluation[] clauses = arg.getClauses();
            Cost worstCost = new Cost(arg.getType(point), target, Cost.Rank.IDENTITY);
            ICPPEvaluation[] iCPPEvaluationArray = clauses;
            int n = clauses.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPEvaluation clause = iCPPEvaluationArray[n2];
                Cost cost = Conversions.checkImplicitConversionSequence(listType, clause.getType(point), clause.getValueCategory(point), UDCMode.ALLOWED, Context.ORDINARY, point);
                if (!cost.converts()) {
                    return cost;
                }
                if (cost.isNarrowingConversion(point)) {
                    cost.setRank(Cost.Rank.NO_MATCH);
                    return cost;
                }
                if (cost.compareTo(worstCost) > 0) {
                    worstCost = cost;
                }
                ++n2;
            }
            return worstCost;
        }
        IType noCVTarget = SemanticUtil.getNestedType(target, 9);
        if (noCVTarget instanceof ICPPClassType) {
            if (udc == UDCMode.FORBIDDEN) {
                return Cost.NO_CONVERSION;
            }
            ICPPClassType classTarget = (ICPPClassType)noCVTarget;
            if (TypeTraits.isAggregateClass(classTarget, point) && Conversions.checkAggregateInitialization(arg, classTarget, point)) {
                Cost cost = new Cost(arg.getType(point), target, Cost.Rank.IDENTITY);
                cost.setUserDefinedConversion(null);
                return cost;
            }
            return Conversions.listInitializationOfClass(arg, classTarget, isDirect, udc == UDCMode.DEFER, point);
        }
        ICPPEvaluation[] args = arg.getClauses();
        if (args.length == 1) {
            ICPPEvaluation firstArg = args[0];
            if (!firstArg.isInitializerList()) {
                Cost cost = Conversions.checkImplicitConversionSequence(target, firstArg.getType(point), firstArg.getValueCategory(point), udc, Context.ORDINARY, point);
                if (cost.isNarrowingConversion(point)) {
                    return Cost.NO_CONVERSION;
                }
                return cost;
            }
        } else if (args.length == 0) {
            return new Cost(arg.getType(point), target, Cost.Rank.IDENTITY);
        }
        return Cost.NO_CONVERSION;
    }

    static IType getInitListType(IType target) {
        ICPPTemplateArgument arg;
        ICPPTemplateArgument[] args;
        IBinding owner;
        ICPPTemplateInstance inst;
        if (target instanceof ICPPClassType && target instanceof ICPPTemplateInstance && CharArrayUtils.equals(INITIALIZER_LIST_NAME, (inst = (ICPPTemplateInstance)((Object)target)).getNameCharArray()) && (owner = inst.getOwner()) instanceof ICPPNamespace && CharArrayUtils.equals(STD_NAME, owner.getNameCharArray()) && owner.getOwner() == null && (args = inst.getTemplateArguments()).length == 1 && (arg = args[0]).isTypeValue()) {
            return arg.getTypeValue();
        }
        return null;
    }

    private static final int compareQualifications(IType t1, IType t2) {
        return SemanticUtil.getCVQualifier(t1).partialComparison(SemanticUtil.getCVQualifier(t2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int isReferenceRelated(IType cv1Target, IType cv2Source, IASTNode point) {
        IType t = SemanticUtil.getNestedType(cv1Target, 5);
        IType s = SemanticUtil.getNestedType(cv2Source, 5);
        if (t instanceof IPointerType) {
            if (!(s instanceof IPointerType)) return -1;
            t = SemanticUtil.getNestedType(((IPointerType)t).getType(), 5);
            s = SemanticUtil.getNestedType(((IPointerType)s).getType(), 5);
        } else if (t instanceof IArrayType) {
            IValue sv;
            if (!(s instanceof IArrayType)) return -1;
            IArrayType at = (IArrayType)t;
            IArrayType st = (IArrayType)s;
            IValue av = at.getSize();
            if (av != (sv = st.getSize()) && (av == null || !av.equals(sv))) return -1;
            t = SemanticUtil.getNestedType(at.getType(), 21);
            s = SemanticUtil.getNestedType(st.getType(), 21);
        } else {
            if (t instanceof IQualifierType) {
                t = SemanticUtil.getNestedType(((IQualifierType)t).getType(), 5);
            }
            if (s instanceof IQualifierType) {
                s = SemanticUtil.getNestedType(((IQualifierType)s).getType(), 5);
            }
            if (t instanceof ICPPClassType && s instanceof ICPPClassType) {
                return SemanticUtil.calculateInheritanceDepth(s, t, point);
            }
        }
        if (t != s && (t == null || s == null || !t.isSameType(s))) return -1;
        return 0;
    }

    private static final Cost isReferenceCompatible(IType cv1Target, IType cv2Source, boolean isImpliedObject, IASTNode point) {
        int inheritanceDist = Conversions.isReferenceRelated(cv1Target, cv2Source, point);
        if (inheritanceDist < 0) {
            return null;
        }
        int cmp = Conversions.compareQualifications(cv1Target, cv2Source);
        if (cmp < 0) {
            return null;
        }
        Cost cost = new Cost(cv2Source, cv1Target, Cost.Rank.IDENTITY);
        cost.setQualificationAdjustment(cmp);
        if (inheritanceDist > 0) {
            cost.setInheritanceDistance(inheritanceDist);
            cost.setRank(Cost.Rank.CONVERSION);
        }
        if (isImpliedObject) {
            cost.setImpliedObject();
        }
        return cost;
    }

    private static final Cost checkStandardConversionSequence(IType source, IType target, IASTNode point) {
        Cost cost = new Cost(source, target, Cost.Rank.IDENTITY);
        if (Conversions.lvalue_to_rvalue(cost)) {
            return cost;
        }
        if (Conversions.promotion(cost)) {
            return cost;
        }
        if (Conversions.conversion(cost, point)) {
            return cost;
        }
        if (Conversions.qualificationConversion(cost)) {
            return cost;
        }
        cost.setRank(Cost.Rank.NO_MATCH);
        return cost;
    }

    static Cost listInitializationOfClass(EvalInitList arg, ICPPClassType t, boolean isDirect, boolean deferUDC, IASTNode point) throws DOMException {
        Cost c;
        IBinding result;
        ICPPFunction[] constructors;
        ICPPFunction[] ctors;
        if (deferUDC) {
            Cost c2 = new Cost(arg.getType(point), t, Cost.Rank.USER_DEFINED_CONVERSION);
            c2.setDeferredUDC(isDirect ? Cost.DeferredUDC.DIRECT_LIST_INIT_OF_CLASS : Cost.DeferredUDC.LIST_INIT_OF_CLASS);
            return c2;
        }
        ICPPMethod usedCtor = null;
        Cost bestCost = null;
        boolean hasInitListConstructor = false;
        ICPPFunction[] iCPPFunctionArray = ctors = (constructors = ClassTypeHelper.getConstructors(t, point));
        int n = ctors.length;
        int n2 = 0;
        while (n2 < n) {
            IType target;
            IType[] parTypes;
            ICPPConstructor ctor = iCPPFunctionArray[n2];
            int minArgCount = ctor.getRequiredArgumentCount();
            if (minArgCount == 0) {
                if (arg.getClauses().length == 0) {
                    Cost c3 = new Cost(arg.getType(point), t, Cost.Rank.IDENTITY);
                    c3.setUserDefinedConversion(ctor);
                    return c3;
                }
            } else if (minArgCount <= 1 && (parTypes = ctor.getType().getParameterTypes()).length > 0 && Conversions.getInitListType(target = parTypes[0]) != null) {
                hasInitListConstructor = true;
                Cost cost = Conversions.listInitializationSequence(arg, target, UDCMode.FORBIDDEN, isDirect, point);
                if (cost.converts()) {
                    int cmp = cost.compareTo(bestCost);
                    if (bestCost == null || cmp < 0) {
                        usedCtor = ctor;
                        cost.setUserDefinedConversion(ctor);
                        bestCost = cost;
                    } else if (cmp == 0) {
                        bestCost.setAmbiguousUDC(true);
                    }
                }
            }
            ++n2;
        }
        if (hasInitListConstructor) {
            if (bestCost == null) {
                return Cost.NO_CONVERSION;
            }
            if (!bestCost.isAmbiguousUDC() && !isDirect && usedCtor != null && usedCtor.isExplicit()) {
                bestCost.setRank(Cost.Rank.NO_MATCH);
            }
            bestCost.setListInitializationTarget(t);
            return bestCost;
        }
        LookupData data = new LookupData(t.getNameCharArray(), null, point);
        ICPPEvaluation[] expandedArgs = arg.getClauses();
        data.setFunctionArguments(false, expandedArgs);
        data.fNoNarrowing = true;
        ICPPFunction[] filteredConstructors = constructors;
        if (expandedArgs.length == 1) {
            filteredConstructors = new ICPPConstructor[constructors.length];
            int j = 0;
            ICPPFunction[] iCPPFunctionArray2 = constructors;
            int n3 = constructors.length;
            int n4 = 0;
            while (n4 < n3) {
                IType ptype;
                IType[] ptypes;
                ICPPFunction ctor = iCPPFunctionArray2[n4];
                if (ctor.getRequiredArgumentCount() < 2 && (ptypes = ctor.getType().getParameterTypes()).length > 0 && !t.isSameType(ptype = SemanticUtil.getNestedType(ptypes[0], 13))) {
                    filteredConstructors[j++] = ctor;
                }
                ++n4;
            }
        }
        if ((result = CPPSemantics.resolveFunction(data, filteredConstructors, true, false)) instanceof ICPPMethod) {
            c = new Cost(arg.getType(point), t, Cost.Rank.IDENTITY);
            c.setUserDefinedConversion((ICPPMethod)result);
        } else if (result instanceof IProblemBinding && ((IProblemBinding)result).getID() == 4) {
            c = new Cost(arg.getType(point), t, Cost.Rank.USER_DEFINED_CONVERSION);
            c.setAmbiguousUDC(true);
        } else {
            c = Cost.NO_CONVERSION;
        }
        c.setListInitializationTarget(t);
        return c;
    }

    static final Cost copyInitializationOfClass(IASTExpression.ValueCategory valueCat, IType source, ICPPClassType t, boolean deferUDC, IASTNode point) throws DOMException {
        if (deferUDC) {
            Cost c = new Cost(source, t, Cost.Rank.USER_DEFINED_CONVERSION);
            c.setDeferredUDC(Cost.DeferredUDC.COPY_INIT_OF_CLASS);
            return c;
        }
        FunctionCost cost1 = null;
        Cost cost2 = null;
        ICPPFunction[] ctors = ClassTypeHelper.getConstructors(t, point);
        ICPPFunction[] iCPPFunctionArray = ctors = CPPTemplates.instantiateForFunctionCall(ctors, null, Collections.singletonList(source), Collections.singletonList(valueCat), false, point);
        int n = ctors.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                FunctionCost c1;
                ICPPConstructor ctor;
                block16: {
                    IType[] ptypes;
                    block15: {
                        ICPPFunction f = iCPPFunctionArray[n2];
                        if (!(f instanceof ICPPConstructor) || f instanceof IProblemBinding || (ctor = (ICPPConstructor)f).isExplicit()) break block14;
                        ICPPFunctionType ft = ctor.getType();
                        ptypes = ft.getParameterTypes();
                        if (ptypes.length != 0) break block15;
                        if (!ctor.takesVarArgs()) break block14;
                        c1 = new FunctionCost((ICPPFunction)ctor, new Cost(source, null, Cost.Rank.ELLIPSIS_CONVERSION), point);
                        break block16;
                    }
                    IType ptype = SemanticUtil.getNestedType(ptypes[0], 1);
                    if (SemanticUtil.isVoidType(ptype) || ctor.getRequiredArgumentCount() > 1) break block14;
                    c1 = new FunctionCost((ICPPFunction)ctor, Conversions.checkImplicitConversionSequence(ptype, source, valueCat, UDCMode.FORBIDDEN, Context.ORDINARY, point), point);
                }
                int cmp = c1.compareTo(null, cost1);
                if (cmp <= 0) {
                    cost1 = c1;
                    cost2 = new Cost(t, t, Cost.Rank.IDENTITY);
                    cost2.setUserDefinedConversion(ctor);
                    if (cmp == 0) {
                        cost2.setAmbiguousUDC(true);
                    }
                }
            }
            ++n2;
        }
        IType uqSource = SemanticUtil.getNestedType(source, 13);
        if (uqSource instanceof ICPPClassType) {
            ICPPFunction[] ops = SemanticUtil.getConversionOperators((ICPPClassType)uqSource, point);
            ICPPFunction[] iCPPFunctionArray2 = ops = CPPTemplates.instantiateConversionTemplates(ops, t, point);
            int n3 = ops.length;
            int n4 = 0;
            while (n4 < n3) {
                IType implicitType;
                Cost udcCost;
                IType returnType;
                IType uqReturnType;
                int dist;
                ICPPMethod op;
                ICPPFunction f = iCPPFunctionArray2[n4];
                if (f instanceof ICPPMethod && !(f instanceof IProblemBinding) && !(op = (ICPPMethod)f).isExplicit() && (dist = SemanticUtil.calculateInheritanceDepth(uqReturnType = SemanticUtil.getNestedType(returnType = op.getType().getReturnType(), 13), t, point)) >= 0 && (udcCost = Conversions.isReferenceCompatible(SemanticUtil.getNestedType(implicitType = CPPSemantics.getImplicitParameterType(op), 5), source, true, point)) != null) {
                    udcCost.setReferenceBinding(Cost.ReferenceBinding.LVALUE_REF);
                    FunctionCost c1 = new FunctionCost((ICPPFunction)op, udcCost, point);
                    int cmp = c1.compareTo(null, cost1);
                    if (cmp <= 0) {
                        cost1 = c1;
                        cost2 = new Cost(t, t, Cost.Rank.IDENTITY);
                        if (dist > 0) {
                            cost2.setInheritanceDistance(dist);
                            cost2.setRank(Cost.Rank.CONVERSION);
                        }
                        cost2.setUserDefinedConversion(op);
                        if (cmp == 0) {
                            cost2.setAmbiguousUDC(true);
                        }
                    }
                }
                ++n4;
            }
        }
        if (cost1 == null || !cost1.getCost(0).converts()) {
            return Cost.NO_CONVERSION;
        }
        return cost2;
    }

    static Cost initializationByConversion(IASTExpression.ValueCategory valueCat, IType source, ICPPClassType uqSource, IType target, boolean deferUDC, IASTNode point, boolean allowExplicitConversion) throws DOMException {
        if (deferUDC) {
            Cost c = new Cost(source, target, Cost.Rank.USER_DEFINED_CONVERSION);
            c.setDeferredUDC(Cost.DeferredUDC.INIT_BY_CONVERSION);
            return c;
        }
        ICPPFunction[] ops = SemanticUtil.getConversionOperators(uqSource, point);
        ops = CPPTemplates.instantiateConversionTemplates(ops, target, point);
        FunctionCost cost1 = null;
        Cost cost2 = null;
        ICPPFunction[] iCPPFunctionArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPFunction f = iCPPFunctionArray[n2];
            if (f instanceof ICPPMethod && !(f instanceof IProblemBinding)) {
                IType implicitType;
                Cost udcCost;
                ICPPFunctionType functionType;
                IType returnType;
                IType uqReturnType;
                Cost c2;
                boolean isExplicitConversion;
                ICPPMethod op = (ICPPMethod)f;
                boolean bl = isExplicitConversion = op.isExplicit() && !allowExplicitConversion;
                if (!(isExplicitConversion || !(c2 = Conversions.checkImplicitConversionSequence(target, uqReturnType = SemanticUtil.getNestedType(returnType = (functionType = op.getType()).getReturnType(), 17), ExpressionTypes.valueCategoryFromReturnType(uqReturnType), UDCMode.FORBIDDEN, Context.ORDINARY, point)).converts() || isExplicitConversion && c2.getRank() != Cost.Rank.IDENTITY || (udcCost = Conversions.isReferenceCompatible(SemanticUtil.getNestedType(implicitType = CPPSemantics.getImplicitParameterType(op), 5), source, true, point)) == null)) {
                    if (functionType.hasRefQualifier() && functionType.isRValueReference()) {
                        udcCost.setReferenceBinding(Cost.ReferenceBinding.RVALUE_REF_BINDS_RVALUE);
                    } else {
                        udcCost.setReferenceBinding(Cost.ReferenceBinding.LVALUE_REF);
                    }
                    FunctionCost c1 = new FunctionCost((ICPPFunction)op, udcCost, point);
                    int cmp = c1.compareTo(null, cost1);
                    if (cmp <= 0) {
                        cost1 = c1;
                        cost2 = c2;
                        cost2.setUserDefinedConversion(op);
                        if (cmp == 0) {
                            cost2.setAmbiguousUDC(true);
                        }
                    }
                }
            }
            ++n2;
        }
        if (cost1 == null || !cost1.getCost(0).converts()) {
            return Cost.NO_CONVERSION;
        }
        return cost2;
    }

    private static final boolean lvalue_to_rvalue(Cost cost) {
        IType target = SemanticUtil.getNestedType(cost.target, 21);
        IType source = SemanticUtil.getNestedType(cost.source, 5);
        if (source instanceof IArrayType) {
            if (target instanceof IPointerType) {
                source = Conversions.unqualifyStringLiteral(source, (IPointerType)target, cost);
            }
            if (!(source instanceof IPointerType)) {
                source = new CPPPointerType(SemanticUtil.getNestedType(((IArrayType)source).getType(), 1));
            }
        } else if (source instanceof IFunctionType) {
            source = new CPPPointerType(source);
        } else {
            if (source instanceof IPointerType && target instanceof IPointerType) {
                source = Conversions.unqualifyStringLiteral(source, (IPointerType)target, cost);
            }
            source = SemanticUtil.getNestedType(source, 21);
        }
        if (source == null || target == null) {
            cost.setRank(Cost.Rank.NO_MATCH);
            return true;
        }
        cost.source = source;
        cost.target = target;
        return source.isSameType(target);
    }

    private static IType unqualifyStringLiteral(IType source, IPointerType target, Cost cost) {
        if (target instanceof ICPPPointerToMemberType) {
            return source;
        }
        IType targetPtrTgt = SemanticUtil.getNestedType(target.getType(), 1);
        if (targetPtrTgt instanceof IQualifierType && ((IQualifierType)targetPtrTgt).isConst()) {
            return source;
        }
        IType srcTarget = ((ITypeContainer)source).getType();
        if (!(srcTarget instanceof IQualifierType)) {
            return source;
        }
        IQualifierType srcQTarget = (IQualifierType)srcTarget;
        if (srcQTarget.isConst() && !srcQTarget.isVolatile() && (srcTarget = srcQTarget.getType()) instanceof CPPBasicType && ((CPPBasicType)srcTarget).isFromStringLiteral()) {
            source = new CPPPointerType(srcTarget, false, false, false);
            CVQualifier cvqTarget = SemanticUtil.getCVQualifier(targetPtrTgt).add(CVQualifier.CONST);
            cost.setQualificationAdjustment(cvqTarget.partialComparison(CVQualifier.NONE) << 3);
        }
        return source;
    }

    private static final boolean qualificationConversion(Cost cost) {
        int cmp;
        IType s = cost.source;
        IType t = cost.target;
        boolean constInEveryCV2k = true;
        boolean firstPointer = true;
        int adjustments = 0;
        int shift = 0;
        while (true) {
            s = SemanticUtil.getNestedType(s, 5);
            t = SemanticUtil.getNestedType(t, 5);
            if (!(s instanceof IPointerType) || !(t instanceof IPointerType)) break;
            cmp = Conversions.compareQualifications(t, s);
            if (cmp < 0 || cmp > 0 && !constInEveryCV2k) {
                return false;
            }
            IPointerType sPtr = (IPointerType)s;
            IPointerType tPtr = (IPointerType)t;
            if (Conversions.haveMemberPtrConflict(sPtr, tPtr)) {
                return false;
            }
            constInEveryCV2k &= firstPointer || tPtr.isConst();
            s = sPtr.getType();
            t = tPtr.getType();
            firstPointer = false;
            adjustments |= cmp << shift;
            shift += 3;
        }
        cmp = Conversions.compareQualifications(t, s);
        if (cmp < 0 || cmp > 0 && !constInEveryCV2k) {
            return false;
        }
        s = SemanticUtil.getNestedType(s, 21);
        t = SemanticUtil.getNestedType(t, 21);
        if ((adjustments |= cmp << shift) > 0) {
            cost.setQualificationAdjustment(adjustments);
        }
        return s != null && t != null && s.isSameType(t);
    }

    private static boolean haveMemberPtrConflict(IPointerType s, IPointerType t) {
        boolean sIsPtrToMember = s instanceof ICPPPointerToMemberType;
        boolean tIsPtrToMember = t instanceof ICPPPointerToMemberType;
        if (sIsPtrToMember != tIsPtrToMember) {
            return true;
        }
        if (sIsPtrToMember) {
            IType sMemberOf = ((ICPPPointerToMemberType)s).getMemberOfClass();
            IType tMemberOf = ((ICPPPointerToMemberType)t).getMemberOfClass();
            if (sMemberOf == null || tMemberOf == null || !sMemberOf.isSameType(tMemberOf)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final boolean promotion(Cost cost) {
        boolean canPromote;
        block17: {
            IBasicType.Kind tKind;
            IBasicType basicTgt;
            IType src;
            block18: {
                IType fixedType;
                IType trg;
                block19: {
                    src = cost.source;
                    trg = cost.target;
                    canPromote = false;
                    if (!(trg instanceof IBasicType)) break block17;
                    basicTgt = (IBasicType)trg;
                    tKind = basicTgt.getKind();
                    if (!(src instanceof ICPPEnumeration)) break block18;
                    ICPPEnumeration enumType = (ICPPEnumeration)src;
                    if (enumType.isScoped()) {
                        return false;
                    }
                    fixedType = enumType.getFixedType();
                    if (fixedType != null) break block19;
                    if (tKind == IBasicType.Kind.eInt || tKind == IBasicType.Kind.eUnspecified) {
                        if (trg instanceof ICPPBasicType) {
                            int targetModifiers;
                            int qualifiers = ArithmeticConversion.getEnumIntTypeModifiers((IEnumeration)src);
                            if (qualifiers == ((targetModifiers = ((ICPPBasicType)trg).getModifiers()) & 0x4B)) {
                                canPromote = true;
                            }
                            break block18;
                        } else {
                            canPromote = true;
                        }
                    }
                    break block18;
                }
                if (fixedType.isSameType(trg)) {
                    canPromote = true;
                }
                src = fixedType;
            }
            if (src instanceof IBasicType) {
                IBasicType basicSrc = (IBasicType)src;
                IBasicType.Kind sKind = basicSrc.getKind();
                if (tKind == IBasicType.Kind.eInt) {
                    if (!(basicTgt.isLong() || basicTgt.isLongLong() || basicTgt.isShort())) {
                        switch (sKind) {
                            case eInt: {
                                if (!basicSrc.isShort() || basicTgt.isUnsigned()) break;
                                canPromote = true;
                                break;
                            }
                            case eUnspecified: 
                            case eChar: 
                            case eWChar: 
                            case eBoolean: 
                            case eChar16: {
                                if (basicTgt.isUnsigned()) break;
                                canPromote = true;
                                break;
                            }
                            case eChar32: {
                                if (!basicTgt.isUnsigned()) break;
                                canPromote = true;
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (tKind == IBasicType.Kind.eDouble && sKind == IBasicType.Kind.eFloat) {
                    canPromote = true;
                }
            }
        }
        if (canPromote) {
            cost.setRank(Cost.Rank.PROMOTION);
            return true;
        }
        return false;
    }

    private static final boolean conversion(Cost cost, IASTNode point) {
        IType s = cost.source;
        IType t = cost.target;
        if (t instanceof IBasicType) {
            IBasicType.Kind tgtKind = ((IBasicType)t).getKind();
            if (s instanceof IBasicType) {
                IBasicType.Kind srcKind = ((IBasicType)s).getKind();
                if (srcKind == IBasicType.Kind.eVoid) {
                    return false;
                }
                if (srcKind == IBasicType.Kind.eNullPtr && tgtKind != IBasicType.Kind.eBoolean) {
                    return false;
                }
                if (tgtKind == IBasicType.Kind.eNullPtr && !Conversions.isNullPointerConstant(s)) {
                    return false;
                }
                cost.setRank(Cost.Rank.CONVERSION);
                if (srcKind != IBasicType.Kind.eNullPtr && tgtKind != IBasicType.Kind.eNullPtr) {
                    cost.setCouldNarrow();
                }
                return true;
            }
            if (s instanceof ICPPEnumeration && !((ICPPEnumeration)s).isScoped()) {
                cost.setRank(Cost.Rank.CONVERSION);
                cost.setCouldNarrow();
                return true;
            }
            if (tgtKind == IBasicType.Kind.eBoolean && s instanceof IPointerType) {
                cost.setRank(Cost.Rank.CONVERSION_PTR_BOOL);
                return true;
            }
        }
        if (t instanceof IPointerType) {
            IPointerType tgtPtr = (IPointerType)t;
            if (s instanceof IBasicType) {
                if (Conversions.isNullPointerConstant(s)) {
                    cost.setRank(Cost.Rank.CONVERSION);
                    return true;
                }
                return false;
            }
            if (s instanceof IPointerType) {
                IPointerType srcPtr = (IPointerType)s;
                IType tgtPtrTgt = SemanticUtil.getNestedType(tgtPtr.getType(), 13);
                if (SemanticUtil.isVoidType(tgtPtrTgt)) {
                    cost.setRank(Cost.Rank.CONVERSION);
                    cost.setInheritanceDistance(Short.MAX_VALUE);
                    CVQualifier cv = SemanticUtil.getCVQualifier(srcPtr.getType());
                    cost.source = new CPPPointerType(SemanticUtil.addQualifiers(CPPSemantics.VOID_TYPE, cv.isConst(), cv.isVolatile(), cv.isRestrict()));
                    return false;
                }
                boolean tIsPtrToMember = t instanceof ICPPPointerToMemberType;
                boolean sIsPtrToMember = s instanceof ICPPPointerToMemberType;
                if (!tIsPtrToMember && !sIsPtrToMember) {
                    IType srcPtrTgt = SemanticUtil.getNestedType(srcPtr.getType(), 13);
                    if (tgtPtrTgt instanceof ICPPClassType && srcPtrTgt instanceof ICPPClassType) {
                        int depth = SemanticUtil.calculateInheritanceDepth(srcPtrTgt, tgtPtrTgt, point);
                        if (depth == -1) {
                            cost.setRank(Cost.Rank.NO_MATCH);
                            return true;
                        }
                        if (depth > 0) {
                            cost.setRank(Cost.Rank.CONVERSION);
                            cost.setInheritanceDistance(depth);
                            CVQualifier cv = SemanticUtil.getCVQualifier(srcPtr.getType());
                            cost.source = new CPPPointerType(SemanticUtil.addQualifiers(tgtPtrTgt, cv.isConst(), cv.isVolatile(), cv.isRestrict()));
                        }
                        return false;
                    }
                } else if (tIsPtrToMember && sIsPtrToMember) {
                    ICPPPointerToMemberType spm = (ICPPPointerToMemberType)s;
                    ICPPPointerToMemberType tpm = (ICPPPointerToMemberType)t;
                    IType st = spm.getType();
                    IType tt = tpm.getType();
                    if (st != null && tt != null && st.isSameType(tt)) {
                        int depth = SemanticUtil.calculateInheritanceDepth(tpm.getMemberOfClass(), spm.getMemberOfClass(), point);
                        if (depth == -1) {
                            cost.setRank(Cost.Rank.NO_MATCH);
                            return true;
                        }
                        if (depth > 0) {
                            cost.setRank(Cost.Rank.CONVERSION);
                            cost.setInheritanceDistance(depth);
                            cost.source = new CPPPointerToMemberType(spm.getType(), tpm.getMemberOfClass(), spm.isConst(), spm.isVolatile(), spm.isRestrict());
                        }
                        return false;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isNullPointerConstant(IType s) {
        if (s instanceof CPPBasicType) {
            CPPBasicType basicType = (CPPBasicType)s;
            if (basicType.getKind() == IBasicType.Kind.eNullPtr) {
                return true;
            }
            Long val = basicType.getAssociatedNumericalValue();
            if (val != null && val == 0L) {
                return true;
            }
        }
        return false;
    }

    public static IType lvalue_to_rvalue(IType type, boolean resolveTypedefs) {
        IType t = SemanticUtil.getNestedType(type, 5);
        if (t instanceof IArrayType) {
            return new CPPPointerType(((IArrayType)t).getType());
        }
        if (t instanceof IFunctionType) {
            return new CPPPointerType(t);
        }
        IType uqType = SemanticUtil.getNestedType(t, 21);
        if (uqType instanceof ICPPClassType) {
            return resolveTypedefs ? t : SemanticUtil.getNestedType(type, 6);
        }
        return resolveTypedefs ? uqType : SemanticUtil.getNestedType(type, 22);
    }

    public static IType compositePointerType(IType t1, IType t2, IASTNode point) {
        t1 = SemanticUtil.getNestedType(t1, 1);
        t2 = SemanticUtil.getNestedType(t2, 1);
        boolean isPtr1 = t1 instanceof IPointerType;
        if ((isPtr1 || Conversions.isNullPtr(t1)) && Conversions.isNullPointerConstant(t2)) {
            return t1;
        }
        boolean isPtr2 = t2 instanceof IPointerType;
        if ((isPtr2 || Conversions.isNullPtr(t2)) && Conversions.isNullPointerConstant(t1)) {
            return t2;
        }
        if (!isPtr1 || !isPtr2) {
            return null;
        }
        IPointerType p1 = (IPointerType)t1;
        IPointerType p2 = (IPointerType)t2;
        if (Conversions.haveMemberPtrConflict(p1, p2)) {
            return null;
        }
        IType target1 = p1.getType();
        if (SemanticUtil.isVoidType(target1)) {
            return SemanticUtil.addQualifiers(p1, p2.isConst(), p2.isVolatile(), p2.isRestrict());
        }
        IType target2 = p2.getType();
        if (SemanticUtil.isVoidType(target2)) {
            return SemanticUtil.addQualifiers(p2, p1.isConst(), p1.isVolatile(), p1.isRestrict());
        }
        IType t = Conversions.mergePointers(target1, target2, point, true, true);
        if (t == null) {
            return null;
        }
        if (t == target1) {
            return p1;
        }
        if (t == target2) {
            return p2;
        }
        return Conversions.copyPointer(p1, t, false, false);
    }

    private static IType mergePointers(IType t1, IType t2, IASTNode point, boolean allcq, boolean allowInheritance) {
        t1 = SemanticUtil.getNestedType(t1, 5);
        t2 = SemanticUtil.getNestedType(t2, 5);
        if (t1 instanceof IPointerType && t2 instanceof IPointerType) {
            IPointerType p1 = (IPointerType)t1;
            IPointerType p2 = (IPointerType)t2;
            CVQualifier cv1 = SemanticUtil.getCVQualifier(t1);
            CVQualifier cv2 = SemanticUtil.getCVQualifier(t2);
            if (Conversions.haveMemberPtrConflict(p1, p2)) {
                return null;
            }
            if (!allcq && cv1 != cv2) {
                return null;
            }
            IType p1target = p1.getType();
            IType merged = Conversions.mergePointers(p1target, p2.getType(), point, allcq && (cv1.isConst() || cv2.isConst()), false);
            if (merged == null) {
                return null;
            }
            if (p1target == merged && cv1.isAtLeastAsQualifiedAs(cv2)) {
                return p1;
            }
            if (p2.getType() == merged && cv2.isAtLeastAsQualifiedAs(cv1)) {
                return p2;
            }
            return Conversions.copyPointer(p1, merged, cv1.isConst() || cv2.isConst(), cv1.isVolatile() || cv2.isVolatile());
        }
        IType uq1 = SemanticUtil.getNestedType(t1, 13);
        IType uq2 = SemanticUtil.getNestedType(t2, 13);
        if (uq1 == null) {
            return null;
        }
        if (uq1.isSameType(uq2)) {
            CVQualifier cv2;
            if (uq1 == t1 && uq2 == t2) {
                return t1;
            }
            CVQualifier cv1 = SemanticUtil.getCVQualifier(t1);
            if (cv1 == (cv2 = SemanticUtil.getCVQualifier(t2))) {
                return t1;
            }
            if (!allcq) {
                return null;
            }
            if (cv1.isAtLeastAsQualifiedAs(cv2)) {
                return t1;
            }
            if (cv2.isAtLeastAsQualifiedAs(cv1)) {
                return t2;
            }
            return new CPPQualifierType(uq1, true, true);
        }
        if (allowInheritance) {
            IType base;
            if (SemanticUtil.calculateInheritanceDepth(uq1, uq2, point) > 0) {
                base = uq2;
            } else if (SemanticUtil.calculateInheritanceDepth(uq2, uq1, point) > 0) {
                base = uq1;
            } else {
                return null;
            }
            CVQualifier cv1 = SemanticUtil.getCVQualifier(t1);
            CVQualifier cv2 = SemanticUtil.getCVQualifier(t2);
            if (cv1 == CVQualifier.NONE && cv2 == CVQualifier.NONE) {
                return base;
            }
            return new CPPQualifierType(base, cv1.isConst() || cv2.isConst(), cv1.isVolatile() || cv2.isVolatile());
        }
        return null;
    }

    public static IType copyPointer(IPointerType p1, IType target, boolean isConst, boolean isVolatile) {
        if (p1 instanceof ICPPPointerToMemberType) {
            ICPPPointerToMemberType ptm = (ICPPPointerToMemberType)p1;
            return new CPPPointerToMemberType(target, ptm.getMemberOfClass(), isConst, isVolatile, false);
        }
        return new CPPPointerType(target, isConst, isVolatile, false);
    }

    private static boolean isNullPtr(IType t1) {
        return t1 instanceof IBasicType && ((IBasicType)t1).getKind() == IBasicType.Kind.eNullPtr;
    }

    public static enum Context {
        ORDINARY,
        IMPLICIT_OBJECT_FOR_METHOD_WITHOUT_REF_QUALIFIER,
        IMPLICIT_OBJECT_FOR_METHOD_WITH_REF_QUALIFIER,
        FIRST_PARAM_OF_DIRECT_COPY_CTOR,
        REQUIRE_DIRECT_BINDING;

    }

    public static enum UDCMode {
        ALLOWED,
        FORBIDDEN,
        DEFER;

    }
}

