/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Transaction;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterUtil;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.DiagramEditorAdapter;
import org.eclipse.bpmn2.modeler.core.utils.Messages;
import org.eclipse.bpmn2.modeler.core.utils.StringWrapper;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.bpmn2.provider.Bpmn2EditPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;

public class ModelUtil {
    public static HashMap<Object, Hashtable<String, EObject>> ids = new HashMap();
    public static HashMap<String, Integer> defaultIds = new HashMap();

    public static void clearIDs(Resource res, boolean all) {
        ids.remove(ModelUtil.getKey(res));
        if (all) {
            defaultIds.clear();
        }
    }

    private static String getObjectName(EObject obj) {
        String name;
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("bpmnElement");
        if (feature != null && obj.eGet(feature) != null) {
            EObject bpmnElement = (EObject)obj.eGet(feature);
            name = String.valueOf(obj.eClass().getName()) + "_" + bpmnElement.eClass().getName();
        } else {
            name = obj.eClass().getName();
        }
        return name;
    }

    private static Object getKey(EObject obj) {
        Resource resource = ExtendedPropertiesAdapter.getResource((Notifier)obj);
        if (resource == null) {
            return null;
        }
        Assert.isTrue((obj != null ? 1 : 0) != 0);
        return ModelUtil.getKey(resource);
    }

    private static Object getKey(Resource res) {
        Assert.isTrue((res != null ? 1 : 0) != 0);
        String key = null;
        if (res.getResourceSet() != null) {
            key = Integer.toString(res.getResourceSet().hashCode());
            key = String.valueOf(key) + "-" + res.getResourceSet().getResources().indexOf((Object)res);
        } else {
            key = Integer.toString(res.hashCode());
        }
        return key;
    }

    private static String generateDefaultID(EObject obj, String name) {
        Integer value;
        if (name == null) {
            name = ModelUtil.getObjectName(obj);
        }
        if ((value = defaultIds.get(name)) == null) {
            value = 1;
        }
        value = value + 1;
        defaultIds.put(name, (int)value);
        return "_" + name + "_" + value;
    }

    private static String generateID(EObject obj, Resource res) {
        return ModelUtil.generateID(obj, res, null);
    }

    public static String generateID(EObject obj, Resource res, String name) {
        Object key;
        if (res == null) {
            res = ExtendedPropertiesAdapter.getResource((Notifier)obj);
        }
        Object object = key = res == null ? ModelUtil.getKey(obj) : ModelUtil.getKey(res);
        if (key != null) {
            Hashtable<String, Object> tab = ids.get(key);
            if (tab == null) {
                tab = new Hashtable();
                ids.put(key, tab);
            }
            String id = name;
            if (name == null) {
                name = ModelUtil.getObjectName(obj);
                id = String.valueOf(name) + "_" + 1;
            }
            int i = 1;
            while (true) {
                if (tab.get(id) == null) {
                    tab.put(id, obj);
                    return id;
                }
                id = String.valueOf(name) + "_" + i;
                ++i;
            }
        }
        return ModelUtil.generateDefaultID(obj, name);
    }

    public static void unsetID(EObject obj, Resource resource) {
        Object value;
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("id");
        if (feature != null && (value = obj.eGet(feature)) instanceof String) {
            Hashtable<String, EObject> tab;
            String id = (String)value;
            Object key = ModelUtil.getKey(resource);
            if (key != null && (tab = ids.get(key)) != null) {
                tab.remove(id);
            }
        }
    }

    public static void addID(EObject obj) {
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("id");
        if (feature != null) {
            Object value = obj.eGet(feature);
            if (value != null) {
                ModelUtil.addID(obj, (String)value);
            } else {
                ModelUtil.setID(obj);
            }
        }
    }

    public static void addID(EObject obj, String id) {
        Object key = ModelUtil.getKey(obj);
        String name = ModelUtil.getObjectName(obj);
        if (key == null || id.startsWith("_" + name + "_")) {
            Integer oldValue;
            int newValue = 0;
            try {
                int i = id.lastIndexOf(95) + 1;
                if (i < id.length()) {
                    newValue = Integer.parseInt(id.substring(i));
                }
            }
            catch (Exception exception) {}
            if ((oldValue = defaultIds.get(name)) == null || newValue > oldValue) {
                defaultIds.put(name, newValue);
            }
        } else {
            Hashtable<String, Object> tab = ids.get(key);
            if (tab == null) {
                tab = new Hashtable();
                ids.put(key, tab);
            }
            tab.put(id, obj);
        }
    }

    public static String setID(EObject obj) {
        return ModelUtil.setID(obj, ExtendedPropertiesAdapter.getResource((Notifier)obj));
    }

    public static String setID(EObject obj, Resource res) {
        EStructuralFeature feature;
        String id = null;
        if (obj != null && (feature = obj.eClass().getEStructuralFeature("id")) != null && obj.eGet(feature) == null) {
            id = ModelUtil.generateID(obj, res);
            obj.eSet(feature, (Object)id);
        }
        return id;
    }

    public static String getID(EObject obj) {
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("id");
        if (feature != null) {
            return (String)obj.eGet(feature);
        }
        return null;
    }

    public static String generateUndefinedID(String base) {
        String name = "undefined";
        if (base.contains("_")) {
            return "<" + name + "_" + base.replaceFirst(".*_", "") + ">";
        }
        Integer value = defaultIds.get(name);
        if (value == null) {
            value = 1;
        }
        value = value + 1;
        defaultIds.put(name, (int)value);
        return "<" + name + "_" + value + ">";
    }

    public static int getIDNumber(String id) {
        try {
            int i = id.lastIndexOf("_");
            return Integer.parseInt(id.substring(i + 1));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String getName(BaseElement element) {
        if (element != null) {
            Object value;
            EStructuralFeature feature = element.eClass().getEStructuralFeature("name");
            if (feature == null) {
                feature = ModelDecorator.getAnyAttribute((EObject)element, "name");
            }
            if (feature != null && (value = element.eGet(feature)) instanceof String) {
                return (String)value;
            }
        }
        return null;
    }

    public static boolean hasName(BaseElement obj) {
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("name");
        if (feature == null) {
            feature = ModelDecorator.getAnyAttribute((EObject)obj, "name");
        }
        return feature != null;
    }

    public static String getCanonicalName(BaseElement element) {
        if (element == null) {
            return "";
        }
        String name = ModelUtil.getName(element);
        if (name == null || name.isEmpty()) {
            name = element.getId();
        }
        return name;
    }

    public static String toCanonicalString(String anyName) {
        anyName = anyName.replaceAll("Impl$", "");
        String displayName = "";
        boolean first = true;
        char[] chars = anyName.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (Character.isUpperCase(c) && displayName.length() > 0 && i + 1 < chars.length && !Character.isUpperCase(chars[i + 1])) {
                displayName = String.valueOf(displayName) + " ";
            }
            if (first) {
                c = Character.toUpperCase(c);
                first = false;
            }
            if (!Character.isLetterOrDigit(c)) {
                c = ' ';
            }
            if (c == ' ') {
                first = true;
            }
            displayName = String.valueOf(displayName) + c;
            ++i;
        }
        return displayName.trim();
    }

    public static String toCanonicalString(EObject object) {
        Object qName;
        EStructuralFeature feature;
        if (object == null) {
            return "";
        }
        String objName = null;
        if (object instanceof BPMNDiagram) {
            Bpmn2DiagramType type = ModelUtil.getDiagramType((BPMNDiagram)object);
            if (type == Bpmn2DiagramType.CHOREOGRAPHY) {
                objName = Messages.ModelUtil_Choreography_Diagram;
            } else if (type == Bpmn2DiagramType.COLLABORATION) {
                objName = Messages.ModelUtil_Collaboration_Diagram;
            } else if (type == Bpmn2DiagramType.PROCESS) {
                objName = Messages.ModelUtil_Process_Diagram;
            }
        }
        if (objName == null) {
            objName = ModelUtil.toCanonicalString(object.eClass().getName());
        }
        if ((feature = object.eClass().getEStructuralFeature("name")) != null) {
            String name = (String)object.eGet(feature);
            name = name == null || name.isEmpty() ? NLS.bind((String)Messages.ModelUtil_Unnamed_Object, (Object)objName) : String.valueOf(objName) + " \"" + name + "\"";
            return name;
        }
        feature = object.eClass().getEStructuralFeature("id");
        if (feature != null) {
            String id = (String)object.eGet(feature);
            id = id == null || id.isEmpty() ? String.valueOf(Messages.ModelUtil_Unknown_Object) + objName : String.valueOf(objName) + " \"" + id + "\"";
            return id;
        }
        feature = object.eClass().getEStructuralFeature("qName");
        if (feature != null && (qName = object.eGet(feature)) != null) {
            return qName.toString();
        }
        return objName;
    }

    public static List<EventDefinition> getEventDefinitions(Event event) {
        EStructuralFeature feature;
        if (event != null && (feature = event.eClass().getEStructuralFeature("eventDefinitions")) != null) {
            return (List)event.eGet(feature);
        }
        return new ArrayList<EventDefinition>();
    }

    public static boolean hasEventDefinition(Event event, Class<?> clazz) {
        for (EventDefinition def : ModelUtil.getEventDefinitions(event)) {
            if (!clazz.isInstance(def)) continue;
            return true;
        }
        return false;
    }

    public static EventDefinition getEventDefinition(Event event, Class<?> clazz) {
        for (EventDefinition def : ModelUtil.getEventDefinitions(event)) {
            if (!clazz.isInstance(def)) continue;
            return def;
        }
        return null;
    }

    public static Bpmn2ModelerResourceSetImpl slightlyHackedResourceSet(ResourceSet resourceSet) {
        if (resourceSet instanceof Bpmn2ModelerResourceSetImpl) {
            return (Bpmn2ModelerResourceSetImpl)resourceSet;
        }
        Map map = resourceSet.getLoadOptions();
        Bpmn2ModelerResourceSetImpl result = (Bpmn2ModelerResourceSetImpl)((Object)map.get("slightly.hacked.resource.set"));
        if (result == null) {
            result = new Bpmn2ModelerResourceSetImpl();
            map.put("slightly.hacked.resource.set", result);
        }
        return result;
    }

    public static Bpmn2ModelerResourceSetImpl slightlyHackedResourceSet(EObject eObj) {
        return ModelUtil.slightlyHackedResourceSet(eObj.eResource().getResourceSet());
    }

    public static Object resolveXSDObject(Object xsdObject) {
        XSDAttributeDeclaration resolvedAttribute;
        if (xsdObject instanceof XSDElementDeclaration) {
            XSDElementDeclaration resolvedElement = ((XSDElementDeclaration)xsdObject).getResolvedElementDeclaration();
            if (resolvedElement != null) {
                xsdObject = resolvedElement;
            }
        } else if (xsdObject instanceof XSDAttributeDeclaration && (resolvedAttribute = ((XSDAttributeDeclaration)xsdObject).getResolvedAttributeDeclaration()) != null) {
            xsdObject = resolvedAttribute;
        }
        return xsdObject;
    }

    public static Bpmn2DiagramType getDiagramType(String name) {
        Bpmn2DiagramType[] bpmn2DiagramTypeArray = Bpmn2DiagramType.values();
        int n = bpmn2DiagramTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bpmn2DiagramType t = bpmn2DiagramTypeArray[n2];
            if (t.toString().equalsIgnoreCase(name)) {
                return t;
            }
            ++n2;
        }
        return Bpmn2DiagramType.NONE;
    }

    public static DiagramEditor getDiagramEditor(EObject object) {
        DiagramEditor ed = ModelUtil.getDiagramEditor(ExtendedPropertiesAdapter.getResource((Notifier)object));
        return ed;
    }

    public static DiagramEditor getDiagramEditor(Resource res) {
        if (res != null) {
            for (Adapter a : res.getResourceSet().eAdapters()) {
                if (!(a instanceof DiagramEditorAdapter)) continue;
                return ((DiagramEditorAdapter)a).getDiagramEditor();
            }
        }
        return null;
    }

    public static Bpmn2DiagramType getDiagramType(EObject object) {
        if (object instanceof Diagram) {
            object = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)((Diagram)object));
        }
        if (object instanceof BPMNDiagram) {
            return ModelUtil.getDiagramType((BPMNDiagram)object);
        }
        DiagramEditor editor = ModelUtil.getDiagramEditor(object);
        return ModelUtil.getDiagramType(editor);
    }

    public static Bpmn2DiagramType getDiagramType(DiagramEditor editor) {
        EObject object;
        Diagram diagram;
        if (editor != null && (diagram = editor.getDiagramTypeProvider().getDiagram()) != null && (object = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diagram)) instanceof BPMNDiagram) {
            return ModelUtil.getDiagramType((BPMNDiagram)object);
        }
        return Bpmn2DiagramType.NONE;
    }

    public static Bpmn2DiagramType getDiagramType(BPMNDiagram diagram) {
        BPMNPlane plane;
        if (diagram != null && ExtendedPropertiesAdapter.getResource((Notifier)diagram) != null && (plane = diagram.getPlane()) != null) {
            BaseElement be = plane.getBpmnElement();
            if (be == null) {
                be = ModelUtil.getDefaultBPMNPlaneReference((EObject)diagram);
            }
            if (be instanceof Choreography) {
                return Bpmn2DiagramType.CHOREOGRAPHY;
            }
            if (be instanceof Collaboration) {
                return Bpmn2DiagramType.COLLABORATION;
            }
            return Bpmn2DiagramType.PROCESS;
        }
        return Bpmn2DiagramType.NONE;
    }

    public static BaseElement getDefaultBPMNPlaneReference(EObject object) {
        Definitions definitions = ModelUtil.getDefinitions(object);
        if (definitions != null) {
            for (RootElement re : definitions.getRootElements()) {
                if (!(re instanceof Process) && !(re instanceof SubProcess) && !(re instanceof AdHocSubProcess) && !(re instanceof Transaction) && !(re instanceof Collaboration) && !(re instanceof Choreography) && !(re instanceof SubChoreography)) continue;
                return re;
            }
        }
        return null;
    }

    public static String getDiagramTypeName(BPMNDiagram object) {
        Bpmn2DiagramType type = ModelUtil.getDiagramType(object);
        if (type == Bpmn2DiagramType.CHOREOGRAPHY) {
            return Messages.ModelUtil_Choreograpy_Diagram;
        }
        if (type == Bpmn2DiagramType.COLLABORATION) {
            return Messages.ModelUtil_Collaboration_Diagram;
        }
        if (type == Bpmn2DiagramType.PROCESS) {
            return Messages.ModelUtil_Process_Diagram;
        }
        return Messages.ModelUtil_Unknown_Diagram_Type;
    }

    public static EObject createStringWrapper(String value) {
        return new StringWrapper(value);
    }

    public static String getStringWrapperValue(Object wrapper) {
        if (wrapper instanceof StringWrapper) {
            return wrapper.toString();
        }
        if (wrapper instanceof EObject) {
            return EcoreUtil.getURI((EObject)((EObject)wrapper)).toString();
        }
        return null;
    }

    public static String getStringWrapperTextValue(Object wrapper) {
        String value = ModelUtil.getStringWrapperValue(wrapper);
        return SyntaxCheckerUtils.fromXMLString(value);
    }

    public static boolean setStringWrapperValue(Object wrapper, String value) {
        if (ModelUtil.isStringWrapper(wrapper)) {
            DynamicEObjectImpl de = (DynamicEObjectImpl)wrapper;
            EStructuralFeature feature = de.eClass().getEStructuralFeature("value");
            de.eSet(feature, (Object)value);
            return true;
        }
        return false;
    }

    public static boolean isStringWrapper(Object wrapper) {
        if (wrapper instanceof StringWrapper) {
            return true;
        }
        if (wrapper instanceof DynamicEObjectImpl) {
            EStructuralFeature feature = ((DynamicEObjectImpl)wrapper).eClass().getEStructuralFeature("value");
            return feature != null;
        }
        return false;
    }

    public static boolean isElementSelected(IDiagramContainer editor, PictogramElement element) {
        PictogramElement[] pictogramElementArray = editor.getSelectedPictogramElements();
        int n = pictogramElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement search = pictogramElementArray[n2];
            if (search.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Definitions getDefinitions(Object object) {
        Resource resource;
        if (object instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor)object;
            object = editor.getDiagramTypeProvider().getDiagram();
        }
        if (object instanceof Diagram) {
            object = ((Diagram)object).eResource();
        }
        if (object instanceof EObject) {
            object = ExtendedPropertiesAdapter.getResource((Notifier)((EObject)object));
        }
        if (object instanceof Resource && (resource = (Resource)object) != null && !resource.getContents().isEmpty() && !((EObject)resource.getContents().get(0)).eContents().isEmpty()) {
            for (EObject c : resource.getContents()) {
                for (Object o : c.eContents()) {
                    if (!(o instanceof Definitions)) continue;
                    return (Definitions)o;
                }
            }
        }
        return null;
    }

    public static EObject getContainer(EObject object) {
        InsertionAdapter insertionAdapter;
        EObject container = null;
        if (object != null && (container = object.eContainer()) == null && (insertionAdapter = AdapterUtil.adapt((Object)object, InsertionAdapter.class)) != null) {
            container = insertionAdapter.getObject();
        }
        return container;
    }

    public static DocumentRoot getDocumentRoot(EObject object) {
        Resource resource = ExtendedPropertiesAdapter.getResource((Notifier)object);
        if (resource != null) {
            for (EObject c : resource.getContents()) {
                if (!(c instanceof DocumentRoot)) continue;
                return (DocumentRoot)c;
            }
        }
        return null;
    }

    public static List<EObject> getAllReachableObjects(EObject object, EStructuralFeature feature) {
        EClass eClass;
        Resource resource;
        ArrayList<EObject> list = null;
        if (object != null && feature.getEType() instanceof EClass && (resource = ExtendedPropertiesAdapter.getResource((Notifier)object)) != null && (eClass = (EClass)feature.getEType()) != EcorePackage.eINSTANCE.getEObject()) {
            list = new ArrayList<EObject>();
            TreeIterator contents = resource.getAllContents();
            while (contents.hasNext()) {
                Object item = contents.next();
                if (!eClass.isInstance(item)) continue;
                list.add((EObject)item);
            }
        }
        return list;
    }

    public static List<EObject> getAllReachableObjects(EObject object, EClass eClass) {
        ArrayList<EObject> list = null;
        Resource resource = ExtendedPropertiesAdapter.getResource((Notifier)object);
        if (resource != null) {
            list = new ArrayList<EObject>();
            if (eClass != EcorePackage.eINSTANCE.getEObject()) {
                TreeIterator contents = resource.getAllContents();
                while (contents.hasNext()) {
                    Object item = contents.next();
                    if (!eClass.isInstance(item)) continue;
                    list.add((EObject)item);
                }
            }
        }
        return list;
    }

    public static <T> List<T> getAllRootElements(Definitions definitions, Class<T> class1) {
        ArrayList<RootElement> list = new ArrayList<RootElement>();
        if (definitions != null) {
            for (RootElement re : definitions.getRootElements()) {
                if (!class1.isInstance(re)) continue;
                list.add(re);
            }
        }
        return list;
    }

    public static <T> List<T> getAllObjectsOfType(Resource resource, Class<T> class1) {
        ArrayList<Object> l = new ArrayList<Object>();
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            Object t = iter.next();
            if (!class1.isInstance(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static boolean compare(Object v1, Object v2) {
        if (v1 == null ? v2 != null : v2 == null && v1 != null) {
            return false;
        }
        return v1.equals(v2);
    }

    public static EObject findNearestAncestor(EObject object, Class[] types) {
        EObject ancestor = null;
        if (object != null) {
            ancestor = ModelUtil.getContainer(object);
            while (ancestor != null) {
                Class<?> type = ancestor.getClass();
                Class[] classArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Class t = classArray[n2];
                    if (t.isAssignableFrom(type)) {
                        return ancestor;
                    }
                    ++n2;
                }
                ancestor = ModelUtil.getContainer(ancestor);
            }
        }
        return ancestor;
    }

    public static List<EObject> collectAncestorObjects(EObject object, String featureName, Class[] ancestorTypes) {
        return ModelUtil.collectAncestorObjects(object, featureName, ancestorTypes, null);
    }

    public static List<EObject> collectAncestorObjects(EObject object, String featureName, Class[] ancestorTypes, Class[] objectTypes) {
        ArrayList<EObject> values = new ArrayList<EObject>();
        EObject ancestor = ModelUtil.findNearestAncestor(object, ancestorTypes);
        while (ancestor != null) {
            EStructuralFeature feature = ancestor.eClass().getEStructuralFeature(featureName);
            if (feature != null && ancestor.eGet(feature) instanceof List) {
                List objects = (List)ancestor.eGet(feature);
                if (objectTypes == null) {
                    values.addAll(objects);
                } else {
                    for (EObject item : objects) {
                        Class[] classArray = objectTypes;
                        int n = objectTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class t = classArray[n2];
                            if (t.isAssignableFrom(item.getClass())) {
                                values.add(item);
                            }
                            ++n2;
                        }
                    }
                }
            }
            ancestor = ModelUtil.findNearestAncestor(ancestor, ancestorTypes);
        }
        return values;
    }

    public static String getTypeLabel(EClass classifier) {
        String type = classifier.getName();
        String label = Bpmn2EditPlugin.INSTANCE.getString("_UI_" + type + "_type");
        if (label == null || label.isEmpty()) {
            label = ModelUtil.toCanonicalString(type);
        }
        return label;
    }

    public static String getLabel(Object object) {
        String label = "";
        if (object instanceof EObject) {
            return ExtendedPropertiesProvider.getLabel((EObject)object);
        }
        label = object.toString();
        label = label.replaceAll(" Ref$", "");
        return label;
    }

    public static String getTextValue(Object object) {
        block3: {
            if (object instanceof EObject) {
                try {
                    return ExtendedPropertiesProvider.getTextValue((EObject)object);
                }
                catch (Exception exception) {
                    EStructuralFeature feature = ((EObject)object).eClass().getEStructuralFeature("name");
                    if (feature == null) break block3;
                    object = ((EObject)object).eGet(feature);
                }
            }
        }
        return object == null ? null : object.toString();
    }

    public static boolean isEmpty(Object result) {
        if (result == null) {
            return true;
        }
        if (result instanceof String) {
            return ((String)result).isEmpty();
        }
        return false;
    }

    public static void disposeChildWidgets(Composite parent) {
        Control[] kids;
        Control[] controlArray = kids = parent.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control k = controlArray[n2];
            if (k instanceof Composite) {
                ModelUtil.disposeChildWidgets((Composite)k);
            }
            k.dispose();
            ++n2;
        }
        kids = parent.getChildren();
    }

    public static void recursivelayout(Composite parent) {
        parent.setRedraw(false);
        ModelUtil.internalRecursivelayout(parent);
        parent.setRedraw(true);
    }

    private static void internalRecursivelayout(Composite parent) {
        Control[] kids;
        Control[] controlArray = kids = parent.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control k = controlArray[n2];
            if (k.isDisposed()) {
                Activator.logError((Exception)new SWTException("Widget is disposed."));
            }
            if (k instanceof Composite) {
                ModelUtil.internalRecursivelayout((Composite)k);
                ((Composite)k).layout(true);
            }
            ++n2;
        }
        parent.layout(true);
    }

    public static DiagramEditor getEditor(EObject object) {
        Resource resource = InsertionAdapter.getResource(object);
        if (resource != null) {
            return ModelUtil.getEditor(resource.getResourceSet());
        }
        return null;
    }

    public static DiagramEditor getEditor(Resource resource) {
        if (resource != null) {
            return ModelUtil.getEditor(resource.getResourceSet());
        }
        return null;
    }

    public static DiagramEditor getEditor(ResourceSet resourceSet) {
        for (Object next : resourceSet.eAdapters()) {
            if (!(next instanceof DiagramEditorAdapter)) continue;
            return ((DiagramEditorAdapter)next).getDiagramEditor();
        }
        return null;
    }

    public static EPackage getEPackage(EStructuralFeature feature) {
        EStructuralFeature o = feature;
        while (o.eContainer() != null) {
            if (!((o = o.eContainer()) instanceof EPackage)) continue;
            return (EPackage)o;
        }
        return null;
    }

    public static String getExpressionBody(FormalExpression expression) {
        String body = null;
        if (expression != null && expression.getMixed() != null && !expression.getMixed().isEmpty()) {
            StringBuilder result = new StringBuilder();
            boolean isNull = true;
            for (FeatureMap.Entry cur : expression.getMixed()) {
                switch (cur.getEStructuralFeature().getFeatureID()) {
                    case 3: 
                    case 6: {
                        if (cur.getValue() == null) break;
                        isNull = false;
                        result.append(cur.getValue());
                        break;
                    }
                }
            }
            if (!isNull) {
                body = result.toString();
            }
        }
        return body;
    }

    public static List<Tuple<EObject, EObject>> findDuplicateIds(Resource resource) {
        ArrayList<Tuple<EObject, EObject>> list = new ArrayList<Tuple<EObject, EObject>>();
        Definitions definitions = ModelUtil.getDefinitions(resource);
        TreeIterator iter1 = definitions.eAllContents();
        Hashtable<String, EObject> map = new Hashtable<String, EObject>();
        while (iter1.hasNext()) {
            EAttribute id1Feature;
            EObject o1 = (EObject)iter1.next();
            if (!(o1 instanceof BaseElement) || (id1Feature = o1.eClass().getEIDAttribute()) == null) continue;
            try {
                String id1 = (String)o1.eGet((EStructuralFeature)id1Feature);
                if (id1 == null) continue;
                EObject o2 = (EObject)map.get(id1);
                if (o2 != null) {
                    list.add(new Tuple<EObject, EObject>(o1, o2));
                }
                map.put(id1, o1);
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public static boolean isParticipantBand(Participant participant) {
        Resource resource = ExtendedPropertiesAdapter.getResource((Notifier)participant);
        for (ChoreographyActivity ca : ModelUtil.getAllObjectsOfType(resource, ChoreographyActivity.class)) {
            if (!ca.getParticipantRefs().contains(participant)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Adapter> T getAdapter(EObject object, Class<T> clazz) {
        for (Adapter a : object.eAdapters()) {
            if (!clazz.isInstance(a)) continue;
            return (T)a;
        }
        return null;
    }

    public static List<ItemAwareElement> getItemAwareElements(List<? extends DataAssociation> list) {
        ArrayList<ItemAwareElement> result = new ArrayList<ItemAwareElement>();
        for (DataAssociation dataAssociation : list) {
            ItemAwareElement e2;
            if (dataAssociation instanceof DataInputAssociation) {
                for (ItemAwareElement e : dataAssociation.getSourceRef()) {
                    if (e == null) continue;
                    result.add(e);
                }
                continue;
            }
            if (!(dataAssociation instanceof DataOutputAssociation) || (e2 = dataAssociation.getTargetRef()) == null) continue;
            result.add(e2);
        }
        return result;
    }

    @Deprecated
    public static List<EStructuralFeature> getAnyAttributes(EObject object) {
        return ModelDecorator.getAnyAttributes(object);
    }

    @Deprecated
    public static String getDisplayName(EObject object) {
        return ModelUtil.getTextValue(object);
    }

    @Deprecated
    public static String toDisplayName(String name) {
        return ModelUtil.toCanonicalString(name);
    }

    @Deprecated
    public static Resource getResource(EObject object) {
        return ExtendedPropertiesAdapter.getResource((Notifier)object);
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (object1 instanceof Interface && object2 instanceof Interface) {
            Interface i1 = (Interface)object1;
            Interface i2 = (Interface)object2;
            return ModelUtil.equals(i1.getImplementationRef(), i2.getImplementationRef()) && ModelUtil.equals(i1.getName(), i2.getName()) && ModelUtil.equals(i1.getOperations(), i2.getOperations());
        }
        if (object1 instanceof Operation && object2 instanceof Operation) {
            Operation o1 = (Operation)object1;
            Operation o2 = (Operation)object2;
            return ModelUtil.equals(o1.getName(), o2.getName()) && ModelUtil.equals(o1.getImplementationRef(), o2.getImplementationRef()) && ModelUtil.equals(o1.getErrorRefs(), o2.getErrorRefs()) && ModelUtil.equals(o1.getInMessageRef(), o2.getInMessageRef()) && ModelUtil.equals(o1.getOutMessageRef(), o2.getOutMessageRef());
        }
        if (object1 instanceof Message && object2 instanceof Message) {
            Message m1 = (Message)object1;
            Message m2 = (Message)object2;
            return ModelUtil.equals(m1.getItemRef(), m2.getItemRef()) && ModelUtil.equals(m1.getName(), m2.getName());
        }
        if (object1 instanceof Error && object2 instanceof Error) {
            Error e1 = (Error)object1;
            Error e2 = (Error)object2;
            return ModelUtil.equals(e1.getName(), e2.getName()) && ModelUtil.equals(e1.getStructureRef(), e2.getStructureRef());
        }
        if (object1 instanceof ItemDefinition && object2 instanceof ItemDefinition) {
            ItemDefinition i1 = (ItemDefinition)object1;
            ItemDefinition i2 = (ItemDefinition)object2;
            return ModelUtil.equals(i1.getItemKind(), i2.getItemKind()) && ModelUtil.equals(i1.getStructureRef(), i2.getStructureRef());
        }
        if (object1 instanceof PortType && object2 instanceof PortType) {
            PortType p1 = (PortType)object1;
            PortType p2 = (PortType)object2;
            return ModelUtil.equals(p1.getQName(), p2.getQName()) && ModelUtil.equals(p1.getOperations(), p2.getOperations());
        }
        if (object1 instanceof org.eclipse.wst.wsdl.Operation && object2 instanceof org.eclipse.wst.wsdl.Operation) {
            org.eclipse.wst.wsdl.Operation o1 = (org.eclipse.wst.wsdl.Operation)object1;
            org.eclipse.wst.wsdl.Operation o2 = (org.eclipse.wst.wsdl.Operation)object2;
            return ModelUtil.equals(o1.getName(), o2.getName()) && ModelUtil.equals(o1.getInput(), o2.getInput()) && ModelUtil.equals(o1.getOutput(), o2.getOutput()) && ModelUtil.equals(o1.getFaults(), o2.getFaults()) && ModelUtil.equals(o1.getStyle(), o2.getStyle());
        }
        if (object1 instanceof org.eclipse.wst.wsdl.Message && object2 instanceof org.eclipse.wst.wsdl.Message) {
            org.eclipse.wst.wsdl.Message m1 = (org.eclipse.wst.wsdl.Message)object1;
            org.eclipse.wst.wsdl.Message m2 = (org.eclipse.wst.wsdl.Message)object2;
            return ModelUtil.equals(m1.getQName(), m2.getQName());
        }
        if (object1 instanceof MessageReference && object2 instanceof MessageReference) {
            MessageReference m1 = (MessageReference)object1;
            MessageReference m2 = (MessageReference)object2;
            return ModelUtil.equals(m1.getName(), m2.getName()) && ModelUtil.equals(m1.getEMessage(), m2.getEMessage());
        }
        if (object1 instanceof Fault && object2 instanceof Fault) {
            Fault f1 = (Fault)object1;
            Fault f2 = (Fault)object2;
            return ModelUtil.equals(f1.getEMessage(), f2.getEMessage());
        }
        if (object1 instanceof QName && object2 instanceof QName) {
            QName m1 = (QName)object1;
            QName m2 = (QName)object2;
            return ModelUtil.equals(m1.getNamespaceURI(), m2.getNamespaceURI()) && ModelUtil.equals(m1.getLocalPart(), m2.getLocalPart());
        }
        if (object1 instanceof XSDElementDeclaration && object2 instanceof XSDElementDeclaration) {
            XSDElementDeclaration x1 = (XSDElementDeclaration)object1;
            XSDElementDeclaration x2 = (XSDElementDeclaration)object2;
            return ModelUtil.equals(x1.getQName(), x2.getQName());
        }
        if (object1 instanceof Map && object2 instanceof Map) {
            Map m1 = (Map)object1;
            Map m2 = (Map)object2;
            if (m1.size() != m2.size()) {
                return false;
            }
            for (Object k1 : m1.keySet()) {
                if (ModelUtil.equals(m1.get(k1), m2.get(k1))) continue;
                return false;
            }
            return true;
        }
        if (object1 instanceof List && object2 instanceof List) {
            List l1 = (List)object1;
            List l2 = (List)object2;
            if (l1.size() != l2.size()) {
                return false;
            }
            int i = 0;
            while (i < l1.size()) {
                if (!ModelUtil.equals(l1.get(i), l2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (object1 instanceof String && object2 instanceof String) {
            return object1.equals(object2);
        }
        return object1.equals(object2);
    }

    public static enum Bpmn2DiagramType {
        NONE("None"),
        PROCESS("Process"),
        CHOREOGRAPHY("Choreography"),
        COLLABORATION("Collaboration"),
        CONVERSATION("Conversation");

        String value;

        private Bpmn2DiagramType(String value) {
            this.value = value;
        }

        public static Bpmn2DiagramType fromString(String value) {
            if (value != null) {
                Bpmn2DiagramType[] bpmn2DiagramTypeArray = Bpmn2DiagramType.values();
                int n = bpmn2DiagramTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bpmn2DiagramType type = bpmn2DiagramTypeArray[n2];
                    if (value.equalsIgnoreCase(type.value)) {
                        return type;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

