/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.actions;

import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.Messages;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.OpenSessionAction;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.ActivityExplorerEditor;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SessionHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenActivityExplorerAction
extends BaseSelectionListenerAction {
    protected OpenActivityExplorerAction() {
        super(Messages.OpenActivityExplorerAction_Title);
        ActivityExplorerActivator.getDefault().getImage("icons/full/obj16/menu-overview.gif");
        this.setImageDescriptor(ActivityExplorerActivator.getDefault().getImageRegistry().getDescriptor("icons/full/obj16/menu-overview.gif"));
    }

    protected Session getSession() {
        IStructuredSelection selection = this.getStructuredSelection();
        Session session = null;
        if (!selection.isEmpty()) {
            ModelingProject p;
            Option modelingProjectOption;
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof IFile && "aird".equals(((IFile)selectedElement).getFileExtension())) {
                session = SessionHelper.getSessionForDiagramFile((IFile)selectedElement);
            } else if (selectedElement instanceof IProject && (modelingProjectOption = ModelingProject.asModelingProject((IProject)((IProject)selectedElement))).some() && (p = (ModelingProject)modelingProjectOption.get()).isValid()) {
                session = p.getSession();
            }
        }
        return session;
    }

    public void run() {
        Session session = this.getSession();
        if (session != null) {
            OpenSessionAction.openActivityExplorer(session);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection_p) {
        return this.getSession() != null;
    }

    public boolean canAddedToMenu() {
        boolean result = false;
        Session session = this.getSession();
        if (session != null) {
            ActivityExplorerEditor editor = ActivityExplorerManager.INSTANCE.getEditorFromSession(session);
            result = editor == null;
        }
        return result;
    }
}

