/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.BMPWriter;

public class Int2D
implements IInt2D {
    private int width;
    private int height;
    private int[][] data;

    public Int2D(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.data = new int[this.getHeight()][this.getWidth()];
    }

    public Int2D(int n, int n2, int[][] nArray) throws ImageException {
        this(n, n2);
        if (nArray.length < n2 || nArray[0].length < n) {
            throw new ImageException("Out of range");
        }
        int n3 = 0;
        while (n3 < this.getHeight()) {
            int n4 = 0;
            while (n4 < this.getWidth()) {
                this.getData()[n3][n4] = nArray[n3][n4];
                ++n4;
            }
            ++n3;
        }
    }

    public Int2D(Int2D int2D) {
        this(int2D.getWidth(), int2D.getHeight());
        int n = 0;
        while (n < this.getHeight()) {
            int n2 = 0;
            while (n2 < this.getWidth()) {
                this.getData()[n][n2] = int2D.getData()[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public Int2D(BufferedImage bufferedImage) {
        this(bufferedImage.getWidth(), bufferedImage.getHeight());
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n = 0;
        int n2 = 0;
        while (n2 < this.getHeight()) {
            int n3 = 0;
            while (n3 < this.getWidth()) {
                this.getData()[n2][n3] = nArray[n];
                ++n;
                ++n3;
            }
            ++n2;
        }
    }

    public Int2D deepCopy() {
        Int2D int2D = new Int2D(this.width, this.height);
        int[][] nArray = int2D.getData();
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                nArray[n][n2] = this.data[n][n2];
                ++n2;
            }
            ++n;
        }
        return int2D;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage toBufferedImage() {
        return ImageUtil.int2DToBufferedImage(this);
    }

    public void writeToBMPFile(String string) throws LowVisionIOException {
        BMPWriter.writeInt2D(this, string);
    }

    public void writeToBMPFile(String string, int n) throws LowVisionIOException {
        BMPWriter.writeInt2D(this, string, n);
    }

    public void fill(int n) {
        int n2 = 0;
        while (n2 < this.getHeight()) {
            int n3 = 0;
            while (n3 < this.getWidth()) {
                this.getData()[n2][n3] = n;
                ++n3;
            }
            ++n2;
        }
    }

    public Int2D cutMargin(int n) throws ImageException {
        if (this.getWidth() <= 2 * n || this.getHeight() <= 2 * n) {
            throw new ImageException("The margin is too wide.");
        }
        int n2 = this.getWidth() - 2 * n;
        int n3 = this.getHeight() - 2 * n;
        Int2D int2D = new Int2D(n2, n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                int2D.getData()[n4][n5] = this.getData()[n4 + n][n5 + n];
                ++n5;
            }
            ++n4;
        }
        return int2D;
    }

    public void drawContour(ConnectedComponent connectedComponent, int n, boolean bl) {
        Int2D int2D = this;
        if (!bl) {
            int2D = this.deepCopy();
        }
        int n2 = connectedComponent.left;
        int n3 = connectedComponent.top;
        int n4 = connectedComponent.shape.width;
        int n5 = connectedComponent.shape.height;
        int n6 = 0;
        while (n6 < n5) {
            if (connectedComponent.shape.data[n6][0] != 0) {
                int2D.getData()[n6 + n3][n2] = n;
            }
            if (connectedComponent.shape.data[n6][n4 - 1] != 0) {
                int2D.getData()[n6 + n3][n4 - 1 + n2] = n;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n4) {
            if (connectedComponent.shape.data[0][n6] != 0) {
                int2D.getData()[n3][n6 + n2] = n;
            }
            if (connectedComponent.shape.data[n5 - 1][0] != 0) {
                int2D.getData()[n5 - 1 + n3][n2] = n;
            }
            ++n6;
        }
        n6 = 1;
        while (n6 < n5 - 1) {
            int n7 = 1;
            while (n7 < n4 - 1) {
                if (connectedComponent.shape.data[n6][n7] != 0 && (connectedComponent.shape.data[n6][n7 - 1] == 0 || connectedComponent.shape.data[n6][n7 + 1] == 0 || connectedComponent.shape.data[n6 - 1][n7] == 0 || connectedComponent.shape.data[n6 + 1][n7] == 0)) {
                    int2D.getData()[n6 + n3][n7 + n2] = n;
                }
                ++n7;
            }
            ++n6;
        }
    }

    public int[][] getData() {
        return this.data;
    }
}

