/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.Messages;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.ITmfXmlSchemaParser;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtils {
    private static final String XML_DIRECTORY = "xml_files";
    private static final String XSD = "xmlDefinition.xsd";
    private static final String TMF_XML_BUILTIN_ID = "org.eclipse.linuxtools.tmf.analysis.xml.core.files";
    private static final String XML_FILE_ELEMENT = "xmlfile";
    private static final String XML_FILE_ATTRIB = "file";
    private static final String TMF_XSD_ID = "org.eclipse.tracecompass.tmf.analysis.xml.core.xsd";
    private static final String XSD_FILE_ELEMENT = "xsdfile";
    private static final String XSD_FILE_ATTRIB = "file";
    private static final String XSD_SCHEMA_PARSER_ELEMENT = "schemaParser";
    private static final String XSD_PARSER_CLASS_ATTRIB = "class";
    public static final String XML_EXTENSION = "xml";

    private XmlUtils() {
    }

    public static IPath getXmlFilesPath() {
        IPath path = Activator.getDefault().getStateLocation();
        File dir = (path = path.addTrailingSeparator().append(XML_DIRECTORY)).toFile();
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        return path;
    }

    public static IStatus xmlValidate(File xmlFile) {
        URL url = TmfXmlUtils.class.getResource(XSD);
        List<@NonNull URL> xsdFiles = XmlUtils.getExtraXsdFiles();
        Validator validator = null;
        Schema schema = null;
        Source[] sources = new Source[xsdFiles.size() + 1];
        sources[0] = new StreamSource(url.toExternalForm());
        int i = 0;
        while (i < xsdFiles.size()) {
            sources[i + 1] = new StreamSource(xsdFiles.get(i).toExternalForm());
            ++i;
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schemaFactory.setFeature("http://apache.org/xml/features/namespace-growth", true);
            schema = schemaFactory.newSchema(sources);
        }
        catch (SAXException e) {
            String error = NLS.bind((String)Messages.XmlUtils_XsdValidationError, (Object)e.getLocalizedMessage());
            Activator.logError(error);
            try {
                schema = schemaFactory.newSchema(url);
            }
            catch (SAXException e1) {
                error = NLS.bind((String)Messages.XmlUtils_XsdValidationError, (Object)e1.getLocalizedMessage());
                Activator.logError(error);
                return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e1);
            }
        }
        validator = schema.newValidator();
        StreamSource xmlSource = new StreamSource(xmlFile);
        try {
            validator.validate(xmlSource);
        }
        catch (SAXParseException e) {
            String error = NLS.bind((String)Messages.XmlUtils_XmlParseError, (Object)e.getLineNumber(), (Object)e.getLocalizedMessage());
            Activator.logError(error);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e);
        }
        catch (SAXException e) {
            String error = NLS.bind((String)Messages.XmlUtils_XmlValidationError, (Object)e.getLocalizedMessage());
            Activator.logError(error);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e);
        }
        catch (IOException e) {
            String error = Messages.XmlUtils_XmlValidateError;
            Activator.logError("IO exception occurred", e);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public static IStatus addXmlFile(File fromFile) {
        File toFile = XmlUtils.getXmlFilesPath().addTrailingSeparator().append(fromFile.getName()).toFile();
        return XmlUtils.copyXmlFile(fromFile, toFile);
    }

    public static synchronized @NonNull Map<@NonNull String, @NonNull File> listFiles() {
        IPath pathToFiles = XmlUtils.getXmlFilesPath();
        File folder = pathToFiles.toFile();
        HashMap<@NonNull String, @NonNull File> fileMap = new HashMap<String, File>();
        if (folder.isDirectory() && folder.exists()) {
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles != null) {
                File[] fileArray = listOfFiles;
                int n = listOfFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    Path path = new Path(file.getName());
                    if (path.getFileExtension().equals(XML_EXTENSION)) {
                        fileMap.put(file.getName(), file);
                    }
                    ++n2;
                }
            } else {
                Activator.logError("I/O error occured while accessing files in folder " + folder.getPath());
            }
        }
        return Collections.unmodifiableMap(fileMap);
    }

    public static synchronized @NonNull Map<String, IPath> listBuiltinFiles() {
        List<URL> urls = XmlUtils.getUrlsFromConfiguration(TMF_XML_BUILTIN_ID, XML_FILE_ELEMENT, "file");
        HashMap<String, IPath> map = new HashMap<String, IPath>();
        urls.forEach(url -> {
            Path path = map.put(FilenameUtils.getName((String)url.getPath()), (IPath)new Path(url.getPath()));
        });
        return map;
    }

    private static synchronized @NonNull List<@NonNull URL> getExtraXsdFiles() {
        return XmlUtils.getUrlsFromConfiguration(TMF_XSD_ID, XSD_FILE_ELEMENT, "file");
    }

    private static synchronized @NonNull List<@NonNull URL> getUrlsFromConfiguration(String extensionName, String elementName, String attribName) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionName);
        final ArrayList<@NonNull URL> list = new ArrayList<URL>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(elementName)) {
                final String filename = element.getAttribute(attribName);
                final String name = element.getContributor().getName();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws IOException {
                        Bundle bundle;
                        if (name != null && (bundle = Platform.getBundle((String)name)) != null) {
                            URL xmlUrl = bundle.getResource(filename);
                            if (xmlUrl == null) {
                                throw new FileNotFoundException(filename);
                            }
                            URL locatedURL = FileLocator.toFileURL((URL)xmlUrl);
                            list.add((URL)NonNullUtils.checkNotNull((Object)locatedURL));
                        }
                    }

                    public void handleException(Throwable exception) {
                    }
                });
            }
            ++n2;
        }
        return list;
    }

    public static synchronized @NonNull Collection<ITmfXmlSchemaParser> getExtraSchemaParsers() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_XSD_ID);
        ArrayList<ITmfXmlSchemaParser> list = new ArrayList<ITmfXmlSchemaParser>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(XSD_SCHEMA_PARSER_ELEMENT)) {
                try {
                    ITmfXmlSchemaParser parser = (ITmfXmlSchemaParser)NonNullUtils.checkNotNull((Object)((ITmfXmlSchemaParser)element.createExecutableExtension(XSD_PARSER_CLASS_ATTRIB)));
                    list.add(parser);
                }
                catch (CoreException e) {
                    Activator.logError("Error getting analysis modules from configuration files", e);
                }
            }
            ++n2;
        }
        return list;
    }

    public static void deleteFile(String name) {
        Map<String, File> files = XmlUtils.listFiles();
        File file = files.get(name);
        if (file == null) {
            return;
        }
        file.delete();
    }

    public static IStatus exportXmlFile(String from, String to) {
        File fromFile = XmlUtils.getXmlFilesPath().addTrailingSeparator().append(from).toFile();
        if (!fromFile.exists()) {
            Activator.logError("Failed to find XML analysis file " + fromFile.getName());
            return Status.CANCEL_STATUS;
        }
        File toFile = new File(to);
        return XmlUtils.copyXmlFile(fromFile, toFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IStatus copyXmlFile(File fromFile, File toFile) {
        try {
            if (!toFile.exists()) {
                toFile.createNewFile();
            }
        }
        catch (IOException e) {
            String error2 = Messages.XmlUtils_ErrorCopyingFile;
            Activator.logError(error2, e);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error2, (Throwable)e);
        }
        try {
            Throwable e = null;
            Object error2 = null;
            try {
                FileInputStream fis = new FileInputStream(fromFile);
                try {
                    block29: {
                        FileOutputStream fos = new FileOutputStream(toFile);
                        try {
                            block28: {
                                FileChannel source = fis.getChannel();
                                try {
                                    try (FileChannel destination = fos.getChannel();){
                                        destination.transferFrom(source, 0L, source.size());
                                    }
                                    if (source == null) break block28;
                                }
                                catch (Throwable error2) {
                                    if (e == null) {
                                        e = error2;
                                    } else if (e != error2) {
                                        e.addSuppressed(error2);
                                    }
                                    if (source == null) throw e;
                                    source.close();
                                    throw e;
                                }
                                source.close();
                            }
                            if (fos == null) break block29;
                        }
                        catch (Throwable error2) {
                            if (e == null) {
                                e = error2;
                            } else if (e != error2) {
                                e.addSuppressed(error2);
                            }
                            if (fos == null) throw e;
                            fos.close();
                            throw e;
                        }
                        fos.close();
                    }
                    if (fis == null) return Status.OK_STATUS;
                }
                catch (Throwable error2) {
                    if (e == null) {
                        e = error2;
                    } else if (e != error2) {
                        e.addSuppressed(error2);
                    }
                    if (fis == null) throw e;
                    fis.close();
                    throw e;
                }
                fis.close();
                return Status.OK_STATUS;
            }
            catch (Throwable error2) {
                if (e == null) {
                    e = error2;
                    throw e;
                }
                if (e == error2) throw e;
                e.addSuppressed(error2);
                throw e;
            }
        }
        catch (IOException e) {
            String error = Messages.XmlUtils_ErrorCopyingFile;
            Activator.logError(error, e);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e);
        }
    }

    public static List<String> getAnalysisIdsFromFile(String fileName) {
        ArrayList<String> ids = new ArrayList<String>();
        File file = XmlUtils.getXmlFilesPath().addTrailingSeparator().append(fileName).toFile();
        if (file.exists()) {
            try {
                Document doc = XmlUtils.getDocumentFromFile(file);
                NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
                int i = 0;
                while (i < stateproviderNodes.getLength()) {
                    ids.add(NonNullUtils.nullToEmptyString((Object)((Element)stateproviderNodes.item(i)).getAttribute("id")));
                    ++i;
                }
                NodeList patternNodes = doc.getElementsByTagName("pattern");
                int i2 = 0;
                while (i2 < patternNodes.getLength()) {
                    ids.add(NonNullUtils.nullToEmptyString((Object)((Element)patternNodes.item(i2)).getAttribute("id")));
                    ++i2;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Activator.logError("Failed to get analyses IDs from " + fileName);
            }
        }
        return ids;
    }

    public static Document getDocumentFromFile(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = dbFactory.newDocumentBuilder().parse(file);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static @NonNull List<@Nullable Element> getChildElements(Element parent) {
        NodeList childNodes = parent.getChildNodes();
        ArrayList<@Nullable Element> childElements = new ArrayList<Element>();
        int index = 0;
        while (index < childNodes.getLength()) {
            if (childNodes.item(index).getNodeType() == 1) {
                childElements.add((Element)childNodes.item(index));
            }
            ++index;
        }
        return childElements;
    }
}

