/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.composer.AuthorSection;
import org.eclipse.php.composer.ui.editor.composer.ComposerFormEditor;
import org.eclipse.php.composer.ui.editor.composer.GeneralSection;
import org.eclipse.php.composer.ui.editor.composer.Messages;
import org.eclipse.php.composer.ui.editor.composer.SupportSection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OverviewPage
extends ComposerFormPage {
    public static final String ID = "org.eclipse.php.composer.ui.editor.composer.OverviewPage";
    protected ComposerFormEditor editor;
    private Composite left;
    private Composite right;
    private GeneralSection generalSection;
    private AuthorSection authorSection;
    private SupportSection supportSection;
    protected IHyperlinkListener linkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent event) {
            String[] chunks = event.getHref().toString().split(":");
            String type = chunks[0];
            String target = chunks[1];
            if (type.equals("page")) {
                OverviewPage.this.editor.setActivePage(target);
            } else if (type.equals("view")) {
                OverviewPage.this.editor.setActivePage(target);
            }
        }
    };

    public OverviewPage(ComposerFormEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
        this.editor = editor;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.editor.getHeaderForm().getForm().setText(Messages.OverviewPage_Title);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.generalSection.setEnabled(enabled);
        this.authorSection.setEnabled(enabled);
        this.supportSection.setEnabled(enabled);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        form.getBody().setLayout((Layout)layout);
        this.left = toolkit.createComposite(form.getBody());
        this.left.setLayout((Layout)new TableWrapLayout());
        this.left.setLayoutData((Object)new TableWrapData(256));
        this.generalSection = new GeneralSection(this, this.left);
        this.authorSection = new AuthorSection(this, this.left);
        this.supportSection = new SupportSection(this, this.left);
        this.right = toolkit.createComposite(form.getBody());
        this.right.setLayout((Layout)new TableWrapLayout());
        this.right.setLayoutData((Object)new TableWrapData(256));
        this.createConfigurationSection(this.right, toolkit);
        this.createDependenciesSection(this.right, toolkit);
        this.createComposerSection(this.right, toolkit);
    }

    private void createConfigurationSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 320);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setText(Messages.OverviewPage_ConfigurationSectionTitle);
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        client.setLayout((Layout)new TableWrapLayout());
        FormText config = toolkit.createFormText(client, false);
        config.setLayoutData((Object)new TableWrapData(256));
        config.setText(NLS.bind((String)Messages.OverviewPage_ConfigurationSectionBody, (Object)"org.eclipse.php.composer.ui.editor.composer.AutoloadPage", (Object)"org.eclipse.php.composer.ui.editor.composer.ConfigurationPage"), true, false);
        config.setImage("page", ComposerUIPluginImages.PAGE.createImage());
        config.addHyperlinkListener(this.linkListener);
    }

    private void createDependenciesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 320);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setText(Messages.OverviewPage_DependenciesSectionTitle);
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        client.setLayout((Layout)new TableWrapLayout());
        FormText dependencies = toolkit.createFormText(client, false);
        dependencies.setLayoutData((Object)new TableWrapData(256));
        dependencies.setText(NLS.bind((String)Messages.OverviewPage_DependenciesSectionBody, (Object)"org.eclipse.php.composer.ui.editor.composer.DependencyPage", (Object)"org.eclipse.php.composer.ui.editor.composer.DependencyGraphPage"), true, false);
        dependencies.setImage("page", ComposerUIPluginImages.PAGE.createImage());
        dependencies.addHyperlinkListener(this.linkListener);
    }

    private void createComposerSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 320);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setText(Messages.OverviewPage_ComposerInfoSectionTitle);
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        client.setLayout((Layout)new TableWrapLayout());
        FormText composer = toolkit.createFormText(client, false);
        composer.setLayoutData((Object)new TableWrapData(256));
        composer.setText(Messages.OverviewPage_ComposerInfoSectionBody, true, false);
        composer.setImage("url", ComposerUIPluginImages.BROWSER.createImage());
        composer.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Program.launch((String)e.getHref().toString());
            }
        });
    }
}

