/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.IJsGlobalScopeContainerInitializerExtension;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.JSDScopeUiUtil;

public class JsGlobalScopeContainer
extends PackageFragmentRootContainer {
    private IIncludePathEntry fClassPathEntry;
    private IJsGlobalScopeContainer fContainer;

    public JsGlobalScopeContainer(IJavaScriptProject parent, IIncludePathEntry entry) {
        super(parent);
        this.fClassPathEntry = entry;
        try {
            this.fContainer = JavaScriptCore.getJsGlobalScopeContainer((IPath)entry.getPath(), (IJavaScriptProject)parent);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.fContainer = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof JsGlobalScopeContainer) {
            JsGlobalScopeContainer other = (JsGlobalScopeContainer)obj;
            if (this.getJavaProject().equals(other.getJavaProject()) && this.fClassPathEntry.equals(other.fClassPathEntry)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getJavaProject().hashCode() * 17 + this.fClassPathEntry.hashCode();
    }

    @Override
    public IPackageFragmentRoot[] getPackageFragmentRoots() {
        return this.getJavaProject().findPackageFragmentRoots(this.fClassPathEntry);
    }

    @Override
    public IAdaptable[] getChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            list.add(roots[i]);
            ++i;
        }
        if (this.fContainer != null) {
            IIncludePathEntry[] classpathEntries = this.fContainer.getIncludepathEntries();
            if (classpathEntries == null) {
                JavaScriptPlugin.log(new IllegalArgumentException("Invalid classpath container implementation: getClasspathEntries() returns null. " + this.fContainer.getPath()));
            } else {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int i2 = 0;
                while (i2 < classpathEntries.length) {
                    IResource resource;
                    IIncludePathEntry entry = classpathEntries[i2];
                    if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) instanceof IProject) {
                        list.add(new RequiredProjectWrapper(this, JavaScriptCore.create((IProject)((IProject)resource))));
                    }
                    ++i2;
                }
            }
        }
        return list.toArray(new IAdaptable[list.size()]);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        IPath entPath;
        ImageDescriptor image;
        IJsGlobalScopeContainerInitializerExtension init = JSDScopeUiUtil.getContainerUiInitializer(this.fClassPathEntry.getPath());
        if (init != null && (image = init.getImage(entPath = this.fClassPathEntry.getPath(), this.fClassPathEntry.toString(), super.getJavaProject())) != null) {
            return image;
        }
        return JavaPluginImages.DESC_OBJS_LIBRARY;
    }

    @Override
    public String getLabel() {
        if (this.fContainer != null) {
            return this.fContainer.getDescription();
        }
        IPath path = this.fClassPathEntry.getPath();
        String containerId = path.segment(0);
        JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer((String)containerId);
        if (initializer != null) {
            String description = initializer.getDescription(path, this.getJavaProject());
            return Messages.format(PackagesMessages.JsGlobalScopeContainer_unbound_label, description);
        }
        return Messages.format(PackagesMessages.JsGlobalScopeContainer_unknown_label, path.toString());
    }

    public IIncludePathEntry getClasspathEntry() {
        return this.fClassPathEntry;
    }

    static boolean contains(IJavaScriptProject project, IIncludePathEntry entry, IPackageFragmentRoot root) {
        IPackageFragmentRoot[] roots = project.findPackageFragmentRoots(entry);
        int i = 0;
        while (i < roots.length) {
            if (roots[i].equals(root)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return this.fClassPathEntry.toString();
    }

    public boolean hasChildren() {
        return this.getPackageFragmentRoots().length > 0;
    }

    public static class RequiredProjectWrapper
    implements IAdaptable,
    IWorkbenchAdapter {
        private final JsGlobalScopeContainer fParent;
        private final IJavaScriptProject fProject;

        public RequiredProjectWrapper(JsGlobalScopeContainer parent, IJavaScriptProject project) {
            this.fParent = parent;
            this.fProject = project;
        }

        public IJavaScriptProject getProject() {
            return this.fProject;
        }

        public JsGlobalScopeContainer getParentJsGlobalScopeContainer() {
            return this.fParent;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return this;
            }
            return null;
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        }

        public String getLabel(Object o) {
            return this.fProject.getElementName();
        }

        public Object getParent(Object o) {
            return this.fParent;
        }
    }
}

