/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.chromium.debug.core.ReverseSourceLookup;
import org.eclipse.wst.jsdt.chromium.debug.ui.DialogUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.source.Messages;
import org.eclipse.wst.jsdt.chromium.debug.ui.source.SourceNameMapperContainerDialog;

abstract class SourceNameMapperContainerDialogLogic {
    SourceNameMapperContainerDialogLogic() {
    }

    abstract SourceNameMapperContainerDialog.Result getResult();

    abstract void updateAll();

    static SourceNameMapperContainerDialogLogic create(final SourceNameMapperContainerDialog.Elements elements, final ISourceLookupDirector director, SourceNameMapperContainerDialog.PresetFieldValues initialParams) {
        final DialogUtils.Updater updater = new DialogUtils.Updater();
        DialogUtils.Scope rootScope = updater.rootScope();
        ArrayList<DialogUtils.ValueProcessor<String>> warningSources = new ArrayList<DialogUtils.ValueProcessor<String>>(2);
        final DialogUtils.ValueSource<String> prefixEditor = new DialogUtils.ValueSource<String>(initialParams, updater){
            {
                if (presetFieldValues != null) {
                    elements2.getPrefixField().setText(presetFieldValues.getPrefix());
                }
                final 1 updatableThis = this;
                ModifyListener listener = new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        updater.reportChanged(updatableThis);
                        updater.update();
                    }
                };
                elements2.getPrefixField().addModifyListener(listener);
            }

            @Override
            public String getValue() {
                return elements.getPrefixField().getText();
            }
        };
        updater.addSource(rootScope, prefixEditor);
        final DialogUtils.ExpressionProcessor<String> prefixValue = new DialogUtils.ExpressionProcessor<String>(Collections.emptyList()){

            @Override
            protected DialogUtils.Optional<String> calculateNormal() {
                String prefix = (String)prefixEditor.getValue();
                if (prefix == null || prefix.length() == 0) {
                    return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.SourceNameMapperContainerDialog_ENTER_PREFIX, DialogUtils.MessagePriority.BLOCKING_INFO));
                }
                return DialogUtils.createOptional(prefix);
            }
        };
        updater.addSource(rootScope, prefixValue);
        updater.addConsumer(rootScope, prefixValue);
        updater.addDependency((DialogUtils.ValueConsumer)prefixValue, prefixEditor);
        DialogUtils.ValueProcessor<String> noSlashWarning = new DialogUtils.ValueProcessor<String>(){

            @Override
            public void update(DialogUtils.Updater updater) {
                DialogUtils.Optional prefix = (DialogUtils.Optional)prefixValue.getValue();
                String result = prefix.isNormal() && !((String)prefix.getNormal()).endsWith("/") ? Messages.SourceNameMapperContainerDialog_PREFIX_NORMALLY_ENDS : null;
                this.setCurrentValue(result);
                updater.reportChanged(this);
            }
        };
        updater.addSource(rootScope, noSlashWarning);
        updater.addConsumer(rootScope, noSlashWarning);
        updater.addDependency((DialogUtils.ValueConsumer)noSlashWarning, prefixValue);
        warningSources.add(noSlashWarning);
        DialogUtils.ValueConsumer prefixExample = new DialogUtils.ValueConsumer(){

            @Override
            public void update(DialogUtils.Updater updater) {
                String line2;
                String line1;
                DialogUtils.Optional prefix = (DialogUtils.Optional)prefixValue.getValue();
                if (prefix.isNormal()) {
                    String sampleFileName = Messages.SourceNameMapperContainerDialog_SAMPLE_FILE_NAME;
                    line1 = NLS.bind((String)Messages.SourceNameMapperContainerDialog_EXAMPLE_1, (Object)(String.valueOf((String)prefix.getNormal()) + sampleFileName));
                    line2 = NLS.bind((String)Messages.SourceNameMapperContainerDialog_EXAMPLE_2, (Object)sampleFileName);
                } else {
                    line1 = "";
                    line2 = "";
                }
                elements.getPrefixExampleLine1Label().setText(line1);
                elements.getPrefixExampleLine2Label().setText(line2);
            }
        };
        updater.addConsumer(rootScope, prefixExample);
        updater.addDependency(prefixExample, prefixValue);
        final DialogUtils.ValueSource<ISourceContainerType> selectedTypeValue = new DialogUtils.ValueSource<ISourceContainerType>(initialParams, updater){
            {
                if (presetFieldValues != null) {
                    ISourceContainerType type = presetFieldValues.getContainer().getType();
                    elements2.getContainerTypeCombo().setSelected(type);
                }
                final 5 updatableThis = this;
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        updater.reportChanged(updatableThis);
                        updater.update();
                    }
                };
                elements2.getContainerTypeCombo().addSelectionListener((SelectionListener)listener);
            }

            @Override
            public ISourceContainerType getValue() {
                return elements.getContainerTypeCombo().getSelected();
            }
        };
        updater.addSource(rootScope, selectedTypeValue);
        final DialogUtils.ValueProcessor<ISourceContainer> containerFactoryButtonValue = new DialogUtils.ValueProcessor<ISourceContainer>(initialParams, updater){
            private SourceNameMapperContainerDialog.ConfigureButtonAction preparedAction = null;
            {
                if (presetFieldValues != null) {
                    this.setCurrentValue(presetFieldValues.getContainer());
                }
                final 6 valueSourceThis = this;
                elements2.getConfigureButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (preparedAction != null) {
                            ISourceContainer value = preparedAction.run(elements2.getShell());
                            if (value != null) {
                                this.setCurrentValue(value);
                            }
                            updater.reportChanged(valueSourceThis);
                            updater.update();
                            this.updateAction();
                        }
                    }
                });
            }

            @Override
            public void update(DialogUtils.Updater updater) {
                if (this.getValue() != null && !((ISourceContainer)this.getValue()).getType().equals(selectedTypeValue.getValue())) {
                    this.setCurrentValue(null);
                    updater.reportChanged(this);
                }
                this.updateAction();
            }

            private void updateAction() {
                this.preparedAction = SourceNameMapperContainerDialog.prepareConfigureAction((ISourceContainerType)selectedTypeValue.getValue(), (ISourceContainer)this.getValue(), director);
                elements.getConfigureButton().setEnabled(this.preparedAction != null);
            }
        };
        updater.addSource(rootScope, containerFactoryButtonValue);
        updater.addConsumer(rootScope, containerFactoryButtonValue);
        updater.addDependency((DialogUtils.ValueConsumer)containerFactoryButtonValue, selectedTypeValue);
        DialogUtils.ValueConsumer showContainerTypeValue = new DialogUtils.ValueConsumer(){

            @Override
            public void update(DialogUtils.Updater updater) {
                boolean enabled;
                Image image;
                String name;
                String status;
                ISourceContainer container = (ISourceContainer)containerFactoryButtonValue.getValue();
                if (container == null) {
                    status = Messages.SourceNameMapperContainerDialog_NOTHING_CONFIGURED;
                    name = "";
                    image = null;
                    enabled = false;
                } else {
                    status = Messages.SourceNameMapperContainerDialog_CONFIGURED_CONTAINER;
                    ISourceContainerType type = container.getType();
                    name = container.getName();
                    image = DebugUITools.getSourceContainerImage((String)type.getId());
                    enabled = true;
                }
                SourceNameMapperContainerDialog.ContainerStatusGroup group = elements.getContainerStatusGroup();
                group.getStatusLabel().setText(status);
                group.getTypeImageLabel().setImage(image);
                group.getContainerNameLabel().setText(name);
                group.setEnabled(enabled);
                group.layout();
            }
        };
        updater.addConsumer(rootScope, showContainerTypeValue);
        updater.addDependency(showContainerTypeValue, containerFactoryButtonValue);
        DialogUtils.ValueProcessor<String> unsupportedContainerWarning = DialogUtils.createProcessor(new DialogUtils.Gettable<String>(){

            @Override
            public String getValue() {
                ISourceContainer container = (ISourceContainer)containerFactoryButtonValue.getValue();
                if (container == null) {
                    return null;
                }
                if (ReverseSourceLookup.isGoodTargetContainer((ISourceContainer)container)) {
                    return null;
                }
                return Messages.SourceNameMapperContainerDialogLogic_TARGET_CONTAINER_NOT_SUPPORTED0;
            }
        });
        updater.addSource(rootScope, unsupportedContainerWarning);
        updater.addConsumer(rootScope, unsupportedContainerWarning);
        updater.addDependency(unsupportedContainerWarning, containerFactoryButtonValue);
        warningSources.add(unsupportedContainerWarning);
        DialogUtils.ExpressionProcessor<SourceNameMapperContainerDialog.Result> resultValue = new DialogUtils.ExpressionProcessor<SourceNameMapperContainerDialog.Result>(Arrays.asList(prefixValue)){

            @Override
            protected DialogUtils.Optional<SourceNameMapperContainerDialog.Result> calculateNormal() {
                final String prefix = (String)((DialogUtils.Optional)prefixValue.getValue()).getNormal();
                final ISourceContainer container = (ISourceContainer)containerFactoryButtonValue.getValue();
                if (container == null) {
                    return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.SourceNameMapperContainerDialog_CONFIGURE_TARGET_CONTAINER, DialogUtils.MessagePriority.BLOCKING_INFO));
                }
                SourceNameMapperContainerDialog.Result result = new SourceNameMapperContainerDialog.Result(){

                    @Override
                    public ISourceContainer getResultContainer() {
                        return container;
                    }

                    @Override
                    public String getResultPrefix() {
                        return prefix;
                    }
                };
                return DialogUtils.createOptional(result);
            }
        };
        updater.addSource(rootScope, resultValue);
        updater.addConsumer(rootScope, resultValue);
        updater.addDependency((DialogUtils.ValueConsumer)resultValue, prefixValue);
        updater.addDependency((DialogUtils.ValueConsumer)resultValue, containerFactoryButtonValue);
        final DialogUtils.OkButtonControl<SourceNameMapperContainerDialog.Result> okButtonControl = new DialogUtils.OkButtonControl<SourceNameMapperContainerDialog.Result>(resultValue, warningSources, elements);
        updater.addConsumer(rootScope, okButtonControl);
        updater.addDependency(okButtonControl, okButtonControl.getDependencies());
        return new SourceNameMapperContainerDialogLogic(){

            @Override
            SourceNameMapperContainerDialog.Result getResult() {
                return (SourceNameMapperContainerDialog.Result)okButtonControl.getNormalValue();
            }

            @Override
            void updateAll() {
                updater.updateAll();
            }
        };
    }
}

