/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.ipv4;

import java.net.Inet4Address;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.endpoint.ProtocolEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ipv4.IPv4Packet;

public class IPv4Endpoint
extends ProtocolEndpoint {
    private final Inet4Address fIPAddress;

    public IPv4Endpoint(IPv4Packet packet, boolean isSourceEndpoint) {
        super(packet, isSourceEndpoint);
        this.fIPAddress = isSourceEndpoint ? packet.getSourceIpAddress() : packet.getDestinationIpAddress();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        ProtocolEndpoint endpoint = this.getParentEndpoint();
        result = endpoint == null ? 0 : endpoint.hashCode();
        result = 31 * result + this.fIPAddress.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IPv4Endpoint)) {
            return false;
        }
        IPv4Endpoint other = (IPv4Endpoint)obj;
        boolean localEquals = this.fIPAddress.equals(other.fIPAddress);
        if (!localEquals) {
            return false;
        }
        ProtocolEndpoint endpoint = this.getParentEndpoint();
        if (endpoint != null) {
            return endpoint.equals(other.getParentEndpoint());
        }
        return true;
    }

    @Override
    public String toString() {
        ProtocolEndpoint endpoint = this.getParentEndpoint();
        if (endpoint == null) {
            return (String)NonNullUtils.checkNotNull((Object)this.fIPAddress.getHostAddress());
        }
        return endpoint.toString() + "/" + this.fIPAddress.getHostAddress();
    }
}

